; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s -mtriple=powerpc-unknown-linux -mattr=spe | FileCheck %s -check-prefix=SPE

define i32 @test_f32_oeq_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_oeq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"oeq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ogt_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ogt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ogt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_oge_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_oge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    bc 4, gt, .LBB2_3
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    bc 4, gt, .LBB2_3
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  .LBB2_3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"oge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_olt_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_olt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"olt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ole_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ole_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    bc 4, gt, .LBB4_3
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    bc 4, gt, .LBB4_3
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  .LBB4_3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ole", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_one_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_one_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"one", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ord_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ord_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    bc 4, gt, .LBB6_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  .LBB6_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ord", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ueq_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ueq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB7_3
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB7_3
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB7_3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ueq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ugt_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ugt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ugt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_uge_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_uge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB9_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB9_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"uge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ult_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ult_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efscmplt cr0, r5, r6
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ult", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_ule_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_ule_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpgt cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB11_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB11_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"ule", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_une_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_une_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r6
; SPE-NEXT:    bc 12, gt, .LBB12_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB12_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"une", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f32_uno_s(i32 %a, i32 %b, float %f1, float %f2) #0 {
; SPE-LABEL: test_f32_uno_s:
; SPE:       # %bb.0:
; SPE-NEXT:    efscmpeq cr0, r5, r5
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efscmpeq cr0, r6, r6
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f32(float %f1, float %f2, metadata !"uno", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_oeq_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_oeq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"oeq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ogt_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ogt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpgt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ogt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_oge_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_oge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    evmergelo r6, r7, r8
; SPE-NEXT:    efdcmpeq cr0, r6, r6
; SPE-NEXT:    bc 4, gt, .LBB16_3
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    bc 4, gt, .LBB16_3
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efdcmplt cr0, r5, r6
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  .LBB16_3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"oge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_olt_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_olt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"olt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ole_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ole_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    evmergelo r6, r7, r8
; SPE-NEXT:    efdcmpeq cr0, r6, r6
; SPE-NEXT:    bc 4, gt, .LBB18_3
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    bc 4, gt, .LBB18_3
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efdcmpgt cr0, r5, r6
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  .LBB18_3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ole", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_one_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_one_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpgt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"one", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ord_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ord_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    evmergelo r6, r7, r8
; SPE-NEXT:    efdcmpeq cr0, r6, r6
; SPE-NEXT:    bc 4, gt, .LBB20_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  .LBB20_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ord", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ueq_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ueq_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB21_3
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpgt cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB21_3
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB21_3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ueq", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ugt_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ugt_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpeq cr0, r7, r7
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efdcmpgt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ugt", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_uge_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_uge_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB23_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB23_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"uge", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ult_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ult_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpeq cr0, r7, r7
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    efdcmplt cr0, r5, r7
; SPE-NEXT:    bclr 12, gt, 0
; SPE-NEXT:  # %bb.3:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ult", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_ule_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_ule_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpgt cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB25_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB25_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"ule", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_une_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_une_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r7
; SPE-NEXT:    bc 12, gt, .LBB26_2
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    mr r4, r3
; SPE-NEXT:  .LBB26_2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"une", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

define i32 @test_f64_uno_s(i32 %a, i32 %b, double %f1, double %f2) #0 {
; SPE-LABEL: test_f64_uno_s:
; SPE:       # %bb.0:
; SPE-NEXT:    evmergelo r7, r7, r8
; SPE-NEXT:    evmergelo r5, r5, r6
; SPE-NEXT:    efdcmpeq cr0, r5, r5
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.1:
; SPE-NEXT:    efdcmpeq cr0, r7, r7
; SPE-NEXT:    bclr 4, gt, 0
; SPE-NEXT:  # %bb.2:
; SPE-NEXT:    mr r3, r4
; SPE-NEXT:    blr
  %cond = call i1 @llvm.experimental.constrained.fcmps.f64(double %f1, double %f2, metadata !"uno", metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i32 %a, i32 %b
  ret i32 %res
}

attributes #0 = { strictfp nounwind }

declare i1 @llvm.experimental.constrained.fcmps.f32(float, float, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmps.f64(double, double, metadata, metadata)
