; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -aarch64-sve-vector-bits-min=256  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_256
; RUN: llc -aarch64-sve-vector-bits-min=512  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512
; RUN: llc -aarch64-sve-vector-bits-min=2048 < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512

target triple = "aarch64-unknown-linux-gnu"

;
; Masked Loads
;

define <2 x half> @masked_load_v2f16(ptr %ap, ptr %bp) vscale_range(2,0) #0 {
; CHECK-LABEL: masked_load_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr s1, [x0]
; CHECK-NEXT:    ldr s2, [x1]
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    fcmeq v1.4h, v1.4h, v2.4h
; CHECK-NEXT:    sshll v1.4s, v1.4h, #0
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    mov w8, v1.s[1]
; CHECK-NEXT:    mov v0.h[1], w8
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %a = load <2 x half>, ptr %ap
  %b = load <2 x half>, ptr %bp
  %mask = fcmp oeq <2 x half> %a, %b
  %load = call <2 x half> @llvm.masked.load.v2f16(ptr %ap, i32 8, <2 x i1> %mask, <2 x half> zeroinitializer)
  ret <2 x half> %load
}

define <2 x float> @masked_load_v2f32(ptr %ap, ptr %bp) vscale_range(2,0) #0 {
; CHECK-LABEL: masked_load_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %ap
  %b = load <2 x float>, ptr %bp
  %mask = fcmp oeq <2 x float> %a, %b
  %load = call <2 x float> @llvm.masked.load.v2f32(ptr %ap, i32 8, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %load
}

define <4 x float> @masked_load_v4f32(ptr %ap, ptr %bp) vscale_range(1,0) #0 {
; CHECK-LABEL: masked_load_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %a = load <4 x float>, ptr %ap
  %b = load <4 x float>, ptr %bp
  %mask = fcmp oeq <4 x float> %a, %b
  %load = call <4 x float> @llvm.masked.load.v4f32(ptr %ap, i32 8, <4 x i1> %mask, <4 x float> zeroinitializer)
  ret <4 x float> %load
}

define void @masked_load_v8f32(ptr %ap, ptr %bp, ptr %c) vscale_range(2,0) #0 {
; CHECK-LABEL: masked_load_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fcmeq p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    ld1w { z0.s }, p1/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x2]
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %ap
  %b = load <8 x float>, ptr %bp
  %mask = fcmp oeq <8 x float> %a, %b
  %load = call <8 x float> @llvm.masked.load.v8f32(ptr %ap, i32 8, <8 x i1> %mask, <8 x float> zeroinitializer)
  store <8 x float> %load, ptr %c
  ret void
}

define void @masked_load_v16f32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_v16f32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z2.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1w { z3.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fcmeq p1.s, p0/z, z0.s, z1.s
; VBITS_GE_256-NEXT:    fcmeq p2.s, p0/z, z2.s, z3.s
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p1/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p2/z, [x0]
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_v16f32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fcmeq p1.s, p0/z, z0.s, z1.s
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %a = load <16 x float>, ptr %ap
  %b = load <16 x float>, ptr %bp
  %mask = fcmp oeq <16 x float> %a, %b
  %load = call <16 x float> @llvm.masked.load.v16f32(ptr %ap, i32 8, <16 x i1> %mask, <16 x float> zeroinitializer)
  store <16 x float> %load, ptr %c
  ret void
}

define void @masked_load_v32f32(ptr %ap, ptr %bp, ptr %c) vscale_range(8,0) #0 {
; CHECK-LABEL: masked_load_v32f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fcmeq p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    ld1w { z0.s }, p1/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x2]
; CHECK-NEXT:    ret
  %a = load <32 x float>, ptr %ap
  %b = load <32 x float>, ptr %bp
  %mask = fcmp oeq <32 x float> %a, %b
  %load = call <32 x float> @llvm.masked.load.v32f32(ptr %ap, i32 8, <32 x i1> %mask, <32 x float> zeroinitializer)
  store <32 x float> %load, ptr %c
  ret void
}

define void @masked_load_v64f32(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_v64f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x1]
; CHECK-NEXT:    fcmeq p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    ld1w { z0.s }, p1/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x2]
; CHECK-NEXT:    ret
  %a = load <64 x float>, ptr %ap
  %b = load <64 x float>, ptr %bp
  %mask = fcmp oeq <64 x float> %a, %b
  %load = call <64 x float> @llvm.masked.load.v64f32(ptr %ap, i32 8, <64 x i1> %mask, <64 x float> zeroinitializer)
  store <64 x float> %load, ptr %c
  ret void
}

define void @masked_load_v64i8(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_v64i8:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl32
; VBITS_GE_256-NEXT:    mov w8, #32 // =0x20
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0, x8]
; VBITS_GE_256-NEXT:    ld1b { z1.b }, p0/z, [x1, x8]
; VBITS_GE_256-NEXT:    ld1b { z2.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1b { z3.b }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.b, p0/z, z0.b, z1.b
; VBITS_GE_256-NEXT:    cmpeq p2.b, p0/z, z2.b, z3.b
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p1/z, [x0, x8]
; VBITS_GE_256-NEXT:    ld1b { z1.b }, p2/z, [x0]
; VBITS_GE_256-NEXT:    st1b { z0.b }, p0, [x2, x8]
; VBITS_GE_256-NEXT:    st1b { z1.b }, p0, [x2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_v64i8:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.b, vl64
; VBITS_GE_512-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1b { z1.b }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.b, p0/z, z0.b, z1.b
; VBITS_GE_512-NEXT:    ld1b { z0.b }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1b { z0.b }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %a = load <64 x i8>, ptr %ap
  %b = load <64 x i8>, ptr %bp
  %mask = icmp eq <64 x i8> %a, %b
  %load = call <64 x i8> @llvm.masked.load.v64i8(ptr %ap, i32 8, <64 x i1> %mask, <64 x i8> poison)
  store <64 x i8> %load, ptr %c
  ret void
}

define void @masked_load_v32i16(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_v32i16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z2.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1h { z3.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.h, p0/z, z0.h, z1.h
; VBITS_GE_256-NEXT:    cmpeq p2.h, p0/z, z2.h, z3.h
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p1/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p2/z, [x0]
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x2, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_v32i16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.h, p0/z, z0.h, z1.h
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %a = load <32 x i16>, ptr %ap
  %b = load <32 x i16>, ptr %bp
  %mask = icmp eq <32 x i16> %a, %b
  %load = call <32 x i16> @llvm.masked.load.v32i16(ptr %ap, i32 8, <32 x i1> %mask, <32 x i16> poison)
  store <32 x i16> %load, ptr %c
  ret void
}

define void @masked_load_v16i32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_v16i32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z2.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1w { z3.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.s, p0/z, z0.s, z1.s
; VBITS_GE_256-NEXT:    cmpeq p2.s, p0/z, z2.s, z3.s
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p1/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p2/z, [x0]
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_v16i32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, z1.s
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %a = load <16 x i32>, ptr %ap
  %b = load <16 x i32>, ptr %bp
  %mask = icmp eq <16 x i32> %a, %b
  %load = call <16 x i32> @llvm.masked.load.v16i32(ptr %ap, i32 8, <16 x i1> %mask, <16 x i32> poison)
  store <16 x i32> %load, ptr %c
  ret void
}

define void @masked_load_v8i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_v8i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, z1.d
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z2.d, z3.d
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p1/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p2/z, [x0]
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_v8i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, z1.d
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %a = load <8 x i64>, ptr %ap
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %a, %b
  %load = call <8 x i64> @llvm.masked.load.v8i64(ptr %ap, i32 8, <8 x i1> %mask, <8 x i64> poison)
  store <8 x i64> %load, ptr %c
  ret void
}

define void @masked_load_passthru_v8i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_passthru_v8i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, z1.d
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z2.d, z3.d
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p1/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p2/z, [x0]
; VBITS_GE_256-NEXT:    sel z0.d, p1, z0.d, z1.d
; VBITS_GE_256-NEXT:    sel z1.d, p2, z2.d, z3.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_passthru_v8i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, z1.d
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    sel z0.d, p1, z0.d, z1.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %a = load <8 x i64>, ptr %ap
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %a, %b
  %load = call <8 x i64> @llvm.masked.load.v8i64(ptr %ap, i32 8, <8 x i1> %mask, <8 x i64> %b)
  store <8 x i64> %load, ptr %c
  ret void
}

define void @masked_load_passthru_v8f64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_passthru_v8f64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ld1d { z3.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    fcmeq p1.d, p0/z, z0.d, z1.d
; VBITS_GE_256-NEXT:    fcmeq p2.d, p0/z, z2.d, z3.d
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p1/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z2.d }, p2/z, [x0]
; VBITS_GE_256-NEXT:    sel z0.d, p1, z0.d, z1.d
; VBITS_GE_256-NEXT:    sel z1.d, p2, z2.d, z3.d
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_passthru_v8f64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    fcmeq p1.d, p0/z, z0.d, z1.d
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    sel z0.d, p1, z0.d, z1.d
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %a = load <8 x double>, ptr %ap
  %b = load <8 x double>, ptr %bp
  %mask = fcmp oeq <8 x double> %a, %b
  %load = call <8 x double> @llvm.masked.load.v8f64(ptr %ap, i32 8, <8 x i1> %mask, <8 x double> %b)
  store <8 x double> %load, ptr %c
  ret void
}

define void @masked_load_sext_v32i8i16(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v32i8i16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl32
; VBITS_GE_256-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    sunpklo z1.h, z0.b
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    sunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x2]
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x2, x8, lsl #1]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v32i8i16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1b { z0.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; VBITS_GE_512-NEXT:    ld1sb { z0.h }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <32 x i8>, ptr %bp
  %mask = icmp eq <32 x i8> %b, zeroinitializer
  %load = call <32 x i8> @llvm.masked.load.v32i8(ptr %ap, i32 8, <32 x i1> %mask, <32 x i8> poison)
  %ext = sext <32 x i8> %load to <32 x i16>
  store <32 x i16> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v16i8i32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v16i8i32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl16
; VBITS_GE_256-NEXT:    ldr q0, [x1]
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    sunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    sunpklo z1.h, z1.b
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    sunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v16i8i32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1b { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1sb { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i8>, ptr %bp
  %mask = icmp eq <16 x i8> %b, zeroinitializer
  %load = call <16 x i8> @llvm.masked.load.v16i8(ptr %ap, i32 8, <16 x i1> %mask, <16 x i8> poison)
  %ext = sext <16 x i8> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v8i8i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v8i8i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl8
; VBITS_GE_256-NEXT:    ldr d0, [x1]
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    sshll v0.8h, v0.8b, #0
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    sunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    sunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    sunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v8i8i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1b { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1sb { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i8>, ptr %bp
  %mask = icmp eq <8 x i8> %b, zeroinitializer
  %load = call <8 x i8> @llvm.masked.load.v8i8(ptr %ap, i32 8, <8 x i1> %mask, <8 x i8> poison)
  %ext = sext <8 x i8> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v16i16i32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v16i16i32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    sunpklo z1.s, z0.h
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v16i16i32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1h { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1sh { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i16>, ptr %bp
  %mask = icmp eq <16 x i16> %b, zeroinitializer
  %load = call <16 x i16> @llvm.masked.load.v16i16(ptr %ap, i32 8, <16 x i1> %mask, <16 x i16> poison)
  %ext = sext <16 x i16> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v8i16i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v8i16i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl8
; VBITS_GE_256-NEXT:    ldr q0, [x1]
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    sunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    sunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    sunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v8i16i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1h { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1sh { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i16>, ptr %bp
  %mask = icmp eq <8 x i16> %b, zeroinitializer
  %load = call <8 x i16> @llvm.masked.load.v8i16(ptr %ap, i32 8, <8 x i1> %mask, <8 x i16> poison)
  %ext = sext <8 x i16> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v8i32i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v8i32i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    sunpklo z1.d, z0.s
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    sunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v8i32i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1w { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1sw { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i32>, ptr %bp
  %mask = icmp eq <8 x i32> %b, zeroinitializer
  %load = call <8 x i32> @llvm.masked.load.v8i32(ptr %ap, i32 8, <8 x i1> %mask, <8 x i32> poison)
  %ext = sext <8 x i32> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v32i8i16(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v32i8i16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl32
; VBITS_GE_256-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    uunpklo z1.h, z0.b
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    uunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x2]
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x2, x8, lsl #1]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v32i8i16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1b { z0.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; VBITS_GE_512-NEXT:    ld1b { z0.h }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <32 x i8>, ptr %bp
  %mask = icmp eq <32 x i8> %b, zeroinitializer
  %load = call <32 x i8> @llvm.masked.load.v32i8(ptr %ap, i32 8, <32 x i1> %mask, <32 x i8> poison)
  %ext = zext <32 x i8> %load to <32 x i16>
  store <32 x i16> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v16i8i32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v16i8i32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl16
; VBITS_GE_256-NEXT:    ldr q0, [x1]
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    uunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    uunpklo z1.h, z1.b
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    uunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v16i8i32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1b { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1b { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i8>, ptr %bp
  %mask = icmp eq <16 x i8> %b, zeroinitializer
  %load = call <16 x i8> @llvm.masked.load.v16i8(ptr %ap, i32 8, <16 x i1> %mask, <16 x i8> poison)
  %ext = zext <16 x i8> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v8i8i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v8i8i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl8
; VBITS_GE_256-NEXT:    ldr d0, [x1]
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ushll v0.8h, v0.8b, #0
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    uunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    uunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    uunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v8i8i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1b { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1b { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i8>, ptr %bp
  %mask = icmp eq <8 x i8> %b, zeroinitializer
  %load = call <8 x i8> @llvm.masked.load.v8i8(ptr %ap, i32 8, <8 x i1> %mask, <8 x i8> poison)
  %ext = zext <8 x i8> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v16i16i32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v16i16i32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    uunpklo z1.s, z0.h
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v16i16i32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1h { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1h { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i16>, ptr %bp
  %mask = icmp eq <16 x i16> %b, zeroinitializer
  %load = call <16 x i16> @llvm.masked.load.v16i16(ptr %ap, i32 8, <16 x i1> %mask, <16 x i16> poison)
  %ext = zext <16 x i16> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v8i16i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v8i16i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl8
; VBITS_GE_256-NEXT:    ldr q0, [x1]
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    uunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    uunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    uunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v8i16i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1h { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1h { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i16>, ptr %bp
  %mask = icmp eq <8 x i16> %b, zeroinitializer
  %load = call <8 x i16> @llvm.masked.load.v8i16(ptr %ap, i32 8, <8 x i1> %mask, <8 x i16> poison)
  %ext = zext <8 x i16> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v8i32i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v8i32i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    uunpklo z1.d, z0.s
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    uunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v8i32i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1w { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1w { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i32>, ptr %bp
  %mask = icmp eq <8 x i32> %b, zeroinitializer
  %load = call <8 x i32> @llvm.masked.load.v8i32(ptr %ap, i32 8, <8 x i1> %mask, <8 x i32> poison)
  %ext = zext <8 x i32> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v32i8i16_m16(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v32i8i16_m16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; VBITS_GE_256-NEXT:    cmpeq p2.h, p0/z, z1.h, #0
; VBITS_GE_256-NEXT:    mov z0.h, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.h, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.b, vl16
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    uzp1 z1.b, z1.b, z1.b
; VBITS_GE_256-NEXT:    splice z1.b, p1, z1.b, z0.b
; VBITS_GE_256-NEXT:    ptrue p1.b, vl32
; VBITS_GE_256-NEXT:    cmpne p1.b, p1/z, z1.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p1/z, [x0]
; VBITS_GE_256-NEXT:    sunpklo z1.h, z0.b
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    sunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x2]
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x2, x8, lsl #1]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v32i8i16_m16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; VBITS_GE_512-NEXT:    ld1sb { z0.h }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <32 x i16>, ptr %bp
  %mask = icmp eq <32 x i16> %b, zeroinitializer
  %load = call <32 x i8> @llvm.masked.load.v32i8(ptr %ap, i32 8, <32 x i1> %mask, <32 x i8> poison)
  %ext = sext <32 x i8> %load to <32 x i16>
  store <32 x i16> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v16i8i32_m32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v16i8i32_m32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    cmpeq p2.s, p0/z, z1.s, #0
; VBITS_GE_256-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.s, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.b, vl16
; VBITS_GE_256-NEXT:    uzp1 z0.h, z0.h, z0.h
; VBITS_GE_256-NEXT:    uzp1 z1.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    uzp1 z1.b, z1.b, z1.b
; VBITS_GE_256-NEXT:    mov v1.d[1], v0.d[0]
; VBITS_GE_256-NEXT:    cmpne p1.b, p1/z, z1.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p1/z, [x0]
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    sunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    sunpklo z1.h, z1.b
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    sunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v16i8i32_m32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1sb { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i32>, ptr %bp
  %mask = icmp eq <16 x i32> %b, zeroinitializer
  %load = call <16 x i8> @llvm.masked.load.v16i8(ptr %ap, i32 8, <16 x i1> %mask, <16 x i8> poison)
  %ext = sext <16 x i8> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v8i8i64_m64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v8i8i64_m64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z1.d, #0
; VBITS_GE_256-NEXT:    mov z0.d, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.d, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.s, vl4
; VBITS_GE_256-NEXT:    uzp1 z0.s, z0.s, z0.s
; VBITS_GE_256-NEXT:    uzp1 z1.s, z1.s, z1.s
; VBITS_GE_256-NEXT:    splice z1.s, p1, z1.s, z0.s
; VBITS_GE_256-NEXT:    ptrue p1.b, vl8
; VBITS_GE_256-NEXT:    uzp1 z0.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    cmpne p1.b, p1/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p1/z, [x0]
; VBITS_GE_256-NEXT:    sshll v0.8h, v0.8b, #0
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    sunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    sunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    sunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v8i8i64_m64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1sb { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %b, zeroinitializer
  %load = call <8 x i8> @llvm.masked.load.v8i8(ptr %ap, i32 8, <8 x i1> %mask, <8 x i8> poison)
  %ext = sext <8 x i8> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v16i16i32_m32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v16i16i32_m32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    cmpeq p2.s, p0/z, z1.s, #0
; VBITS_GE_256-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.s, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.h, vl16
; VBITS_GE_256-NEXT:    uzp1 z0.h, z0.h, z0.h
; VBITS_GE_256-NEXT:    uzp1 z1.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    uzp1 z1.b, z1.b, z1.b
; VBITS_GE_256-NEXT:    mov v1.d[1], v0.d[0]
; VBITS_GE_256-NEXT:    sunpklo z0.h, z1.b
; VBITS_GE_256-NEXT:    cmpne p1.h, p1/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p1/z, [x0]
; VBITS_GE_256-NEXT:    sunpklo z1.s, z0.h
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v16i16i32_m32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1sh { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i32>, ptr %bp
  %mask = icmp eq <16 x i32> %b, zeroinitializer
  %load = call <16 x i16> @llvm.masked.load.v16i16(ptr %ap, i32 8, <16 x i1> %mask, <16 x i16> poison)
  %ext = sext <16 x i16> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v8i16i64_m64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v8i16i64_m64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z1.d, #0
; VBITS_GE_256-NEXT:    mov z0.d, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.d, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.s, vl4
; VBITS_GE_256-NEXT:    uzp1 z0.s, z0.s, z0.s
; VBITS_GE_256-NEXT:    uzp1 z1.s, z1.s, z1.s
; VBITS_GE_256-NEXT:    splice z1.s, p1, z1.s, z0.s
; VBITS_GE_256-NEXT:    ptrue p1.h, vl8
; VBITS_GE_256-NEXT:    uzp1 z0.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    cmpne p1.h, p1/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p1/z, [x0]
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    sunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    sunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    sunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    sunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v8i16i64_m64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1sh { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %b, zeroinitializer
  %load = call <8 x i16> @llvm.masked.load.v8i16(ptr %ap, i32 8, <8 x i1> %mask, <8 x i16> poison)
  %ext = sext <8 x i16> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v8i32i64_m64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_v8i32i64_m64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z1.d, #0
; VBITS_GE_256-NEXT:    mov z0.d, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.d, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.s, vl4
; VBITS_GE_256-NEXT:    uzp1 z0.s, z0.s, z0.s
; VBITS_GE_256-NEXT:    uzp1 z1.s, z1.s, z1.s
; VBITS_GE_256-NEXT:    splice z1.s, p1, z1.s, z0.s
; VBITS_GE_256-NEXT:    ptrue p1.s, vl8
; VBITS_GE_256-NEXT:    cmpne p1.s, p1/z, z1.s, #0
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p1/z, [x0]
; VBITS_GE_256-NEXT:    sunpklo z1.d, z0.s
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    sunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_v8i32i64_m64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1sw { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %b, zeroinitializer
  %load = call <8 x i32> @llvm.masked.load.v8i32(ptr %ap, i32 8, <8 x i1> %mask, <8 x i32> poison)
  %ext = sext <8 x i32> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v32i8i16_m16(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v32i8i16_m16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x1, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; VBITS_GE_256-NEXT:    cmpeq p2.h, p0/z, z1.h, #0
; VBITS_GE_256-NEXT:    mov z0.h, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.h, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.b, vl16
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    uzp1 z1.b, z1.b, z1.b
; VBITS_GE_256-NEXT:    splice z1.b, p1, z1.b, z0.b
; VBITS_GE_256-NEXT:    ptrue p1.b, vl32
; VBITS_GE_256-NEXT:    cmpne p1.b, p1/z, z1.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p1/z, [x0]
; VBITS_GE_256-NEXT:    uunpklo z1.h, z0.b
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    uunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x2]
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x2, x8, lsl #1]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v32i8i16_m16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; VBITS_GE_512-NEXT:    ld1b { z0.h }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <32 x i16>, ptr %bp
  %mask = icmp eq <32 x i16> %b, zeroinitializer
  %load = call <32 x i8> @llvm.masked.load.v32i8(ptr %ap, i32 8, <32 x i1> %mask, <32 x i8> poison)
  %ext = zext <32 x i8> %load to <32 x i16>
  store <32 x i16> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v16i8i32_m32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v16i8i32_m32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    cmpeq p2.s, p0/z, z1.s, #0
; VBITS_GE_256-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.s, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.b, vl16
; VBITS_GE_256-NEXT:    uzp1 z0.h, z0.h, z0.h
; VBITS_GE_256-NEXT:    uzp1 z1.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    uzp1 z1.b, z1.b, z1.b
; VBITS_GE_256-NEXT:    mov v1.d[1], v0.d[0]
; VBITS_GE_256-NEXT:    cmpne p1.b, p1/z, z1.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p1/z, [x0]
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    uunpklo z0.h, z0.b
; VBITS_GE_256-NEXT:    uunpklo z1.h, z1.b
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    uunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v16i8i32_m32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1b { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i32>, ptr %bp
  %mask = icmp eq <16 x i32> %b, zeroinitializer
  %load = call <16 x i8> @llvm.masked.load.v16i8(ptr %ap, i32 8, <16 x i1> %mask, <16 x i8> poison)
  %ext = zext <16 x i8> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v8i8i64_m64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v8i8i64_m64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z1.d, #0
; VBITS_GE_256-NEXT:    mov z0.d, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.d, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.s, vl4
; VBITS_GE_256-NEXT:    uzp1 z0.s, z0.s, z0.s
; VBITS_GE_256-NEXT:    uzp1 z1.s, z1.s, z1.s
; VBITS_GE_256-NEXT:    splice z1.s, p1, z1.s, z0.s
; VBITS_GE_256-NEXT:    ptrue p1.b, vl8
; VBITS_GE_256-NEXT:    uzp1 z0.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    cmpne p1.b, p1/z, z0.b, #0
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p1/z, [x0]
; VBITS_GE_256-NEXT:    ushll v0.8h, v0.8b, #0
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    uunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    uunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    uunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v8i8i64_m64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1b { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %b, zeroinitializer
  %load = call <8 x i8> @llvm.masked.load.v8i8(ptr %ap, i32 8, <8 x i1> %mask, <8 x i8> poison)
  %ext = zext <8 x i8> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v16i16i32_m32(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v16i16i32_m32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    cmpeq p2.s, p0/z, z1.s, #0
; VBITS_GE_256-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.s, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.h, vl16
; VBITS_GE_256-NEXT:    uzp1 z0.h, z0.h, z0.h
; VBITS_GE_256-NEXT:    uzp1 z1.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    uzp1 z0.b, z0.b, z0.b
; VBITS_GE_256-NEXT:    uzp1 z1.b, z1.b, z1.b
; VBITS_GE_256-NEXT:    mov v1.d[1], v0.d[0]
; VBITS_GE_256-NEXT:    sunpklo z0.h, z1.b
; VBITS_GE_256-NEXT:    cmpne p1.h, p1/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p1/z, [x0]
; VBITS_GE_256-NEXT:    uunpklo z1.s, z0.h
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x2]
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x2, x8, lsl #2]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v16i16i32_m32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; VBITS_GE_512-NEXT:    ld1h { z0.s }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <16 x i32>, ptr %bp
  %mask = icmp eq <16 x i32> %b, zeroinitializer
  %load = call <16 x i16> @llvm.masked.load.v16i16(ptr %ap, i32 8, <16 x i1> %mask, <16 x i16> poison)
  %ext = zext <16 x i16> %load to <16 x i32>
  store <16 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v8i16i64_m64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v8i16i64_m64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z1.d, #0
; VBITS_GE_256-NEXT:    mov z0.d, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.d, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.s, vl4
; VBITS_GE_256-NEXT:    uzp1 z0.s, z0.s, z0.s
; VBITS_GE_256-NEXT:    uzp1 z1.s, z1.s, z1.s
; VBITS_GE_256-NEXT:    splice z1.s, p1, z1.s, z0.s
; VBITS_GE_256-NEXT:    ptrue p1.h, vl8
; VBITS_GE_256-NEXT:    uzp1 z0.h, z1.h, z1.h
; VBITS_GE_256-NEXT:    cmpne p1.h, p1/z, z0.h, #0
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p1/z, [x0]
; VBITS_GE_256-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; VBITS_GE_256-NEXT:    uunpklo z0.s, z0.h
; VBITS_GE_256-NEXT:    uunpklo z1.s, z1.h
; VBITS_GE_256-NEXT:    uunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    uunpklo z1.d, z1.s
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v8i16i64_m64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1h { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %b, zeroinitializer
  %load = call <8 x i16> @llvm.masked.load.v8i16(ptr %ap, i32 8, <8 x i1> %mask, <8 x i16> poison)
  %ext = zext <8 x i16> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v8i32i64_m64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_v8i32i64_m64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x1, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_256-NEXT:    cmpeq p2.d, p0/z, z1.d, #0
; VBITS_GE_256-NEXT:    mov z0.d, p1/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    mov z1.d, p2/z, #-1 // =0xffffffffffffffff
; VBITS_GE_256-NEXT:    ptrue p1.s, vl4
; VBITS_GE_256-NEXT:    uzp1 z0.s, z0.s, z0.s
; VBITS_GE_256-NEXT:    uzp1 z1.s, z1.s, z1.s
; VBITS_GE_256-NEXT:    splice z1.s, p1, z1.s, z0.s
; VBITS_GE_256-NEXT:    ptrue p1.s, vl8
; VBITS_GE_256-NEXT:    cmpne p1.s, p1/z, z1.s, #0
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p1/z, [x0]
; VBITS_GE_256-NEXT:    uunpklo z1.d, z0.s
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    uunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_v8i32i64_m64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1w { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i64>, ptr %bp
  %mask = icmp eq <8 x i64> %b, zeroinitializer
  %load = call <8 x i32> @llvm.masked.load.v8i32(ptr %ap, i32 8, <8 x i1> %mask, <8 x i32> poison)
  %ext = zext <8 x i32> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v128i8i16(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_sext_v128i8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1sb { z0.h }, p1/z, [x0]
; CHECK-NEXT:    st1h { z0.h }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <128 x i8>, ptr %bp
  %mask = icmp eq <128 x i8> %b, zeroinitializer
  %load = call <128 x i8> @llvm.masked.load.v128i8(ptr %ap, i32 8, <128 x i1> %mask, <128 x i8> poison)
  %ext = sext <128 x i8> %load to <128 x i16>
  store <128 x i16> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v64i8i32(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_sext_v64i8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1b { z0.s }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1sb { z0.s }, p1/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <64 x i8>, ptr %bp
  %mask = icmp eq <64 x i8> %b, zeroinitializer
  %load = call <64 x i8> @llvm.masked.load.v64i8(ptr %ap, i32 8, <64 x i1> %mask, <64 x i8> poison)
  %ext = sext <64 x i8> %load to <64 x i32>
  store <64 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v32i8i64(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_sext_v32i8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1b { z0.d }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1sb { z0.d }, p1/z, [x0]
; CHECK-NEXT:    st1d { z0.d }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <32 x i8>, ptr %bp
  %mask = icmp eq <32 x i8> %b, zeroinitializer
  %load = call <32 x i8> @llvm.masked.load.v32i8(ptr %ap, i32 8, <32 x i1> %mask, <32 x i8> poison)
  %ext = sext <32 x i8> %load to <32 x i64>
  store <32 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v64i16i32(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_sext_v64i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1sh { z0.s }, p1/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <64 x i16>, ptr %bp
  %mask = icmp eq <64 x i16> %b, zeroinitializer
  %load = call <64 x i16> @llvm.masked.load.v64i16(ptr %ap, i32 8, <64 x i1> %mask, <64 x i16> poison)
  %ext = sext <64 x i16> %load to <64 x i32>
  store <64 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v32i16i64(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_sext_v32i16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1h { z0.d }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1sh { z0.d }, p1/z, [x0]
; CHECK-NEXT:    st1d { z0.d }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <32 x i16>, ptr %bp
  %mask = icmp eq <32 x i16> %b, zeroinitializer
  %load = call <32 x i16> @llvm.masked.load.v32i16(ptr %ap, i32 8, <32 x i1> %mask, <32 x i16> poison)
  %ext = sext <32 x i16> %load to <32 x i64>
  store <32 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_v32i32i64(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_sext_v32i32i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1sw { z0.d }, p1/z, [x0]
; CHECK-NEXT:    st1d { z0.d }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <32 x i32>, ptr %bp
  %mask = icmp eq <32 x i32> %b, zeroinitializer
  %load = call <32 x i32> @llvm.masked.load.v32i32(ptr %ap, i32 8, <32 x i1> %mask, <32 x i32> poison)
  %ext = sext <32 x i32> %load to <32 x i64>
  store <32 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v128i8i16(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_zext_v128i8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1b { z0.h }, p1/z, [x0]
; CHECK-NEXT:    st1h { z0.h }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <128 x i8>, ptr %bp
  %mask = icmp eq <128 x i8> %b, zeroinitializer
  %load = call <128 x i8> @llvm.masked.load.v128i8(ptr %ap, i32 8, <128 x i1> %mask, <128 x i8> poison)
  %ext = zext <128 x i8> %load to <128 x i16>
  store <128 x i16> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v64i8i32(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_zext_v64i8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1b { z0.s }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1b { z0.s }, p1/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <64 x i8>, ptr %bp
  %mask = icmp eq <64 x i8> %b, zeroinitializer
  %load = call <64 x i8> @llvm.masked.load.v64i8(ptr %ap, i32 8, <64 x i1> %mask, <64 x i8> poison)
  %ext = zext <64 x i8> %load to <64 x i32>
  store <64 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v32i8i64(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_zext_v32i8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1b { z0.d }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1b { z0.d }, p1/z, [x0]
; CHECK-NEXT:    st1d { z0.d }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <32 x i8>, ptr %bp
  %mask = icmp eq <32 x i8> %b, zeroinitializer
  %load = call <32 x i8> @llvm.masked.load.v32i8(ptr %ap, i32 8, <32 x i1> %mask, <32 x i8> poison)
  %ext = zext <32 x i8> %load to <32 x i64>
  store <32 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v64i16i32(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_zext_v64i16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1h { z0.s }, p1/z, [x0]
; CHECK-NEXT:    st1w { z0.s }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <64 x i16>, ptr %bp
  %mask = icmp eq <64 x i16> %b, zeroinitializer
  %load = call <64 x i16> @llvm.masked.load.v64i16(ptr %ap, i32 8, <64 x i1> %mask, <64 x i16> poison)
  %ext = zext <64 x i16> %load to <64 x i32>
  store <64 x i32> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v32i16i64(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_zext_v32i16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1h { z0.d }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1h { z0.d }, p1/z, [x0]
; CHECK-NEXT:    st1d { z0.d }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <32 x i16>, ptr %bp
  %mask = icmp eq <32 x i16> %b, zeroinitializer
  %load = call <32 x i16> @llvm.masked.load.v32i16(ptr %ap, i32 8, <32 x i1> %mask, <32 x i16> poison)
  %ext = zext <32 x i16> %load to <32 x i64>
  store <32 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_v32i32i64(ptr %ap, ptr %bp, ptr %c) vscale_range(16,0) #0 {
; CHECK-LABEL: masked_load_zext_v32i32i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1w { z0.d }, p0/z, [x1]
; CHECK-NEXT:    cmpeq p1.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1w { z0.d }, p1/z, [x0]
; CHECK-NEXT:    st1d { z0.d }, p0, [x2]
; CHECK-NEXT:    ret
  %b = load <32 x i32>, ptr %bp
  %mask = icmp eq <32 x i32> %b, zeroinitializer
  %load = call <32 x i32> @llvm.masked.load.v32i32(ptr %ap, i32 8, <32 x i1> %mask, <32 x i32> poison)
  %ext = zext <32 x i32> %load to <32 x i64>
  store <32 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_sext_ugt_v8i32i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_sext_ugt_v8i32i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    sunpklo z1.d, z0.s
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    sunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_sext_ugt_v8i32i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1w { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpne p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1sw { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i32>, ptr %bp
  %mask = icmp ugt <8 x i32> %b, zeroinitializer
  %load = call <8 x i32> @llvm.masked.load.v8i32(ptr %ap, i32 8, <8 x i1> %mask, <8 x i32> poison)
  %ext = sext <8 x i32> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

define void @masked_load_zext_sgt_v8i32i64(ptr %ap, ptr %bp, ptr %c) #0 {
; VBITS_GE_256-LABEL: masked_load_zext_sgt_v8i32i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x1]
; VBITS_GE_256-NEXT:    cmpgt p0.s, p0/z, z0.s, #0
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    uunpklo z1.d, z0.s
; VBITS_GE_256-NEXT:    ext z0.b, z0.b, z0.b, #16
; VBITS_GE_256-NEXT:    uunpklo z0.d, z0.s
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x2]
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x2, x8, lsl #3]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: masked_load_zext_sgt_v8i32i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1sw { z0.d }, p0/z, [x1]
; VBITS_GE_512-NEXT:    cmpgt p1.d, p0/z, z0.d, #0
; VBITS_GE_512-NEXT:    ld1w { z0.d }, p1/z, [x0]
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x2]
; VBITS_GE_512-NEXT:    ret
  %b = load <8 x i32>, ptr %bp
  %mask = icmp sgt <8 x i32> %b, zeroinitializer
  %load = call <8 x i32> @llvm.masked.load.v8i32(ptr %ap, i32 8, <8 x i1> %mask, <8 x i32> poison)
  %ext = zext <8 x i32> %load to <8 x i64>
  store <8 x i64> %ext, ptr %c
  ret void
}

declare <2 x half> @llvm.masked.load.v2f16(ptr, i32, <2 x i1>, <2 x half>)
declare <2 x float> @llvm.masked.load.v2f32(ptr, i32, <2 x i1>, <2 x float>)
declare <4 x float> @llvm.masked.load.v4f32(ptr, i32, <4 x i1>, <4 x float>)
declare <8 x float> @llvm.masked.load.v8f32(ptr, i32, <8 x i1>, <8 x float>)
declare <16 x float> @llvm.masked.load.v16f32(ptr, i32, <16 x i1>, <16 x float>)
declare <32 x float> @llvm.masked.load.v32f32(ptr, i32, <32 x i1>, <32 x float>)
declare <64 x float> @llvm.masked.load.v64f32(ptr, i32, <64 x i1>, <64 x float>)

declare <128 x i8> @llvm.masked.load.v128i8(ptr, i32, <128 x i1>, <128 x i8>)
declare <64 x i8> @llvm.masked.load.v64i8(ptr, i32, <64 x i1>, <64 x i8>)
declare <32 x i8> @llvm.masked.load.v32i8(ptr, i32, <32 x i1>, <32 x i8>)
declare <16 x i8> @llvm.masked.load.v16i8(ptr, i32, <16 x i1>, <16 x i8>)
declare <16 x i16> @llvm.masked.load.v16i16(ptr, i32, <16 x i1>, <16 x i16>)
declare <8 x i8> @llvm.masked.load.v8i8(ptr, i32, <8 x i1>, <8 x i8>)
declare <8 x i16> @llvm.masked.load.v8i16(ptr, i32, <8 x i1>, <8 x i16>)
declare <8 x i32> @llvm.masked.load.v8i32(ptr, i32, <8 x i1>, <8 x i32>)
declare <32 x i32> @llvm.masked.load.v32i32(ptr, i32, <32 x i1>, <32 x i32>)
declare <32 x i16> @llvm.masked.load.v32i16(ptr, i32, <32 x i1>, <32 x i16>)
declare <64 x i16> @llvm.masked.load.v64i16(ptr, i32, <64 x i1>, <64 x i16>)
declare <16 x i32> @llvm.masked.load.v16i32(ptr, i32, <16 x i1>, <16 x i32>)
declare <8 x i64> @llvm.masked.load.v8i64(ptr, i32, <8 x i1>, <8 x i64>)
declare <8 x double> @llvm.masked.load.v8f64(ptr, i32, <8 x i1>, <8 x double>)

attributes #0 = { "target-features"="+sve" }
