# For z17 and above.
# RUN: llvm-mc -triple s390x-linux-gnu -mcpu=z17 -show-encoding %s \
# RUN:   | FileCheck %s

#CHECK: bdepg	%r0, %r0, %r0           # encoding: [0xb9,0x6d,0x00,0x00]
#CHECK: bdepg	%r0, %r0, %r15          # encoding: [0xb9,0x6d,0xf0,0x00]
#CHECK: bdepg	%r0, %r15, %r0          # encoding: [0xb9,0x6d,0x00,0x0f]
#CHECK: bdepg	%r15, %r0, %r0          # encoding: [0xb9,0x6d,0x00,0xf0]
#CHECK: bdepg	%r7, %r8, %r9           # encoding: [0xb9,0x6d,0x90,0x78]

	bdepg	%r0,%r0,%r0
	bdepg	%r0,%r0,%r15
	bdepg	%r0,%r15,%r0
	bdepg	%r15,%r0,%r0
	bdepg	%r7,%r8,%r9

#CHECK: bextg	%r0, %r0, %r0           # encoding: [0xb9,0x6c,0x00,0x00]
#CHECK: bextg	%r0, %r0, %r15          # encoding: [0xb9,0x6c,0xf0,0x00]
#CHECK: bextg	%r0, %r15, %r0          # encoding: [0xb9,0x6c,0x00,0x0f]
#CHECK: bextg	%r15, %r0, %r0          # encoding: [0xb9,0x6c,0x00,0xf0]
#CHECK: bextg	%r7, %r8, %r9           # encoding: [0xb9,0x6c,0x90,0x78]

	bextg	%r0,%r0,%r0
	bextg	%r0,%r0,%r15
	bextg	%r0,%r15,%r0
	bextg	%r15,%r0,%r0
	bextg	%r7,%r8,%r9

#CHECK: cal	%r0, 0, 0               # encoding: [0xc8,0x06,0x00,0x00,0x00,0x00]
#CHECK: cal	%r2, 0(%r1), 0(%r15)    # encoding: [0xc8,0x26,0x10,0x00,0xf0,0x00]
#CHECK: cal	%r2, 1(%r1), 0(%r15)    # encoding: [0xc8,0x26,0x10,0x01,0xf0,0x00]
#CHECK: cal	%r2, 4095(%r1), 0(%r15) # encoding: [0xc8,0x26,0x1f,0xff,0xf0,0x00]
#CHECK: cal	%r2, 0(%r1), 1(%r15)    # encoding: [0xc8,0x26,0x10,0x00,0xf0,0x01]
#CHECK: cal	%r2, 0(%r1), 4095(%r15) # encoding: [0xc8,0x26,0x10,0x00,0xff,0xff]

	cal	%r0, 0, 0
	cal	%r2, 0(%r1), 0(%r15)
	cal	%r2, 1(%r1), 0(%r15)
	cal	%r2, 4095(%r1), 0(%r15)
	cal	%r2, 0(%r1), 1(%r15)
	cal	%r2, 0(%r1), 4095(%r15)

#CHECK: calg	%r0, 0, 0               # encoding: [0xc8,0x07,0x00,0x00,0x00,0x00]
#CHECK: calg	%r2, 0(%r1), 0(%r15)    # encoding: [0xc8,0x27,0x10,0x00,0xf0,0x00]
#CHECK: calg	%r2, 1(%r1), 0(%r15)    # encoding: [0xc8,0x27,0x10,0x01,0xf0,0x00]
#CHECK: calg	%r2, 4095(%r1), 0(%r15) # encoding: [0xc8,0x27,0x1f,0xff,0xf0,0x00]
#CHECK: calg	%r2, 0(%r1), 1(%r15)    # encoding: [0xc8,0x27,0x10,0x00,0xf0,0x01]
#CHECK: calg	%r2, 0(%r1), 4095(%r15) # encoding: [0xc8,0x27,0x10,0x00,0xff,0xff]

	calg	%r0, 0, 0
	calg	%r2, 0(%r1), 0(%r15)
	calg	%r2, 1(%r1), 0(%r15)
	calg	%r2, 4095(%r1), 0(%r15)
	calg	%r2, 0(%r1), 1(%r15)
	calg	%r2, 0(%r1), 4095(%r15)

#CHECK: calgf	%r0, 0, 0               # encoding: [0xc8,0x0f,0x00,0x00,0x00,0x00]
#CHECK: calgf	%r2, 0(%r1), 0(%r15)    # encoding: [0xc8,0x2f,0x10,0x00,0xf0,0x00]
#CHECK: calgf	%r2, 1(%r1), 0(%r15)    # encoding: [0xc8,0x2f,0x10,0x01,0xf0,0x00]
#CHECK: calgf	%r2, 4095(%r1), 0(%r15) # encoding: [0xc8,0x2f,0x1f,0xff,0xf0,0x00]
#CHECK: calgf	%r2, 0(%r1), 1(%r15)    # encoding: [0xc8,0x2f,0x10,0x00,0xf0,0x01]
#CHECK: calgf	%r2, 0(%r1), 4095(%r15) # encoding: [0xc8,0x2f,0x10,0x00,0xff,0xff]

	calgf	%r0, 0, 0
	calgf	%r2, 0(%r1), 0(%r15)
	calgf	%r2, 1(%r1), 0(%r15)
	calgf	%r2, 4095(%r1), 0(%r15)
	calgf	%r2, 0(%r1), 1(%r15)
	calgf	%r2, 0(%r1), 4095(%r15)

#CHECK: clzg	%r0, %r15               # encoding: [0xb9,0x68,0x00,0x0f]
#CHECK: clzg	%r7, %r8                # encoding: [0xb9,0x68,0x00,0x78]
#CHECK: clzg	%r15, %r0               # encoding: [0xb9,0x68,0x00,0xf0]

	clzg	%r0, %r15
	clzg	%r7, %r8
	clzg	%r15, %r0

#CHECK: ctzg	%r0, %r15               # encoding: [0xb9,0x69,0x00,0x0f]
#CHECK: ctzg	%r7, %r8                # encoding: [0xb9,0x69,0x00,0x78]
#CHECK: ctzg	%r15, %r0               # encoding: [0xb9,0x69,0x00,0xf0]

	ctzg	%r0, %r15
	ctzg	%r7, %r8
	ctzg	%r15, %r0

#CHECK: kimd	%r0, %r0, 0             # encoding: [0xb9,0x3e,0x00,0x00]
#CHECK: kimd	%r0, %r0, 15            # encoding: [0xb9,0x3e,0xf0,0x00]
#CHECK: kimd	%r0, %r14, 0            # encoding: [0xb9,0x3e,0x00,0x0e]
#CHECK: kimd	%r15, %r0, 0            # encoding: [0xb9,0x3e,0x00,0xf0]
#CHECK: kimd	%r7, %r10, 13           # encoding: [0xb9,0x3e,0xd0,0x7a]

	kimd	%r0, %r0, 0
	kimd	%r0, %r0, 15
	kimd	%r0, %r14, 0
	kimd	%r15, %r0, 0
	kimd	%r7, %r10, 13

#CHECK: klmd	%r0, %r0, 0             # encoding: [0xb9,0x3f,0x00,0x00]
#CHECK: klmd	%r0, %r0, 15            # encoding: [0xb9,0x3f,0xf0,0x00]
#CHECK: klmd	%r0, %r14, 0            # encoding: [0xb9,0x3f,0x00,0x0e]
#CHECK: klmd	%r15, %r0, 0            # encoding: [0xb9,0x3f,0x00,0xf0]
#CHECK: klmd	%r7, %r10, 13           # encoding: [0xb9,0x3f,0xd0,0x7a]

	klmd	%r0, %r0, 0
	klmd	%r0, %r0, 15
	klmd	%r0, %r14, 0
	klmd	%r15, %r0, 0
	klmd	%r7, %r10, 13

#CHECK: lxab	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x60]
#CHECK: lxab	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x60]
#CHECK: lxab	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x60]
#CHECK: lxab	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x60]
#CHECK: lxab	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x60]
#CHECK: lxab	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x60]
#CHECK: lxab	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x60]
#CHECK: lxab	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x60]
#CHECK: lxab	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x60]
#CHECK: lxab	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x60]

	lxab	%r0, -524288
	lxab	%r0, -1
	lxab	%r0, 0
	lxab	%r0, 1
	lxab	%r0, 524287
	lxab	%r0, 0(%r1)
	lxab	%r0, 0(%r15)
	lxab	%r0, 524287(%r1,%r15)
	lxab	%r0, 524287(%r15,%r1)
	lxab	%r15, 0

#CHECK: lxah	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x62]
#CHECK: lxah	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x62]
#CHECK: lxah	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x62]
#CHECK: lxah	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x62]
#CHECK: lxah	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x62]
#CHECK: lxah	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x62]
#CHECK: lxah	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x62]
#CHECK: lxah	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x62]
#CHECK: lxah	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x62]
#CHECK: lxah	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x62]

	lxah	%r0, -524288
	lxah	%r0, -1
	lxah	%r0, 0
	lxah	%r0, 1
	lxah	%r0, 524287
	lxah	%r0, 0(%r1)
	lxah	%r0, 0(%r15)
	lxah	%r0, 524287(%r1,%r15)
	lxah	%r0, 524287(%r15,%r1)
	lxah	%r15, 0

#CHECK: lxaf	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x64]
#CHECK: lxaf	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x64]
#CHECK: lxaf	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x64]
#CHECK: lxaf	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x64]
#CHECK: lxaf	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x64]
#CHECK: lxaf	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x64]
#CHECK: lxaf	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x64]
#CHECK: lxaf	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x64]
#CHECK: lxaf	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x64]
#CHECK: lxaf	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x64]

	lxaf	%r0, -524288
	lxaf	%r0, -1
	lxaf	%r0, 0
	lxaf	%r0, 1
	lxaf	%r0, 524287
	lxaf	%r0, 0(%r1)
	lxaf	%r0, 0(%r15)
	lxaf	%r0, 524287(%r1,%r15)
	lxaf	%r0, 524287(%r15,%r1)
	lxaf	%r15, 0

#CHECK: lxag	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x66]
#CHECK: lxag	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x66]
#CHECK: lxag	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x66]
#CHECK: lxag	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x66]
#CHECK: lxag	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x66]
#CHECK: lxag	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x66]
#CHECK: lxag	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x66]
#CHECK: lxag	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x66]
#CHECK: lxag	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x66]
#CHECK: lxag	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x66]

	lxag	%r0, -524288
	lxag	%r0, -1
	lxag	%r0, 0
	lxag	%r0, 1
	lxag	%r0, 524287
	lxag	%r0, 0(%r1)
	lxag	%r0, 0(%r15)
	lxag	%r0, 524287(%r1,%r15)
	lxag	%r0, 524287(%r15,%r1)
	lxag	%r15, 0

#CHECK: lxaq	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x68]
#CHECK: lxaq	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x68]
#CHECK: lxaq	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x68]
#CHECK: lxaq	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x68]
#CHECK: lxaq	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x68]
#CHECK: lxaq	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x68]
#CHECK: lxaq	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x68]
#CHECK: lxaq	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x68]
#CHECK: lxaq	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x68]
#CHECK: lxaq	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x68]

	lxaq	%r0, -524288
	lxaq	%r0, -1
	lxaq	%r0, 0
	lxaq	%r0, 1
	lxaq	%r0, 524287
	lxaq	%r0, 0(%r1)
	lxaq	%r0, 0(%r15)
	lxaq	%r0, 524287(%r1,%r15)
	lxaq	%r0, 524287(%r15,%r1)
	lxaq	%r15, 0

#CHECK: llxab	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x61]
#CHECK: llxab	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x61]
#CHECK: llxab	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x61]
#CHECK: llxab	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x61]
#CHECK: llxab	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x61]
#CHECK: llxab	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x61]
#CHECK: llxab	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x61]
#CHECK: llxab	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x61]
#CHECK: llxab	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x61]
#CHECK: llxab	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x61]

	llxab	%r0, -524288
	llxab	%r0, -1
	llxab	%r0, 0
	llxab	%r0, 1
	llxab	%r0, 524287
	llxab	%r0, 0(%r1)
	llxab	%r0, 0(%r15)
	llxab	%r0, 524287(%r1,%r15)
	llxab	%r0, 524287(%r15,%r1)
	llxab	%r15, 0

#CHECK: llxah	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x63]
#CHECK: llxah	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x63]
#CHECK: llxah	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x63]
#CHECK: llxah	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x63]
#CHECK: llxah	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x63]
#CHECK: llxah	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x63]
#CHECK: llxah	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x63]
#CHECK: llxah	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x63]
#CHECK: llxah	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x63]
#CHECK: llxah	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x63]

	llxah	%r0, -524288
	llxah	%r0, -1
	llxah	%r0, 0
	llxah	%r0, 1
	llxah	%r0, 524287
	llxah	%r0, 0(%r1)
	llxah	%r0, 0(%r15)
	llxah	%r0, 524287(%r1,%r15)
	llxah	%r0, 524287(%r15,%r1)
	llxah	%r15, 0

#CHECK: llxaf	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x65]
#CHECK: llxaf	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x65]
#CHECK: llxaf	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x65]
#CHECK: llxaf	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x65]
#CHECK: llxaf	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x65]
#CHECK: llxaf	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x65]
#CHECK: llxaf	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x65]
#CHECK: llxaf	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x65]
#CHECK: llxaf	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x65]
#CHECK: llxaf	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x65]

	llxaf	%r0, -524288
	llxaf	%r0, -1
	llxaf	%r0, 0
	llxaf	%r0, 1
	llxaf	%r0, 524287
	llxaf	%r0, 0(%r1)
	llxaf	%r0, 0(%r15)
	llxaf	%r0, 524287(%r1,%r15)
	llxaf	%r0, 524287(%r15,%r1)
	llxaf	%r15, 0

#CHECK: llxag	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x67]
#CHECK: llxag	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x67]
#CHECK: llxag	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x67]
#CHECK: llxag	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x67]
#CHECK: llxag	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x67]
#CHECK: llxag	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x67]
#CHECK: llxag	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x67]
#CHECK: llxag	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x67]
#CHECK: llxag	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x67]
#CHECK: llxag	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x67]

	llxag	%r0, -524288
	llxag	%r0, -1
	llxag	%r0, 0
	llxag	%r0, 1
	llxag	%r0, 524287
	llxag	%r0, 0(%r1)
	llxag	%r0, 0(%r15)
	llxag	%r0, 524287(%r1,%r15)
	llxag	%r0, 524287(%r15,%r1)
	llxag	%r15, 0

#CHECK: llxaq	%r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x69]
#CHECK: llxaq	%r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x69]
#CHECK: llxaq	%r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x69]
#CHECK: llxaq	%r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x69]
#CHECK: llxaq	%r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x69]
#CHECK: llxaq	%r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x69]
#CHECK: llxaq	%r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x69]
#CHECK: llxaq	%r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x69]
#CHECK: llxaq	%r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x69]
#CHECK: llxaq	%r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x69]

	llxaq	%r0, -524288
	llxaq	%r0, -1
	llxaq	%r0, 0
	llxaq	%r0, 1
	llxaq	%r0, 524287
	llxaq	%r0, 0(%r1)
	llxaq	%r0, 0(%r15)
	llxaq	%r0, 524287(%r1,%r15)
	llxaq	%r0, 524287(%r15,%r1)
	llxaq	%r15, 0

#CHECK: pfcr	%r0, %r0, 0             # encoding: [0xeb,0x00,0x00,0x00,0x00,0x16]
#CHECK: pfcr	%r15, %r1, 0            # encoding: [0xeb,0xf1,0x00,0x00,0x00,0x16]
#CHECK: pfcr	%r1, %r15, 0            # encoding: [0xeb,0x1f,0x00,0x00,0x00,0x16]
#CHECK: pfcr	%r15, %r15, 0           # encoding: [0xeb,0xff,0x00,0x00,0x00,0x16]
#CHECK: pfcr	%r0, %r0, -524288       # encoding: [0xeb,0x00,0x00,0x00,0x80,0x16]
#CHECK: pfcr	%r0, %r0, -1            # encoding: [0xeb,0x00,0x0f,0xff,0xff,0x16]
#CHECK: pfcr	%r0, %r0, 1             # encoding: [0xeb,0x00,0x00,0x01,0x00,0x16]
#CHECK: pfcr	%r0, %r0, 524287        # encoding: [0xeb,0x00,0x0f,0xff,0x7f,0x16]
#CHECK: pfcr	%r0, %r0, 0(%r1)        # encoding: [0xeb,0x00,0x10,0x00,0x00,0x16]
#CHECK: pfcr	%r0, %r0, 0(%r15)       # encoding: [0xeb,0x00,0xf0,0x00,0x00,0x16]
#CHECK: pfcr	%r0, %r0, 524287(%r1)   # encoding: [0xeb,0x00,0x1f,0xff,0x7f,0x16]
#CHECK: pfcr	%r0, %r0, 524287(%r15)  # encoding: [0xeb,0x00,0xff,0xff,0x7f,0x16]

	pfcr	%r0, %r0 ,0
	pfcr	%r15, %r1, 0
	pfcr	%r1, %r15, 0
	pfcr	%r15, %r15, 0
	pfcr	%r0, %r0, -524288
	pfcr	%r0, %r0, -1
	pfcr	%r0, %r0, 1
	pfcr	%r0, %r0, 524287
	pfcr	%r0, %r0, 0(%r1)
	pfcr	%r0, %r0, 0(%r15)
	pfcr	%r0, %r0, 524287(%r1)
	pfcr	%r0, %r0, 524287(%r15)

#CHECK: vavgq	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf2]
#CHECK: vavgq	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf2]
#CHECK: vavgq	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf2]
#CHECK: vavgq	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf2]
#CHECK: vavgq	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf2]

	vavgq	%v0, %v0, %v0
	vavgq	%v0, %v0, %v31
	vavgq	%v0, %v31, %v0
	vavgq	%v31, %v0, %v0
	vavgq	%v18, %v3, %v20

#CHECK: vavglq	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf0]
#CHECK: vavglq	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf0]
#CHECK: vavglq	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf0]
#CHECK: vavglq	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf0]
#CHECK: vavglq	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf0]

	vavglq	%v0, %v0, %v0
	vavglq	%v0, %v0, %v31
	vavglq	%v0, %v31, %v0
	vavglq	%v31, %v0, %v0
	vavglq	%v18, %v3, %v20

#CHECK: vblend	%v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0x89]
#CHECK: vblend	%v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x89]
#CHECK: vblend	%v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x89]
#CHECK: vblend	%v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x89]
#CHECK: vblend	%v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x89]
#CHECK: vblend	%v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x89]
#CHECK: vblend	%v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0x89]

	vblend	%v0, %v0, %v0, %v0, 0
	vblend	%v0, %v0, %v0, %v0, 15
	vblend	%v0, %v0, %v0, %v31, 0
	vblend	%v0, %v0, %v31, %v0, 0
	vblend	%v0, %v31, %v0, %v0, 0
	vblend	%v31, %v0, %v0, %v0, 0
	vblend	%v13, %v17, %v21, %v25, 11

#CHECK: vblendb	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0x89]
#CHECK: vblendb	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x89]
#CHECK: vblendb	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x89]
#CHECK: vblendb	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x89]
#CHECK: vblendb	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x89]
#CHECK: vblendb	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0x89]

	vblendb	%v0, %v0, %v0, %v0
	vblendb	%v0, %v0, %v0, %v31
	vblendb	%v0, %v0, %v31, %v0
	vblendb	%v0, %v31, %v0, %v0
	vblendb	%v31, %v0, %v0, %v0
	vblendb	%v13, %v17, %v21, %v25

#CHECK: vblendh	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0x89]
#CHECK: vblendh	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0x89]
#CHECK: vblendh	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0x89]
#CHECK: vblendh	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0x89]
#CHECK: vblendh	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0x89]
#CHECK: vblendh	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0x89]

	vblendh	%v0, %v0, %v0, %v0
	vblendh	%v0, %v0, %v0, %v31
	vblendh	%v0, %v0, %v31, %v0
	vblendh	%v0, %v31, %v0, %v0
	vblendh	%v31, %v0, %v0, %v0
	vblendh	%v13, %v17, %v21, %v25

#CHECK: vblendf	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0x89]
#CHECK: vblendf	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0x89]
#CHECK: vblendf	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0x89]
#CHECK: vblendf	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0x89]
#CHECK: vblendf	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0x89]
#CHECK: vblendf	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0x89]

	vblendf	%v0, %v0, %v0, %v0
	vblendf	%v0, %v0, %v0, %v31
	vblendf	%v0, %v0, %v31, %v0
	vblendf	%v0, %v31, %v0, %v0
	vblendf	%v31, %v0, %v0, %v0
	vblendf	%v13, %v17, %v21, %v25

#CHECK: vblendg	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0x89]
#CHECK: vblendg	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0x89]
#CHECK: vblendg	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0x89]
#CHECK: vblendg	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0x89]
#CHECK: vblendg	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0x89]
#CHECK: vblendg	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0x89]

	vblendg	%v0, %v0, %v0, %v0
	vblendg	%v0, %v0, %v0, %v31
	vblendg	%v0, %v0, %v31, %v0
	vblendg	%v0, %v31, %v0, %v0
	vblendg	%v31, %v0, %v0, %v0
	vblendg	%v13, %v17, %v21, %v25

#CHECK: vblendq	%v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0x89]
#CHECK: vblendq	%v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0x89]
#CHECK: vblendq	%v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0x89]
#CHECK: vblendq	%v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0x89]
#CHECK: vblendq	%v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0x89]
#CHECK: vblendq	%v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0x89]

	vblendq	%v0, %v0, %v0, %v0
	vblendq	%v0, %v0, %v0, %v31
	vblendq	%v0, %v0, %v31, %v0
	vblendq	%v0, %v31, %v0, %v0
	vblendq	%v31, %v0, %v0, %v0
	vblendq	%v13, %v17, %v21, %v25

#CHECK: vceqq   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf8]
#CHECK: vceqq   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf8]
#CHECK: vceqq   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf8]
#CHECK: vceqq   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf8]
#CHECK: vceqq   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf8]
#CHECK: vceqqs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x44,0xf8]

	vceqq	%v0, %v0, %v0
	vceqq	%v0, %v0, %v31
	vceqq	%v0, %v31, %v0
	vceqq	%v31, %v0, %v0
	vceqq	%v18, %v3, %v20
	vceqqs	%v5, %v22, %v7

#CHECK: vchq    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xfb]
#CHECK: vchq    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xfb]
#CHECK: vchq    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xfb]
#CHECK: vchq    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xfb]
#CHECK: vchq    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xfb]
#CHECK: vchqs   %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x44,0xfb]

	vchq	%v0, %v0, %v0
	vchq	%v0, %v0, %v31
	vchq	%v0, %v31, %v0
	vchq	%v31, %v0, %v0
	vchq	%v18, %v3, %v20
	vchqs	%v5, %v22, %v7

#CHECK: vchlq   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf9]
#CHECK: vchlq   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf9]
#CHECK: vchlq   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf9]
#CHECK: vchlq   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf9]
#CHECK: vchlq   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf9]
#CHECK: vchlqs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x44,0xf9]

	vchlq	%v0, %v0, %v0
	vchlq	%v0, %v0, %v31
	vchlq	%v0, %v31, %v0
	vchlq	%v31, %v0, %v0
	vchlq	%v18, %v3, %v20
	vchlqs	%v5, %v22, %v7

#CHECK: vclzq   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0x53]
#CHECK: vclzq   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0x53]
#CHECK: vclzq   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0x53]
#CHECK: vclzq   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0x53]
#CHECK: vclzq   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0x53]
#CHECK: vclzq   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0x53]

	vclzq	%v0, %v0
	vclzq	%v0, %v15
	vclzq	%v0, %v31
	vclzq	%v15, %v0
	vclzq	%v31, %v0
	vclzq	%v14, %v17

#CHECK: vctzq   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0x52]
#CHECK: vctzq   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0x52]
#CHECK: vctzq   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0x52]
#CHECK: vctzq   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0x52]
#CHECK: vctzq   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0x52]
#CHECK: vctzq   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0x52]

	vctzq	%v0, %v0
	vctzq	%v0, %v15
	vctzq	%v0, %v31
	vctzq	%v15, %v0
	vctzq	%v31, %v0
	vctzq	%v14, %v17

#CHECK: vcvbq	%v0, %v0, 0             # encoding: [0xe6,0x00,0x00,0x00,0x00,0x4e]
#CHECK: vcvbq	%v0, %v0, 15            # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x4e]
#CHECK: vcvbq	%v31, %v0, 0            # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x4e]
#CHECK: vcvbq	%v0, %v15, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x00,0x4e]
#CHECK: vcvbq	%v0, %v31, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x4e]
#CHECK: vcvbq	%v3, %v18, 4            # encoding: [0xe6,0x32,0x00,0x40,0x04,0x4e]

	vcvbq	%v0, %v0, 0
	vcvbq	%v0, %v0, 15
	vcvbq	%v31, %v0, 0
	vcvbq	%v0, %v15, 0
	vcvbq	%v0, %v31, 0
	vcvbq	%v3, %v18, 4

#CHECK: vcvdq	%v0, %v0, 0, 0          # encoding: [0xe6,0x00,0x00,0x00,0x00,0x4a]
#CHECK: vcvdq	%v0, %v0, 0, 15         # encoding: [0xe6,0x00,0x00,0xf0,0x00,0x4a]
#CHECK: vcvdq	%v0, %v0, 255, 0        # encoding: [0xe6,0x00,0x00,0x0f,0xf0,0x4a]
#CHECK: vcvdq	%v0, %v31, 0, 0         # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x4a]
#CHECK: vcvdq	%v15, %v0, 0, 0         # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x4a]
#CHECK: vcvdq	%v31, %v0, 0, 0         # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x4a]
#CHECK: vcvdq	%v18, %v9, 52, 11       # encoding: [0xe6,0x29,0x00,0xb3,0x48,0x4a]

	vcvdq	%v0, %v0, 0, 0
	vcvdq	%v0, %v0, 0, 15
	vcvdq	%v0, %v0, 255, 0
	vcvdq	%v0, %v31, 0, 0
	vcvdq	%v15, %v0, 0, 0
	vcvdq	%v31, %v0, 0, 0
	vcvdq	%v18, %v9, 0x34, 11

#CHECK: vd	%v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb2]
#CHECK: vd	%v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xb2]
#CHECK: vd	%v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xb2]
#CHECK: vd	%v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb2]
#CHECK: vd	%v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb2]
#CHECK: vd	%v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb2]
#CHECK: vd	%v13, %v17, %v21, 8, 4  # encoding: [0xe7,0xd1,0x50,0x04,0x86,0xb2]

	vd	%v0, %v0, %v0, 0, 0
	vd	%v0, %v0, %v0, 0, 15
	vd	%v0, %v0, %v0, 15, 0
	vd	%v0, %v0, %v31, 0, 0
	vd	%v0, %v31, %v0, 0, 0
	vd	%v31, %v0, %v0, 0, 0
	vd	%v13, %v17, %v21, 8, 4

#CHECK: vdf	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0xb2]
#CHECK: vdf	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x20,0xb2]
#CHECK: vdf	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xb2]
#CHECK: vdf	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xb2]
#CHECK: vdf	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xb2]
#CHECK: vdf	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x26,0xb2]

	vdf	%v0, %v0, %v0, 0
	vdf	%v0, %v0, %v0, 15
	vdf	%v0, %v0, %v31, 0
	vdf	%v0, %v31, %v0, 0
	vdf	%v31, %v0, %v0, 0
	vdf	%v13, %v17, %v21, 4

#CHECK: vdg	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x30,0xb2]
#CHECK: vdg	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x30,0xb2]
#CHECK: vdg	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xb2]
#CHECK: vdg	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xb2]
#CHECK: vdg	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xb2]
#CHECK: vdg	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x36,0xb2]

	vdg	%v0, %v0, %v0, 0
	vdg	%v0, %v0, %v0, 15
	vdg	%v0, %v0, %v31, 0
	vdg	%v0, %v31, %v0, 0
	vdg	%v31, %v0, %v0, 0
	vdg	%v13, %v17, %v21, 4

#CHECK: vdq	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x40,0xb2]
#CHECK: vdq	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x40,0xb2]
#CHECK: vdq	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xb2]
#CHECK: vdq	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xb2]
#CHECK: vdq	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xb2]
#CHECK: vdq	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x46,0xb2]

	vdq	%v0, %v0, %v0, 0
	vdq	%v0, %v0, %v0, 15
	vdq	%v0, %v0, %v31, 0
	vdq	%v0, %v31, %v0, 0
	vdq	%v31, %v0, %v0, 0
	vdq	%v13, %v17, %v21, 4

#CHECK: vdl	%v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb0]
#CHECK: vdl	%v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xb0]
#CHECK: vdl	%v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xb0]
#CHECK: vdl	%v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb0]
#CHECK: vdl	%v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb0]
#CHECK: vdl	%v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb0]
#CHECK: vdl	%v13, %v17, %v21, 8, 4  # encoding: [0xe7,0xd1,0x50,0x04,0x86,0xb0]

	vdl	%v0, %v0, %v0, 0, 0
	vdl	%v0, %v0, %v0, 0, 15
	vdl	%v0, %v0, %v0, 15, 0
	vdl	%v0, %v0, %v31, 0, 0
	vdl	%v0, %v31, %v0, 0, 0
	vdl	%v31, %v0, %v0, 0, 0
	vdl	%v13, %v17, %v21, 8, 4

#CHECK: vdlf	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0xb0]
#CHECK: vdlf	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x20,0xb0]
#CHECK: vdlf	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xb0]
#CHECK: vdlf	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xb0]
#CHECK: vdlf	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xb0]
#CHECK: vdlf	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x26,0xb0]

	vdlf	%v0, %v0, %v0, 0
	vdlf	%v0, %v0, %v0, 15
	vdlf	%v0, %v0, %v31, 0
	vdlf	%v0, %v31, %v0, 0
	vdlf	%v31, %v0, %v0, 0
	vdlf	%v13, %v17, %v21, 4

#CHECK: vdlg	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x30,0xb0]
#CHECK: vdlg	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x30,0xb0]
#CHECK: vdlg	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xb0]
#CHECK: vdlg	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xb0]
#CHECK: vdlg	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xb0]
#CHECK: vdlg	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x36,0xb0]

	vdlg	%v0, %v0, %v0, 0
	vdlg	%v0, %v0, %v0, 15
	vdlg	%v0, %v0, %v31, 0
	vdlg	%v0, %v31, %v0, 0
	vdlg	%v31, %v0, %v0, 0
	vdlg	%v13, %v17, %v21, 4

#CHECK: vdlq	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x40,0xb0]
#CHECK: vdlq	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x40,0xb0]
#CHECK: vdlq	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xb0]
#CHECK: vdlq	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xb0]
#CHECK: vdlq	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xb0]
#CHECK: vdlq	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x46,0xb0]

	vdlq	%v0, %v0, %v0, 0
	vdlq	%v0, %v0, %v0, 15
	vdlq	%v0, %v0, %v31, 0
	vdlq	%v0, %v31, %v0, 0
	vdlq	%v31, %v0, %v0, 0
	vdlq	%v13, %v17, %v21, 4

#CHECK: veval	%v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0x88]
#CHECK: veval	%v0, %v0, %v0, %v0, 255 # encoding: [0xe7,0x00,0x00,0xff,0x00,0x88]
#CHECK: veval	%v0, %v0, %v0, %v15, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x88]
#CHECK: veval	%v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x88]
#CHECK: veval	%v0, %v0, %v15, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x88]
#CHECK: veval	%v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x88]
#CHECK: veval	%v0, %v15, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x88]
#CHECK: veval	%v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x88]
#CHECK: veval	%v15, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x88]
#CHECK: veval	%v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x88]
#CHECK: veval	%v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x40,0x04,0x5a,0x88]

	veval	%v0, %v0, %v0, %v0, 0
	veval	%v0, %v0, %v0, %v0, 255
	veval	%v0, %v0, %v0, %v15, 0
	veval	%v0, %v0, %v0, %v31, 0
	veval	%v0, %v0, %v15, %v0, 0
	veval	%v0, %v0, %v31, %v0, 0
	veval	%v0, %v15, %v0, %v0, 0
	veval	%v0, %v31, %v0, %v0, 0
	veval	%v15, %v0, %v0, %v0, 0
	veval	%v31, %v0, %v0, %v0, 0
	veval	%v18, %v3, %v20, %v5, 4

#CHECK: vecq    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0xdb]
#CHECK: vecq    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0xdb]
#CHECK: vecq    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xdb]
#CHECK: vecq    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0xdb]
#CHECK: vecq    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xdb]
#CHECK: vecq    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0xdb]

	vecq	%v0, %v0
	vecq	%v0, %v15
	vecq	%v0, %v31
	vecq	%v15, %v0
	vecq	%v31, %v0
	vecq	%v14, %v17

#CHECK: veclq   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0xd9]
#CHECK: veclq   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0xd9]
#CHECK: veclq   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xd9]
#CHECK: veclq   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0xd9]
#CHECK: veclq   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xd9]
#CHECK: veclq   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0xd9]

	veclq	%v0, %v0
	veclq	%v0, %v15
	veclq	%v0, %v31
	veclq	%v15, %v0
	veclq	%v31, %v0
	veclq	%v14, %v17

#CHECK: vgem	%v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x54]
#CHECK: vgem	%v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x54]
#CHECK: vgem	%v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x54]
#CHECK: vgem	%v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x54]
#CHECK: vgem	%v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x54]
#CHECK: vgem	%v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x54]
#CHECK: vgem	%v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0x54]

	vgem	%v0, %v0, 0
	vgem	%v0, %v0, 15
	vgem	%v0, %v15, 0
	vgem	%v0, %v31, 0
	vgem	%v15, %v0, 0
	vgem	%v31, %v0, 0
	vgem	%v14, %v17, 11

#CHECK: vgemb	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0x54]
#CHECK: vgemb	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x54]
#CHECK: vgemb	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x54]
#CHECK: vgemb	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x54]
#CHECK: vgemb	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x54]
#CHECK: vgemb	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0x54]

	vgemb	%v0, %v0
	vgemb	%v0, %v15
	vgemb	%v0, %v31
	vgemb	%v15, %v0
	vgemb	%v31, %v0
	vgemb	%v14, %v17

#CHECK: vgemh	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0x54]
#CHECK: vgemh	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x54]
#CHECK: vgemh	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x54]
#CHECK: vgemh	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x54]
#CHECK: vgemh	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x54]
#CHECK: vgemh	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0x54]

	vgemh	%v0, %v0
	vgemh	%v0, %v15
	vgemh	%v0, %v31
	vgemh	%v15, %v0
	vgemh	%v31, %v0
	vgemh	%v14, %v17

#CHECK: vgemf	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0x54]
#CHECK: vgemf	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x54]
#CHECK: vgemf	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x54]
#CHECK: vgemf	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x54]
#CHECK: vgemf	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x54]
#CHECK: vgemf	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0x54]

	vgemf	%v0, %v0
	vgemf	%v0, %v15
	vgemf	%v0, %v31
	vgemf	%v15, %v0
	vgemf	%v31, %v0
	vgemf	%v14, %v17

#CHECK: vgemg	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0x54]
#CHECK: vgemg	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x54]
#CHECK: vgemg	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x54]
#CHECK: vgemg	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x54]
#CHECK: vgemg	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x54]
#CHECK: vgemg	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0x54]

	vgemg	%v0, %v0
	vgemg	%v0, %v15
	vgemg	%v0, %v31
	vgemg	%v15, %v0
	vgemg	%v31, %v0
	vgemg	%v14, %v17

#CHECK: vgemq	%v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0x54]
#CHECK: vgemq	%v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0x54]
#CHECK: vgemq	%v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0x54]
#CHECK: vgemq	%v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0x54]
#CHECK: vgemq	%v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0x54]
#CHECK: vgemq	%v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0x54]

	vgemq	%v0, %v0
	vgemq	%v0, %v15
	vgemq	%v0, %v31
	vgemq	%v15, %v0
	vgemq	%v31, %v0
	vgemq	%v14, %v17

#CHECK: vlcq    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0xde]
#CHECK: vlcq    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0xde]
#CHECK: vlcq    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xde]
#CHECK: vlcq    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0xde]
#CHECK: vlcq    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xde]
#CHECK: vlcq    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0xde]

	vlcq	%v0, %v0
	vlcq	%v0, %v15
	vlcq	%v0, %v31
	vlcq	%v15, %v0
	vlcq	%v31, %v0
	vlcq	%v14, %v17

#CHECK: vlpq    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x40,0xdf]
#CHECK: vlpq    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x40,0xdf]
#CHECK: vlpq    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xdf]
#CHECK: vlpq    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x40,0xdf]
#CHECK: vlpq    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xdf]
#CHECK: vlpq    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x44,0xdf]

	vlpq	%v0, %v0
	vlpq	%v0, %v15
	vlpq	%v0, %v31
	vlpq	%v15, %v0
	vlpq	%v31, %v0
	vlpq	%v14, %v17

#CHECK: vmalg   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xaa]
#CHECK: vmalg   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xaa]
#CHECK: vmalg   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xaa]
#CHECK: vmalg   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xaa]
#CHECK: vmalg   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xaa]
#CHECK: vmalg   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xaa]

	vmalg	%v0, %v0, %v0, %v0
	vmalg	%v0, %v0, %v0, %v31
	vmalg	%v0, %v0, %v31, %v0
	vmalg	%v0, %v31, %v0, %v0
	vmalg	%v31, %v0, %v0, %v0
	vmalg	%v13, %v17, %v21, %v25

#CHECK: vmalq   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0xaa]
#CHECK: vmalq   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0xaa]
#CHECK: vmalq   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0xaa]
#CHECK: vmalq   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0xaa]
#CHECK: vmalq   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0xaa]
#CHECK: vmalq   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0xaa]

	vmalq	%v0, %v0, %v0, %v0
	vmalq	%v0, %v0, %v0, %v31
	vmalq	%v0, %v0, %v31, %v0
	vmalq	%v0, %v31, %v0, %v0
	vmalq	%v31, %v0, %v0, %v0
	vmalq	%v13, %v17, %v21, %v25

#CHECK: vmahg   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xab]
#CHECK: vmahg   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xab]
#CHECK: vmahg   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xab]
#CHECK: vmahg   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xab]
#CHECK: vmahg   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xab]
#CHECK: vmahg   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xab]

	vmahg	%v0, %v0, %v0, %v0
	vmahg	%v0, %v0, %v0, %v31
	vmahg	%v0, %v0, %v31, %v0
	vmahg	%v0, %v31, %v0, %v0
	vmahg	%v31, %v0, %v0, %v0
	vmahg	%v13, %v17, %v21, %v25

#CHECK: vmahq   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0xab]
#CHECK: vmahq   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0xab]
#CHECK: vmahq   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0xab]
#CHECK: vmahq   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0xab]
#CHECK: vmahq   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0xab]
#CHECK: vmahq   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0xab]

	vmahq	%v0, %v0, %v0, %v0
	vmahq	%v0, %v0, %v0, %v31
	vmahq	%v0, %v0, %v31, %v0
	vmahq	%v0, %v31, %v0, %v0
	vmahq	%v31, %v0, %v0, %v0
	vmahq	%v13, %v17, %v21, %v25

#CHECK: vmalhg  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xa9]
#CHECK: vmalhg  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xa9]
#CHECK: vmalhg  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xa9]
#CHECK: vmalhg  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xa9]
#CHECK: vmalhg  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xa9]
#CHECK: vmalhg  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xa9]

	vmalhg	%v0, %v0, %v0, %v0
	vmalhg	%v0, %v0, %v0, %v31
	vmalhg	%v0, %v0, %v31, %v0
	vmalhg	%v0, %v31, %v0, %v0
	vmalhg	%v31, %v0, %v0, %v0
	vmalhg	%v13, %v17, %v21, %v25

#CHECK: vmalhq  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0xa9]
#CHECK: vmalhq  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0xa9]
#CHECK: vmalhq  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0xa9]
#CHECK: vmalhq  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0xa9]
#CHECK: vmalhq  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0xa9]
#CHECK: vmalhq  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0xa9]

	vmalhq	%v0, %v0, %v0, %v0
	vmalhq	%v0, %v0, %v0, %v31
	vmalhq	%v0, %v0, %v31, %v0
	vmalhq	%v0, %v31, %v0, %v0
	vmalhq	%v31, %v0, %v0, %v0
	vmalhq	%v13, %v17, %v21, %v25

#CHECK: vmaeg   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xae]
#CHECK: vmaeg   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xae]
#CHECK: vmaeg   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xae]
#CHECK: vmaeg   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xae]
#CHECK: vmaeg   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xae]
#CHECK: vmaeg   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xae]

	vmaeg	%v0, %v0, %v0, %v0
	vmaeg	%v0, %v0, %v0, %v31
	vmaeg	%v0, %v0, %v31, %v0
	vmaeg	%v0, %v31, %v0, %v0
	vmaeg	%v31, %v0, %v0, %v0
	vmaeg	%v13, %v17, %v21, %v25

#CHECK: vmaleg  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xac]
#CHECK: vmaleg  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xac]
#CHECK: vmaleg  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xac]
#CHECK: vmaleg  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xac]
#CHECK: vmaleg  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xac]
#CHECK: vmaleg  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xac]

	vmaleg	%v0, %v0, %v0, %v0
	vmaleg	%v0, %v0, %v0, %v31
	vmaleg	%v0, %v0, %v31, %v0
	vmaleg	%v0, %v31, %v0, %v0
	vmaleg	%v31, %v0, %v0, %v0
	vmaleg	%v13, %v17, %v21, %v25

#CHECK: vmaog   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xaf]
#CHECK: vmaog   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xaf]
#CHECK: vmaog   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xaf]
#CHECK: vmaog   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xaf]
#CHECK: vmaog   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xaf]
#CHECK: vmaog   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xaf]

	vmaog	%v0, %v0, %v0, %v0
	vmaog	%v0, %v0, %v0, %v31
	vmaog	%v0, %v0, %v31, %v0
	vmaog	%v0, %v31, %v0, %v0
	vmaog	%v31, %v0, %v0, %v0
	vmaog	%v13, %v17, %v21, %v25

#CHECK: vmalog  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xad]
#CHECK: vmalog  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xad]
#CHECK: vmalog  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xad]
#CHECK: vmalog  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xad]
#CHECK: vmalog  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xad]
#CHECK: vmalog  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xad]

	vmalog	%v0, %v0, %v0, %v0
	vmalog	%v0, %v0, %v0, %v31
	vmalog	%v0, %v0, %v31, %v0
	vmalog	%v0, %v31, %v0, %v0
	vmalog	%v31, %v0, %v0, %v0
	vmalog	%v13, %v17, %v21, %v25

#CHECK: vmlg    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xa2]
#CHECK: vmlg    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xa2]
#CHECK: vmlg    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xa2]
#CHECK: vmlg    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xa2]
#CHECK: vmlg    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xa2]

	vmlg	%v0, %v0, %v0
	vmlg	%v0, %v0, %v31
	vmlg	%v0, %v31, %v0
	vmlg	%v31, %v0, %v0
	vmlg	%v18, %v3, %v20

#CHECK: vmlq    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xa2]
#CHECK: vmlq    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xa2]
#CHECK: vmlq    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xa2]
#CHECK: vmlq    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xa2]
#CHECK: vmlq    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xa2]

	vmlq	%v0, %v0, %v0
	vmlq	%v0, %v0, %v31
	vmlq	%v0, %v31, %v0
	vmlq	%v31, %v0, %v0
	vmlq	%v18, %v3, %v20

#CHECK: vmhg    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xa3]
#CHECK: vmhg    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xa3]
#CHECK: vmhg    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xa3]
#CHECK: vmhg    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xa3]
#CHECK: vmhg    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xa3]

	vmhg	%v0, %v0, %v0
	vmhg	%v0, %v0, %v31
	vmhg	%v0, %v31, %v0
	vmhg	%v31, %v0, %v0
	vmhg	%v18, %v3, %v20

#CHECK: vmhq    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xa3]
#CHECK: vmhq    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xa3]
#CHECK: vmhq    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xa3]
#CHECK: vmhq    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xa3]
#CHECK: vmhq    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xa3]

	vmhq	%v0, %v0, %v0
	vmhq	%v0, %v0, %v31
	vmhq	%v0, %v31, %v0
	vmhq	%v31, %v0, %v0
	vmhq	%v18, %v3, %v20

#CHECK: vmlhg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xa1]
#CHECK: vmlhg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xa1]
#CHECK: vmlhg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xa1]
#CHECK: vmlhg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xa1]
#CHECK: vmlhg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xa1]

	vmlhg	%v0, %v0, %v0
	vmlhg	%v0, %v0, %v31
	vmlhg	%v0, %v31, %v0
	vmlhg	%v31, %v0, %v0
	vmlhg	%v18, %v3, %v20

#CHECK: vmlhq   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xa1]
#CHECK: vmlhq   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xa1]
#CHECK: vmlhq   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xa1]
#CHECK: vmlhq   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xa1]
#CHECK: vmlhq   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xa1]

	vmlhq	%v0, %v0, %v0
	vmlhq	%v0, %v0, %v31
	vmlhq	%v0, %v31, %v0
	vmlhq	%v31, %v0, %v0
	vmlhq	%v18, %v3, %v20

#CHECK: vmeg    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xa6]
#CHECK: vmeg    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xa6]
#CHECK: vmeg    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xa6]
#CHECK: vmeg    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xa6]
#CHECK: vmeg    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xa6]

	vmeg	%v0, %v0, %v0
	vmeg	%v0, %v0, %v31
	vmeg	%v0, %v31, %v0
	vmeg	%v31, %v0, %v0
	vmeg	%v18, %v3, %v20

#CHECK: vmleg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xa4]
#CHECK: vmleg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xa4]
#CHECK: vmleg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xa4]
#CHECK: vmleg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xa4]
#CHECK: vmleg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xa4]

	vmleg	%v0, %v0, %v0
	vmleg	%v0, %v0, %v31
	vmleg	%v0, %v31, %v0
	vmleg	%v31, %v0, %v0
	vmleg	%v18, %v3, %v20

#CHECK: vmog    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xa7]
#CHECK: vmog    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xa7]
#CHECK: vmog    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xa7]
#CHECK: vmog    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xa7]
#CHECK: vmog    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xa7]

	vmog	%v0, %v0, %v0
	vmog	%v0, %v0, %v31
	vmog	%v0, %v31, %v0
	vmog	%v31, %v0, %v0
	vmog	%v18, %v3, %v20

#CHECK: vmlog   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xa5]
#CHECK: vmlog   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xa5]
#CHECK: vmlog   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xa5]
#CHECK: vmlog   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xa5]
#CHECK: vmlog   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xa5]

	vmlog	%v0, %v0, %v0
	vmlog	%v0, %v0, %v31
	vmlog	%v0, %v31, %v0
	vmlog	%v31, %v0, %v0
	vmlog	%v18, %v3, %v20

#CHECK: vmnq	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xfe]
#CHECK: vmnq	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xfe]
#CHECK: vmnq	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xfe]
#CHECK: vmnq	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xfe]
#CHECK: vmnq	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xfe]

	vmnq	%v0, %v0, %v0
	vmnq	%v0, %v0, %v31
	vmnq	%v0, %v31, %v0
	vmnq	%v31, %v0, %v0
	vmnq	%v18, %v3, %v20

#CHECK: vmnlq	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xfc]
#CHECK: vmnlq	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xfc]
#CHECK: vmnlq	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xfc]
#CHECK: vmnlq	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xfc]
#CHECK: vmnlq	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xfc]

	vmnlq	%v0, %v0, %v0
	vmnlq	%v0, %v0, %v31
	vmnlq	%v0, %v31, %v0
	vmnlq	%v31, %v0, %v0
	vmnlq	%v18, %v3, %v20

#CHECK: vmxq	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xff]
#CHECK: vmxq	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xff]
#CHECK: vmxq	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xff]
#CHECK: vmxq	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xff]
#CHECK: vmxq	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xff]

	vmxq	%v0, %v0, %v0
	vmxq	%v0, %v0, %v31
	vmxq	%v0, %v31, %v0
	vmxq	%v31, %v0, %v0
	vmxq	%v18, %v3, %v20

#CHECK: vmxlq	%v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xfd]
#CHECK: vmxlq	%v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xfd]
#CHECK: vmxlq	%v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xfd]
#CHECK: vmxlq	%v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xfd]
#CHECK: vmxlq	%v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xfd]

	vmxlq	%v0, %v0, %v0
	vmxlq	%v0, %v0, %v31
	vmxlq	%v0, %v31, %v0
	vmxlq	%v31, %v0, %v0
	vmxlq	%v18, %v3, %v20

#CHECK: vr	%v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb3]
#CHECK: vr	%v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xb3]
#CHECK: vr	%v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xb3]
#CHECK: vr	%v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb3]
#CHECK: vr	%v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb3]
#CHECK: vr	%v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb3]
#CHECK: vr	%v13, %v17, %v21, 8, 4  # encoding: [0xe7,0xd1,0x50,0x04,0x86,0xb3]

	vr	%v0, %v0, %v0, 0, 0
	vr	%v0, %v0, %v0, 0, 15
	vr	%v0, %v0, %v0, 15, 0
	vr	%v0, %v0, %v31, 0, 0
	vr	%v0, %v31, %v0, 0, 0
	vr	%v31, %v0, %v0, 0, 0
	vr	%v13, %v17, %v21, 8, 4

#CHECK: vrf	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0xb3]
#CHECK: vrf	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x20,0xb3]
#CHECK: vrf	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xb3]
#CHECK: vrf	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xb3]
#CHECK: vrf	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xb3]
#CHECK: vrf	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x26,0xb3]

	vrf	%v0, %v0, %v0, 0
	vrf	%v0, %v0, %v0, 15
	vrf	%v0, %v0, %v31, 0
	vrf	%v0, %v31, %v0, 0
	vrf	%v31, %v0, %v0, 0
	vrf	%v13, %v17, %v21, 4

#CHECK: vrg	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x30,0xb3]
#CHECK: vrg	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x30,0xb3]
#CHECK: vrg	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xb3]
#CHECK: vrg	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xb3]
#CHECK: vrg	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xb3]
#CHECK: vrg	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x36,0xb3]

	vrg	%v0, %v0, %v0, 0
	vrg	%v0, %v0, %v0, 15
	vrg	%v0, %v0, %v31, 0
	vrg	%v0, %v31, %v0, 0
	vrg	%v31, %v0, %v0, 0
	vrg	%v13, %v17, %v21, 4

#CHECK: vrq	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x40,0xb3]
#CHECK: vrq	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x40,0xb3]
#CHECK: vrq	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xb3]
#CHECK: vrq	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xb3]
#CHECK: vrq	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xb3]
#CHECK: vrq	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x46,0xb3]

	vrq	%v0, %v0, %v0, 0
	vrq	%v0, %v0, %v0, 15
	vrq	%v0, %v0, %v31, 0
	vrq	%v0, %v31, %v0, 0
	vrq	%v31, %v0, %v0, 0
	vrq	%v13, %v17, %v21, 4

#CHECK: vrl	%v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb1]
#CHECK: vrl	%v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xb1]
#CHECK: vrl	%v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xb1]
#CHECK: vrl	%v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb1]
#CHECK: vrl	%v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb1]
#CHECK: vrl	%v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb1]
#CHECK: vrl	%v13, %v17, %v21, 8, 4  # encoding: [0xe7,0xd1,0x50,0x04,0x86,0xb1]

	vrl	%v0, %v0, %v0, 0, 0
	vrl	%v0, %v0, %v0, 0, 15
	vrl	%v0, %v0, %v0, 15, 0
	vrl	%v0, %v0, %v31, 0, 0
	vrl	%v0, %v31, %v0, 0, 0
	vrl	%v31, %v0, %v0, 0, 0
	vrl	%v13, %v17, %v21, 8, 4

#CHECK: vrlf	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0xb1]
#CHECK: vrlf	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x20,0xb1]
#CHECK: vrlf	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xb1]
#CHECK: vrlf	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xb1]
#CHECK: vrlf	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xb1]
#CHECK: vrlf	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x26,0xb1]

	vrlf	%v0, %v0, %v0, 0
	vrlf	%v0, %v0, %v0, 15
	vrlf	%v0, %v0, %v31, 0
	vrlf	%v0, %v31, %v0, 0
	vrlf	%v31, %v0, %v0, 0
	vrlf	%v13, %v17, %v21, 4

#CHECK: vrlg	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x30,0xb1]
#CHECK: vrlg	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x30,0xb1]
#CHECK: vrlg	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xb1]
#CHECK: vrlg	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xb1]
#CHECK: vrlg	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xb1]
#CHECK: vrlg	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x36,0xb1]

	vrlg	%v0, %v0, %v0, 0
	vrlg	%v0, %v0, %v0, 15
	vrlg	%v0, %v0, %v31, 0
	vrlg	%v0, %v31, %v0, 0
	vrlg	%v31, %v0, %v0, 0
	vrlg	%v13, %v17, %v21, 4

#CHECK: vrlq	%v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x40,0xb1]
#CHECK: vrlq	%v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x0f,0x40,0xb1]
#CHECK: vrlq	%v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xb1]
#CHECK: vrlq	%v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xb1]
#CHECK: vrlq	%v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xb1]
#CHECK: vrlq	%v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x04,0x46,0xb1]

	vrlq	%v0, %v0, %v0, 0
	vrlq	%v0, %v0, %v0, 15
	vrlq	%v0, %v0, %v31, 0
	vrlq	%v0, %v31, %v0, 0
	vrlq	%v31, %v0, %v0, 0
	vrlq	%v13, %v17, %v21, 4

#CHECK: vtp	%v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x00,0x5f]
#CHECK: vtp	%v0, 65535              # encoding: [0xe6,0x00,0x0f,0xff,0xf0,0x5f]
#CHECK: vtp	%v15, 4660              # encoding: [0xe6,0x0f,0x01,0x23,0x40,0x5f]

	vtp	%v0, 0
	vtp	%v0, 65535
	vtp	%v15, 4660

#CHECK: vtz	%v0, %v0, 0             # encoding: [0xe6,0x00,0x00,0x00,0x00,0x7f]
#CHECK: vtz	%v0, %v0, 65535         # encoding: [0xe6,0x00,0x0f,0xff,0xf0,0x7f]
#CHECK: vtz	%v0, %v31, 0            # encoding: [0xe6,0x00,0xf0,0x00,0x02,0x7f]
#CHECK: vtz	%v31, %v0, 0            # encoding: [0xe6,0x0f,0x00,0x00,0x04,0x7f]
#CHECK: vtz	%v13, %v17, 4660        # encoding: [0xe6,0x0d,0x11,0x23,0x42,0x7f]

	vtz	%v0, %v0, 0
	vtz	%v0, %v0, 65535
	vtz	%v0, %v31, 0
	vtz	%v31, %v0, 0
	vtz	%v13, %v17, 4660

#CHECK: vuphg   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xd7]
#CHECK: vuphg   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xd7]
#CHECK: vuphg   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xd7]
#CHECK: vuphg   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xd7]
#CHECK: vuphg   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xd7]
#CHECK: vuphg   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xd7]

	vuphg	%v0, %v0
	vuphg	%v0, %v15
	vuphg	%v0, %v31
	vuphg	%v15, %v0
	vuphg	%v31, %v0
	vuphg	%v14, %v17

#CHECK: vuplg   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xd6]
#CHECK: vuplg   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xd6]
#CHECK: vuplg   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xd6]
#CHECK: vuplg   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xd6]
#CHECK: vuplg   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xd6]
#CHECK: vuplg   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xd6]

	vuplg	%v0, %v0
	vuplg	%v0, %v15
	vuplg	%v0, %v31
	vuplg	%v15, %v0
	vuplg	%v31, %v0
	vuplg	%v14, %v17

#CHECK: vuplhg  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xd5]
#CHECK: vuplhg  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xd5]
#CHECK: vuplhg  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xd5]
#CHECK: vuplhg  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xd5]
#CHECK: vuplhg  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xd5]
#CHECK: vuplhg  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xd5]

	vuplhg	%v0, %v0
	vuplhg	%v0, %v15
	vuplhg	%v0, %v31
	vuplhg	%v15, %v0
	vuplhg	%v31, %v0
	vuplhg	%v14, %v17

#CHECK: vupllg  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xd4]
#CHECK: vupllg  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xd4]
#CHECK: vupllg  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xd4]
#CHECK: vupllg  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xd4]
#CHECK: vupllg  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xd4]
#CHECK: vupllg  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xd4]

	vupllg	%v0, %v0
	vupllg	%v0, %v15
	vupllg	%v0, %v31
	vupllg	%v15, %v0
	vupllg	%v31, %v0
	vupllg	%v14, %v17

