; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefixes=CHECK,X64

define i32 @i32_zext_shift_i16_zext_i1(i1 %a0) nounwind {
; CHECK-LABEL: i32_zext_shift_i16_zext_i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    ret{{[l|q]}}
  %t0 = zext i1 %a0 to i16
  %t1 = lshr i16 %t0, 5
  %t2 = zext i16 %t1 to i32
  ret i32 %t2
}

define i32 @i32_zext_shift_i16_zext_i8(i8 %a0) nounwind {
; X86-LABEL: i32_zext_shift_i16_zext_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $5, %eax
; X86-NEXT:    retl
;
; X64-LABEL: i32_zext_shift_i16_zext_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    shrl $5, %eax
; X64-NEXT:    retq
  %t0 = zext i8 %a0 to i16
  %t1 = lshr i16 %t0, 5
  %t2 = zext i16 %t1 to i32
  ret i32 %t2
}

define i64 @i64_zext_shift_i16_zext_i8(i8 %a0) nounwind {
; X86-LABEL: i64_zext_shift_i16_zext_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $5, %eax
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    retl
;
; X64-LABEL: i64_zext_shift_i16_zext_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    shrl $5, %eax
; X64-NEXT:    retq
  %t0 = zext i8 %a0 to i16
  %t1 = lshr i16 %t0, 5
  %t2 = zext i16 %t1 to i64
  ret i64 %t2
}

define i64 @i64_zext_shift_i32_zext_i8(i8 %a0) nounwind {
; X86-LABEL: i64_zext_shift_i32_zext_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $3, %eax
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    retl
;
; X64-LABEL: i64_zext_shift_i32_zext_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    shrl $3, %eax
; X64-NEXT:    retq
  %t0 = zext i8 %a0 to i32
  %t1 = lshr i32 %t0, 3
  %t2 = zext i32 %t1 to i64
  ret i64 %t2
}

define i64 @i64_zext_shift_i32_zext_i16(i16 %a0) nounwind {
; X86-LABEL: i64_zext_shift_i32_zext_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $5, %eax
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    retl
;
; X64-LABEL: i64_zext_shift_i32_zext_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    shrl $5, %eax
; X64-NEXT:    retq
  %t0 = zext i16 %a0 to i32
  %t1 = lshr i32 %t0, 5
  %t2 = zext i32 %t1 to i64
  ret i64 %t2
}

define i128 @i128_zext_shift_i64_zext_i8(i8 %a0) nounwind {
; X86-LABEL: i128_zext_shift_i64_zext_i8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shrl $4, %ecx
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl $0, 12(%eax)
; X86-NEXT:    movl $0, 8(%eax)
; X86-NEXT:    movl $0, 4(%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: i128_zext_shift_i64_zext_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    shrl $4, %eax
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    retq
  %t0 = zext i8 %a0 to i64
  %t1 = lshr i64 %t0, 4
  %t2 = zext i64 %t1 to i128
  ret i128 %t2
}

define i128 @i128_zext_shift_i64_zext_i16(i16 %a0) nounwind {
; X86-LABEL: i128_zext_shift_i64_zext_i16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shrl $7, %ecx
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl $0, 12(%eax)
; X86-NEXT:    movl $0, 8(%eax)
; X86-NEXT:    movl $0, 4(%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: i128_zext_shift_i64_zext_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    shrl $7, %eax
; X64-NEXT:    xorl %edx, %edx
; X64-NEXT:    retq
  %t0 = zext i16 %a0 to i64
  %t1 = lshr i64 %t0,7
  %t2 = zext i64 %t1 to i128
  ret i128 %t2
}
