; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=i686-- < %s | FileCheck %s

; No attributes, should not use idiv
define i32 @test1(i32 inreg %x) {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    sarl $31, %ecx
; CHECK-NEXT:    shrl $28, %ecx
; CHECK-NEXT:    addl %ecx, %eax
; CHECK-NEXT:    sarl $4, %eax
; CHECK-NEXT:    retl
entry:
  %div = sdiv i32 %x, 16
  ret i32 %div
}

; Has minsize (-Oz) attribute, should generate idiv
define i32 @test2(i32 inreg %x) minsize {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl $16
; CHECK-NEXT:    .cfi_adjust_cfa_offset 4
; CHECK-NEXT:    popl %ecx
; CHECK-NEXT:    .cfi_adjust_cfa_offset -4
; CHECK-NEXT:    cltd
; CHECK-NEXT:    idivl %ecx
; CHECK-NEXT:    retl
entry:
  %div = sdiv i32 %x, 16
  ret i32 %div
}

; Has optsize (-Os) attribute, should not generate idiv
define i32 @test3(i32 inreg %x) optsize {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    sarl $31, %ecx
; CHECK-NEXT:    shrl $28, %ecx
; CHECK-NEXT:    addl %ecx, %eax
; CHECK-NEXT:    sarl $4, %eax
; CHECK-NEXT:    retl
entry:
  %div = sdiv i32 %x, 16
  ret i32 %div
}


