; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64 -relocation-model=static < %s | FileCheck --check-prefixes=STATIC %s
; RUN: llc -mtriple=x86_64 -relocation-model=pic < %s | FileCheck --check-prefixes=PIC %s
; RUN: llc -mtriple=x86_64 -code-model=medium -relocation-model=static < %s | FileCheck --check-prefixes=MSTATIC %s
; RUN: llc -mtriple=x86_64 -code-model=medium -relocation-model=pic < %s | FileCheck --check-prefixes=MPIC %s

@foo = internal global i32 0

define dso_local i64 @zero() #0 {
; STATIC-LABEL: zero:
; STATIC:       # %bb.0: # %entry
; STATIC-NEXT:    movl $foo, %eax
; STATIC-NEXT:    retq
;
; PIC-LABEL: zero:
; PIC:       # %bb.0: # %entry
; PIC-NEXT:    leaq foo(%rip), %rax
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: zero:
; MSTATIC:       # %bb.0: # %entry
; MSTATIC-NEXT:    movabsq $foo, %rax
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: zero:
; MPIC:       # %bb.0: # %entry
; MPIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MPIC-NEXT:    movabsq $foo@GOTOFF, %rax
; MPIC-NEXT:    addq %rcx, %rax
; MPIC-NEXT:    retq
entry:
  ret i64 add (i64 ptrtoint (ptr @foo to i64), i64 0)
}

define dso_local i64 @one() #0 {
; STATIC-LABEL: one:
; STATIC:       # %bb.0: # %entry
; STATIC-NEXT:    movl $foo+1, %eax
; STATIC-NEXT:    retq
;
; PIC-LABEL: one:
; PIC:       # %bb.0: # %entry
; PIC-NEXT:    leaq foo+1(%rip), %rax
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: one:
; MSTATIC:       # %bb.0: # %entry
; MSTATIC-NEXT:    movabsq $foo+1, %rax
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: one:
; MPIC:       # %bb.0: # %entry
; MPIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MPIC-NEXT:    movabsq $foo@GOTOFF, %rcx
; MPIC-NEXT:    leaq 1(%rax,%rcx), %rax
; MPIC-NEXT:    retq
entry:
  ret i64 add (i64 ptrtoint (ptr @foo to i64), i64 1)
}

;; Check we don't fold a large offset into leaq, otherwise
;; the large r_addend can easily cause a relocation overflow.
define dso_local i64 @large() #0 {
; STATIC-LABEL: large:
; STATIC:       # %bb.0: # %entry
; STATIC-NEXT:    movl $1701208431, %eax # imm = 0x6566616F
; STATIC-NEXT:    leaq foo(%rax), %rax
; STATIC-NEXT:    retq
;
; PIC-LABEL: large:
; PIC:       # %bb.0: # %entry
; PIC-NEXT:    leaq foo(%rip), %rax
; PIC-NEXT:    addq $1701208431, %rax # imm = 0x6566616F
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: large:
; MSTATIC:       # %bb.0: # %entry
; MSTATIC-NEXT:    movabsq $foo, %rax
; MSTATIC-NEXT:    addq $1701208431, %rax # imm = 0x6566616F
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: large:
; MPIC:       # %bb.0: # %entry
; MPIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MPIC-NEXT:    movabsq $foo@GOTOFF, %rcx
; MPIC-NEXT:    leaq 1701208431(%rax,%rcx), %rax
; MPIC-NEXT:    retq
entry:
  ret i64 add (i64 ptrtoint (ptr @foo to i64), i64 1701208431)
}

;; Test we don't emit movl foo-1, %eax. ELF R_X86_64_32 does not allow
;; a negative value.
define dso_local i64 @neg_1() #0 {
; STATIC-LABEL: neg_1:
; STATIC:       # %bb.0: # %entry
; STATIC-NEXT:    leaq foo-1(%rip), %rax
; STATIC-NEXT:    retq
;
; PIC-LABEL: neg_1:
; PIC:       # %bb.0: # %entry
; PIC-NEXT:    leaq foo-1(%rip), %rax
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: neg_1:
; MSTATIC:       # %bb.0: # %entry
; MSTATIC-NEXT:    movabsq $foo, %rax
; MSTATIC-NEXT:    decq %rax
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: neg_1:
; MPIC:       # %bb.0: # %entry
; MPIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MPIC-NEXT:    movabsq $foo@GOTOFF, %rcx
; MPIC-NEXT:    leaq -1(%rax,%rcx), %rax
; MPIC-NEXT:    retq
entry:
  ret i64 add (i64 ptrtoint (ptr @foo to i64), i64 -1)
}

;; Test we don't emit movl foo-2147483648, %eax. ELF R_X86_64_32 does not allow
;; a negative value.
define dso_local i64 @neg_0x80000000() #0 {
; STATIC-LABEL: neg_0x80000000:
; STATIC:       # %bb.0: # %entry
; STATIC-NEXT:    leaq foo-2147483648(%rip), %rax
; STATIC-NEXT:    retq
;
; PIC-LABEL: neg_0x80000000:
; PIC:       # %bb.0: # %entry
; PIC-NEXT:    leaq foo-2147483648(%rip), %rax
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: neg_0x80000000:
; MSTATIC:       # %bb.0: # %entry
; MSTATIC-NEXT:    movabsq $foo, %rax
; MSTATIC-NEXT:    addq $-2147483648, %rax # imm = 0x80000000
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: neg_0x80000000:
; MPIC:       # %bb.0: # %entry
; MPIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MPIC-NEXT:    movabsq $foo@GOTOFF, %rcx
; MPIC-NEXT:    leaq -2147483648(%rax,%rcx), %rax
; MPIC-NEXT:    retq
entry:
  ret i64 add (i64 ptrtoint (ptr @foo to i64), i64 -2147483648)
}

define dso_local i64 @neg_0x80000001() #0 {
; STATIC-LABEL: neg_0x80000001:
; STATIC:       # %bb.0: # %entry
; STATIC-NEXT:    movabsq $-2147483649, %rax # imm = 0xFFFFFFFF7FFFFFFF
; STATIC-NEXT:    leaq foo(%rax), %rax
; STATIC-NEXT:    retq
;
; PIC-LABEL: neg_0x80000001:
; PIC:       # %bb.0: # %entry
; PIC-NEXT:    leaq foo(%rip), %rcx
; PIC-NEXT:    movabsq $-2147483649, %rax # imm = 0xFFFFFFFF7FFFFFFF
; PIC-NEXT:    addq %rcx, %rax
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: neg_0x80000001:
; MSTATIC:       # %bb.0: # %entry
; MSTATIC-NEXT:    movabsq $-2147483649, %rcx # imm = 0xFFFFFFFF7FFFFFFF
; MSTATIC-NEXT:    movabsq $foo, %rax
; MSTATIC-NEXT:    addq %rcx, %rax
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: neg_0x80000001:
; MPIC:       # %bb.0: # %entry
; MPIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MPIC-NEXT:    movabsq $foo@GOTOFF, %rcx
; MPIC-NEXT:    addq %rax, %rcx
; MPIC-NEXT:    movabsq $-2147483649, %rax # imm = 0xFFFFFFFF7FFFFFFF
; MPIC-NEXT:    addq %rcx, %rax
; MPIC-NEXT:    retq
entry:
  ret i64 add (i64 ptrtoint (ptr @foo to i64), i64 -2147483649)
}

define internal void @bar() #0 {
; STATIC-LABEL: bar:
; STATIC:       # %bb.0:
; STATIC-NEXT:    retq
;
; PIC-LABEL: bar:
; PIC:       # %bb.0:
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: bar:
; MSTATIC:       # %bb.0:
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: bar:
; MPIC:       # %bb.0:
; MPIC-NEXT:    retq
  ret void
}

define dso_local i64 @fun_neg_0xfeffffff() #0 {
; STATIC-LABEL: fun_neg_0xfeffffff:
; STATIC:       # %bb.0:
; STATIC-NEXT:    movl $bar, %eax
; STATIC-NEXT:    addq $-16777217, %rax # imm = 0xFEFFFFFF
; STATIC-NEXT:    retq
;
; PIC-LABEL: fun_neg_0xfeffffff:
; PIC:       # %bb.0:
; PIC-NEXT:    leaq bar-16777217(%rip), %rax
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: fun_neg_0xfeffffff:
; MSTATIC:       # %bb.0:
; MSTATIC-NEXT:    movl $bar, %eax
; MSTATIC-NEXT:    addq $-16777217, %rax # imm = 0xFEFFFFFF
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: fun_neg_0xfeffffff:
; MPIC:       # %bb.0:
; MPIC-NEXT:    leaq bar-16777217(%rip), %rax
; MPIC-NEXT:    retq
  ret i64 add (i64 ptrtoint (ptr @bar to i64), i64 -16777217)
}

define dso_local i64 @fun_neg_ff000000() #0 {
; STATIC-LABEL: fun_neg_ff000000:
; STATIC:       # %bb.0:
; STATIC-NEXT:    leaq bar-16777216(%rip), %rax
; STATIC-NEXT:    retq
;
; PIC-LABEL: fun_neg_ff000000:
; PIC:       # %bb.0:
; PIC-NEXT:    leaq bar-16777216(%rip), %rax
; PIC-NEXT:    retq
;
; MSTATIC-LABEL: fun_neg_ff000000:
; MSTATIC:       # %bb.0:
; MSTATIC-NEXT:    leaq bar-16777216(%rip), %rax
; MSTATIC-NEXT:    retq
;
; MPIC-LABEL: fun_neg_ff000000:
; MPIC:       # %bb.0:
; MPIC-NEXT:    leaq bar-16777216(%rip), %rax
; MPIC-NEXT:    retq
  ret i64 add (i64 ptrtoint (ptr @bar to i64), i64 -16777216)
}

attributes #0 = { nounwind }
