; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zve64d,+f,+d,+zvfh \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, i64, <vscale x 16 x i1>, i64, i64)

define void @test_vssseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, i64, <vscale x 32 x i1>, i64, i64)

define void @test_vssseg2_nxv32i8_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv32i8_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg2_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, ma
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 32 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, i64, <vscale x 16 x i1>, i64, i64)

define void @test_vssseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, i64, <vscale x 16 x i1>, i64, i64)

define void @test_vssseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf4, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, i64, i64, i64)
declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 3)
  ret void
}

define void @test_vssseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e8, m1, ta, ma
; CHECK-NEXT:    vssseg8e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 3)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, i64, <vscale x 16 x i1>, i64, i64)

define void @test_vssseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, i64, <vscale x 8 x i1>, i64, i64)

define void @test_vssseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, i64, <vscale x 4 x i1>, i64, i64)

define void @test_vssseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, i64, <vscale x 2 x i1>, i64, i64)

define void @test_vssseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg5e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg5e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg6e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg6e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg7e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg7e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}

declare void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, i64, <vscale x 1 x i1>, i64, i64)

define void @test_vssseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg8e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg8e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m4, ta, ma
; CHECK-NEXT:    vssseg2e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg3e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; CHECK-NEXT:    vssseg4e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg5e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg6_nxv1f32_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1f32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg6_mask_nxv1f32_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1f32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg6_nxv2f32_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv2f32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg6_mask_nxv2f32_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv2f32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg6e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg7_nxv1f32_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1f32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg7_mask_nxv1f32_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1f32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg7_nxv2f32_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv2f32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg7_mask_nxv2f32_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv2f32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg7e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg8_nxv1f32_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1f32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg8_mask_nxv1f32_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1f32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, mf2, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg8_nxv2f32_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv2f32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 5)
  ret void
}

define void @test_vssseg8_mask_nxv2f32_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv2f32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e32, m1, ta, ma
; CHECK-NEXT:    vssseg8e32.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 5)
  ret void
}


define void @test_vssseg2_nxv1f64_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1f64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg2_mask_nxv1f64_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1f64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg2_nxv2f64_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2f64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg2_mask_nxv2f64_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2f64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg2_nxv4f64_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4f64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg2_mask_nxv4f64_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4f64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m4, ta, ma
; CHECK-NEXT:    vssseg2e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg3_nxv1f64_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1f64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg3_mask_nxv1f64_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1f64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg3_nxv2f64_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2f64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg3_mask_nxv2f64_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2f64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg3e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg4_nxv1f64_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1f64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg4_mask_nxv1f64_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1f64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg4_nxv2f64_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2f64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg4_mask_nxv2f64_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2f64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-NEXT:    vssseg4e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg5_nxv1f64_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1f64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg5e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg5_mask_nxv1f64_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1f64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg5e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg6_nxv1f64_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1f64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg6e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg6_mask_nxv1f64_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1f64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg6e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg7_nxv1f64_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1f64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg7e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg7_mask_nxv1f64_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1f64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg7e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg8_nxv1f64_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1f64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg8e64.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 6)
  ret void
}

define void @test_vssseg8_mask_nxv1f64_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1f64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-NEXT:    vssseg8e64.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 6)
  ret void
}


define void @test_vssseg2_nxv1bf16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1bf16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv2bf16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv2bf16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv4bf16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv4bf16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv8bf16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv8bf16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg2_nxv16bf16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg2_nxv16bf16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg2_mask_nxv16bf16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vssseg2_mask_nxv16bf16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %offset, <vscale x 16 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv1bf16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1bf16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv2bf16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv2bf16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv4bf16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv4bf16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg3_nxv8bf16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg3_nxv8bf16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg3_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg3_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg3e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv1bf16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1bf16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv2bf16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv2bf16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv4bf16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv4bf16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg4_nxv8bf16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg4_nxv8bf16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg4_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vssseg4_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m2, ta, ma
; CHECK-NEXT:    vssseg4e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %offset, <vscale x 8 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg5_nxv1bf16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1bf16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg5_nxv2bf16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv2bf16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg5_nxv4bf16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg5_nxv4bf16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg5_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg5_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg5e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg6_nxv1bf16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1bf16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg6_nxv2bf16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv2bf16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg6_nxv4bf16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg6_nxv4bf16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg6_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg6_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg6e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg7_nxv1bf16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1bf16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg7_nxv2bf16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv2bf16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg7_nxv4bf16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg7_nxv4bf16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg7_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg7_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg7e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg8_nxv1bf16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1bf16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf4, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 1 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg8_nxv2bf16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv2bf16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, mf2, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 2 x i1> %mask, i64 %vl, i64 4)
  ret void
}


define void @test_vssseg8_nxv4bf16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl) {
; CHECK-LABEL: test_vssseg8_nxv4bf16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, i64 4)
  ret void
}

define void @test_vssseg8_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vssseg8_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; CHECK-NEXT:    vssseg8e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %offset, <vscale x 4 x i1> %mask, i64 %vl, i64 4)
  ret void
}

