; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-BE

define <2 x double> @test2elt(i16 %a.coerce) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r4, r2, .LCPI0_0@toc@ha
; CHECK-P8-NEXT:    mtvsrd v3, r3
; CHECK-P8-NEXT:    xxlxor v4, v4, v4
; CHECK-P8-NEXT:    addi r4, r4, .LCPI0_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    vperm v2, v4, v3, v2
; CHECK-P8-NEXT:    xvcvuxddp v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprd f0, r3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; CHECK-P9-NEXT:    xxlxor vs2, vs2, vs2
; CHECK-P9-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; CHECK-P9-NEXT:    lxv vs1, 0(r3)
; CHECK-P9-NEXT:    xxperm vs0, vs2, vs1
; CHECK-P9-NEXT:    xvcvuxddp v2, vs0
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtfprwz f0, r3
; CHECK-BE-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; CHECK-BE-NEXT:    xxlxor vs2, vs2, vs2
; CHECK-BE-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; CHECK-BE-NEXT:    lxv vs1, 0(r3)
; CHECK-BE-NEXT:    xxperm vs0, vs2, vs1
; CHECK-BE-NEXT:    xvcvuxddp v2, vs0
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i16 %a.coerce to <2 x i8>
  %1 = uitofp <2 x i8> %0 to <2 x double>
  ret <2 x double> %1
}

define void @test4elt(ptr noalias nocapture sret(<4 x double>) %agg.result, i32 %a.coerce) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r5, r2, .LCPI1_0@toc@ha
; CHECK-P8-NEXT:    mtvsrwz v4, r4
; CHECK-P8-NEXT:    xxlxor v5, v5, v5
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    addi r5, r5, .LCPI1_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI1_1@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI1_1@toc@l
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r5
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    vperm v2, v5, v4, v2
; CHECK-P8-NEXT:    xvcvuxddp vs0, v2
; CHECK-P8-NEXT:    xxswapd v3, vs1
; CHECK-P8-NEXT:    vperm v3, v5, v4, v3
; CHECK-P8-NEXT:    xvcvuxddp vs1, v3
; CHECK-P8-NEXT:    xxswapd vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs0, 0, r3
; CHECK-P8-NEXT:    xxswapd vs1, vs1
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrwz v2, r4
; CHECK-P9-NEXT:    addis r4, r2, .LCPI1_0@toc@ha
; CHECK-P9-NEXT:    xxlxor v4, v4, v4
; CHECK-P9-NEXT:    addi r4, r4, .LCPI1_0@toc@l
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI1_1@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI1_1@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    xvcvuxddp vs0, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    vperm v2, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs1, v2
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrwz v2, r4
; CHECK-BE-NEXT:    addis r4, r2, .LCPI1_0@toc@ha
; CHECK-BE-NEXT:    xxlxor v4, v4, v4
; CHECK-BE-NEXT:    addi r4, r4, .LCPI1_0@toc@l
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI1_1@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI1_1@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    xvcvuxddp vs0, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    vperm v2, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs1, v2
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i32 %a.coerce to <4 x i8>
  %1 = uitofp <4 x i8> %0 to <4 x double>
  store <4 x double> %1, ptr %agg.result, align 32
  ret void
}

define void @test8elt(ptr noalias nocapture sret(<8 x double>) %agg.result, i64 %a.coerce) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test8elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r5, r2, .LCPI2_0@toc@ha
; CHECK-P8-NEXT:    mtvsrd v0, r4
; CHECK-P8-NEXT:    xxlxor v1, v1, v1
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    addi r5, r5, .LCPI2_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI2_1@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI2_1@toc@l
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI2_3@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI2_3@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI2_2@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI2_2@toc@l
; CHECK-P8-NEXT:    xxswapd v3, vs0
; CHECK-P8-NEXT:    vperm v3, v1, v0, v3
; CHECK-P8-NEXT:    xvcvuxddp vs0, v3
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    vperm v4, v1, v0, v4
; CHECK-P8-NEXT:    xvcvuxddp vs1, v4
; CHECK-P8-NEXT:    xxswapd v2, vs2
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r5
; CHECK-P8-NEXT:    vperm v2, v1, v0, v2
; CHECK-P8-NEXT:    xxswapd vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs0, 0, r3
; CHECK-P8-NEXT:    xxswapd v5, vs2
; CHECK-P8-NEXT:    xvcvuxddp vs2, v2
; CHECK-P8-NEXT:    xxswapd vs1, vs1
; CHECK-P8-NEXT:    vperm v5, v1, v0, v5
; CHECK-P8-NEXT:    xvcvuxddp vs3, v5
; CHECK-P8-NEXT:    xxswapd vs2, vs2
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r4
; CHECK-P8-NEXT:    li r4, 32
; CHECK-P8-NEXT:    xxswapd vs3, vs3
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r4
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrd v2, r4
; CHECK-P9-NEXT:    addis r4, r2, .LCPI2_0@toc@ha
; CHECK-P9-NEXT:    xxlxor v4, v4, v4
; CHECK-P9-NEXT:    addi r4, r4, .LCPI2_0@toc@l
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI2_1@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI2_1@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    xvcvuxddp vs0, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI2_2@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI2_2@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs1, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI2_3@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI2_3@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs2, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    vperm v2, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs2, 32(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs3, v2
; CHECK-P9-NEXT:    stxv vs3, 48(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrd v2, r4
; CHECK-BE-NEXT:    addis r4, r2, .LCPI2_0@toc@ha
; CHECK-BE-NEXT:    xxlxor v4, v4, v4
; CHECK-BE-NEXT:    addi r4, r4, .LCPI2_0@toc@l
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI2_1@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI2_1@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    xvcvuxddp vs0, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI2_2@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI2_2@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs1, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI2_3@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI2_3@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs2, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    vperm v2, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs2, 32(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs3, v2
; CHECK-BE-NEXT:    stxv vs3, 48(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i64 %a.coerce to <8 x i8>
  %1 = uitofp <8 x i8> %0 to <8 x double>
  store <8 x double> %1, ptr %agg.result, align 64
  ret void
}

define void @test16elt(ptr noalias nocapture sret(<16 x double>) %agg.result, <16 x i8> %a) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test16elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_0@toc@ha
; CHECK-P8-NEXT:    xxlxor v0, v0, v0
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_1@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_1@toc@l
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_3@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_3@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_4@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_4@toc@l
; CHECK-P8-NEXT:    lxvd2x vs3, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_6@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_6@toc@l
; CHECK-P8-NEXT:    lxvd2x vs4, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_7@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_7@toc@l
; CHECK-P8-NEXT:    lxvd2x vs5, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_5@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_5@toc@l
; CHECK-P8-NEXT:    xxswapd v7, vs0
; CHECK-P8-NEXT:    vperm v7, v0, v2, v7
; CHECK-P8-NEXT:    xvcvuxddp vs0, v7
; CHECK-P8-NEXT:    xxswapd v8, vs1
; CHECK-P8-NEXT:    vperm v8, v0, v2, v8
; CHECK-P8-NEXT:    xvcvuxddp vs1, v8
; CHECK-P8-NEXT:    xxswapd v1, vs2
; CHECK-P8-NEXT:    vperm v1, v0, v2, v1
; CHECK-P8-NEXT:    xxswapd vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs0, 0, r3
; CHECK-P8-NEXT:    xxswapd v6, vs3
; CHECK-P8-NEXT:    vperm v6, v0, v2, v6
; CHECK-P8-NEXT:    xvcvuxddp vs6, v6
; CHECK-P8-NEXT:    xxswapd vs1, vs1
; CHECK-P8-NEXT:    xxswapd v3, vs4
; CHECK-P8-NEXT:    lxvd2x vs4, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI3_2@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI3_2@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r4
; CHECK-P8-NEXT:    li r4, 112
; CHECK-P8-NEXT:    vperm v3, v0, v2, v3
; CHECK-P8-NEXT:    xvcvuxddp vs3, v3
; CHECK-P8-NEXT:    xxswapd v4, vs5
; CHECK-P8-NEXT:    xvcvuxddp vs5, v1
; CHECK-P8-NEXT:    vperm v4, v0, v2, v4
; CHECK-P8-NEXT:    xxswapd v5, vs4
; CHECK-P8-NEXT:    xvcvuxddp vs4, v4
; CHECK-P8-NEXT:    vperm v5, v0, v2, v5
; CHECK-P8-NEXT:    xxswapd vs3, vs3
; CHECK-P8-NEXT:    xvcvuxddp vs7, v5
; CHECK-P8-NEXT:    xxswapd v9, vs2
; CHECK-P8-NEXT:    xxswapd vs4, vs4
; CHECK-P8-NEXT:    vperm v2, v0, v2, v9
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r4
; CHECK-P8-NEXT:    li r4, 96
; CHECK-P8-NEXT:    xvcvuxddp vs2, v2
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r4
; CHECK-P8-NEXT:    li r4, 80
; CHECK-P8-NEXT:    xxswapd vs4, vs5
; CHECK-P8-NEXT:    xxswapd vs7, vs7
; CHECK-P8-NEXT:    xxswapd vs3, vs6
; CHECK-P8-NEXT:    stxvd2x vs7, r3, r4
; CHECK-P8-NEXT:    li r4, 64
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r4
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r4
; CHECK-P8-NEXT:    li r4, 32
; CHECK-P8-NEXT:    xxswapd vs2, vs2
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r4
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_0@toc@ha
; CHECK-P9-NEXT:    xxlxor v4, v4, v4
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_0@toc@l
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_1@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_1@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    xvcvuxddp vs0, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_2@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_2@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs1, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_3@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_3@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs2, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_4@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_4@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs2, 32(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs3, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_5@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_5@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs3, 48(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs4, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_6@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_6@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs4, 64(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs5, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI3_7@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI3_7@toc@l
; CHECK-P9-NEXT:    vperm v3, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs5, 80(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs6, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    vperm v2, v4, v2, v3
; CHECK-P9-NEXT:    stxv vs6, 96(r3)
; CHECK-P9-NEXT:    xvcvuxddp vs7, v2
; CHECK-P9-NEXT:    stxv vs7, 112(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_0@toc@ha
; CHECK-BE-NEXT:    xxlxor v4, v4, v4
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_0@toc@l
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_1@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_1@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    xvcvuxddp vs0, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_2@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_2@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs1, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_3@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_3@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs2, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_4@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_4@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs2, 32(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs3, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_5@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_5@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs3, 48(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs4, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_6@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_6@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs4, 64(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs5, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI3_7@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI3_7@toc@l
; CHECK-BE-NEXT:    vperm v3, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs5, 80(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs6, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    vperm v2, v4, v2, v3
; CHECK-BE-NEXT:    stxv vs6, 96(r3)
; CHECK-BE-NEXT:    xvcvuxddp vs7, v2
; CHECK-BE-NEXT:    stxv vs7, 112(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = uitofp <16 x i8> %a to <16 x double>
  store <16 x double> %0, ptr %agg.result, align 128
  ret void
}

define <2 x double> @test2elt_signed(i16 %a.coerce) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r4, r2, .LCPI4_0@toc@ha
; CHECK-P8-NEXT:    mtvsrd v3, r3
; CHECK-P8-NEXT:    addis r3, r2, .LCPI4_1@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI4_0@toc@l
; CHECK-P8-NEXT:    addi r3, r3, .LCPI4_1@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    vperm v2, v3, v3, v2
; CHECK-P8-NEXT:    lxvd2x v3, 0, r3
; CHECK-P8-NEXT:    vsld v2, v2, v3
; CHECK-P8-NEXT:    vsrad v2, v2, v3
; CHECK-P8-NEXT:    xvcvsxddp v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrd v2, r3
; CHECK-P9-NEXT:    addis r3, r2, .LCPI4_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI4_0@toc@l
; CHECK-P9-NEXT:    lxv vs0, 0(r3)
; CHECK-P9-NEXT:    xxperm v2, v2, vs0
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xvcvsxddp v2, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrwz v2, r3
; CHECK-BE-NEXT:    addis r3, r2, .LCPI4_0@toc@ha
; CHECK-BE-NEXT:    addi r3, r3, .LCPI4_0@toc@l
; CHECK-BE-NEXT:    lxv vs0, 0(r3)
; CHECK-BE-NEXT:    xxperm v2, v2, vs0
; CHECK-BE-NEXT:    vextsb2d v2, v2
; CHECK-BE-NEXT:    xvcvsxddp v2, v2
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i16 %a.coerce to <2 x i8>
  %1 = sitofp <2 x i8> %0 to <2 x double>
  ret <2 x double> %1
}

define void @test4elt_signed(ptr noalias nocapture sret(<4 x double>) %agg.result, i32 %a.coerce) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r5, r2, .LCPI5_0@toc@ha
; CHECK-P8-NEXT:    mtvsrwz v4, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI5_1@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI5_0@toc@l
; CHECK-P8-NEXT:    addi r4, r4, .LCPI5_1@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI5_2@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI5_2@toc@l
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r5
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    vperm v2, v4, v4, v2
; CHECK-P8-NEXT:    xxswapd v3, vs1
; CHECK-P8-NEXT:    vperm v3, v4, v4, v3
; CHECK-P8-NEXT:    lxvd2x v4, 0, r4
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    vsld v2, v2, v4
; CHECK-P8-NEXT:    vsrad v2, v2, v4
; CHECK-P8-NEXT:    xvcvsxddp vs0, v2
; CHECK-P8-NEXT:    vsld v2, v3, v4
; CHECK-P8-NEXT:    vsrad v2, v2, v4
; CHECK-P8-NEXT:    xvcvsxddp vs1, v2
; CHECK-P8-NEXT:    xxswapd vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs0, 0, r3
; CHECK-P8-NEXT:    xxswapd vs1, vs1
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrwz v2, r4
; CHECK-P9-NEXT:    addis r4, r2, .LCPI5_0@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI5_0@toc@l
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI5_1@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI5_1@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs0, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    vperm v2, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xvcvsxddp vs1, v2
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrwz v2, r4
; CHECK-BE-NEXT:    addis r4, r2, .LCPI5_0@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI5_0@toc@l
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI5_1@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI5_1@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs0, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    vperm v2, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    vextsb2d v2, v2
; CHECK-BE-NEXT:    xvcvsxddp vs1, v2
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i32 %a.coerce to <4 x i8>
  %1 = sitofp <4 x i8> %0 to <4 x double>
  store <4 x double> %1, ptr %agg.result, align 32
  ret void
}

define void @test8elt_signed(ptr noalias nocapture sret(<8 x double>) %agg.result, i64 %a.coerce) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test8elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r5, r2, .LCPI6_0@toc@ha
; CHECK-P8-NEXT:    mtvsrd v0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI6_1@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI6_0@toc@l
; CHECK-P8-NEXT:    addi r4, r4, .LCPI6_1@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI6_2@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI6_2@toc@l
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI6_4@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI6_4@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r5
; CHECK-P8-NEXT:    addis r5, r2, .LCPI6_3@toc@ha
; CHECK-P8-NEXT:    addi r5, r5, .LCPI6_3@toc@l
; CHECK-P8-NEXT:    xxswapd v3, vs0
; CHECK-P8-NEXT:    vperm v3, v0, v0, v3
; CHECK-P8-NEXT:    xxswapd v4, vs1
; CHECK-P8-NEXT:    vperm v4, v0, v0, v4
; CHECK-P8-NEXT:    xxswapd v2, vs2
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r5
; CHECK-P8-NEXT:    vperm v2, v0, v0, v2
; CHECK-P8-NEXT:    xxswapd v5, vs2
; CHECK-P8-NEXT:    vperm v5, v0, v0, v5
; CHECK-P8-NEXT:    lxvd2x v0, 0, r4
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    vsld v2, v2, v0
; CHECK-P8-NEXT:    vsld v5, v5, v0
; CHECK-P8-NEXT:    vsld v3, v3, v0
; CHECK-P8-NEXT:    vsld v4, v4, v0
; CHECK-P8-NEXT:    vsrad v2, v2, v0
; CHECK-P8-NEXT:    vsrad v5, v5, v0
; CHECK-P8-NEXT:    vsrad v3, v3, v0
; CHECK-P8-NEXT:    vsrad v4, v4, v0
; CHECK-P8-NEXT:    xvcvsxddp vs2, v2
; CHECK-P8-NEXT:    xvcvsxddp vs3, v5
; CHECK-P8-NEXT:    xvcvsxddp vs0, v3
; CHECK-P8-NEXT:    xvcvsxddp vs1, v4
; CHECK-P8-NEXT:    xxswapd vs2, vs2
; CHECK-P8-NEXT:    xxswapd vs3, vs3
; CHECK-P8-NEXT:    xxswapd vs1, vs1
; CHECK-P8-NEXT:    xxswapd vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r4
; CHECK-P8-NEXT:    li r4, 32
; CHECK-P8-NEXT:    stxvd2x vs0, 0, r3
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r4
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrd v2, r4
; CHECK-P9-NEXT:    addis r4, r2, .LCPI6_0@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI6_0@toc@l
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI6_1@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI6_1@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs0, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI6_2@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI6_2@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs1, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI6_3@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI6_3@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs2, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    vperm v2, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs2, 32(r3)
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xvcvsxddp vs3, v2
; CHECK-P9-NEXT:    stxv vs3, 48(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrd v2, r4
; CHECK-BE-NEXT:    addis r4, r2, .LCPI6_0@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI6_0@toc@l
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI6_1@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI6_1@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs0, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI6_2@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI6_2@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs1, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI6_3@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI6_3@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs2, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    vperm v2, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs2, 32(r3)
; CHECK-BE-NEXT:    vextsb2d v2, v2
; CHECK-BE-NEXT:    xvcvsxddp vs3, v2
; CHECK-BE-NEXT:    stxv vs3, 48(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i64 %a.coerce to <8 x i8>
  %1 = sitofp <8 x i8> %0 to <8 x double>
  store <8 x double> %1, ptr %agg.result, align 64
  ret void
}

define void @test16elt_signed(ptr noalias nocapture sret(<16 x double>) %agg.result, <16 x i8> %a) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test16elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_0@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_0@toc@l
; CHECK-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_2@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_2@toc@l
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_4@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_4@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_7@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_7@toc@l
; CHECK-P8-NEXT:    lxvd2x vs3, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_8@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_8@toc@l
; CHECK-P8-NEXT:    lxvd2x vs4, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_6@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_6@toc@l
; CHECK-P8-NEXT:    xxswapd v6, vs0
; CHECK-P8-NEXT:    vperm v6, v2, v2, v6
; CHECK-P8-NEXT:    xxswapd v7, vs1
; CHECK-P8-NEXT:    vperm v7, v2, v2, v7
; CHECK-P8-NEXT:    xxswapd v0, vs2
; CHECK-P8-NEXT:    vperm v0, v2, v2, v0
; CHECK-P8-NEXT:    xxswapd v3, vs3
; CHECK-P8-NEXT:    lxvd2x vs3, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_5@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_5@toc@l
; CHECK-P8-NEXT:    vperm v3, v2, v2, v3
; CHECK-P8-NEXT:    xxswapd v4, vs4
; CHECK-P8-NEXT:    vperm v4, v2, v2, v4
; CHECK-P8-NEXT:    xxswapd v5, vs3
; CHECK-P8-NEXT:    lxvd2x vs3, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_3@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_3@toc@l
; CHECK-P8-NEXT:    lxvd2x vs2, 0, r4
; CHECK-P8-NEXT:    addis r4, r2, .LCPI7_1@toc@ha
; CHECK-P8-NEXT:    addi r4, r4, .LCPI7_1@toc@l
; CHECK-P8-NEXT:    vperm v5, v2, v2, v5
; CHECK-P8-NEXT:    xxswapd v1, vs3
; CHECK-P8-NEXT:    vperm v1, v2, v2, v1
; CHECK-P8-NEXT:    xxswapd v8, vs2
; CHECK-P8-NEXT:    vperm v2, v2, v2, v8
; CHECK-P8-NEXT:    lxvd2x v8, 0, r4
; CHECK-P8-NEXT:    li r4, 112
; CHECK-P8-NEXT:    vsld v4, v4, v8
; CHECK-P8-NEXT:    vsld v3, v3, v8
; CHECK-P8-NEXT:    vsld v5, v5, v8
; CHECK-P8-NEXT:    vsld v1, v1, v8
; CHECK-P8-NEXT:    vsld v0, v0, v8
; CHECK-P8-NEXT:    vsld v2, v2, v8
; CHECK-P8-NEXT:    vsld v6, v6, v8
; CHECK-P8-NEXT:    vsld v7, v7, v8
; CHECK-P8-NEXT:    vsrad v4, v4, v8
; CHECK-P8-NEXT:    vsrad v3, v3, v8
; CHECK-P8-NEXT:    vsrad v5, v5, v8
; CHECK-P8-NEXT:    vsrad v1, v1, v8
; CHECK-P8-NEXT:    vsrad v0, v0, v8
; CHECK-P8-NEXT:    vsrad v2, v2, v8
; CHECK-P8-NEXT:    vsrad v6, v6, v8
; CHECK-P8-NEXT:    vsrad v7, v7, v8
; CHECK-P8-NEXT:    xvcvsxddp vs4, v4
; CHECK-P8-NEXT:    xvcvsxddp vs3, v3
; CHECK-P8-NEXT:    xvcvsxddp vs7, v5
; CHECK-P8-NEXT:    xvcvsxddp vs6, v1
; CHECK-P8-NEXT:    xvcvsxddp vs5, v0
; CHECK-P8-NEXT:    xvcvsxddp vs2, v2
; CHECK-P8-NEXT:    xvcvsxddp vs0, v6
; CHECK-P8-NEXT:    xvcvsxddp vs1, v7
; CHECK-P8-NEXT:    xxswapd vs4, vs4
; CHECK-P8-NEXT:    xxswapd vs3, vs3
; CHECK-P8-NEXT:    xxswapd vs7, vs7
; CHECK-P8-NEXT:    xxswapd vs2, vs2
; CHECK-P8-NEXT:    xxswapd vs1, vs1
; CHECK-P8-NEXT:    xxswapd vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r4
; CHECK-P8-NEXT:    li r4, 96
; CHECK-P8-NEXT:    xxswapd vs4, vs5
; CHECK-P8-NEXT:    stxvd2x vs0, 0, r3
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r4
; CHECK-P8-NEXT:    li r4, 80
; CHECK-P8-NEXT:    stxvd2x vs7, r3, r4
; CHECK-P8-NEXT:    li r4, 64
; CHECK-P8-NEXT:    xxswapd vs3, vs6
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r4
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r4
; CHECK-P8-NEXT:    li r4, 32
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r4
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_0@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_0@toc@l
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_1@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_1@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs0, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_2@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_2@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs1, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_3@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_3@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs2, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_4@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_4@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs2, 32(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs3, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_5@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_5@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs3, 48(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs4, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_6@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_6@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs4, 64(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs5, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    addis r4, r2, .LCPI7_7@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, .LCPI7_7@toc@l
; CHECK-P9-NEXT:    vperm v3, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs5, 80(r3)
; CHECK-P9-NEXT:    vextsb2d v3, v3
; CHECK-P9-NEXT:    xvcvsxddp vs6, v3
; CHECK-P9-NEXT:    lxv v3, 0(r4)
; CHECK-P9-NEXT:    vperm v2, v2, v2, v3
; CHECK-P9-NEXT:    stxv vs6, 96(r3)
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xvcvsxddp vs7, v2
; CHECK-P9-NEXT:    stxv vs7, 112(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_0@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_0@toc@l
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_1@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_1@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs0, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_2@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_2@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs1, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_3@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_3@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs2, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_4@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_4@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs2, 32(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs3, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_5@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_5@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs3, 48(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs4, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_6@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_6@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs4, 64(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs5, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    addis r4, r2, .LCPI7_7@toc@ha
; CHECK-BE-NEXT:    addi r4, r4, .LCPI7_7@toc@l
; CHECK-BE-NEXT:    vperm v3, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs5, 80(r3)
; CHECK-BE-NEXT:    vextsb2d v3, v3
; CHECK-BE-NEXT:    xvcvsxddp vs6, v3
; CHECK-BE-NEXT:    lxv v3, 0(r4)
; CHECK-BE-NEXT:    vperm v2, v2, v2, v3
; CHECK-BE-NEXT:    stxv vs6, 96(r3)
; CHECK-BE-NEXT:    vextsb2d v2, v2
; CHECK-BE-NEXT:    xvcvsxddp vs7, v2
; CHECK-BE-NEXT:    stxv vs7, 112(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = sitofp <16 x i8> %a to <16 x double>
  store <16 x double> %0, ptr %agg.result, align 128
  ret void
}
