; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX900,GFX900-MUBUF %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx906 -mattr=-promote-alloca,+sram-ecc -verify-machineinstrs < %s | FileCheck --check-prefix=GFX906 %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck --check-prefix=GFX803 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-promote-alloca -verify-machineinstrs --mattr=+enable-flat-scratch < %s | FileCheck -check-prefixes=GFX900,GFX900-FLATSCR %s

define <2 x i16> @load_local_lo_v2i16_undeflo(ptr addrspace(3) %in) #0 {
; GFX900-LABEL: load_local_lo_v2i16_undeflo:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ds_read_u16_d16 v0, v0
; GFX900-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_undeflo:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_undeflo:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i16, ptr addrspace(3) %in
  %build = insertelement <2 x i16> poison, i16 %load, i32 0
  ret <2 x i16> %build
}

define <2 x i16> @load_local_lo_v2i16_reglo(ptr addrspace(3) %in, i16 %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2i16_reglo:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_u16 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reglo:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reglo:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2i16_reglo:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_u16 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i16, ptr addrspace(3) %in
  %build0 = insertelement <2 x i16> poison, i16 %reg, i32 1
  %build1 = insertelement <2 x i16> %build0, i16 %load, i32 0
  ret <2 x i16> %build1
}

; Show that we get reasonable regalloc without physreg constraints.
define void @load_local_lo_v2i16_reglo_vreg(ptr addrspace(3) %in, i16 %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2i16_reglo_vreg:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_u16 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2i16_reglo_vreg:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_u16 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i16, ptr addrspace(3) %in
  %build0 = insertelement <2 x i16> poison, i16 %reg, i32 1
  %build1 = insertelement <2 x i16> %build0, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define <2 x i16> @load_local_lo_v2i16_zerolo(ptr addrspace(3) %in) #0 {
; GFX900-LABEL: load_local_lo_v2i16_zerolo:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v1, 0
; GFX900-NEXT:    ds_read_u16_d16 v1, v0
; GFX900-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_zerolo:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_zerolo:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i16, ptr addrspace(3) %in
  %build = insertelement <2 x i16> zeroinitializer, i16 %load, i32 0
  ret <2 x i16> %build
}

define <2 x half> @load_local_lo_v2f16_fpimm(ptr addrspace(3) %in) #0 {
; GFX900-LABEL: load_local_lo_v2f16_fpimm:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v1, 2.0
; GFX900-NEXT:    ds_read_u16_d16 v1, v0
; GFX900-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2f16_fpimm:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_movk_i32 s4, 0x4000
; GFX906-NEXT:    v_mov_b32_e32 v1, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, s4, v0, v1
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2f16_fpimm:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, 2.0, v0
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load half, ptr addrspace(3) %in
  %build = insertelement <2 x half> <half 0.0, half 2.0>, half %load, i32 0
  ret <2 x half> %build
}

define void @load_local_lo_v2f16_reghi_vreg(ptr addrspace(3) %in, i32 %reg) #0 {
; GFX900-LABEL: load_local_lo_v2f16_reghi_vreg:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ds_read_u16_d16 v1, v0
; GFX900-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2f16_reghi_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2f16_reghi_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %load = load half, ptr addrspace(3) %in
  %build1 = insertelement <2 x half> %reg.bc, half %load, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2f16_reglo_vreg(ptr addrspace(3) %in, half %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2f16_reglo_vreg:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_u16 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2f16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2f16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2f16_reglo_vreg:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_u16 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load half, ptr addrspace(3) %in
  %build0 = insertelement <2 x half> poison, half %reg, i32 1
  %build1 = insertelement <2 x half> %build0, half %load, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2i16_reghi_vreg_zexti8(ptr addrspace(3) %in, i32 %reg) #0 {
; GFX900-LABEL: load_local_lo_v2i16_reghi_vreg_zexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ds_read_u8_d16 v1, v0
; GFX900-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reghi_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u8 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reghi_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u8 v0, v0
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load i8, ptr addrspace(3) %in
  %ext = zext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2i16_reglo_vreg_zexti8(ptr addrspace(3) %in, i16 %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2i16_reglo_vreg_zexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_u8 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u8 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u8 v0, v0
; GFX803-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2i16_reglo_vreg_zexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_u8 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i8, ptr addrspace(3) %in
  %ext = zext i8 %load to i16
  %build0 = insertelement <2 x i16> poison, i16 %reg, i32 1
  %build1 = insertelement <2 x i16> %build0, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2i16_reghi_vreg_sexti8(ptr addrspace(3) %in, i32 %reg) #0 {
; GFX900-LABEL: load_local_lo_v2i16_reghi_vreg_sexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ds_read_i8_d16 v1, v0
; GFX900-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reghi_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_i8 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reghi_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_i8 v0, v0
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load i8, ptr addrspace(3) %in
  %ext = sext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2i16_reglo_vreg_sexti8(ptr addrspace(3) %in, i16 %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2i16_reglo_vreg_sexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_i8 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_i8 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_i8 v0, v0
; GFX803-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2i16_reglo_vreg_sexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_i8 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i8, ptr addrspace(3) %in
  %ext = sext i8 %load to i16
  %build0 = insertelement <2 x i16> poison, i16 %reg, i32 1
  %build1 = insertelement <2 x i16> %build0, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2f16_reglo_vreg_zexti8(ptr addrspace(3) %in, half %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2f16_reglo_vreg_zexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_u8 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2f16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u8 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2f16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u8 v0, v0
; GFX803-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2f16_reglo_vreg_zexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_u8 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i8, ptr addrspace(3) %in
  %ext = zext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build0 = insertelement <2 x half> poison, half %reg, i32 1
  %build1 = insertelement <2 x half> %build0, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2f16_reglo_vreg_sexti8(ptr addrspace(3) %in, half %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2f16_reglo_vreg_sexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_i8 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2f16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_i8 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2f16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_i8 v0, v0
; GFX803-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2f16_reglo_vreg_sexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_i8 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i8, ptr addrspace(3) %in
  %ext = sext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build0 = insertelement <2 x half> poison, half %reg, i32 1
  %build1 = insertelement <2 x half> %build0, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2i16_reghi_vreg_multi_use_lo(ptr addrspace(3) %in, <2 x i16> %reg) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lo:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_u16 v0, v0
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_write_b16 v2, v0
; GFX900-MUBUF-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lo:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    v_mov_b32_e32 v2, 0
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    ds_write_b16 v2, v0
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lo:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    v_mov_b32_e32 v2, 0
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    ds_write_b16 v2, v0
; GFX803-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lo:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_u16 v0, v0
; GFX900-FLATSCR-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0xffff
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_write_b16 v2, v0
; GFX900-FLATSCR-NEXT:    v_bfi_b32 v0, s0, v0, v1
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i16, ptr addrspace(3) %in
  %elt1 = extractelement <2 x i16> %reg, i32 1
  store i16 %load, ptr addrspace(3) null
  %build1 = insertelement <2 x i16> %reg, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2i16_reghi_vreg_multi_use_hi(ptr addrspace(3) %in, <2 x i16> %reg) #0 {
; GFX900-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_hi:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX900-NEXT:    ds_read_u16_d16 v1, v0
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ds_write_b16 v0, v2
; GFX900-NEXT:    s_waitcnt lgkmcnt(1)
; GFX900-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_hi:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX906-NEXT:    v_mov_b32_e32 v3, 0
; GFX906-NEXT:    ds_write_b16 v3, v2
; GFX906-NEXT:    s_waitcnt lgkmcnt(1)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_hi:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX803-NEXT:    v_mov_b32_e32 v3, 0
; GFX803-NEXT:    ds_write_b16 v3, v2
; GFX803-NEXT:    s_waitcnt lgkmcnt(1)
; GFX803-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i16, ptr addrspace(3) %in
  %elt1 = extractelement <2 x i16> %reg, i32 1
  store i16 %elt1, ptr addrspace(3) null
  %build1 = insertelement <2 x i16> %reg, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_local_lo_v2i16_reghi_vreg_multi_use_lohi(ptr addrspace(3) noalias %in, <2 x i16> %reg, ptr addrspace(3) noalias %out0, ptr addrspace(3) noalias %out1) #0 {
; GFX900-MUBUF-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lohi:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_read_u16 v0, v0
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-MUBUF-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX900-MUBUF-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-MUBUF-NEXT:    ds_write_b16 v2, v0
; GFX900-MUBUF-NEXT:    ds_write_b16 v3, v4
; GFX900-MUBUF-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lohi:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    ds_read_u16 v0, v0
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX906-NEXT:    s_waitcnt lgkmcnt(0)
; GFX906-NEXT:    ds_write_b16 v2, v0
; GFX906-NEXT:    ds_write_b16 v3, v4
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lohi:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_mov_b32 m0, -1
; GFX803-NEXT:    ds_read_u16 v0, v0
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX803-NEXT:    s_waitcnt lgkmcnt(0)
; GFX803-NEXT:    ds_write_b16 v2, v0
; GFX803-NEXT:    ds_write_b16 v3, v4
; GFX803-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_local_lo_v2i16_reghi_vreg_multi_use_lohi:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_read_u16 v0, v0
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0xffff
; GFX900-FLATSCR-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX900-FLATSCR-NEXT:    s_waitcnt lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    ds_write_b16 v2, v0
; GFX900-FLATSCR-NEXT:    ds_write_b16 v3, v4
; GFX900-FLATSCR-NEXT:    v_bfi_b32 v0, s0, v0, v1
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %load = load i16, ptr addrspace(3) %in
  %elt1 = extractelement <2 x i16> %reg, i32 1
  store i16 %load, ptr addrspace(3) %out0
  store i16 %elt1, ptr addrspace(3) %out1
  %build1 = insertelement <2 x i16> %reg, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_global_lo_v2i16_reglo_vreg(ptr addrspace(1) %in, i32 %reg) #0 {
; GFX900-LABEL: load_global_lo_v2i16_reglo_vreg:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_short_d16 v2, v[0:1], off offset:-4094
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_global_lo_v2i16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_ushort v0, v[0:1], off offset:-4094
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_global_lo_v2i16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff002, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_ushort v0, v[0:1]
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %gep = getelementptr inbounds i16, ptr addrspace(1) %in, i64 -2047
  %load = load i16, ptr addrspace(1) %gep
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_global_lo_v2f16_reglo_vreg(ptr addrspace(1) %in, i32 %reg) #0 {
; GFX900-LABEL: load_global_lo_v2f16_reglo_vreg:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_short_d16 v2, v[0:1], off offset:-4094
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_global_lo_v2f16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_ushort v0, v[0:1], off offset:-4094
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_global_lo_v2f16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff002, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_ushort v0, v[0:1]
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %gep = getelementptr inbounds half, ptr addrspace(1) %in, i64 -2047
  %load = load half, ptr addrspace(1) %gep
  %build1 = insertelement <2 x half> %reg.bc, half %load, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_global_lo_v2i16_reglo_vreg_zexti8(ptr addrspace(1) %in, i32 %reg) #0 {
; GFX900-LABEL: load_global_lo_v2i16_reglo_vreg_zexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_ubyte_d16 v2, v[0:1], off offset:-4095
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_global_lo_v2i16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_ubyte v0, v[0:1], off offset:-4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_global_lo_v2i16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff001, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %gep = getelementptr inbounds i8, ptr addrspace(1) %in, i64 -4095
  %load = load i8, ptr addrspace(1) %gep
  %ext = zext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_global_lo_v2i16_reglo_vreg_sexti8(ptr addrspace(1) %in, i32 %reg) #0 {
; GFX900-LABEL: load_global_lo_v2i16_reglo_vreg_sexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_sbyte_d16 v2, v[0:1], off offset:-4095
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_global_lo_v2i16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_sbyte v0, v[0:1], off offset:-4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_global_lo_v2i16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff001, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_sbyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %gep = getelementptr inbounds i8, ptr addrspace(1) %in, i64 -4095
  %load = load i8, ptr addrspace(1) %gep
  %ext = sext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_global_lo_v2f16_reglo_vreg_zexti8(ptr addrspace(1) %in, i32 %reg) #0 {
; GFX900-LABEL: load_global_lo_v2f16_reglo_vreg_zexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_ubyte_d16 v2, v[0:1], off offset:-4095
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_global_lo_v2f16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_ubyte v0, v[0:1], off offset:-4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_global_lo_v2f16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff001, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %gep = getelementptr inbounds i8, ptr addrspace(1) %in, i64 -4095
  %load = load i8, ptr addrspace(1) %gep
  %ext = zext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_global_lo_v2f16_reglo_vreg_sexti8(ptr addrspace(1) %in, i32 %reg) #0 {
; GFX900-LABEL: load_global_lo_v2f16_reglo_vreg_sexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_sbyte_d16 v2, v[0:1], off offset:-4095
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_global_lo_v2f16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_sbyte v0, v[0:1], off offset:-4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_global_lo_v2f16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff001, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_sbyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %gep = getelementptr inbounds i8, ptr addrspace(1) %in, i64 -4095
  %load = load i8, ptr addrspace(1) %gep
  %ext = sext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_flat_lo_v2i16_reghi_vreg(ptr %in, i32 %reg) #0 {
; GFX900-LABEL: load_flat_lo_v2i16_reghi_vreg:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    flat_load_short_d16 v2, v[0:1]
; GFX900-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_flat_lo_v2i16_reghi_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    flat_load_ushort v0, v[0:1]
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_flat_lo_v2i16_reghi_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    flat_load_ushort v0, v[0:1]
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load i16, ptr %in
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_flat_lo_v2f16_reghi_vreg(ptr %in, i32 %reg) #0 {
; GFX900-LABEL: load_flat_lo_v2f16_reghi_vreg:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    flat_load_short_d16 v2, v[0:1]
; GFX900-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_flat_lo_v2f16_reghi_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    flat_load_ushort v0, v[0:1]
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_flat_lo_v2f16_reghi_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    flat_load_ushort v0, v[0:1]
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]

; FIXME: the and above should be removable
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %load = load half, ptr %in
  %build1 = insertelement <2 x half> %reg.bc, half %load, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_flat_lo_v2i16_reglo_vreg_zexti8(ptr %in, i32 %reg) #0 {
; GFX900-LABEL: load_flat_lo_v2i16_reglo_vreg_zexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    flat_load_ubyte_d16 v2, v[0:1]
; GFX900-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_flat_lo_v2i16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_flat_lo_v2i16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load i8, ptr %in
  %ext = zext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_flat_lo_v2i16_reglo_vreg_sexti8(ptr %in, i32 %reg) #0 {
; GFX900-LABEL: load_flat_lo_v2i16_reglo_vreg_sexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    flat_load_sbyte_d16 v2, v[0:1]
; GFX900-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_flat_lo_v2i16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    flat_load_sbyte v0, v[0:1]
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_flat_lo_v2i16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    flat_load_sbyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load i8, ptr %in
  %ext = sext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_flat_lo_v2f16_reglo_vreg_zexti8(ptr %in, i32 %reg) #0 {
; GFX900-LABEL: load_flat_lo_v2f16_reglo_vreg_zexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    flat_load_ubyte_d16 v2, v[0:1]
; GFX900-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_flat_lo_v2f16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_flat_lo_v2f16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %load = load i8, ptr %in
  %ext = zext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_flat_lo_v2f16_reglo_vreg_sexti8(ptr %in, i32 %reg) #0 {
; GFX900-LABEL: load_flat_lo_v2f16_reglo_vreg_sexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    flat_load_sbyte_d16 v2, v[0:1]
; GFX900-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_flat_lo_v2f16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    flat_load_sbyte v0, v[0:1]
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_flat_lo_v2f16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    flat_load_sbyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %load = load i8, ptr %in
  %ext = sext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg(ptr addrspace(5) byval(i16) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_short_d16 v0, off, s[0:3], s32 offset:4094
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:4094
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:4094
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    scratch_load_short_d16 v0, off, s32 offset:4094
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %gep = getelementptr inbounds i16, ptr addrspace(5) %in, i64 2047
  %load = load i16, ptr addrspace(5) %gep
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reghi_vreg(ptr addrspace(5) byval(i16) %in, i16 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reghi_vreg:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:4094
; GFX900-MUBUF-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reghi_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:4094
; GFX906-NEXT:    s_mov_b32 s4, 0x5040100
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reghi_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:4094
; GFX803-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reghi_vreg:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    scratch_load_ushort v1, off, s32 offset:4094
; GFX900-FLATSCR-NEXT:    s_mov_b32 s0, 0x5040100
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    v_perm_b32 v0, v0, v1, s0
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %gep = getelementptr inbounds i16, ptr addrspace(5) %in, i64 2047
  %load = load i16, ptr addrspace(5) %gep
  %build0 = insertelement <2 x i16> poison, i16 %reg, i32 1
  %build1 = insertelement <2 x i16> %build0, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2f16_reglo_vreg(ptr addrspace(5) byval(half) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2f16_reglo_vreg:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_short_d16 v0, off, s[0:3], s32 offset:4094
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2f16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:4094
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2f16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ushort v1, off, s[0:3], s32 offset:4094
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2f16_reglo_vreg:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    scratch_load_short_d16 v0, off, s32 offset:4094
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %gep = getelementptr inbounds half, ptr addrspace(5) %in, i64 2047
  %load = load half, ptr addrspace(5) %gep
  %build1 = insertelement <2 x half> %reg.bc, half %load, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_nooff(ptr addrspace(5) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_nooff:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_short_d16 v1, off, s[0:3], 0 offset:4094 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_nooff:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ushort v0, off, s[0:3], 0 offset:4094 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_nooff:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ushort v0, off, s[0:3], 0 offset:4094 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_nooff:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_movk_i32 s0, 0xffe
; GFX900-FLATSCR-NEXT:    scratch_load_short_d16 v1, off, s0 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load volatile i16, ptr addrspace(5) inttoptr (i32 4094 to ptr addrspace(5))
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reghi_vreg_nooff(ptr addrspace(5) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reghi_vreg_nooff:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_short_d16 v1, off, s[0:3], 0 offset:4094 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reghi_vreg_nooff:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ushort v0, off, s[0:3], 0 offset:4094 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reghi_vreg_nooff:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ushort v0, off, s[0:3], 0 offset:4094 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reghi_vreg_nooff:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_movk_i32 s0, 0xffe
; GFX900-FLATSCR-NEXT:    scratch_load_short_d16 v1, off, s0 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load volatile i16, ptr addrspace(5) inttoptr (i32 4094 to ptr addrspace(5))
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2f16_reglo_vreg_nooff(ptr addrspace(5) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2f16_reglo_vreg_nooff:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_short_d16 v1, off, s[0:3], 0 offset:4094 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2f16_reglo_vreg_nooff:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ushort v0, off, s[0:3], 0 offset:4094 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2f16_reglo_vreg_nooff:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ushort v0, off, s[0:3], 0 offset:4094 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2f16_reglo_vreg_nooff:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_movk_i32 s0, 0xffe
; GFX900-FLATSCR-NEXT:    scratch_load_short_d16 v1, off, s0 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %load = load volatile half, ptr addrspace(5) inttoptr (i32 4094 to ptr addrspace(5))
  %build1 = insertelement <2 x half> %reg.bc, half %load, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_zexti8(ptr addrspace(5) byval(i8) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_ubyte_d16 v0, off, s[0:3], s32 offset:4095
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ubyte v1, off, s[0:3], s32 offset:4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ubyte v1, off, s[0:3], s32 offset:4095
; GFX803-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    scratch_load_ubyte_d16 v0, off, s32 offset:4095
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %gep = getelementptr inbounds i8, ptr addrspace(5) %in, i64 4095
  %load = load i8, ptr addrspace(5) %gep
  %ext = zext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_sexti8(ptr addrspace(5) byval(i8) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_sbyte_d16 v0, off, s[0:3], s32 offset:4095
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_sbyte v1, off, s[0:3], s32 offset:4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_sbyte v1, off, s[0:3], s32 offset:4095
; GFX803-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    scratch_load_sbyte_d16 v0, off, s32 offset:4095
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %gep = getelementptr inbounds i8, ptr addrspace(5) %in, i64 4095
  %load = load i8, ptr addrspace(5) %gep
  %ext = sext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_nooff_zexti8(ptr addrspace(5) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_zexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_ubyte_d16 v1, off, s[0:3], 0 offset:4094 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0 offset:4094 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0 offset:4094 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_zexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_movk_i32 s0, 0xffe
; GFX900-FLATSCR-NEXT:    scratch_load_ubyte_d16 v1, off, s0 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load volatile i8, ptr addrspace(5) inttoptr (i32 4094 to ptr addrspace(5))
  %ext = zext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_nooff_sexti8(ptr addrspace(5) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_sexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_sbyte_d16 v1, off, s[0:3], 0 offset:4094 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_sbyte v0, off, s[0:3], 0 offset:4094 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_sbyte v0, off, s[0:3], 0 offset:4094 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_nooff_sexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_movk_i32 s0, 0xffe
; GFX900-FLATSCR-NEXT:    scratch_load_sbyte_d16 v1, off, s0 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %load = load volatile i8, ptr addrspace(5) inttoptr (i32 4094 to ptr addrspace(5))
  %ext = sext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2f16_reglo_vreg_nooff_zexti8(ptr addrspace(5) %in, i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2f16_reglo_vreg_nooff_zexti8:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    buffer_load_ubyte_d16 v1, off, s[0:3], 0 offset:4094 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2f16_reglo_vreg_nooff_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0 offset:4094 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2f16_reglo_vreg_nooff_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0 offset:4094 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2f16_reglo_vreg_nooff_zexti8:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    s_movk_i32 s0, 0xffe
; GFX900-FLATSCR-NEXT:    scratch_load_ubyte_d16 v1, off, s0 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v1, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %load = load volatile i8, ptr addrspace(5) inttoptr (i32 4094 to ptr addrspace(5))
  %ext = zext i8 %load to i16
  %bc.ext = bitcast i16 %ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bc.ext, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_constant_lo_v2i16_reglo_vreg(ptr addrspace(4) %in, i32 %reg) #0 {
; GFX900-LABEL: load_constant_lo_v2i16_reglo_vreg:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_short_d16 v2, v[0:1], off offset:-4094
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_constant_lo_v2i16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_ushort v0, v[0:1], off offset:-4094
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_constant_lo_v2i16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff002, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_ushort v0, v[0:1]
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x i16>
  %gep = getelementptr inbounds i16, ptr addrspace(4) %in, i64 -2047
  %load = load i16, ptr addrspace(4) %gep
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_constant_lo_v2f16_reglo_vreg(ptr addrspace(4) %in, i32 %reg) #0 {
; GFX900-LABEL: load_constant_lo_v2f16_reglo_vreg:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_short_d16 v2, v[0:1], off offset:-4094
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_constant_lo_v2f16_reglo_vreg:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_ushort v0, v[0:1], off offset:-4094
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_constant_lo_v2f16_reglo_vreg:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff002, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_ushort v0, v[0:1]
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %gep = getelementptr inbounds half, ptr addrspace(4) %in, i64 -2047
  %load = load half, ptr addrspace(4) %gep
  %build1 = insertelement <2 x half> %reg.bc, half %load, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_constant_lo_v2f16_reglo_vreg_zexti8(ptr addrspace(4) %in, i32 %reg) #0 {
; GFX900-LABEL: load_constant_lo_v2f16_reglo_vreg_zexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_ubyte_d16 v2, v[0:1], off offset:-4095
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_constant_lo_v2f16_reglo_vreg_zexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_ubyte v0, v[0:1], off offset:-4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_constant_lo_v2f16_reglo_vreg_zexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff001, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %gep = getelementptr inbounds i8, ptr addrspace(4) %in, i64 -4095
  %load = load i8, ptr addrspace(4) %gep
  %ext = zext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_constant_lo_v2f16_reglo_vreg_sexti8(ptr addrspace(4) %in, i32 %reg) #0 {
; GFX900-LABEL: load_constant_lo_v2f16_reglo_vreg_sexti8:
; GFX900:       ; %bb.0: ; %entry
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    global_load_sbyte_d16 v2, v[0:1], off offset:-4095
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    global_store_dword v[0:1], v2, off
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_constant_lo_v2f16_reglo_vreg_sexti8:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    global_load_sbyte v0, v[0:1], off offset:-4095
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_constant_lo_v2f16_reglo_vreg_sexti8:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff001, v0
; GFX803-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX803-NEXT:    flat_load_sbyte v0, v[0:1]
; GFX803-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
entry:
  %reg.bc = bitcast i32 %reg to <2 x half>
  %gep = getelementptr inbounds i8, ptr addrspace(4) %in, i64 -4095
  %load = load i8, ptr addrspace(4) %gep
  %ext = sext i8 %load to i16
  %bitcast = bitcast i16 %ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_to_offset(i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_to_offset:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 44
; GFX900-MUBUF-NEXT:    buffer_load_short_d16 v0, v1, s[0:3], s32 offen offset:4054 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_to_offset:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX906-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v2, 44
; GFX906-NEXT:    buffer_load_ushort v1, v2, s[0:3], s32 offen offset:4054 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_to_offset:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX803-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v2, 44
; GFX803-NEXT:    buffer_load_ushort v1, v2, s[0:3], s32 offen offset:4054 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_mov_b32 s4, 0x3020504
; GFX803-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_to_offset:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-FLATSCR-NEXT:    scratch_store_dword off, v1, s32 offset:4
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_add_i32 s0, s32, 44
; GFX900-FLATSCR-NEXT:    scratch_load_short_d16 v0, off, s0 offset:4054 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %obj0 = alloca [10 x i32], align 4, addrspace(5)
  %obj1 = alloca [4096 x i16], align 2, addrspace(5)
  %reg.bc = bitcast i32 %reg to <2 x i16>
  store volatile i32 123, ptr addrspace(5) %obj0
  %gep = getelementptr inbounds [4096 x i16], ptr addrspace(5) %obj1, i32 0, i32 2027
  %load = load volatile i16, ptr addrspace(5) %gep
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_sexti8_to_offset(i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8_to_offset:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 44
; GFX900-MUBUF-NEXT:    buffer_load_sbyte_d16 v0, v1, s[0:3], s32 offen offset:4055 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8_to_offset:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX906-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v2, 44
; GFX906-NEXT:    buffer_load_sbyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8_to_offset:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX803-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v2, 44
; GFX803-NEXT:    buffer_load_sbyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX803-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_sexti8_to_offset:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-FLATSCR-NEXT:    scratch_store_dword off, v1, s32 offset:4
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_add_i32 s0, s32, 44
; GFX900-FLATSCR-NEXT:    scratch_load_sbyte_d16 v0, off, s0 offset:4055 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %obj0 = alloca [10 x i32], align 4, addrspace(5)
  %obj1 = alloca [4096 x i8], align 2, addrspace(5)
  %reg.bc = bitcast i32 %reg to <2 x i16>
  store volatile i32 123, ptr addrspace(5) %obj0
  %gep = getelementptr inbounds [4096 x i8], ptr addrspace(5) %obj1, i32 0, i32 4055
  %load = load volatile i8, ptr addrspace(5) %gep
  %load.ext = sext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load.ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2i16_reglo_vreg_zexti8_to_offset(i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8_to_offset:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 44
; GFX900-MUBUF-NEXT:    buffer_load_ubyte_d16 v0, v1, s[0:3], s32 offen offset:4055 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8_to_offset:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX906-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v2, 44
; GFX906-NEXT:    buffer_load_ubyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8_to_offset:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX803-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v2, 44
; GFX803-NEXT:    buffer_load_ubyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX803-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2i16_reglo_vreg_zexti8_to_offset:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-FLATSCR-NEXT:    scratch_store_dword off, v1, s32 offset:4
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_add_i32 s0, s32, 44
; GFX900-FLATSCR-NEXT:    scratch_load_ubyte_d16 v0, off, s0 offset:4055 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %obj0 = alloca [10 x i32], align 4, addrspace(5)
  %obj1 = alloca [4096 x i8], align 2, addrspace(5)
  %reg.bc = bitcast i32 %reg to <2 x i16>
  store volatile i32 123, ptr addrspace(5) %obj0
  %gep = getelementptr inbounds [4096 x i8], ptr addrspace(5) %obj1, i32 0, i32 4055
  %load = load volatile i8, ptr addrspace(5) %gep
  %load.ext = zext i8 %load to i16
  %build1 = insertelement <2 x i16> %reg.bc, i16 %load.ext, i32 0
  store <2 x i16> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2f16_reglo_vreg_sexti8_to_offset(i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2f16_reglo_vreg_sexti8_to_offset:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 44
; GFX900-MUBUF-NEXT:    buffer_load_sbyte_d16 v0, v1, s[0:3], s32 offen offset:4055 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2f16_reglo_vreg_sexti8_to_offset:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX906-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v2, 44
; GFX906-NEXT:    buffer_load_sbyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2f16_reglo_vreg_sexti8_to_offset:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX803-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v2, 44
; GFX803-NEXT:    buffer_load_sbyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX803-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2f16_reglo_vreg_sexti8_to_offset:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-FLATSCR-NEXT:    scratch_store_dword off, v1, s32 offset:4
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_add_i32 s0, s32, 44
; GFX900-FLATSCR-NEXT:    scratch_load_sbyte_d16 v0, off, s0 offset:4055 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %obj0 = alloca [10 x i32], align 4, addrspace(5)
  %obj1 = alloca [4096 x i8], align 2, addrspace(5)
  %reg.bc = bitcast i32 %reg to <2 x half>
  store volatile i32 123, ptr addrspace(5) %obj0
  %gep = getelementptr inbounds [4096 x i8], ptr addrspace(5) %obj1, i32 0, i32 4055
  %load = load volatile i8, ptr addrspace(5) %gep
  %load.ext = sext i8 %load to i16
  %bitcast = bitcast i16 %load.ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

define void @load_private_lo_v2f16_reglo_vreg_zexti8_to_offset(i32 %reg) #0 {
; GFX900-MUBUF-LABEL: load_private_lo_v2f16_reglo_vreg_zexti8_to_offset:
; GFX900-MUBUF:       ; %bb.0: ; %entry
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    v_mov_b32_e32 v1, 44
; GFX900-MUBUF-NEXT:    buffer_load_ubyte_d16 v0, v1, s[0:3], s32 offen offset:4055 glc
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-MUBUF-NEXT:    s_waitcnt vmcnt(0)
; GFX900-MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; GFX906-LABEL: load_private_lo_v2f16_reglo_vreg_zexti8_to_offset:
; GFX906:       ; %bb.0: ; %entry
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX906-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    v_mov_b32_e32 v2, 44
; GFX906-NEXT:    buffer_load_ubyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_mov_b32 s4, 0xffff
; GFX906-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX906-NEXT:    global_store_dword v[0:1], v0, off
; GFX906-NEXT:    s_waitcnt vmcnt(0)
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX803-LABEL: load_private_lo_v2f16_reglo_vreg_zexti8_to_offset:
; GFX803:       ; %bb.0: ; %entry
; GFX803-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX803-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_mov_b32_e32 v2, 44
; GFX803-NEXT:    buffer_load_ubyte v1, v2, s[0:3], s32 offen offset:4055 glc
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX803-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX803-NEXT:    flat_store_dword v[0:1], v0
; GFX803-NEXT:    s_waitcnt vmcnt(0)
; GFX803-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-FLATSCR-LABEL: load_private_lo_v2f16_reglo_vreg_zexti8_to_offset:
; GFX900-FLATSCR:       ; %bb.0: ; %entry
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-FLATSCR-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX900-FLATSCR-NEXT:    scratch_store_dword off, v1, s32 offset:4
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_add_i32 s0, s32, 44
; GFX900-FLATSCR-NEXT:    scratch_load_ubyte_d16 v0, off, s0 offset:4055 glc
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    global_store_dword v[0:1], v0, off
; GFX900-FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; GFX900-FLATSCR-NEXT:    s_setpc_b64 s[30:31]
entry:
  %obj0 = alloca [10 x i32], align 4, addrspace(5)
  %obj1 = alloca [4096 x i8], align 2, addrspace(5)
  %reg.bc = bitcast i32 %reg to <2 x half>
  store volatile i32 123, ptr addrspace(5) %obj0
  %gep = getelementptr inbounds [4096 x i8], ptr addrspace(5) %obj1, i32 0, i32 4055
  %load = load volatile i8, ptr addrspace(5) %gep
  %load.ext = zext i8 %load to i16
  %bitcast = bitcast i16 %load.ext to half
  %build1 = insertelement <2 x half> %reg.bc, half %bitcast, i32 0
  store <2 x half> %build1, ptr addrspace(1) poison
  ret void
}

attributes #0 = { nounwind }
