; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -amdgpu-load-store-vectorizer=0 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12-SDAG %s
; RUN: llc -global-isel=1 -amdgpu-load-store-vectorizer=0 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12-GISEL %s

declare i32 @llvm.amdgcn.permlane16.var(i32, i32, i32, i1, i1)
declare i32 @llvm.amdgcn.permlanex16.var(i32, i32, i32, i1, i1)
declare i32 @llvm.amdgcn.workitem.id.x()
declare i32 @llvm.amdgcn.workitem.id.y()

define amdgpu_kernel void @v_permlane16var_b32_vv(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_vv:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_vv:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %src0, i32 %src0, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_vi(ptr addrspace(1) %out, i32 %src0) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_vi:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 1
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v1, v1, v0
; GFX12-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_vi:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, 1 :: v_dual_mov_b32 v1, s2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v1, v1, v0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %src0, i32 %src0, i32 1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_vl(ptr addrspace(1) %out, i32 %src0) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_vl:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 0xc1d1
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v1, v1, v0
; GFX12-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_vl:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, 0xc1d1 :: v_dual_mov_b32 v1, s2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v1, v1, v0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %src0, i32 %src0, i32 49617, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_vvv(ptr addrspace(1) %out, i32 %src0) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_vvv:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v1, v1, v0
; GFX12-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_vvv:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v1, v1, v0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %src0, i32 %src0, i32 %tidx, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_vv_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_vv_fi:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_vv_fi:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %src0, i32 %src0, i32 %src1, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_vv_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_vv_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_vv_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %src0, i32 %src0, i32 %src1, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_vv_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_vv_fi_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_vv_fi_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %src0, i32 %src0, i32 %src1, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_vv(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_vv:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_vv:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %src0, i32 %src0, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_vi(ptr addrspace(1) %out, i32 %src0) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_vi:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 1
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v1, v1, v0
; GFX12-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_vi:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, 1 :: v_dual_mov_b32 v1, s2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v1, v1, v0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %src0, i32 %src0, i32 1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_vl(ptr addrspace(1) %out, i32 %src0) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_vl:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 0xc1d1
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v1, v1, v0
; GFX12-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_vl:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, 0xc1d1 :: v_dual_mov_b32 v1, s2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v1, v1, v0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %src0, i32 %src0, i32 49617, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_vvv(ptr addrspace(1) %out, i32 %src0) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_vvv:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v1, v1, v0
; GFX12-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_vvv:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v1, v1, v0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %src0, i32 %src0, i32 %tidx, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_vv_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_vv_fi:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_vv_fi:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %src0, i32 %src0, i32 %src1, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_vv_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_vv_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_vv_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %src0, i32 %src0, i32 %src1, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_vv_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_vv_fi_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_vv_fi_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %src0, i32 %src0, i32 %src1, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_tid_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_tid_tid:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_tid_tid:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %tidx, i32 %tidx, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_undef_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_undef_tid:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_undef_tid:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %undef, i32 %tidx, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_i_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_i_tid:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v1, 0x3039 :: v_dual_mov_b32 v2, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v1, v0, v2
; GFX12-SDAG-NEXT:    global_store_b32 v3, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_i_tid:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v1, v0, v2
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 12345, i32 %tidx, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_i_tid_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_i_tid_fi:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_i_tid_fi:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %undef, i32 %tidx, i32 %src1, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_i_tid_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_i_tid_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_i_tid_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %undef, i32 %tidx, i32 %src1, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16var_b32_i_tid_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlane16var_b32_i_tid_fi_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlane16var_b32_i_tid_fi_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlane16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16.var(i32 %undef, i32 %tidx, i32 %src1, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_tid_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_tid_tid:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_tid_tid:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %tidx, i32 %tidx, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_undef_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_undef_tid:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_undef_tid:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %undef, i32 %tidx, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_i_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_i_tid:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v1, 0x3039 :: v_dual_mov_b32 v2, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v1, v0, v2
; GFX12-SDAG-NEXT:    global_store_b32 v3, v1, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_i_tid:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v1, v0, v2
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 12345, i32 %tidx, i32 %src1, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_i_tid_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_i_tid_fi:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_i_tid_fi:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,0]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %undef, i32 %tidx, i32 %src1, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_i_tid_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_i_tid_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_i_tid_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[0,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %undef, i32 %tidx, i32 %src1, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16var_b32_i_tid_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX12-SDAG-LABEL: v_permlanex16var_b32_i_tid_fi_bc:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-SDAG-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: v_permlanex16var_b32_i_tid_fi_bc:
; GFX12-GISEL:       ; %bb.0:
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x30
; GFX12-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_permlanex16_var_b32 v0, v0, v1 op_sel:[1,1]
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX12-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16.var(i32 %undef, i32 %tidx, i32 %src1, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}
