; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; REQUIRES: x86-registered-target
; RUN: opt < %s -passes=rel-lookup-table-converter -relocation-model=pic -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@.str = private unnamed_addr constant [5 x i8] c"zero\00", align 1
@.str.1 = private unnamed_addr constant [4 x i8] c"one\00", align 1
@.str.2 = private unnamed_addr constant [4 x i8] c"two\00", align 1
@.str.3 = private unnamed_addr constant [8 x i8] c"default\00", align 1
@.str.4 = private unnamed_addr constant [6 x i8] c"three\00", align 1
@.str.5 = private unnamed_addr constant [5 x i8] c"str1\00", align 1
@.str.6 = private unnamed_addr constant [5 x i8] c"str2\00", align 1
@.str.7 = private unnamed_addr constant [12 x i8] c"singlevalue\00", align 1
@.str.8 = private unnamed_addr constant [2 x i8] c"a\00", align 1
@.str.9 = private unnamed_addr constant [2 x i8] c"b\00", align 1
@.str.10 = private unnamed_addr constant [2 x i8] c"c\00", align 1

@a1 = external global i32, align 4
@b1 = external global i32, align 4
@c1 = external global i32, align 4
@d1 = external global i32, align 4

@a2 = internal constant i32 0, align 4
@b2 = internal constant i32 0, align 4
@c2 = internal constant i32 0, align 4
@d2 = internal constant i32 0, align 4

@switch.table.external_linkage = private unnamed_addr constant [3 x ptr] [ptr @a1, ptr @b1, ptr @c1], align 8

@switch.table.internal_linkage = private unnamed_addr constant [3 x ptr] [ptr @a2, ptr @b2, ptr @c2], align 8

@switch.table.string_table = private unnamed_addr constant [3 x ptr]
                             [
                              ptr @.str,
                              ptr @.str.1,
                              ptr @.str.2
                             ], align 8

@switch.table.string_table_holes = private unnamed_addr constant [4 x ptr]
                                   [
                                    ptr @.str,
                                    ptr @.str.3,
                                    ptr @.str.2,
                                    ptr @.str.4
                                   ], align 8

@switch.table.single_value = private unnamed_addr constant [3 x ptr]
                             [
                              ptr @.str,
                              ptr @.str.1,
                              ptr @.str.2
                             ], align 8

@user_defined_lookup_table.table = internal unnamed_addr constant [3 x ptr]
                                   [
                                    ptr @.str,
                                    ptr @.str.1,
                                    ptr @.str.2
                                   ], align 16

@table = internal constant [2 x ptr] [
  ptr @.str.8,
  ptr @.str.9
], align 16

@table2 = internal constant [2 x ptr] [
  ptr @.str.8,
  ptr @.str.9
], align 16

; Lookup table check for integer pointers that have external linkage
; CHECK: @switch.table.external_linkage = private unnamed_addr constant [3 x ptr] [ptr @a1, ptr @b1, ptr @c1], align

; Lookup table check for integer pointers that have internal linkage
; CHECK: @switch.table.internal_linkage.rel = private unnamed_addr constant [3 x i32]
; CHECK-SAME: [
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @a2 to i64), i64 ptrtoint (ptr @switch.table.internal_linkage.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @b2 to i64), i64 ptrtoint (ptr @switch.table.internal_linkage.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @c2 to i64), i64 ptrtoint (ptr @switch.table.internal_linkage.rel to i64)) to i32)
; CHECK-SAME: ], align 4

; Relative switch lookup table for strings
; CHECK: @switch.table.string_table.rel = private unnamed_addr constant [3 x i32]
; CHECK-SAME: [
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str to i64), i64 ptrtoint (ptr @switch.table.string_table.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.1 to i64), i64 ptrtoint (ptr @switch.table.string_table.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.2 to i64), i64 ptrtoint (ptr @switch.table.string_table.rel to i64)) to i32)
; CHECK-SAME: ], align 4

; Relative switch lookup table for strings with holes, where holes are filled with relative offset to default values
; CHECK: @switch.table.string_table_holes.rel = private unnamed_addr constant [4 x i32]
; CHECK-SAME: [
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str to i64), i64 ptrtoint (ptr @switch.table.string_table_holes.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.3 to i64), i64 ptrtoint (ptr @switch.table.string_table_holes.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.2 to i64), i64 ptrtoint (ptr @switch.table.string_table_holes.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.4 to i64), i64 ptrtoint (ptr @switch.table.string_table_holes.rel to i64)) to i32)
; CHECK-SAME: ], align 4

; Single value check
; CHECK: @switch.table.single_value.rel = private unnamed_addr constant [3 x i32]
; CHECK-SAME: [
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str to i64), i64 ptrtoint (ptr @switch.table.single_value.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.1 to i64), i64 ptrtoint (ptr @switch.table.single_value.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.2 to i64), i64 ptrtoint (ptr @switch.table.single_value.rel to i64)) to i32)
; CHECK-SAME: ], align 4
;

; Relative lookup table for the loop hoist check test
; CHECK: @table.rel = internal unnamed_addr constant [2 x i32]
; CHECK-SAME: [
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.8 to i64), i64 ptrtoint (ptr @table.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.9 to i64), i64 ptrtoint (ptr @table.rel to i64)) to i32)
; CHECK-SAME: ], align 4

; Relative look up table for the test where gep is not immediately followed by a load check
; CHECK: @table2.rel = internal unnamed_addr constant [2 x i32]
; CHECK-SAME: [
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.8 to i64), i64 ptrtoint (ptr @table2.rel to i64)) to i32),
; CHECK-SAME: i32 trunc (i64 sub (i64 ptrtoint (ptr @.str.9 to i64), i64 ptrtoint (ptr @table2.rel to i64)) to i32)
; CHECK-SAME: ], align 4

; Lookup table check for integer pointers that have external linkage
define ptr @external_linkage(i32 %cond) {
; CHECK-LABEL: @external_linkage(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[COND:%.*]], 3
; CHECK-NEXT:    br i1 [[TMP0]], label [[SWITCH_LOOKUP:%.*]], label [[RETURN:%.*]]
; CHECK:       switch.lookup:
; CHECK-NEXT:    [[SWITCH_GEP:%.*]] = getelementptr inbounds [3 x ptr], ptr @switch.table.external_linkage, i32 0, i32 [[COND:%.*]]
; CHECK-NEXT:    [[SWITCH_LOAD:%.*]] = load ptr, ptr [[SWITCH_GEP]], align 8
; CHECK-NEXT:    ret ptr [[SWITCH_LOAD]]
; CHECK:       return:
; CHECK-NEXT:    ret ptr @d1
;
entry:
  %0 = icmp ult i32 %cond, 3
  br i1 %0, label %switch.lookup, label %return

switch.lookup:                                    ; preds = %entry
  %switch.gep = getelementptr inbounds [3 x ptr], ptr @switch.table.external_linkage, i32 0, i32 %cond
  %switch.load = load ptr, ptr %switch.gep, align 8
  ret ptr %switch.load

return:                                           ; preds = %entry
  ret ptr @d1
}

; Relative switch lookup table for integer pointers that have internal linkage
define ptr @internal_linkage(i32 %cond) {
; CHECK-LABEL: @internal_linkage(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[COND:%.*]], 3
; CHECK-NEXT:    br i1 [[TMP0]], label [[SWITCH_LOOKUP:%.*]], label [[RETURN:%.*]]
; CHECK:       switch.lookup:
; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i32 %cond, 2
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i32(ptr @switch.table.internal_linkage.rel, i32 [[RELTABLE_SHIFT]])
; CHECK-NEXT:    ret ptr [[RELTABLE_INTRINSIC]]
; CHECK:       return:
; CHECK-NEXT:    ret ptr @d2
;
entry:
  %0 = icmp ult i32 %cond, 3
  br i1 %0, label %switch.lookup, label %return

switch.lookup:                                    ; preds = %entry
  %switch.gep = getelementptr inbounds [3 x ptr], ptr @switch.table.internal_linkage, i32 0, i32 %cond
  %switch.load = load ptr, ptr %switch.gep, align 8
  ret ptr %switch.load

return:                                           ; preds = %entry
  ret ptr @d2
}

; ; Relative switch lookup table for strings
define ptr @string_table(i32 %cond) {
  ; CHECK-LABEL: @string_table(
  ; CHECK-NEXT:  entry:
  ; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[COND:%.*]], 3
  ; CHECK-NEXT:    br i1 [[TMP0]], label [[SWITCH_LOOKUP:%.*]], label [[RETURN:%.*]]
  ; CHECK:       switch.lookup:
  ; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i32 %cond, 2
  ; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i32(ptr @switch.table.string_table.rel, i32 [[RELTABLE_SHIFT]])
  ; CHECK-NEXT:    ret ptr [[RELTABLE_INTRINSIC]]
  ; CHECK:       return:
  ; CHECK-NEXT:    ret ptr @.str.3
  ;
entry:
  %0 = icmp ult i32 %cond, 3
  br i1 %0, label %switch.lookup, label %return

switch.lookup:                                    ; preds = %entry
  %switch.gep = getelementptr inbounds [3 x ptr], ptr @switch.table.string_table, i32 0, i32 %cond
  %switch.load = load ptr, ptr %switch.gep, align 8
  ret ptr %switch.load

return:                                           ; preds = %entry
  ret ptr @.str.3
}

; Relative switch lookup table for strings with holes, where holes are filled with relative offset to default values
define ptr @string_table_holes(i32 %cond) {
; CHECK-LABEL: @string_table_holes(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[COND:%.*]], 4
; CHECK-NEXT:    br i1 [[TMP0]], label [[SWITCH_LOOKUP:%.*]], label [[RETURN:%.*]]
; CHECK:       switch.lookup:
; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i32 [[COND]], 2
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i32(ptr @switch.table.string_table_holes.rel, i32 [[RELTABLE_SHIFT]])
; CHECK-NEXT:    ret ptr [[RELTABLE_INTRINSIC]]
; CHECK:       return:
; CHECK-NEXT:    ret ptr @.str.3
;
entry:
  %0 = icmp ult i32 %cond, 4
  br i1 %0, label %switch.lookup, label %return

switch.lookup:                                    ; preds = %entry
  %switch.gep = getelementptr inbounds [4 x ptr], ptr @switch.table.string_table_holes, i32 0, i32 %cond
  %switch.load = load ptr, ptr %switch.gep, align 8
  ret ptr %switch.load

return:                                           ; preds = %entry
  ret ptr @.str.3
}


; Single value check
; If there is a lookup table, where each element contains the same value,
; a relative lookup should not be generated
define void @single_value(i32 %cond)  {
; CHECK-LABEL: @single_value(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[COND:%.*]], 3
; CHECK-NEXT:    br i1 [[TMP0]], label [[SWITCH_LOOKUP:%.*]], label [[RETURN:%.*]]
; CHECK:       switch.lookup:
; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i32 [[COND]], 2
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i32(ptr @switch.table.single_value.rel, i32 [[RELTABLE_SHIFT]])
; CHECK:       sw.epilog:
; CHECK-NEXT:   [[STR1:%.*]] = phi ptr [ @.str.5, %entry ], [ @.str.7, %switch.lookup ]
; CHECK-NEXT:   [[STR2:%.*]] = phi ptr [ @.str.6, %entry ], [ [[RELTABLE_INTRINSIC]], [[SWITCH_LOOKUP]] ]
; CHECK-NEXT:    ret void

entry:
  %0 = icmp ult i32 %cond, 3
  br i1 %0, label %switch.lookup, label %sw.epilog

switch.lookup:                                    ; preds = %entry
  %switch.gep = getelementptr inbounds [3 x ptr], ptr @switch.table.single_value, i32 0, i32 %cond
  %switch.load = load ptr, ptr %switch.gep, align 8
  br label %sw.epilog

sw.epilog:                                        ; preds = %switch.lookup, %entry
  %str1.0 = phi ptr [ @.str.5, %entry ], [ @.str.7, %switch.lookup ]
  %str2.0 = phi ptr [ @.str.6, %entry ], [ %switch.load, %switch.lookup ]
  ret void
}

; Relative lookup table generated for a user-defined lookup table
define ptr @user_defined_lookup_table(i32 %cond)  {
; CHECK-LABEL: @user_defined_lookup_table(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp sgt i32 [[COND:%.*]], 3
; CHECK-NEXT:    br i1 [[TMP0]], label [[SWITCH_LOOKUP:%.*]], label [[RETURN:%.*]]
; CHECK:       cond.false:
; CHECK-NEXT:    [[IDX_PROM:%.*]] = sext i32 [[COND]] to i64
; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i64 [[IDX_PROM]], 2
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i64(ptr @user_defined_lookup_table.table.rel, i64 [[RELTABLE_SHIFT]])
; CHECK-NEXT:    br label %cond.end
; CHECK:       cond.end:
; CHECK-NEXT:    [[COND1:%.*]] = phi ptr [ [[RELTABLE_INTRINSIC]], %cond.false ], [ @.str.3, %entry ]
; CHECK-NEXT:    ret ptr [[COND1]]
;
entry:
  %cmp = icmp sgt i32 %cond, 3
  br i1 %cmp, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  %idxprom = sext i32 %cond to i64
  %arrayidx = getelementptr inbounds [3 x ptr], ptr @user_defined_lookup_table.table, i64 0, i64 %idxprom
  %0 = load ptr, ptr %arrayidx, align 8, !tbaa !4
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond1 = phi ptr [ %0, %cond.false ], [ @.str.3, %entry ]
  ret ptr %cond1
}

; Check to ensure that call @llvm.load.relative is inserted before load, not before gep.
; When a lookup table is accessed inside a loop, and a gep is hosted outside the loop via licm,
; make sure that call @llvm.load.relative is inserted before load.
define ptr @loop_hoist(i32 %x) {
; CHECK-LABEL: @loop_hoist(i32 %x)
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp sgt i32 [[X:%.*]], 1
; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i32 [[X:%.*]], 2
; CHECK-NEXT:    br i1 [[TMP0]], label %if.done, label %if.false
; CHECK:       if.false:
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i32(ptr @table.rel, i32 [[RELTABLE_SHIFT]])
; CHECK-NEXT:    br label %if.done
; CHECK:       if.done:
; CHECK-NEXT:    [[TMP2:%.*]] = phi ptr [ @.str.10, %entry ], [ [[RELTABLE_INTRINSIC]], %if.false ]
; CHECK-NEXT:    ret ptr [[TMP2]]
;
entry:
  %0 = icmp sgt i32 %x, 1
  %1 = getelementptr [2 x ptr], ptr @table, i32 0, i32 %x
  br i1 %0, label %if.done, label %if.false

if.false:
  %2 = load ptr, ptr %1
  br label %if.done

if.done:
  %3 = phi ptr [ @.str.10, %entry ], [ %2, %if.false ]
  ret ptr %3
}

; Another check to ensure that call @llvm.load.relative is inserted before load but not before gep.
; When a lookup table is accessed, and gep is not immediately followed by a load (like if there is a function call
; or an exception in between), make sure that call @llvm.load.relative is inserted before load.
; CHECK-LABEL: @may_not_return()
declare void @may_not_return()

define ptr @gep_is_not_imm_followed_by_load(i32 %x) {
; CHECK-LABEL: @gep_is_not_imm_followed_by_load(i32 %x)
; CHECK:       entry:
; CHECK-NEXT:    [[RELTABLE_SHIFT:%.*]] = shl i32 [[X:%.*]], 2
; CHECK-NEXT:    call void @may_not_return()
; CHECK-NEXT:    [[RELTABLE_INTRINSIC:%.*]] = call ptr @llvm.load.relative.i32(ptr @table2.rel, i32 [[RELTABLE_SHIFT]])
; CHECK-NEXT:    ret ptr [[RELTABLE_INTRINSIC]]
;
entry:
  %0 = getelementptr [2 x ptr], ptr @table2, i32 0, i32 %x
  call void @may_not_return()
  %1 = load ptr, ptr %0
  ret ptr %1
}

!llvm.module.flags = !{!0, !1}
!0 = !{i32 7, !"PIC Level", i32 2}
!1 = !{i32 1, !"Code Model", i32 1}
!4 = !{!"any pointer", !5, i64 0}
!5 = !{!"omnipotent char", !6, i64 0}
!6 = !{!"Simple C/C++ TBAA"}
