; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='default<O2>' -S | FileCheck %s

target datalayout = "p:64:64:64"

declare {ptr, ptr, i32} @prototype_f(ptr, i1)
define {ptr, ptr, i32} @f(ptr %buffer, i32 %n) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    [[N_VAL_SPILL_ADDR:%.*]] = getelementptr inbounds nuw i8, ptr [[BUFFER:%.*]], i64 8
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[N_VAL_SPILL_ADDR]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = tail call ptr @allocate(i32 [[N]])
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, ptr, i32 } { ptr @f.resume.0, ptr poison, i32 poison }, ptr [[TMP0]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = insertvalue { ptr, ptr, i32 } [[TMP1]], i32 [[N]], 2
; CHECK-NEXT:    ret { ptr, ptr, i32 } [[TMP2]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 1024, i32 8, ptr %buffer, ptr @prototype_f, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:
  %n.val = phi i32 [ %n, %entry ], [ %inc, %resume ]
  %alloca = call token @llvm.coro.alloca.alloc.i32(i32 %n.val, i32 8)
  %ptr = call ptr @llvm.coro.alloca.get(token %alloca)
  %unwind = call i1 (...) @llvm.coro.suspend.retcon.i1(ptr %ptr, i32 %n.val)
  call void @llvm.coro.alloca.free(token %alloca)
  br i1 %unwind, label %cleanup, label %resume

resume:
  %inc = add i32 %n.val, 1
  br label %loop

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}



declare {ptr, i32} @prototype_g(ptr, i1)
define {ptr, i32} @g(ptr %buffer, i32 %n) {
; CHECK-LABEL: @g(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[N]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = alloca i8, i64 [[TMP0]], align 8
; CHECK-NEXT:    tail call void @use(ptr nonnull [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = insertvalue { ptr, i32 } { ptr @g.resume.0, i32 poison }, i32 [[N]], 1
; CHECK-NEXT:    ret { ptr, i32 } [[TMP2]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 1024, i32 8, ptr %buffer, ptr @prototype_g, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:
  %n.val = phi i32 [ %n, %entry ], [ %inc, %resume ]
  %alloca = call token @llvm.coro.alloca.alloc.i32(i32 %n.val, i32 8)
  %ptr = call ptr @llvm.coro.alloca.get(token %alloca)
  call void @use(ptr %ptr)
  call void @llvm.coro.alloca.free(token %alloca)
  %unwind = call i1 (...) @llvm.coro.suspend.retcon.i1(i32 %n.val)
  br i1 %unwind, label %cleanup, label %resume

resume:
  %inc = add i32 %n.val, 1
  br label %loop

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}



declare {ptr, i32} @prototype_h(ptr, i1)
define {ptr, i32} @h(ptr %buffer, i32 %n) {
; CHECK-LABEL: @h(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = insertvalue { ptr, i32 } { ptr @h.resume.0, i32 poison }, i32 [[N]], 1
; CHECK-NEXT:    ret { ptr, i32 } [[TMP0]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 1024, i32 8, ptr %buffer, ptr @prototype_h, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:
  %n.val = phi i32 [ %n, %entry ], [ %inc, %resume ]
  %unwind = call i1 (...) @llvm.coro.suspend.retcon.i1(i32 %n.val)
  br i1 %unwind, label %cleanup, label %resume

resume:
  %inc = add i32 %n.val, 1
  %alloca = call token @llvm.coro.alloca.alloc.i32(i32 %inc, i32 8)
  %ptr = call ptr @llvm.coro.alloca.get(token %alloca)
  call void @use(ptr %ptr)
  call void @llvm.coro.alloca.free(token %alloca)
  br label %loop

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}



declare {ptr, i32} @prototype_i(ptr)
define {ptr, i32} @i(ptr %buffer, i32 %n) {
; CHECK-LABEL: @i(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = insertvalue { ptr, i32 } { ptr @i.resume.0, i32 poison }, i32 [[N]], 1
; CHECK-NEXT:    ret { ptr, i32 } [[TMP0]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 1024, i32 8, ptr %buffer, ptr @prototype_i, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:
  %n.val = phi i32 [ %n, %entry ], [ %k, %loop2 ]
  call void (...) @llvm.coro.suspend.retcon.isVoid(i32 %n.val)
  %inc = add i32 %n.val, 1
  br label %loop2

loop2:
  %k = phi i32 [ %inc, %loop ], [ %k2, %loop2 ]
  %alloca = call token @llvm.coro.alloca.alloc.i32(i32 %k, i32 8)
  %ptr = call ptr @llvm.coro.alloca.get(token %alloca)
  call void @use(ptr %ptr)
  call void @llvm.coro.alloca.free(token %alloca)
  %k2 = lshr i32 %k, 1
  %cmp = icmp ugt i32 %k, 128
  br i1 %cmp, label %loop2, label %loop
}



declare {ptr, i32} @prototype_j(ptr)
define {ptr, i32} @j(ptr %buffer, i32 %n) {
; CHECK-LABEL: @j(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = insertvalue { ptr, i32 } { ptr @j.resume.0, i32 poison }, i32 [[N]], 1
; CHECK-NEXT:    ret { ptr, i32 } [[TMP0]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 1024, i32 8, ptr %buffer, ptr @prototype_j, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %forward

back:
  ; We should encounter this 'get' before we encounter the 'alloc'.
  %ptr = call ptr @llvm.coro.alloca.get(token %alloca)
  call void @use(ptr %ptr)
  call void @llvm.coro.alloca.free(token %alloca)
  %k = add i32 %n.val, 1
  %cmp = icmp ugt i32 %k, 128
  br i1 %cmp, label %forward, label %end

forward:
  %n.val = phi i32 [ %n, %entry ], [ %k, %back ]
  call void (...) @llvm.coro.suspend.retcon.isVoid(i32 %n.val)
  %alloca = call token @llvm.coro.alloca.alloc.i32(i32 %n.val, i32 8)
  %inc = add i32 %n.val, 1
  br label %back

end:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}

declare i32 @getSize()
define {ptr, i32} @k(ptr %buffer, i32 %n, i1 %cond) {
; CHECK-LABEL: @k(
; CHECK-NEXT:  PostSpill:
; CHECK-NEXT:    [[SIZE:%.*]] = tail call i32 @getSize()
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[ALLOCA_BLOCK:%.*]], label [[CORO_RETURN:%.*]]
; CHECK:       coro.return:
; CHECK-NEXT:    [[TMP0:%.*]] = insertvalue { ptr, i32 } { ptr @k.resume.0, i32 poison }, i32 [[N:%.*]], 1
; CHECK-NEXT:    ret { ptr, i32 } [[TMP0]]
; CHECK:       alloca_block:
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[SIZE]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    tail call void @use(ptr nonnull [[TMP2]])
; CHECK-NEXT:    br label [[CORO_RETURN]]
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 1024, i32 8, ptr %buffer, ptr @prototype_g, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br i1 %cond, label %alloca_block, label %non_alloca_block

suspend:
  %unwind = call i1 (...) @llvm.coro.suspend.retcon.i1(i32 %n)
  br i1 %unwind, label %cleanup, label %resume

resume:
  br label %cleanup

alloca_block:
  %size = call i32 @getSize()
  ; This will get lowered to a dynamic alloca.
  ; Make sure code that runs after that lowering does not hoist the dynamic
  ; alloca into the entry block of the resume function.
  %alloca = call token @llvm.coro.alloca.alloc.i32(i32 %size, i32 8)
  %ptr = call ptr @llvm.coro.alloca.get(token %alloca)
  call void @use(ptr %ptr)
  call void @llvm.coro.alloca.free(token %alloca)
  br label %suspend

non_alloca_block:
  %ignore = call i32 @getSize()
  br label %suspend

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}

declare token @llvm.coro.id.retcon(i32, i32, ptr, ptr, ptr, ptr)
declare ptr @llvm.coro.begin(token, ptr)
declare i1 @llvm.coro.suspend.retcon.i1(...)
declare void @llvm.coro.suspend.retcon.isVoid(...)
declare i1 @llvm.coro.end(ptr, i1, token)
declare ptr @llvm.coro.prepare.retcon(ptr)
declare token @llvm.coro.alloca.alloc.i32(i32, i32)
declare ptr @llvm.coro.alloca.get(token)
declare void @llvm.coro.alloca.free(token)

declare noalias ptr @allocate(i32 %size)
declare void @deallocate(ptr %ptr)

declare void @print(i32)
declare void @use(ptr)
