; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

; Should not crash when GEP pointer operand is a vector.
define <2 x i1> @test.vectorgep(<2 x ptr> %vec) {
; CHECK-LABEL: @test.vectorgep(
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i32, <2 x ptr> [[VEC:%.*]], i64 0
; CHECK-NEXT:    [[COND:%.*]] = icmp ule <2 x ptr> [[GEP]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[COND]]
;
  %gep = getelementptr inbounds i32, <2 x ptr> %vec, i64 0
  %cond = icmp ule <2 x ptr> %gep, zeroinitializer
  ret <2 x i1> %cond
}

define <2 x i1> @test.vectorgep.ult.true(<2 x ptr> %vec) {
; CHECK-LABEL: @test.vectorgep.ult.true(
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i32, <2 x ptr> [[VEC:%.*]], i64 1
; CHECK-NEXT:    ret <2 x i1> splat (i1 true)
;
  %gep.1 = getelementptr inbounds i32, <2 x ptr> %vec, i64 1
  %t.1 = icmp ult <2 x ptr> %vec, %gep.1
  ret <2 x i1> %t.1
}

define <2 x i1> @test.vectorgep.ult.false(<2 x ptr> %vec) {
; CHECK-LABEL: @test.vectorgep.ult.false(
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i32, <2 x ptr> [[VEC:%.*]], i64 1
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %gep.1 = getelementptr inbounds i32, <2 x ptr> %vec, i64 1
  %t.1 = icmp ult <2 x ptr> %gep.1, %vec
  ret <2 x i1> %t.1
}


define <vscale x 2 x i1> @test.scalable.vectorgep.ult.true(<vscale x 2 x ptr> %vec) {
; CHECK-LABEL: @test.scalable.vectorgep.ult.true(
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i32, <vscale x 2 x ptr> [[VEC:%.*]], i64 1
; CHECK-NEXT:    ret <vscale x 2 x i1> splat (i1 true)
;
  %gep.1 = getelementptr inbounds i32, <vscale x 2 x ptr> %vec, i64 1
  %t.1 = icmp ult <vscale x 2 x ptr> %vec, %gep.1
  ret <vscale x 2 x i1> %t.1
}

define <vscale x 2 x i1> @test.scalable.vectorgep.ult.false(<vscale x 2 x ptr> %vec) {
; CHECK-LABEL: @test.scalable.vectorgep.ult.false(
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i32, <vscale x 2 x ptr> [[VEC:%.*]], i64 1
; CHECK-NEXT:    ret <vscale x 2 x i1> zeroinitializer
;
  %gep.1 = getelementptr inbounds i32, <vscale x 2 x ptr> %vec, i64 1
  %t.1 = icmp ult <vscale x 2 x ptr> %gep.1, %vec
  ret <vscale x 2 x i1> %t.1
}
