; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-FP16
; RUN: llc < %s -mtriple=aarch64 -global-isel -global-isel-abort=2 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 -global-isel -global-isel-abort=2 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-FP16

; CHECK-GI:       warning: Instruction selection used fallback path for test_unsigned_v4f32_v4i50
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_unsigned_v4f16_v4i50
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_unsigned_v8f16_v8i19
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_unsigned_v8f16_v8i50

;
; Float to unsigned 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptoui.sat.v1f32.v1i32 (<1 x float>)
declare <2 x i32> @llvm.fptoui.sat.v2f32.v2i32 (<2 x float>)
declare <3 x i32> @llvm.fptoui.sat.v3f32.v3i32 (<3 x float>)
declare <4 x i32> @llvm.fptoui.sat.v4f32.v4i32 (<4 x float>)
declare <5 x i32> @llvm.fptoui.sat.v5f32.v5i32 (<5 x float>)
declare <6 x i32> @llvm.fptoui.sat.v6f32.v6i32 (<6 x float>)
declare <7 x i32> @llvm.fptoui.sat.v7f32.v7i32 (<7 x float>)
declare <8 x i32> @llvm.fptoui.sat.v8f32.v8i32 (<8 x float>)

define <1 x i32> @test_unsigned_v1f32_v1i32(<1 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v1f32_v1i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v1f32_v1i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu w8, s0
; CHECK-GI-NEXT:    mov v0.s[0], w8
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
    %x = call <1 x i32> @llvm.fptoui.sat.v1f32.v1i32(<1 x float> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_unsigned_v2f32_v2i32(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptoui.sat.v2f32.v2i32(<2 x float> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_unsigned_v3f32_v3i32(<3 x float> %f) {
; CHECK-LABEL: test_unsigned_v3f32_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
    %x = call <3 x i32> @llvm.fptoui.sat.v3f32.v3i32(<3 x float> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_unsigned_v4f32_v4i32(<4 x float> %f) {
; CHECK-LABEL: test_unsigned_v4f32_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptoui.sat.v4f32.v4i32(<4 x float> %f)
    ret <4 x i32> %x
}

define <5 x i32> @test_unsigned_v5f32_v5i32(<5 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v5f32_v5i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-SD-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-SD-NEXT:    // kill: def $s3 killed $s3 def $q3
; CHECK-SD-NEXT:    // kill: def $s4 killed $s4 def $q4
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    fcvtzu v4.4s, v4.4s
; CHECK-SD-NEXT:    mov v0.s[2], v2.s[0]
; CHECK-SD-NEXT:    fmov w4, s4
; CHECK-SD-NEXT:    mov v0.s[3], v3.s[0]
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    mov w1, v0.s[1]
; CHECK-SD-NEXT:    mov w2, v0.s[2]
; CHECK-SD-NEXT:    mov w3, v0.s[3]
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v5f32_v5i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-GI-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-GI-NEXT:    // kill: def $s3 killed $s3 def $q3
; CHECK-GI-NEXT:    // kill: def $s4 killed $s4 def $q4
; CHECK-GI-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NEXT:    fcvtzu v1.4s, v4.4s
; CHECK-GI-NEXT:    mov v0.s[2], v2.s[0]
; CHECK-GI-NEXT:    fmov w4, s1
; CHECK-GI-NEXT:    mov v0.s[3], v3.s[0]
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    mov s3, v0.s[2]
; CHECK-GI-NEXT:    mov s4, v0.s[3]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    fmov w1, s2
; CHECK-GI-NEXT:    fmov w2, s3
; CHECK-GI-NEXT:    fmov w3, s4
; CHECK-GI-NEXT:    ret
    %x = call <5 x i32> @llvm.fptoui.sat.v5f32.v5i32(<5 x float> %f)
    ret <5 x i32> %x
}

define <6 x i32> @test_unsigned_v6f32_v6i32(<6 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v6f32_v6i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-SD-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-SD-NEXT:    // kill: def $s4 killed $s4 def $q4
; CHECK-SD-NEXT:    // kill: def $s5 killed $s5 def $q5
; CHECK-SD-NEXT:    // kill: def $s3 killed $s3 def $q3
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    mov v4.s[1], v5.s[0]
; CHECK-SD-NEXT:    mov v0.s[2], v2.s[0]
; CHECK-SD-NEXT:    fcvtzu v1.4s, v4.4s
; CHECK-SD-NEXT:    mov v0.s[3], v3.s[0]
; CHECK-SD-NEXT:    mov w5, v1.s[1]
; CHECK-SD-NEXT:    fmov w4, s1
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    mov w1, v0.s[1]
; CHECK-SD-NEXT:    mov w2, v0.s[2]
; CHECK-SD-NEXT:    mov w3, v0.s[3]
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v6f32_v6i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-GI-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-GI-NEXT:    // kill: def $s4 killed $s4 def $q4
; CHECK-GI-NEXT:    // kill: def $s3 killed $s3 def $q3
; CHECK-GI-NEXT:    // kill: def $s5 killed $s5 def $q5
; CHECK-GI-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NEXT:    mov v4.s[1], v5.s[0]
; CHECK-GI-NEXT:    mov v0.s[2], v2.s[0]
; CHECK-GI-NEXT:    fcvtzu v1.4s, v4.4s
; CHECK-GI-NEXT:    mov v0.s[3], v3.s[0]
; CHECK-GI-NEXT:    mov s4, v1.s[1]
; CHECK-GI-NEXT:    fmov w4, s1
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    fmov w5, s4
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    mov s3, v0.s[2]
; CHECK-GI-NEXT:    mov s5, v0.s[3]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    fmov w1, s2
; CHECK-GI-NEXT:    fmov w2, s3
; CHECK-GI-NEXT:    fmov w3, s5
; CHECK-GI-NEXT:    ret
    %x = call <6 x i32> @llvm.fptoui.sat.v6f32.v6i32(<6 x float> %f)
    ret <6 x i32> %x
}

define <7 x i32> @test_unsigned_v7f32_v7i32(<7 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v7f32_v7i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-SD-NEXT:    // kill: def $s4 killed $s4 def $q4
; CHECK-SD-NEXT:    // kill: def $s5 killed $s5 def $q5
; CHECK-SD-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-SD-NEXT:    // kill: def $s6 killed $s6 def $q6
; CHECK-SD-NEXT:    // kill: def $s3 killed $s3 def $q3
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    mov v4.s[1], v5.s[0]
; CHECK-SD-NEXT:    mov v0.s[2], v2.s[0]
; CHECK-SD-NEXT:    mov v4.s[2], v6.s[0]
; CHECK-SD-NEXT:    mov v0.s[3], v3.s[0]
; CHECK-SD-NEXT:    fcvtzu v1.4s, v4.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    mov w5, v1.s[1]
; CHECK-SD-NEXT:    mov w6, v1.s[2]
; CHECK-SD-NEXT:    fmov w4, s1
; CHECK-SD-NEXT:    mov w1, v0.s[1]
; CHECK-SD-NEXT:    mov w2, v0.s[2]
; CHECK-SD-NEXT:    mov w3, v0.s[3]
; CHECK-SD-NEXT:    fmov w0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v7f32_v7i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-GI-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-GI-NEXT:    // kill: def $s4 killed $s4 def $q4
; CHECK-GI-NEXT:    // kill: def $s2 killed $s2 def $q2
; CHECK-GI-NEXT:    // kill: def $s5 killed $s5 def $q5
; CHECK-GI-NEXT:    // kill: def $s3 killed $s3 def $q3
; CHECK-GI-NEXT:    // kill: def $s6 killed $s6 def $q6
; CHECK-GI-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NEXT:    mov v4.s[1], v5.s[0]
; CHECK-GI-NEXT:    mov v0.s[2], v2.s[0]
; CHECK-GI-NEXT:    mov v4.s[2], v6.s[0]
; CHECK-GI-NEXT:    mov v0.s[3], v3.s[0]
; CHECK-GI-NEXT:    fcvtzu v1.4s, v4.4s
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    mov s5, v1.s[1]
; CHECK-GI-NEXT:    mov s6, v1.s[2]
; CHECK-GI-NEXT:    fmov w4, s1
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    mov s3, v0.s[2]
; CHECK-GI-NEXT:    mov s4, v0.s[3]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    fmov w5, s5
; CHECK-GI-NEXT:    fmov w6, s6
; CHECK-GI-NEXT:    fmov w1, s2
; CHECK-GI-NEXT:    fmov w2, s3
; CHECK-GI-NEXT:    fmov w3, s4
; CHECK-GI-NEXT:    ret
    %x = call <7 x i32> @llvm.fptoui.sat.v7f32.v7i32(<7 x float> %f)
    ret <7 x i32> %x
}

define <8 x i32> @test_unsigned_v8f32_v8i32(<8 x float> %f) {
; CHECK-LABEL: test_unsigned_v8f32_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-NEXT:    ret
    %x = call <8 x i32> @llvm.fptoui.sat.v8f32.v8i32(<8 x float> %f)
    ret <8 x i32> %x
}

;
; Double to unsigned 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptoui.sat.v1f64.v1i32 (<1 x double>)
declare <2 x i32> @llvm.fptoui.sat.v2f64.v2i32 (<2 x double>)
declare <3 x i32> @llvm.fptoui.sat.v3f64.v3i32 (<3 x double>)
declare <4 x i32> @llvm.fptoui.sat.v4f64.v4i32 (<4 x double>)
declare <5 x i32> @llvm.fptoui.sat.v5f64.v5i32 (<5 x double>)
declare <6 x i32> @llvm.fptoui.sat.v6f64.v6i32 (<6 x double>)

define <1 x i32> @test_unsigned_v1f64_v1i32(<1 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v1f64_v1i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w8, d0
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v1f64_v1i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu w8, d0
; CHECK-GI-NEXT:    mov v0.s[0], w8
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
    %x = call <1 x i32> @llvm.fptoui.sat.v1f64.v1i32(<1 x double> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_unsigned_v2f64_v2i32(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w8, d0
; CHECK-SD-NEXT:    fcvtzu w9, d1
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x000000ffffffff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    xtn v0.2s, v0.2d
; CHECK-GI-NEXT:    ret
    %x = call <2 x i32> @llvm.fptoui.sat.v2f64.v2i32(<2 x double> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_unsigned_v3f64_v3i32(<3 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v3f64_v3i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w8, d0
; CHECK-SD-NEXT:    fcvtzu w9, d1
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    fcvtzu w8, d2
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    mov v0.s[2], w8
; CHECK-SD-NEXT:    fcvtzu w8, d0
; CHECK-SD-NEXT:    mov v0.s[3], w8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v3f64_v3i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    fcvtzu v1.2d, v2.2d
; CHECK-GI-NEXT:    movi v2.2d, #0x000000ffffffff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v4.2d, v2.2d, v1.2d
; CHECK-GI-NEXT:    bif v1.16b, v2.16b, v4.16b
; CHECK-GI-NEXT:    cmhi v3.2d, v2.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v2.16b, v3.16b
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    ret
    %x = call <3 x i32> @llvm.fptoui.sat.v3f64.v3i32(<3 x double> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_unsigned_v4f64_v4i32(<4 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f64_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d2, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w8, d0
; CHECK-SD-NEXT:    fcvtzu w9, d2
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    fcvtzu w8, d1
; CHECK-SD-NEXT:    mov d1, v1.d[1]
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    mov v0.s[2], w8
; CHECK-SD-NEXT:    fcvtzu w8, d1
; CHECK-SD-NEXT:    mov v0.s[3], w8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v4f64_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0x000000ffffffff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtzu v1.2d, v1.2d
; CHECK-GI-NEXT:    cmhi v3.2d, v2.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v4.2d, v2.2d, v1.2d
; CHECK-GI-NEXT:    bif v0.16b, v2.16b, v3.16b
; CHECK-GI-NEXT:    bif v1.16b, v2.16b, v4.16b
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    ret
    %x = call <4 x i32> @llvm.fptoui.sat.v4f64.v4i32(<4 x double> %f)
    ret <4 x i32> %x
}

define <5 x i32> @test_unsigned_v5f64_v5i32(<5 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v5f64_v5i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, d0
; CHECK-SD-NEXT:    fcvtzu w1, d1
; CHECK-SD-NEXT:    fcvtzu w2, d2
; CHECK-SD-NEXT:    fcvtzu w3, d3
; CHECK-SD-NEXT:    fcvtzu w4, d4
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v5f64_v5i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v2.d[1], v3.d[0]
; CHECK-GI-NEXT:    movi v1.2d, #0x000000ffffffff
; CHECK-GI-NEXT:    fcvtzu v3.2d, v4.2d
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtzu v2.2d, v2.2d
; CHECK-GI-NEXT:    cmhi v4.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v5.2d, v1.2d, v2.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v4.16b
; CHECK-GI-NEXT:    bif v2.16b, v1.16b, v5.16b
; CHECK-GI-NEXT:    cmhi v4.2d, v1.2d, v3.2d
; CHECK-GI-NEXT:    bit v1.16b, v3.16b, v4.16b
; CHECK-GI-NEXT:    mov d3, v0.d[1]
; CHECK-GI-NEXT:    mov d4, v2.d[1]
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    fmov x2, d2
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-GI-NEXT:    // kill: def $w2 killed $w2 killed $x2
; CHECK-GI-NEXT:    fmov x4, d1
; CHECK-GI-NEXT:    fmov x1, d3
; CHECK-GI-NEXT:    fmov x3, d4
; CHECK-GI-NEXT:    // kill: def $w4 killed $w4 killed $x4
; CHECK-GI-NEXT:    // kill: def $w1 killed $w1 killed $x1
; CHECK-GI-NEXT:    // kill: def $w3 killed $w3 killed $x3
; CHECK-GI-NEXT:    ret
    %x = call <5 x i32> @llvm.fptoui.sat.v5f64.v5i32(<5 x double> %f)
    ret <5 x i32> %x
}

define <6 x i32> @test_unsigned_v6f64_v6i32(<6 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v6f64_v6i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, d0
; CHECK-SD-NEXT:    fcvtzu w1, d1
; CHECK-SD-NEXT:    fcvtzu w2, d2
; CHECK-SD-NEXT:    fcvtzu w3, d3
; CHECK-SD-NEXT:    fcvtzu w4, d4
; CHECK-SD-NEXT:    fcvtzu w5, d5
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v6f64_v6i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-GI-NEXT:    // kill: def $d5 killed $d5 def $q5
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v2.d[1], v3.d[0]
; CHECK-GI-NEXT:    mov v4.d[1], v5.d[0]
; CHECK-GI-NEXT:    movi v1.2d, #0x000000ffffffff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtzu v2.2d, v2.2d
; CHECK-GI-NEXT:    fcvtzu v3.2d, v4.2d
; CHECK-GI-NEXT:    cmhi v4.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v5.2d, v1.2d, v2.2d
; CHECK-GI-NEXT:    cmhi v6.2d, v1.2d, v3.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v4.16b
; CHECK-GI-NEXT:    bif v2.16b, v1.16b, v5.16b
; CHECK-GI-NEXT:    bit v1.16b, v3.16b, v6.16b
; CHECK-GI-NEXT:    mov d3, v0.d[1]
; CHECK-GI-NEXT:    mov d4, v2.d[1]
; CHECK-GI-NEXT:    mov d5, v1.d[1]
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    fmov x2, d2
; CHECK-GI-NEXT:    fmov x4, d1
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 killed $x0
; CHECK-GI-NEXT:    // kill: def $w2 killed $w2 killed $x2
; CHECK-GI-NEXT:    // kill: def $w4 killed $w4 killed $x4
; CHECK-GI-NEXT:    fmov x1, d3
; CHECK-GI-NEXT:    fmov x3, d4
; CHECK-GI-NEXT:    fmov x5, d5
; CHECK-GI-NEXT:    // kill: def $w1 killed $w1 killed $x1
; CHECK-GI-NEXT:    // kill: def $w3 killed $w3 killed $x3
; CHECK-GI-NEXT:    // kill: def $w5 killed $w5 killed $x5
; CHECK-GI-NEXT:    ret
    %x = call <6 x i32> @llvm.fptoui.sat.v6f64.v6i32(<6 x double> %f)
    ret <6 x i32> %x
}

;
; FP128 to unsigned 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptoui.sat.v1f128.v1i32 (<1 x fp128>)
declare <2 x i32> @llvm.fptoui.sat.v2f128.v2i32 (<2 x fp128>)
declare <3 x i32> @llvm.fptoui.sat.v3f128.v3i32 (<3 x fp128>)
declare <4 x i32> @llvm.fptoui.sat.v4f128.v4i32 (<4 x fp128>)

define <1 x i32> @test_unsigned_v1f128_v1i32(<1 x fp128> %f) {
; CHECK-SD-LABEL: test_unsigned_v1f128_v1i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #32
; CHECK-SD-NEXT:    stp x30, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 32
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    adrp x8, .LCPI14_0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI14_0]
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    adrp x8, .LCPI14_1
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI14_1]
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csinv w8, w19, wzr, le
; CHECK-SD-NEXT:    ldp x30, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    add sp, sp, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v1f128_v1i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #48
; CHECK-GI-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 48
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w30, -32
; CHECK-GI-NEXT:    adrp x8, .LCPI14_1
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI14_1]
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x19, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x19
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    adrp x8, .LCPI14_0
; CHECK-GI-NEXT:    mov v0.d[1], x20
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI14_0]
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x19, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    mov x8, #281474976579584 // =0xfffffffe0000
; CHECK-GI-NEXT:    movk x8, #16414, lsl #48
; CHECK-GI-NEXT:    csel x8, x20, x8, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.s[0], w0
; CHECK-GI-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    add sp, sp, #48
; CHECK-GI-NEXT:    ret
    %x = call <1 x i32> @llvm.fptoui.sat.v1f128.v1i32(<1 x fp128> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_unsigned_v2f128_v2i32(<2 x fp128> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f128_v2i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #96
; CHECK-SD-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 96
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w30, -32
; CHECK-SD-NEXT:    mov v2.16b, v1.16b
; CHECK-SD-NEXT:    stp q1, q0, [sp, #32] // 32-byte Folded Spill
; CHECK-SD-NEXT:    adrp x8, .LCPI15_0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI15_0]
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    adrp x8, .LCPI15_1
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI15_1]
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csinv w20, w19, wzr, le
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-SD-NEXT:    csinv w8, w19, wzr, le
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w20
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    add sp, sp, #96
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f128_v2i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #96
; CHECK-GI-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp x22, x21, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 96
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w22, -32
; CHECK-GI-NEXT:    .cfi_offset w30, -48
; CHECK-GI-NEXT:    adrp x8, .LCPI15_1
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI15_1]
; CHECK-GI-NEXT:    stp q2, q1, [sp, #16] // 32-byte Folded Spill
; CHECK-GI-NEXT:    mov v1.16b, v2.16b
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x19, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x19
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    adrp x8, .LCPI15_0
; CHECK-GI-NEXT:    mov v0.d[1], x20
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI15_0]
; CHECK-GI-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    mov x21, #281474976579584 // =0xfffffffe0000
; CHECK-GI-NEXT:    csel x8, x19, xzr, lt
; CHECK-GI-NEXT:    movk x21, #16414, lsl #48
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x20, x21, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    ldp q1, q0, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov w19, w0
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x20
; CHECK-GI-NEXT:    csel x22, x8, xzr, gt
; CHECK-GI-NEXT:    mov v0.d[1], x22
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x20, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x22, x21, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    mov v0.s[0], w19
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x22, x21, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.s[1], w0
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    add sp, sp, #96
; CHECK-GI-NEXT:    ret
    %x = call <2 x i32> @llvm.fptoui.sat.v2f128.v2i32(<2 x fp128> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_unsigned_v3f128_v3i32(<3 x fp128> %f) {
; CHECK-SD-LABEL: test_unsigned_v3f128_v3i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #112
; CHECK-SD-NEXT:    str x30, [sp, #80] // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 112
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w30, -32
; CHECK-SD-NEXT:    stp q0, q2, [sp, #48] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov v2.16b, v1.16b
; CHECK-SD-NEXT:    adrp x8, .LCPI16_0
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI16_0]
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    adrp x8, .LCPI16_1
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI16_1]
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    ldp q1, q0, [sp, #32] // 32-byte Folded Reload
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csinv w20, w19, wzr, le
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv w8, w19, wzr, le
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w20
; CHECK-SD-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #80] // 8-byte Folded Reload
; CHECK-SD-NEXT:    csinv w8, w19, wzr, le
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.s[2], w8
; CHECK-SD-NEXT:    add sp, sp, #112
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v3f128_v3i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #112
; CHECK-GI-NEXT:    stp x30, x23, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x22, x21, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 112
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w22, -32
; CHECK-GI-NEXT:    .cfi_offset w23, -40
; CHECK-GI-NEXT:    .cfi_offset w30, -48
; CHECK-GI-NEXT:    adrp x8, .LCPI16_1
; CHECK-GI-NEXT:    stp q1, q0, [sp] // 32-byte Folded Spill
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI16_1]
; CHECK-GI-NEXT:    stp q1, q2, [sp, #32] // 32-byte Folded Spill
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x19, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x19
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    adrp x8, .LCPI16_0
; CHECK-GI-NEXT:    mov v0.d[1], x20
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI16_0]
; CHECK-GI-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    mov x21, #281474976579584 // =0xfffffffe0000
; CHECK-GI-NEXT:    csel x8, x19, xzr, lt
; CHECK-GI-NEXT:    movk x21, #16414, lsl #48
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x20, x21, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w19, w0
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldp q0, q1, [sp] // 32-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x20
; CHECK-GI-NEXT:    csel x22, x8, xzr, gt
; CHECK-GI-NEXT:    mov v0.d[1], x22
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x20, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x22, x21, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    ldp q1, q0, [sp, #32] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov w20, w0
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x22, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x22
; CHECK-GI-NEXT:    csel x23, x8, xzr, gt
; CHECK-GI-NEXT:    mov v0.d[1], x23
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x22, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x23, x21, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    mov v0.s[0], w19
; CHECK-GI-NEXT:    ldp x22, x21, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x30, x23, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.s[1], w20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.s[2], w0
; CHECK-GI-NEXT:    add sp, sp, #112
; CHECK-GI-NEXT:    ret
    %x = call <3 x i32> @llvm.fptoui.sat.v3f128.v3i32(<3 x fp128> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_unsigned_v4f128_v4i32(<4 x fp128> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f128_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #128
; CHECK-SD-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #112] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 128
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w30, -32
; CHECK-SD-NEXT:    stp q0, q2, [sp, #16] // 32-byte Folded Spill
; CHECK-SD-NEXT:    mov v2.16b, v1.16b
; CHECK-SD-NEXT:    adrp x8, .LCPI17_0
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI17_0]
; CHECK-SD-NEXT:    str q3, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    str q1, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    adrp x8, .LCPI17_1
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI17_1]
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    str q1, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csinv w20, w19, wzr, le
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr q1, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv w8, w19, wzr, le
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w20
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    ldp q0, q1, [sp, #32] // 32-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv w8, w19, wzr, le
; CHECK-SD-NEXT:    mov v0.s[2], w8
; CHECK-SD-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldp q1, q0, [sp, #64] // 32-byte Folded Reload
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfsi
; CHECK-SD-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    csel w19, wzr, w0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr x30, [sp, #96] // 8-byte Folded Reload
; CHECK-SD-NEXT:    csinv w8, w19, wzr, le
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #112] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov v0.s[3], w8
; CHECK-SD-NEXT:    add sp, sp, #128
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v4f128_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #144
; CHECK-GI-NEXT:    str x30, [sp, #80] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp x24, x23, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x22, x21, [sp, #112] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #128] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 144
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w22, -32
; CHECK-GI-NEXT:    .cfi_offset w23, -40
; CHECK-GI-NEXT:    .cfi_offset w24, -48
; CHECK-GI-NEXT:    .cfi_offset w30, -64
; CHECK-GI-NEXT:    adrp x8, .LCPI17_1
; CHECK-GI-NEXT:    stp q1, q2, [sp] // 32-byte Folded Spill
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI17_1]
; CHECK-GI-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str q3, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str q1, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x19, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x19
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    adrp x8, .LCPI17_0
; CHECK-GI-NEXT:    mov v0.d[1], x20
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI17_0]
; CHECK-GI-NEXT:    str q1, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    mov x22, #281474976579584 // =0xfffffffe0000
; CHECK-GI-NEXT:    csel x8, x19, xzr, lt
; CHECK-GI-NEXT:    movk x22, #16414, lsl #48
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x20, x22, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q1, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w19, w0
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr q1, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x20
; CHECK-GI-NEXT:    csel x21, x8, xzr, gt
; CHECK-GI-NEXT:    mov v0.d[1], x21
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x20, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x21, x22, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q1, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w20, w0
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr q1, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x21, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x21
; CHECK-GI-NEXT:    csel x23, x8, xzr, gt
; CHECK-GI-NEXT:    mov v0.d[1], x23
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x21, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x23, x22, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr q1, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w21, w0
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldp q0, q1, [sp, #32] // 32-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x23, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x23
; CHECK-GI-NEXT:    csel x24, x8, xzr, gt
; CHECK-GI-NEXT:    mov v0.d[1], x24
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x23, xzr, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x24, x22, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfsi
; CHECK-GI-NEXT:    mov v0.s[0], w19
; CHECK-GI-NEXT:    ldp x24, x23, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldr x30, [sp, #80] // 8-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.s[1], w20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #128] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.s[2], w21
; CHECK-GI-NEXT:    ldp x22, x21, [sp, #112] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.s[3], w0
; CHECK-GI-NEXT:    add sp, sp, #144
; CHECK-GI-NEXT:    ret
    %x = call <4 x i32> @llvm.fptoui.sat.v4f128.v4i32(<4 x fp128> %f)
    ret <4 x i32> %x
}

;
; FP16 to unsigned 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptoui.sat.v1f16.v1i32 (<1 x half>)
declare <2 x i32> @llvm.fptoui.sat.v2f16.v2i32 (<2 x half>)
declare <3 x i32> @llvm.fptoui.sat.v3f16.v3i32 (<3 x half>)
declare <4 x i32> @llvm.fptoui.sat.v4f16.v4i32 (<4 x half>)
declare <5 x i32> @llvm.fptoui.sat.v5f16.v5i32 (<5 x half>)
declare <6 x i32> @llvm.fptoui.sat.v6f16.v6i32 (<6 x half>)
declare <7 x i32> @llvm.fptoui.sat.v7f16.v7i32 (<7 x half>)
declare <8 x i32> @llvm.fptoui.sat.v8f16.v8i32 (<8 x half>)

define <1 x i32> @test_unsigned_v1f16_v1i32(<1 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v1f16_v1i32:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    fcvtzu w8, s0
; CHECK-SD-CVT-NEXT:    fmov s0, w8
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v1f16_v1i32:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu w8, h0
; CHECK-SD-FP16-NEXT:    fmov s0, w8
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v1f16_v1i32:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    fcvtzu w8, s0
; CHECK-GI-CVT-NEXT:    mov v0.s[0], w8
; CHECK-GI-CVT-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v1f16_v1i32:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzu w8, h0
; CHECK-GI-FP16-NEXT:    mov v0.s[0], w8
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
    %x = call <1 x i32> @llvm.fptoui.sat.v1f16.v1i32(<1 x half> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_unsigned_v2f16_v2i32(<2 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f16_v2i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f16_v2i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-GI-NEXT:    ret
    %x = call <2 x i32> @llvm.fptoui.sat.v2f16.v2i32(<2 x half> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_unsigned_v3f16_v3i32(<3 x half> %f) {
; CHECK-LABEL: test_unsigned_v3f16_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
    %x = call <3 x i32> @llvm.fptoui.sat.v3f16.v3i32(<3 x half> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_unsigned_v4f16_v4i32(<4 x half> %f) {
; CHECK-LABEL: test_unsigned_v4f16_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptoui.sat.v4f16.v4i32(<4 x half> %f)
    ret <4 x i32> %x
}

define <5 x i32> @test_unsigned_v5f16_v5i32(<5 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v5f16_v5i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    mov w1, v1.s[1]
; CHECK-SD-NEXT:    mov w2, v1.s[2]
; CHECK-SD-NEXT:    mov w3, v1.s[3]
; CHECK-SD-NEXT:    fmov w0, s1
; CHECK-SD-NEXT:    fmov w4, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v5f16_v5i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NEXT:    mov v0.h[0], v0.h[4]
; CHECK-GI-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NEXT:    mov s2, v1.s[1]
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    mov s3, v1.s[2]
; CHECK-GI-NEXT:    mov s4, v1.s[3]
; CHECK-GI-NEXT:    fmov w0, s1
; CHECK-GI-NEXT:    fmov w1, s2
; CHECK-GI-NEXT:    fmov w2, s3
; CHECK-GI-NEXT:    fmov w4, s0
; CHECK-GI-NEXT:    fmov w3, s4
; CHECK-GI-NEXT:    ret
    %x = call <5 x i32> @llvm.fptoui.sat.v5f16.v5i32(<5 x half> %f)
    ret <5 x i32> %x
}

define <6 x i32> @test_unsigned_v6f16_v6i32(<6 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v6f16_v6i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    mov w1, v1.s[1]
; CHECK-SD-NEXT:    mov w2, v1.s[2]
; CHECK-SD-NEXT:    mov w5, v0.s[1]
; CHECK-SD-NEXT:    mov w3, v1.s[3]
; CHECK-SD-NEXT:    fmov w4, s0
; CHECK-SD-NEXT:    fmov w0, s1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v6f16_v6i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov v1.h[0], v0.h[4]
; CHECK-GI-NEXT:    mov v1.h[1], v0.h[5]
; CHECK-GI-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    mov s3, v0.s[2]
; CHECK-GI-NEXT:    mov s4, v0.s[3]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    mov s5, v1.s[1]
; CHECK-GI-NEXT:    fmov w1, s2
; CHECK-GI-NEXT:    fmov w2, s3
; CHECK-GI-NEXT:    fmov w3, s4
; CHECK-GI-NEXT:    fmov w4, s1
; CHECK-GI-NEXT:    fmov w5, s5
; CHECK-GI-NEXT:    ret
    %x = call <6 x i32> @llvm.fptoui.sat.v6f16.v6i32(<6 x half> %f)
    ret <6 x i32> %x
}

define <7 x i32> @test_unsigned_v7f16_v7i32(<7 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v7f16_v7i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    mov w1, v1.s[1]
; CHECK-SD-NEXT:    mov w2, v1.s[2]
; CHECK-SD-NEXT:    mov w3, v1.s[3]
; CHECK-SD-NEXT:    mov w5, v0.s[1]
; CHECK-SD-NEXT:    mov w6, v0.s[2]
; CHECK-SD-NEXT:    fmov w0, s1
; CHECK-SD-NEXT:    fmov w4, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v7f16_v7i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov v1.h[0], v0.h[4]
; CHECK-GI-NEXT:    mov v1.h[1], v0.h[5]
; CHECK-GI-NEXT:    mov v1.h[2], v0.h[6]
; CHECK-GI-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    mov s3, v0.s[2]
; CHECK-GI-NEXT:    mov s4, v0.s[3]
; CHECK-GI-NEXT:    fmov w0, s0
; CHECK-GI-NEXT:    mov s5, v1.s[1]
; CHECK-GI-NEXT:    mov s6, v1.s[2]
; CHECK-GI-NEXT:    fmov w1, s2
; CHECK-GI-NEXT:    fmov w2, s3
; CHECK-GI-NEXT:    fmov w3, s4
; CHECK-GI-NEXT:    fmov w4, s1
; CHECK-GI-NEXT:    fmov w5, s5
; CHECK-GI-NEXT:    fmov w6, s6
; CHECK-GI-NEXT:    ret
    %x = call <7 x i32> @llvm.fptoui.sat.v7f16.v7i32(<7 x half> %f)
    ret <7 x i32> %x
}

define <8 x i32> @test_unsigned_v8f16_v8i32(<8 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f16_v8i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtl2 v1.4s, v0.8h
; CHECK-SD-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v8f16_v8i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-GI-NEXT:    fcvtzu v0.4s, v1.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v2.4s
; CHECK-GI-NEXT:    ret
    %x = call <8 x i32> @llvm.fptoui.sat.v8f16.v8i32(<8 x half> %f)
    ret <8 x i32> %x
}

;
; 2-Vector float to unsigned integer -- result size variation
;

declare <2 x   i1> @llvm.fptoui.sat.v2f32.v2i1  (<2 x float>)
declare <2 x   i8> @llvm.fptoui.sat.v2f32.v2i8  (<2 x float>)
declare <2 x  i13> @llvm.fptoui.sat.v2f32.v2i13 (<2 x float>)
declare <2 x  i16> @llvm.fptoui.sat.v2f32.v2i16 (<2 x float>)
declare <2 x  i19> @llvm.fptoui.sat.v2f32.v2i19 (<2 x float>)
declare <2 x  i50> @llvm.fptoui.sat.v2f32.v2i50 (<2 x float>)
declare <2 x  i64> @llvm.fptoui.sat.v2f32.v2i64 (<2 x float>)
declare <2 x i100> @llvm.fptoui.sat.v2f32.v2i100(<2 x float>)
declare <2 x i128> @llvm.fptoui.sat.v2f32.v2i128(<2 x float>)

define <2 x i1> @test_unsigned_v2f32_v2i1(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2s, #1
; CHECK-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-NEXT:    umin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
    %x = call <2 x i1> @llvm.fptoui.sat.v2f32.v2i1(<2 x float> %f)
    ret <2 x i1> %x
}

define <2 x i8> @test_unsigned_v2f32_v2i8(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-NEXT:    umin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
    %x = call <2 x i8> @llvm.fptoui.sat.v2f32.v2i8(<2 x float> %f)
    ret <2 x i8> %x
}

define <2 x i13> @test_unsigned_v2f32_v2i13(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2s, #31, msl #8
; CHECK-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-NEXT:    umin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
    %x = call <2 x i13> @llvm.fptoui.sat.v2f32.v2i13(<2 x float> %f)
    ret <2 x i13> %x
}

define <2 x i16> @test_unsigned_v2f32_v2i16(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-NEXT:    umin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
    %x = call <2 x i16> @llvm.fptoui.sat.v2f32.v2i16(<2 x float> %f)
    ret <2 x i16> %x
}

define <2 x i19> @test_unsigned_v2f32_v2i19(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2s, #7, msl #16
; CHECK-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-NEXT:    umin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
    %x = call <2 x i19> @llvm.fptoui.sat.v2f32.v2i19(<2 x float> %f)
    ret <2 x i19> %x
}

define <2 x i32> @test_unsigned_v2f32_v2i32_duplicate(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i32_duplicate:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu v0.2s, v0.2s
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptoui.sat.v2f32.v2i32(<2 x float> %f)
    ret <2 x i32> %x
}

define <2 x i50> @test_unsigned_v2f32_v2i50(<2 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f32_v2i50:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    fcvtzu x9, s0
; CHECK-SD-NEXT:    mov x10, #1125899906842623 // =0x3ffffffffffff
; CHECK-SD-NEXT:    fcvtzu x8, s1
; CHECK-SD-NEXT:    cmp x8, x10
; CHECK-SD-NEXT:    csel x8, x8, x10, lo
; CHECK-SD-NEXT:    cmp x9, x10
; CHECK-SD-NEXT:    csel x9, x9, x10, lo
; CHECK-SD-NEXT:    fmov d0, x9
; CHECK-SD-NEXT:    mov v0.d[1], x8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f32_v2i50:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-GI-NEXT:    adrp x8, .LCPI32_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI32_0]
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    ret
    %x = call <2 x i50> @llvm.fptoui.sat.v2f32.v2i50(<2 x float> %f)
    ret <2 x i50> %x
}

define <2 x i64> @test_unsigned_v2f32_v2i64(<2 x float> %f) {
; CHECK-LABEL: test_unsigned_v2f32_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-NEXT:    ret
    %x = call <2 x i64> @llvm.fptoui.sat.v2f32.v2i64(<2 x float> %f)
    ret <2 x i64> %x
}

define <2 x i100> @test_unsigned_v2f32_v2i100(<2 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f32_v2i100:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x30, x21, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w30, -32
; CHECK-SD-NEXT:    .cfi_offset b8, -40
; CHECK-SD-NEXT:    .cfi_offset b9, -48
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #1904214015 // =0x717fffff
; CHECK-SD-NEXT:    mov x21, #68719476735 // =0xfffffffff
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov s8, v0.s[1]
; CHECK-SD-NEXT:    fcmp s0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s0, s9
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    csel x19, x21, x9, gt
; CHECK-SD-NEXT:    csinv x20, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    mov x0, x20
; CHECK-SD-NEXT:    mov x1, x19
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x3, x21, x9, gt
; CHECK-SD-NEXT:    ldp x30, x21, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x2, x8, xzr, le
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f32_v2i100:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x30, x21, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w30, -32
; CHECK-GI-NEXT:    .cfi_offset b8, -40
; CHECK-GI-NEXT:    .cfi_offset b9, -48
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w8, #1904214015 // =0x717fffff
; CHECK-GI-NEXT:    mov x21, #68719476735 // =0xfffffffff
; CHECK-GI-NEXT:    fmov s9, w8
; CHECK-GI-NEXT:    fcmp s0, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s0, s9
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    csinv x19, x8, xzr, le
; CHECK-GI-NEXT:    csel x20, x21, x9, gt
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s8, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s8, s9
; CHECK-GI-NEXT:    mov x0, x19
; CHECK-GI-NEXT:    mov x1, x20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csel x3, x21, x9, gt
; CHECK-GI-NEXT:    ldp x30, x21, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csinv x2, x8, xzr, le
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
    %x = call <2 x i100> @llvm.fptoui.sat.v2f32.v2i100(<2 x float> %f)
    ret <2 x i100> %x
}

define <2 x i128> @test_unsigned_v2f32_v2i128(<2 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f32_v2i128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w30, -32
; CHECK-SD-NEXT:    .cfi_offset b8, -40
; CHECK-SD-NEXT:    .cfi_offset b9, -48
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #2139095039 // =0x7f7fffff
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov s8, v0.s[1]
; CHECK-SD-NEXT:    fcmp s0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s0, s9
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    csinv x19, x9, xzr, le
; CHECK-SD-NEXT:    csinv x20, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    mov x0, x19
; CHECK-SD-NEXT:    mov x1, x20
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x2, x9, xzr, le
; CHECK-SD-NEXT:    csinv x3, x8, xzr, le
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f32_v2i128:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w30, -32
; CHECK-GI-NEXT:    .cfi_offset b8, -40
; CHECK-GI-NEXT:    .cfi_offset b9, -48
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w8, #2139095039 // =0x7f7fffff
; CHECK-GI-NEXT:    fmov s9, w8
; CHECK-GI-NEXT:    fcmp s0, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s0, s9
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    csinv x19, x8, xzr, le
; CHECK-GI-NEXT:    csinv x20, x9, xzr, le
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s8, #0.0
; CHECK-GI-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s8, s9
; CHECK-GI-NEXT:    mov x0, x19
; CHECK-GI-NEXT:    mov x1, x20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csinv x2, x8, xzr, le
; CHECK-GI-NEXT:    csinv x3, x9, xzr, le
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
    %x = call <2 x i128> @llvm.fptoui.sat.v2f32.v2i128(<2 x float> %f)
    ret <2 x i128> %x
}

;
; 4-Vector float to unsigned integer -- result size variation
;

declare <4 x   i1> @llvm.fptoui.sat.v4f32.v4i1  (<4 x float>)
declare <4 x   i8> @llvm.fptoui.sat.v4f32.v4i8  (<4 x float>)
declare <4 x  i13> @llvm.fptoui.sat.v4f32.v4i13 (<4 x float>)
declare <4 x  i16> @llvm.fptoui.sat.v4f32.v4i16 (<4 x float>)
declare <4 x  i19> @llvm.fptoui.sat.v4f32.v4i19 (<4 x float>)
declare <4 x  i50> @llvm.fptoui.sat.v4f32.v4i50 (<4 x float>)
declare <4 x  i64> @llvm.fptoui.sat.v4f32.v4i64 (<4 x float>)
declare <4 x i100> @llvm.fptoui.sat.v4f32.v4i100(<4 x float>)
declare <4 x i128> @llvm.fptoui.sat.v4f32.v4i128(<4 x float>)

define <4 x i1> @test_unsigned_v4f32_v4i1(<4 x float> %f) {
; CHECK-LABEL: test_unsigned_v4f32_v4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #1
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
    %x = call <4 x i1> @llvm.fptoui.sat.v4f32.v4i1(<4 x float> %f)
    ret <4 x i1> %x
}

define <4 x i8> @test_unsigned_v4f32_v4i8(<4 x float> %f) {
; CHECK-LABEL: test_unsigned_v4f32_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
    %x = call <4 x i8> @llvm.fptoui.sat.v4f32.v4i8(<4 x float> %f)
    ret <4 x i8> %x
}

define <4 x i13> @test_unsigned_v4f32_v4i13(<4 x float> %f) {
; CHECK-LABEL: test_unsigned_v4f32_v4i13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #31, msl #8
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
    %x = call <4 x i13> @llvm.fptoui.sat.v4f32.v4i13(<4 x float> %f)
    ret <4 x i13> %x
}

define <4 x i16> @test_unsigned_v4f32_v4i16(<4 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f32_v4i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    uqxtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v4f32_v4i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
    %x = call <4 x i16> @llvm.fptoui.sat.v4f32.v4i16(<4 x float> %f)
    ret <4 x i16> %x
}

define <4 x i19> @test_unsigned_v4f32_v4i19(<4 x float> %f) {
; CHECK-LABEL: test_unsigned_v4f32_v4i19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #7, msl #16
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
    %x = call <4 x i19> @llvm.fptoui.sat.v4f32.v4i19(<4 x float> %f)
    ret <4 x i19> %x
}

define <4 x i32> @test_unsigned_v4f32_v4i32_duplicate(<4 x float> %f) {
; CHECK-LABEL: test_unsigned_v4f32_v4i32_duplicate:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptoui.sat.v4f32.v4i32(<4 x float> %f)
    ret <4 x i32> %x
}

define <4 x i50> @test_unsigned_v4f32_v4i50(<4 x float> %f) {
; CHECK-LABEL: test_unsigned_v4f32_v4i50:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    mov s3, v0.s[1]
; CHECK-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-NEXT:    fcvtzu x11, s0
; CHECK-NEXT:    mov s2, v1.s[1]
; CHECK-NEXT:    fcvtzu x9, s1
; CHECK-NEXT:    fcvtzu x12, s3
; CHECK-NEXT:    fcvtzu x10, s2
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    csel x2, x9, x8, lo
; CHECK-NEXT:    cmp x10, x8
; CHECK-NEXT:    csel x3, x10, x8, lo
; CHECK-NEXT:    cmp x11, x8
; CHECK-NEXT:    csel x0, x11, x8, lo
; CHECK-NEXT:    cmp x12, x8
; CHECK-NEXT:    csel x1, x12, x8, lo
; CHECK-NEXT:    ret
    %x = call <4 x i50> @llvm.fptoui.sat.v4f32.v4i50(<4 x float> %f)
    ret <4 x i50> %x
}

define <4 x i64> @test_unsigned_v4f32_v4i64(<4 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f32_v4i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtl2 v1.2d, v0.4s
; CHECK-SD-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-SD-NEXT:    fcvtzu v1.2d, v1.2d
; CHECK-SD-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v4f32_v4i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtl v1.2d, v0.2s
; CHECK-GI-NEXT:    fcvtl2 v2.2d, v0.4s
; CHECK-GI-NEXT:    fcvtzu v0.2d, v1.2d
; CHECK-GI-NEXT:    fcvtzu v1.2d, v2.2d
; CHECK-GI-NEXT:    ret
    %x = call <4 x i64> @llvm.fptoui.sat.v4f32.v4i64(<4 x float> %f)
    ret <4 x i64> %x
}

define <4 x i100> @test_unsigned_v4f32_v4i100(<4 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f32_v4i100:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #96
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x30, x25, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x24, x23, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x22, x21, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 96
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w22, -32
; CHECK-SD-NEXT:    .cfi_offset w23, -40
; CHECK-SD-NEXT:    .cfi_offset w24, -48
; CHECK-SD-NEXT:    .cfi_offset w25, -56
; CHECK-SD-NEXT:    .cfi_offset w30, -64
; CHECK-SD-NEXT:    .cfi_offset b8, -72
; CHECK-SD-NEXT:    .cfi_offset b9, -80
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #1904214015 // =0x717fffff
; CHECK-SD-NEXT:    mov x25, #68719476735 // =0xfffffffff
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov s8, v0.s[1]
; CHECK-SD-NEXT:    fcmp s0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s0, s9
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    csel x19, x25, x9, gt
; CHECK-SD-NEXT:    csinv x20, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    csel x21, x25, x9, gt
; CHECK-SD-NEXT:    csinv x22, x8, xzr, le
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s8, v0.s[1]
; CHECK-SD-NEXT:    fcmp s0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s0, s9
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    csel x23, x25, x9, gt
; CHECK-SD-NEXT:    csinv x24, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov x2, x22
; CHECK-SD-NEXT:    mov x3, x21
; CHECK-SD-NEXT:    mov x4, x24
; CHECK-SD-NEXT:    mov x5, x23
; CHECK-SD-NEXT:    ldp x22, x21, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    mov x0, x20
; CHECK-SD-NEXT:    mov x1, x19
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x7, x25, x9, gt
; CHECK-SD-NEXT:    ldp x24, x23, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x30, x25, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x6, x8, xzr, le
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add sp, sp, #96
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v4f32_v4i100:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #112
; CHECK-GI-NEXT:    stp d11, d10, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x30, x25, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x24, x23, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x22, x21, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 112
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w22, -32
; CHECK-GI-NEXT:    .cfi_offset w23, -40
; CHECK-GI-NEXT:    .cfi_offset w24, -48
; CHECK-GI-NEXT:    .cfi_offset w25, -56
; CHECK-GI-NEXT:    .cfi_offset w30, -64
; CHECK-GI-NEXT:    .cfi_offset b8, -72
; CHECK-GI-NEXT:    .cfi_offset b9, -80
; CHECK-GI-NEXT:    .cfi_offset b10, -88
; CHECK-GI-NEXT:    .cfi_offset b11, -96
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w8, #1904214015 // =0x717fffff
; CHECK-GI-NEXT:    mov x25, #68719476735 // =0xfffffffff
; CHECK-GI-NEXT:    fmov s11, w8
; CHECK-GI-NEXT:    fcmp s0, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s0, s11
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    csinv x19, x8, xzr, le
; CHECK-GI-NEXT:    csel x20, x25, x9, gt
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s8, #0.0
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s8, s11
; CHECK-GI-NEXT:    csinv x21, x8, xzr, le
; CHECK-GI-NEXT:    csel x22, x25, x9, gt
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s9, #0.0
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s9, s11
; CHECK-GI-NEXT:    csinv x23, x8, xzr, le
; CHECK-GI-NEXT:    csel x24, x25, x9, gt
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s10, #0.0
; CHECK-GI-NEXT:    mov x2, x21
; CHECK-GI-NEXT:    mov x3, x22
; CHECK-GI-NEXT:    mov x4, x23
; CHECK-GI-NEXT:    mov x5, x24
; CHECK-GI-NEXT:    ldp x22, x21, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s10, s11
; CHECK-GI-NEXT:    mov x0, x19
; CHECK-GI-NEXT:    mov x1, x20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csel x7, x25, x9, gt
; CHECK-GI-NEXT:    ldp x24, x23, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x30, x25, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csinv x6, x8, xzr, le
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    add sp, sp, #112
; CHECK-GI-NEXT:    ret
    %x = call <4 x i100> @llvm.fptoui.sat.v4f32.v4i100(<4 x float> %f)
    ret <4 x i100> %x
}

define <4 x i128> @test_unsigned_v4f32_v4i128(<4 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f32_v4i128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #96
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x24, x23, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x22, x21, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 96
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w22, -32
; CHECK-SD-NEXT:    .cfi_offset w23, -40
; CHECK-SD-NEXT:    .cfi_offset w24, -48
; CHECK-SD-NEXT:    .cfi_offset w30, -64
; CHECK-SD-NEXT:    .cfi_offset b8, -72
; CHECK-SD-NEXT:    .cfi_offset b9, -80
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #2139095039 // =0x7f7fffff
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov s8, v0.s[1]
; CHECK-SD-NEXT:    fcmp s0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s0, s9
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    csinv x19, x9, xzr, le
; CHECK-SD-NEXT:    csinv x20, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    csinv x21, x9, xzr, le
; CHECK-SD-NEXT:    csinv x22, x8, xzr, le
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov s8, v0.s[1]
; CHECK-SD-NEXT:    fcmp s0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s0, s9
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    csinv x23, x9, xzr, le
; CHECK-SD-NEXT:    csinv x24, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov x2, x21
; CHECK-SD-NEXT:    mov x3, x22
; CHECK-SD-NEXT:    mov x4, x23
; CHECK-SD-NEXT:    mov x5, x24
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    ldp x22, x21, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    mov x0, x19
; CHECK-SD-NEXT:    mov x1, x20
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x24, x23, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x6, x9, xzr, le
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x7, x8, xzr, le
; CHECK-SD-NEXT:    add sp, sp, #96
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v4f32_v4i128:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #112
; CHECK-GI-NEXT:    stp d11, d10, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp x24, x23, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x22, x21, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 112
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w22, -32
; CHECK-GI-NEXT:    .cfi_offset w23, -40
; CHECK-GI-NEXT:    .cfi_offset w24, -48
; CHECK-GI-NEXT:    .cfi_offset w30, -64
; CHECK-GI-NEXT:    .cfi_offset b8, -72
; CHECK-GI-NEXT:    .cfi_offset b9, -80
; CHECK-GI-NEXT:    .cfi_offset b10, -88
; CHECK-GI-NEXT:    .cfi_offset b11, -96
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov s8, v0.s[1]
; CHECK-GI-NEXT:    mov s9, v0.s[2]
; CHECK-GI-NEXT:    mov s10, v0.s[3]
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov w8, #2139095039 // =0x7f7fffff
; CHECK-GI-NEXT:    fmov s11, w8
; CHECK-GI-NEXT:    fcmp s0, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s0, s11
; CHECK-GI-NEXT:    fmov s0, s8
; CHECK-GI-NEXT:    csinv x19, x8, xzr, le
; CHECK-GI-NEXT:    csinv x20, x9, xzr, le
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s8, #0.0
; CHECK-GI-NEXT:    fmov s0, s9
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s8, s11
; CHECK-GI-NEXT:    csinv x21, x8, xzr, le
; CHECK-GI-NEXT:    csinv x22, x9, xzr, le
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s9, #0.0
; CHECK-GI-NEXT:    fmov s0, s10
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s9, s11
; CHECK-GI-NEXT:    csinv x23, x8, xzr, le
; CHECK-GI-NEXT:    csinv x24, x9, xzr, le
; CHECK-GI-NEXT:    bl __fixunssfti
; CHECK-GI-NEXT:    fcmp s10, #0.0
; CHECK-GI-NEXT:    mov x2, x21
; CHECK-GI-NEXT:    mov x3, x22
; CHECK-GI-NEXT:    mov x4, x23
; CHECK-GI-NEXT:    mov x5, x24
; CHECK-GI-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-GI-NEXT:    ldp x22, x21, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp s10, s11
; CHECK-GI-NEXT:    mov x0, x19
; CHECK-GI-NEXT:    mov x1, x20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x24, x23, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csinv x6, x8, xzr, le
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csinv x7, x9, xzr, le
; CHECK-GI-NEXT:    ldp d11, d10, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    add sp, sp, #112
; CHECK-GI-NEXT:    ret
    %x = call <4 x i128> @llvm.fptoui.sat.v4f32.v4i128(<4 x float> %f)
    ret <4 x i128> %x
}

;
; 2-Vector double to unsigned integer -- result size variation
;

declare <2 x   i1> @llvm.fptoui.sat.v2f64.v2i1  (<2 x double>)
declare <2 x   i8> @llvm.fptoui.sat.v2f64.v2i8  (<2 x double>)
declare <2 x  i13> @llvm.fptoui.sat.v2f64.v2i13 (<2 x double>)
declare <2 x  i16> @llvm.fptoui.sat.v2f64.v2i16 (<2 x double>)
declare <2 x  i19> @llvm.fptoui.sat.v2f64.v2i19 (<2 x double>)
declare <2 x  i50> @llvm.fptoui.sat.v2f64.v2i50 (<2 x double>)
declare <2 x  i64> @llvm.fptoui.sat.v2f64.v2i64 (<2 x double>)
declare <2 x i100> @llvm.fptoui.sat.v2f64.v2i100(<2 x double>)
declare <2 x i128> @llvm.fptoui.sat.v2f64.v2i128(<2 x double>)

define <2 x i1> @test_unsigned_v2f64_v2i1(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i1:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w9, d0
; CHECK-SD-NEXT:    fcvtzu w8, d1
; CHECK-SD-NEXT:    cmp w8, #1
; CHECK-SD-NEXT:    csinc w8, w8, wzr, lo
; CHECK-SD-NEXT:    cmp w9, #1
; CHECK-SD-NEXT:    csinc w9, w9, wzr, lo
; CHECK-SD-NEXT:    fmov s0, w9
; CHECK-SD-NEXT:    mov v0.s[1], w8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i1:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    adrp x8, .LCPI46_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI46_0]
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    xtn v0.2s, v0.2d
; CHECK-GI-NEXT:    ret
    %x = call <2 x i1> @llvm.fptoui.sat.v2f64.v2i1(<2 x double> %f)
    ret <2 x i1> %x
}

define <2 x i8> @test_unsigned_v2f64_v2i8(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w10, d0
; CHECK-SD-NEXT:    mov w8, #255 // =0xff
; CHECK-SD-NEXT:    fcvtzu w9, d1
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    csel w8, w10, w8, lo
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x000000000000ff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    xtn v0.2s, v0.2d
; CHECK-GI-NEXT:    ret
    %x = call <2 x i8> @llvm.fptoui.sat.v2f64.v2i8(<2 x double> %f)
    ret <2 x i8> %x
}

define <2 x i13> @test_unsigned_v2f64_v2i13(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i13:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w9, d0
; CHECK-SD-NEXT:    mov w10, #8191 // =0x1fff
; CHECK-SD-NEXT:    fcvtzu w8, d1
; CHECK-SD-NEXT:    cmp w8, w10
; CHECK-SD-NEXT:    csel w8, w8, w10, lo
; CHECK-SD-NEXT:    cmp w9, w10
; CHECK-SD-NEXT:    csel w9, w9, w10, lo
; CHECK-SD-NEXT:    fmov s0, w9
; CHECK-SD-NEXT:    mov v0.s[1], w8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i13:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    adrp x8, .LCPI48_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI48_0]
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    xtn v0.2s, v0.2d
; CHECK-GI-NEXT:    ret
    %x = call <2 x i13> @llvm.fptoui.sat.v2f64.v2i13(<2 x double> %f)
    ret <2 x i13> %x
}

define <2 x i16> @test_unsigned_v2f64_v2i16(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w9, d0
; CHECK-SD-NEXT:    mov w10, #65535 // =0xffff
; CHECK-SD-NEXT:    fcvtzu w8, d1
; CHECK-SD-NEXT:    cmp w8, w10
; CHECK-SD-NEXT:    csel w8, w8, w10, lo
; CHECK-SD-NEXT:    cmp w9, w10
; CHECK-SD-NEXT:    csel w9, w9, w10, lo
; CHECK-SD-NEXT:    fmov s0, w9
; CHECK-SD-NEXT:    mov v0.s[1], w8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x0000000000ffff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    xtn v0.2s, v0.2d
; CHECK-GI-NEXT:    ret
    %x = call <2 x i16> @llvm.fptoui.sat.v2f64.v2i16(<2 x double> %f)
    ret <2 x i16> %x
}

define <2 x i19> @test_unsigned_v2f64_v2i19(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i19:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w9, d0
; CHECK-SD-NEXT:    mov w10, #524287 // =0x7ffff
; CHECK-SD-NEXT:    fcvtzu w8, d1
; CHECK-SD-NEXT:    cmp w8, w10
; CHECK-SD-NEXT:    csel w8, w8, w10, lo
; CHECK-SD-NEXT:    cmp w9, w10
; CHECK-SD-NEXT:    csel w9, w9, w10, lo
; CHECK-SD-NEXT:    fmov s0, w9
; CHECK-SD-NEXT:    mov v0.s[1], w8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i19:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    adrp x8, .LCPI50_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI50_0]
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    xtn v0.2s, v0.2d
; CHECK-GI-NEXT:    ret
    %x = call <2 x i19> @llvm.fptoui.sat.v2f64.v2i19(<2 x double> %f)
    ret <2 x i19> %x
}

define <2 x i32> @test_unsigned_v2f64_v2i32_duplicate(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i32_duplicate:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w8, d0
; CHECK-SD-NEXT:    fcvtzu w9, d1
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i32_duplicate:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x000000ffffffff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    xtn v0.2s, v0.2d
; CHECK-GI-NEXT:    ret
    %x = call <2 x i32> @llvm.fptoui.sat.v2f64.v2i32(<2 x double> %f)
    ret <2 x i32> %x
}

define <2 x i50> @test_unsigned_v2f64_v2i50(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i50:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu x9, d0
; CHECK-SD-NEXT:    mov x10, #1125899906842623 // =0x3ffffffffffff
; CHECK-SD-NEXT:    fcvtzu x8, d1
; CHECK-SD-NEXT:    cmp x8, x10
; CHECK-SD-NEXT:    csel x8, x8, x10, lo
; CHECK-SD-NEXT:    cmp x9, x10
; CHECK-SD-NEXT:    csel x9, x9, x10, lo
; CHECK-SD-NEXT:    fmov d0, x9
; CHECK-SD-NEXT:    mov v0.d[1], x8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i50:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    adrp x8, .LCPI52_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI52_0]
; CHECK-GI-NEXT:    cmhi v2.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    ret
    %x = call <2 x i50> @llvm.fptoui.sat.v2f64.v2i50(<2 x double> %f)
    ret <2 x i50> %x
}

define <2 x i64> @test_unsigned_v2f64_v2i64(<2 x double> %f) {
; CHECK-LABEL: test_unsigned_v2f64_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-NEXT:    ret
    %x = call <2 x i64> @llvm.fptoui.sat.v2f64.v2i64(<2 x double> %f)
    ret <2 x i64> %x
}

define <2 x i100> @test_unsigned_v2f64_v2i100(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i100:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x30, x21, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w30, -32
; CHECK-SD-NEXT:    .cfi_offset b8, -40
; CHECK-SD-NEXT:    .cfi_offset b9, -48
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl __fixunsdfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov x8, #5057542381537067007 // =0x462fffffffffffff
; CHECK-SD-NEXT:    mov x21, #68719476735 // =0xfffffffff
; CHECK-SD-NEXT:    fmov d9, x8
; CHECK-SD-NEXT:    mov d8, v0.d[1]
; CHECK-SD-NEXT:    fcmp d0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp d0, d9
; CHECK-SD-NEXT:    fmov d0, d8
; CHECK-SD-NEXT:    csel x19, x21, x9, gt
; CHECK-SD-NEXT:    csinv x20, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunsdfti
; CHECK-SD-NEXT:    fcmp d8, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp d8, d9
; CHECK-SD-NEXT:    mov x0, x20
; CHECK-SD-NEXT:    mov x1, x19
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x3, x21, x9, gt
; CHECK-SD-NEXT:    ldp x30, x21, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x2, x8, xzr, le
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i100:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x30, x21, [sp, #32] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w30, -32
; CHECK-GI-NEXT:    .cfi_offset b8, -40
; CHECK-GI-NEXT:    .cfi_offset b9, -48
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl __fixunsdfti
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov x8, #5057542381537067007 // =0x462fffffffffffff
; CHECK-GI-NEXT:    mov x21, #68719476735 // =0xfffffffff
; CHECK-GI-NEXT:    fmov d9, x8
; CHECK-GI-NEXT:    fcmp d0, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp d0, d9
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    csinv x19, x8, xzr, le
; CHECK-GI-NEXT:    csel x20, x21, x9, gt
; CHECK-GI-NEXT:    bl __fixunsdfti
; CHECK-GI-NEXT:    fcmp d8, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp d8, d9
; CHECK-GI-NEXT:    mov x0, x19
; CHECK-GI-NEXT:    mov x1, x20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csel x3, x21, x9, gt
; CHECK-GI-NEXT:    ldp x30, x21, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csinv x2, x8, xzr, le
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
    %x = call <2 x i100> @llvm.fptoui.sat.v2f64.v2i100(<2 x double> %f)
    ret <2 x i100> %x
}

define <2 x i128> @test_unsigned_v2f64_v2i128(<2 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v2f64_v2i128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #64
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 64
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w30, -32
; CHECK-SD-NEXT:    .cfi_offset b8, -40
; CHECK-SD-NEXT:    .cfi_offset b9, -48
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    bl __fixunsdfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov x8, #5183643171103440895 // =0x47efffffffffffff
; CHECK-SD-NEXT:    fmov d9, x8
; CHECK-SD-NEXT:    mov d8, v0.d[1]
; CHECK-SD-NEXT:    fcmp d0, #0.0
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp d0, d9
; CHECK-SD-NEXT:    fmov d0, d8
; CHECK-SD-NEXT:    csinv x19, x9, xzr, le
; CHECK-SD-NEXT:    csinv x20, x8, xzr, le
; CHECK-SD-NEXT:    bl __fixunsdfti
; CHECK-SD-NEXT:    fcmp d8, #0.0
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp d8, d9
; CHECK-SD-NEXT:    mov x0, x19
; CHECK-SD-NEXT:    mov x1, x20
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x2, x9, xzr, le
; CHECK-SD-NEXT:    csinv x3, x8, xzr, le
; CHECK-SD-NEXT:    add sp, sp, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v2f64_v2i128:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #64
; CHECK-GI-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-GI-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w30, -32
; CHECK-GI-NEXT:    .cfi_offset b8, -40
; CHECK-GI-NEXT:    .cfi_offset b9, -48
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    mov d8, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    bl __fixunsdfti
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov x8, #5183643171103440895 // =0x47efffffffffffff
; CHECK-GI-NEXT:    fmov d9, x8
; CHECK-GI-NEXT:    fcmp d0, #0.0
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp d0, d9
; CHECK-GI-NEXT:    fmov d0, d8
; CHECK-GI-NEXT:    csinv x19, x8, xzr, le
; CHECK-GI-NEXT:    csinv x20, x9, xzr, le
; CHECK-GI-NEXT:    bl __fixunsdfti
; CHECK-GI-NEXT:    fcmp d8, #0.0
; CHECK-GI-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-GI-NEXT:    csel x8, xzr, x0, lt
; CHECK-GI-NEXT:    csel x9, xzr, x1, lt
; CHECK-GI-NEXT:    fcmp d8, d9
; CHECK-GI-NEXT:    mov x0, x19
; CHECK-GI-NEXT:    mov x1, x20
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-GI-NEXT:    csinv x2, x8, xzr, le
; CHECK-GI-NEXT:    csinv x3, x9, xzr, le
; CHECK-GI-NEXT:    add sp, sp, #64
; CHECK-GI-NEXT:    ret
    %x = call <2 x i128> @llvm.fptoui.sat.v2f64.v2i128(<2 x double> %f)
    ret <2 x i128> %x
}

;
; 4-Vector half to unsigned integer -- result size variation
;

declare <4 x   i1> @llvm.fptoui.sat.v4f16.v4i1  (<4 x half>)
declare <4 x   i8> @llvm.fptoui.sat.v4f16.v4i8  (<4 x half>)
declare <4 x  i13> @llvm.fptoui.sat.v4f16.v4i13 (<4 x half>)
declare <4 x  i16> @llvm.fptoui.sat.v4f16.v4i16 (<4 x half>)
declare <4 x  i19> @llvm.fptoui.sat.v4f16.v4i19 (<4 x half>)
declare <4 x  i50> @llvm.fptoui.sat.v4f16.v4i50 (<4 x half>)
declare <4 x  i64> @llvm.fptoui.sat.v4f16.v4i64 (<4 x half>)
declare <4 x i100> @llvm.fptoui.sat.v4f16.v4i100(<4 x half>)
declare <4 x i128> @llvm.fptoui.sat.v4f16.v4i128(<4 x half>)

define <4 x i1> @test_unsigned_v4f16_v4i1(<4 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v4f16_v4i1:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    movi v1.4s, #1
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-SD-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v4f16_v4i1:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    movi v1.4h, #1
; CHECK-SD-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    umin v0.4h, v0.4h, v1.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i1:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-CVT-NEXT:    movi v1.4s, #1
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i1:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    movi v1.4h, #1
; CHECK-GI-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    umin v0.4h, v0.4h, v1.4h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i1> @llvm.fptoui.sat.v4f16.v4i1(<4 x half> %f)
    ret <4 x i1> %x
}

define <4 x i8> @test_unsigned_v4f16_v4i8(<4 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v4f16_v4i8:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-SD-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v4f16_v4i8:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-SD-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    umin v0.4h, v0.4h, v1.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i8:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-CVT-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i8:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    umin v0.4h, v0.4h, v1.4h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i8> @llvm.fptoui.sat.v4f16.v4i8(<4 x half> %f)
    ret <4 x i8> %x
}

define <4 x i13> @test_unsigned_v4f16_v4i13(<4 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v4f16_v4i13:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    movi v1.4s, #31, msl #8
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-SD-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v4f16_v4i13:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    mvni v1.4h, #224, lsl #8
; CHECK-SD-FP16-NEXT:    umin v0.4h, v0.4h, v1.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i13:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-CVT-NEXT:    movi v1.4s, #31, msl #8
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i13:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    mvni v1.4h, #224, lsl #8
; CHECK-GI-FP16-NEXT:    umin v0.4h, v0.4h, v1.4h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i13> @llvm.fptoui.sat.v4f16.v4i13(<4 x half> %f)
    ret <4 x i13> %x
}

define <4 x i16> @test_unsigned_v4f16_v4i16(<4 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v4f16_v4i16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    uqxtn v0.4h, v0.4s
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v4f16_v4i16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-CVT-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i16> @llvm.fptoui.sat.v4f16.v4i16(<4 x half> %f)
    ret <4 x i16> %x
}

define <4 x i19> @test_unsigned_v4f16_v4i19(<4 x half> %f) {
; CHECK-LABEL: test_unsigned_v4f16_v4i19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    movi v1.4s, #7, msl #16
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
    %x = call <4 x i19> @llvm.fptoui.sat.v4f16.v4i19(<4 x half> %f)
    ret <4 x i19> %x
}

define <4 x i32> @test_unsigned_v4f16_v4i32_duplicate(<4 x half> %f) {
; CHECK-LABEL: test_unsigned_v4f16_v4i32_duplicate:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptoui.sat.v4f16.v4i32(<4 x half> %f)
    ret <4 x i32> %x
}

define <4 x i50> @test_unsigned_v4f16_v4i50(<4 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v4f16_v4i50:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-SD-CVT-NEXT:    mov h2, v0.h[2]
; CHECK-SD-CVT-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-SD-CVT-NEXT:    mov h3, v0.h[3]
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    fcvt s1, h1
; CHECK-SD-CVT-NEXT:    fcvt s2, h2
; CHECK-SD-CVT-NEXT:    fcvt s3, h3
; CHECK-SD-CVT-NEXT:    fcvtzu x9, s0
; CHECK-SD-CVT-NEXT:    fcvtzu x10, s1
; CHECK-SD-CVT-NEXT:    fcvtzu x11, s2
; CHECK-SD-CVT-NEXT:    fcvtzu x12, s3
; CHECK-SD-CVT-NEXT:    cmp x9, x8
; CHECK-SD-CVT-NEXT:    csel x0, x9, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x10, x8
; CHECK-SD-CVT-NEXT:    csel x1, x10, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x11, x8
; CHECK-SD-CVT-NEXT:    csel x2, x11, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x12, x8
; CHECK-SD-CVT-NEXT:    csel x3, x12, x8, lo
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v4f16_v4i50:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-SD-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-SD-FP16-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-SD-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-SD-FP16-NEXT:    fcvtzu x9, h0
; CHECK-SD-FP16-NEXT:    fcvtzu x10, h1
; CHECK-SD-FP16-NEXT:    fcvtzu x11, h2
; CHECK-SD-FP16-NEXT:    fcvtzu x12, h3
; CHECK-SD-FP16-NEXT:    cmp x9, x8
; CHECK-SD-FP16-NEXT:    csel x0, x9, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x10, x8
; CHECK-SD-FP16-NEXT:    csel x1, x10, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x11, x8
; CHECK-SD-FP16-NEXT:    csel x2, x11, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x12, x8
; CHECK-SD-FP16-NEXT:    csel x3, x12, x8, lo
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i50:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-GI-CVT-NEXT:    mov h2, v0.h[2]
; CHECK-GI-CVT-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-GI-CVT-NEXT:    mov h3, v0.h[3]
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    fcvt s1, h1
; CHECK-GI-CVT-NEXT:    fcvt s2, h2
; CHECK-GI-CVT-NEXT:    fcvt s3, h3
; CHECK-GI-CVT-NEXT:    fcvtzu x9, s0
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s1
; CHECK-GI-CVT-NEXT:    fcvtzu x11, s2
; CHECK-GI-CVT-NEXT:    fcvtzu x12, s3
; CHECK-GI-CVT-NEXT:    cmp x9, x8
; CHECK-GI-CVT-NEXT:    csel x0, x9, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x10, x8
; CHECK-GI-CVT-NEXT:    csel x1, x10, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x11, x8
; CHECK-GI-CVT-NEXT:    csel x2, x11, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x12, x8
; CHECK-GI-CVT-NEXT:    csel x3, x12, x8, lo
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i50:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-GI-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h0
; CHECK-GI-FP16-NEXT:    fcvtzu x10, h1
; CHECK-GI-FP16-NEXT:    fcvtzu x11, h2
; CHECK-GI-FP16-NEXT:    fcvtzu x12, h3
; CHECK-GI-FP16-NEXT:    cmp x9, x8
; CHECK-GI-FP16-NEXT:    csel x0, x9, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x10, x8
; CHECK-GI-FP16-NEXT:    csel x1, x10, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x11, x8
; CHECK-GI-FP16-NEXT:    csel x2, x11, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x12, x8
; CHECK-GI-FP16-NEXT:    csel x3, x12, x8, lo
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i50> @llvm.fptoui.sat.v4f16.v4i50(<4 x half> %f)
    ret <4 x i50> %x
}

define <4 x i64> @test_unsigned_v4f16_v4i64(<4 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v4f16_v4i64:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-CVT-NEXT:    mov h1, v0.h[2]
; CHECK-SD-CVT-NEXT:    mov h2, v0.h[1]
; CHECK-SD-CVT-NEXT:    mov h3, v0.h[3]
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    fcvt s1, h1
; CHECK-SD-CVT-NEXT:    fcvt s2, h2
; CHECK-SD-CVT-NEXT:    fcvt s3, h3
; CHECK-SD-CVT-NEXT:    fcvtzu x8, s0
; CHECK-SD-CVT-NEXT:    fcvtzu x9, s1
; CHECK-SD-CVT-NEXT:    fcvtzu x10, s2
; CHECK-SD-CVT-NEXT:    fcvtzu x11, s3
; CHECK-SD-CVT-NEXT:    fmov d0, x8
; CHECK-SD-CVT-NEXT:    fmov d1, x9
; CHECK-SD-CVT-NEXT:    mov v0.d[1], x10
; CHECK-SD-CVT-NEXT:    mov v1.d[1], x11
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v4f16_v4i64:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-FP16-NEXT:    mov h1, v0.h[2]
; CHECK-SD-FP16-NEXT:    mov h2, v0.h[1]
; CHECK-SD-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-SD-FP16-NEXT:    fcvtzu x8, h0
; CHECK-SD-FP16-NEXT:    fcvtzu x9, h1
; CHECK-SD-FP16-NEXT:    fcvtzu x10, h2
; CHECK-SD-FP16-NEXT:    fcvtzu x11, h3
; CHECK-SD-FP16-NEXT:    fmov d0, x8
; CHECK-SD-FP16-NEXT:    fmov d1, x9
; CHECK-SD-FP16-NEXT:    mov v0.d[1], x10
; CHECK-SD-FP16-NEXT:    mov v1.d[1], x11
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i64:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl v1.2d, v0.2s
; CHECK-GI-CVT-NEXT:    fcvtl2 v2.2d, v0.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.2d, v1.2d
; CHECK-GI-CVT-NEXT:    fcvtzu v1.2d, v2.2d
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i64:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-GI-FP16-NEXT:    fcvt d0, h0
; CHECK-GI-FP16-NEXT:    fcvt d1, h1
; CHECK-GI-FP16-NEXT:    fcvt d2, h2
; CHECK-GI-FP16-NEXT:    fcvt d3, h3
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-FP16-NEXT:    mov v2.d[1], v3.d[0]
; CHECK-GI-FP16-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    fcvtzu v1.2d, v2.2d
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i64> @llvm.fptoui.sat.v4f16.v4i64(<4 x half> %f)
    ret <4 x i64> %x
}

define <4 x i100> @test_unsigned_v4f16_v4i100(<4 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f16_v4i100:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #96
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x30, x25, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x24, x23, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x22, x21, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 96
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w22, -32
; CHECK-SD-NEXT:    .cfi_offset w23, -40
; CHECK-SD-NEXT:    .cfi_offset w24, -48
; CHECK-SD-NEXT:    .cfi_offset w25, -56
; CHECK-SD-NEXT:    .cfi_offset w30, -64
; CHECK-SD-NEXT:    .cfi_offset b8, -72
; CHECK-SD-NEXT:    .cfi_offset b9, -80
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fcvt s8, h1
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #1904214015 // =0x717fffff
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov x25, #68719476735 // =0xfffffffff
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x19, x25, x8, gt
; CHECK-SD-NEXT:    csinv x20, x9, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x21, x25, x9, gt
; CHECK-SD-NEXT:    csinv x22, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x23, x25, x9, gt
; CHECK-SD-NEXT:    csinv x24, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov x2, x20
; CHECK-SD-NEXT:    mov x3, x19
; CHECK-SD-NEXT:    mov x4, x22
; CHECK-SD-NEXT:    mov x5, x21
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    mov x0, x24
; CHECK-SD-NEXT:    mov x1, x23
; CHECK-SD-NEXT:    ldp x22, x21, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x7, x25, x9, gt
; CHECK-SD-NEXT:    ldp x24, x23, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x30, x25, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x6, x8, xzr, le
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add sp, sp, #96
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i100:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-GI-CVT-NEXT:    mov h2, v0.h[2]
; CHECK-GI-CVT-NEXT:    mov x1, xzr
; CHECK-GI-CVT-NEXT:    mov h3, v0.h[3]
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov x3, xzr
; CHECK-GI-CVT-NEXT:    mov x5, xzr
; CHECK-GI-CVT-NEXT:    mov x7, xzr
; CHECK-GI-CVT-NEXT:    fcvt s1, h1
; CHECK-GI-CVT-NEXT:    fcvt s2, h2
; CHECK-GI-CVT-NEXT:    fcvt s3, h3
; CHECK-GI-CVT-NEXT:    fcvtzu x0, s0
; CHECK-GI-CVT-NEXT:    fcvtzu x2, s1
; CHECK-GI-CVT-NEXT:    fcvtzu x4, s2
; CHECK-GI-CVT-NEXT:    fcvtzu x6, s3
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i100:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    mov x1, xzr
; CHECK-GI-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-GI-FP16-NEXT:    fcvtzu x0, h0
; CHECK-GI-FP16-NEXT:    mov x3, xzr
; CHECK-GI-FP16-NEXT:    mov x5, xzr
; CHECK-GI-FP16-NEXT:    mov x7, xzr
; CHECK-GI-FP16-NEXT:    fcvtzu x2, h1
; CHECK-GI-FP16-NEXT:    fcvtzu x4, h2
; CHECK-GI-FP16-NEXT:    fcvtzu x6, h3
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i100> @llvm.fptoui.sat.v4f16.v4i100(<4 x half> %f)
    ret <4 x i100> %x
}

define <4 x i128> @test_unsigned_v4f16_v4i128(<4 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v4f16_v4i128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #96
; CHECK-SD-NEXT:    stp d9, d8, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x24, x23, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x22, x21, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 96
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w22, -32
; CHECK-SD-NEXT:    .cfi_offset w23, -40
; CHECK-SD-NEXT:    .cfi_offset w24, -48
; CHECK-SD-NEXT:    .cfi_offset w30, -64
; CHECK-SD-NEXT:    .cfi_offset b8, -72
; CHECK-SD-NEXT:    .cfi_offset b9, -80
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #2139095039 // =0x7f7fffff
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x19, x8, xzr, le
; CHECK-SD-NEXT:    csinv x20, x9, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x21, x9, xzr, le
; CHECK-SD-NEXT:    csinv x22, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x23, x9, xzr, le
; CHECK-SD-NEXT:    csinv x24, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov x2, x21
; CHECK-SD-NEXT:    mov x3, x22
; CHECK-SD-NEXT:    mov x4, x23
; CHECK-SD-NEXT:    mov x5, x24
; CHECK-SD-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    ldp x22, x21, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    mov x0, x19
; CHECK-SD-NEXT:    mov x1, x20
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x24, x23, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x6, x9, xzr, le
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x7, x8, xzr, le
; CHECK-SD-NEXT:    add sp, sp, #96
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v4f16_v4i128:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-GI-CVT-NEXT:    mov h2, v0.h[2]
; CHECK-GI-CVT-NEXT:    mov x1, xzr
; CHECK-GI-CVT-NEXT:    mov h3, v0.h[3]
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov x3, xzr
; CHECK-GI-CVT-NEXT:    mov x5, xzr
; CHECK-GI-CVT-NEXT:    mov x7, xzr
; CHECK-GI-CVT-NEXT:    fcvt s1, h1
; CHECK-GI-CVT-NEXT:    fcvt s2, h2
; CHECK-GI-CVT-NEXT:    fcvt s3, h3
; CHECK-GI-CVT-NEXT:    fcvtzu x0, s0
; CHECK-GI-CVT-NEXT:    fcvtzu x2, s1
; CHECK-GI-CVT-NEXT:    fcvtzu x4, s2
; CHECK-GI-CVT-NEXT:    fcvtzu x6, s3
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v4f16_v4i128:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    mov x1, xzr
; CHECK-GI-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-GI-FP16-NEXT:    fcvtzu x0, h0
; CHECK-GI-FP16-NEXT:    mov x3, xzr
; CHECK-GI-FP16-NEXT:    mov x5, xzr
; CHECK-GI-FP16-NEXT:    mov x7, xzr
; CHECK-GI-FP16-NEXT:    fcvtzu x2, h1
; CHECK-GI-FP16-NEXT:    fcvtzu x4, h2
; CHECK-GI-FP16-NEXT:    fcvtzu x6, h3
; CHECK-GI-FP16-NEXT:    ret
    %x = call <4 x i128> @llvm.fptoui.sat.v4f16.v4i128(<4 x half> %f)
    ret <4 x i128> %x
}

;
; 8-Vector half to unsigned integer -- result size variation
;

declare <8 x   i1> @llvm.fptoui.sat.v8f16.v8i1  (<8 x half>)
declare <8 x   i8> @llvm.fptoui.sat.v8f16.v8i8  (<8 x half>)
declare <8 x  i13> @llvm.fptoui.sat.v8f16.v8i13 (<8 x half>)
declare <8 x  i16> @llvm.fptoui.sat.v8f16.v8i16 (<8 x half>)
declare <8 x  i19> @llvm.fptoui.sat.v8f16.v8i19 (<8 x half>)
declare <8 x  i50> @llvm.fptoui.sat.v8f16.v8i50 (<8 x half>)
declare <8 x  i64> @llvm.fptoui.sat.v8f16.v8i64 (<8 x half>)
declare <8 x i100> @llvm.fptoui.sat.v8f16.v8i100(<8 x half>)
declare <8 x i128> @llvm.fptoui.sat.v8f16.v8i128(<8 x half>)

define <8 x i1> @test_unsigned_v8f16_v8i1(<8 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v8f16_v8i1:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    movi v1.4s, #1
; CHECK-SD-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-SD-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-SD-CVT-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-CVT-NEXT:    xtn v0.8b, v0.8h
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v8f16_v8i1:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    movi v1.8h, #1
; CHECK-SD-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    umin v0.8h, v0.8h, v1.8h
; CHECK-SD-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i1:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-CVT-NEXT:    movi v1.4s, #1
; CHECK-GI-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    uzp1 v0.8h, v2.8h, v0.8h
; CHECK-GI-CVT-NEXT:    xtn v0.8b, v0.8h
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i1:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    movi v1.8h, #1
; CHECK-GI-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    umin v0.8h, v0.8h, v1.8h
; CHECK-GI-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i1> @llvm.fptoui.sat.v8f16.v8i1(<8 x half> %f)
    ret <8 x i1> %x
}

define <8 x i8> @test_unsigned_v8f16_v8i8(<8 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v8f16_v8i8:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-SD-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-SD-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-SD-CVT-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-CVT-NEXT:    xtn v0.8b, v0.8h
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v8f16_v8i8:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    uqxtn v0.8b, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i8:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-CVT-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-GI-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    uzp1 v0.8h, v2.8h, v0.8h
; CHECK-GI-CVT-NEXT:    xtn v0.8b, v0.8h
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i8:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    umin v0.8h, v0.8h, v1.8h
; CHECK-GI-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i8> @llvm.fptoui.sat.v8f16.v8i8(<8 x half> %f)
    ret <8 x i8> %x
}

define <8 x i13> @test_unsigned_v8f16_v8i13(<8 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v8f16_v8i13:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    movi v1.4s, #31, msl #8
; CHECK-SD-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-SD-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-SD-CVT-NEXT:    uzp1 v0.8h, v0.8h, v2.8h
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v8f16_v8i13:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    mvni v1.8h, #224, lsl #8
; CHECK-SD-FP16-NEXT:    umin v0.8h, v0.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i13:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-CVT-NEXT:    movi v1.4s, #31, msl #8
; CHECK-GI-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    uzp1 v0.8h, v2.8h, v0.8h
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i13:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    mvni v1.8h, #224, lsl #8
; CHECK-GI-FP16-NEXT:    umin v0.8h, v0.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i13> @llvm.fptoui.sat.v8f16.v8i13(<8 x half> %f)
    ret <8 x i13> %x
}

define <8 x i16> @test_unsigned_v8f16_v8i16(<8 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v8f16_v8i16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-CVT-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-CVT-NEXT:    uqxtn v0.4h, v1.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v1.4s, v2.4s
; CHECK-SD-CVT-NEXT:    uqxtn2 v0.8h, v1.4s
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v8f16_v8i16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-CVT-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-GI-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-GI-CVT-NEXT:    uzp1 v0.8h, v2.8h, v0.8h
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i16> @llvm.fptoui.sat.v8f16.v8i16(<8 x half> %f)
    ret <8 x i16> %x
}

define <8 x i19> @test_unsigned_v8f16_v8i19(<8 x half> %f) {
; CHECK-LABEL: test_unsigned_v8f16_v8i19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-NEXT:    movi v1.4s, #7, msl #16
; CHECK-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    umin v2.4s, v2.4s, v1.4s
; CHECK-NEXT:    umin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    mov w1, v2.s[1]
; CHECK-NEXT:    mov w2, v2.s[2]
; CHECK-NEXT:    mov w3, v2.s[3]
; CHECK-NEXT:    mov w5, v0.s[1]
; CHECK-NEXT:    mov w6, v0.s[2]
; CHECK-NEXT:    mov w7, v0.s[3]
; CHECK-NEXT:    fmov w4, s0
; CHECK-NEXT:    fmov w0, s2
; CHECK-NEXT:    ret
    %x = call <8 x i19> @llvm.fptoui.sat.v8f16.v8i19(<8 x half> %f)
    ret <8 x i19> %x
}

define <8 x i32> @test_unsigned_v8f16_v8i32_duplicate(<8 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f16_v8i32_duplicate:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtl2 v1.4s, v0.8h
; CHECK-SD-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v8f16_v8i32_duplicate:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-GI-NEXT:    fcvtzu v0.4s, v1.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v2.4s
; CHECK-GI-NEXT:    ret
    %x = call <8 x i32> @llvm.fptoui.sat.v8f16.v8i32(<8 x half> %f)
    ret <8 x i32> %x
}

define <8 x i50> @test_unsigned_v8f16_v8i50(<8 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v8f16_v8i50:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-CVT-NEXT:    mov h5, v0.h[1]
; CHECK-SD-CVT-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-SD-CVT-NEXT:    mov h6, v0.h[2]
; CHECK-SD-CVT-NEXT:    mov h7, v0.h[3]
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-SD-CVT-NEXT:    mov h3, v1.h[2]
; CHECK-SD-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-SD-CVT-NEXT:    fcvt s1, h1
; CHECK-SD-CVT-NEXT:    fcvtzu x13, s0
; CHECK-SD-CVT-NEXT:    fcvt s2, h2
; CHECK-SD-CVT-NEXT:    fcvt s3, h3
; CHECK-SD-CVT-NEXT:    fcvt s4, h4
; CHECK-SD-CVT-NEXT:    fcvtzu x9, s1
; CHECK-SD-CVT-NEXT:    fcvt s1, h5
; CHECK-SD-CVT-NEXT:    fcvtzu x10, s2
; CHECK-SD-CVT-NEXT:    fcvtzu x11, s3
; CHECK-SD-CVT-NEXT:    fcvt s2, h6
; CHECK-SD-CVT-NEXT:    fcvtzu x12, s4
; CHECK-SD-CVT-NEXT:    fcvt s3, h7
; CHECK-SD-CVT-NEXT:    cmp x9, x8
; CHECK-SD-CVT-NEXT:    fcvtzu x14, s1
; CHECK-SD-CVT-NEXT:    csel x4, x9, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x10, x8
; CHECK-SD-CVT-NEXT:    fcvtzu x9, s2
; CHECK-SD-CVT-NEXT:    csel x5, x10, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x11, x8
; CHECK-SD-CVT-NEXT:    fcvtzu x10, s3
; CHECK-SD-CVT-NEXT:    csel x6, x11, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x12, x8
; CHECK-SD-CVT-NEXT:    csel x7, x12, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x13, x8
; CHECK-SD-CVT-NEXT:    csel x0, x13, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x14, x8
; CHECK-SD-CVT-NEXT:    csel x1, x14, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x9, x8
; CHECK-SD-CVT-NEXT:    csel x2, x9, x8, lo
; CHECK-SD-CVT-NEXT:    cmp x10, x8
; CHECK-SD-CVT-NEXT:    csel x3, x10, x8, lo
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v8f16_v8i50:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-FP16-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-SD-FP16-NEXT:    fcvtzu x13, h0
; CHECK-SD-FP16-NEXT:    mov h2, v1.h[1]
; CHECK-SD-FP16-NEXT:    mov h3, v1.h[2]
; CHECK-SD-FP16-NEXT:    mov h4, v1.h[3]
; CHECK-SD-FP16-NEXT:    fcvtzu x9, h1
; CHECK-SD-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-SD-FP16-NEXT:    fcvtzu x10, h2
; CHECK-SD-FP16-NEXT:    fcvtzu x11, h3
; CHECK-SD-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-SD-FP16-NEXT:    fcvtzu x12, h4
; CHECK-SD-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-SD-FP16-NEXT:    cmp x9, x8
; CHECK-SD-FP16-NEXT:    fcvtzu x14, h1
; CHECK-SD-FP16-NEXT:    csel x4, x9, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x10, x8
; CHECK-SD-FP16-NEXT:    fcvtzu x9, h2
; CHECK-SD-FP16-NEXT:    csel x5, x10, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x11, x8
; CHECK-SD-FP16-NEXT:    fcvtzu x10, h3
; CHECK-SD-FP16-NEXT:    csel x6, x11, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x12, x8
; CHECK-SD-FP16-NEXT:    csel x7, x12, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x13, x8
; CHECK-SD-FP16-NEXT:    csel x0, x13, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x14, x8
; CHECK-SD-FP16-NEXT:    csel x1, x14, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x9, x8
; CHECK-SD-FP16-NEXT:    csel x2, x9, x8, lo
; CHECK-SD-FP16-NEXT:    cmp x10, x8
; CHECK-SD-FP16-NEXT:    csel x3, x10, x8, lo
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i50:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-GI-CVT-NEXT:    mov h5, v0.h[1]
; CHECK-GI-CVT-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-GI-CVT-NEXT:    mov h6, v0.h[2]
; CHECK-GI-CVT-NEXT:    mov h7, v0.h[3]
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-GI-CVT-NEXT:    mov h3, v1.h[2]
; CHECK-GI-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-GI-CVT-NEXT:    fcvt s1, h1
; CHECK-GI-CVT-NEXT:    fcvtzu x13, s0
; CHECK-GI-CVT-NEXT:    fcvt s2, h2
; CHECK-GI-CVT-NEXT:    fcvt s3, h3
; CHECK-GI-CVT-NEXT:    fcvt s4, h4
; CHECK-GI-CVT-NEXT:    fcvtzu x9, s1
; CHECK-GI-CVT-NEXT:    fcvt s1, h5
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s2
; CHECK-GI-CVT-NEXT:    fcvtzu x11, s3
; CHECK-GI-CVT-NEXT:    fcvt s2, h6
; CHECK-GI-CVT-NEXT:    fcvtzu x12, s4
; CHECK-GI-CVT-NEXT:    fcvt s3, h7
; CHECK-GI-CVT-NEXT:    cmp x9, x8
; CHECK-GI-CVT-NEXT:    fcvtzu x14, s1
; CHECK-GI-CVT-NEXT:    csel x4, x9, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x10, x8
; CHECK-GI-CVT-NEXT:    fcvtzu x9, s2
; CHECK-GI-CVT-NEXT:    csel x5, x10, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x11, x8
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s3
; CHECK-GI-CVT-NEXT:    csel x6, x11, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x12, x8
; CHECK-GI-CVT-NEXT:    csel x7, x12, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x13, x8
; CHECK-GI-CVT-NEXT:    csel x0, x13, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x14, x8
; CHECK-GI-CVT-NEXT:    csel x1, x14, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x9, x8
; CHECK-GI-CVT-NEXT:    csel x2, x9, x8, lo
; CHECK-GI-CVT-NEXT:    cmp x10, x8
; CHECK-GI-CVT-NEXT:    csel x3, x10, x8, lo
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i50:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-GI-FP16-NEXT:    mov x8, #1125899906842623 // =0x3ffffffffffff
; CHECK-GI-FP16-NEXT:    fcvtzu x13, h0
; CHECK-GI-FP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-FP16-NEXT:    mov h3, v1.h[2]
; CHECK-GI-FP16-NEXT:    mov h4, v1.h[3]
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h1
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    fcvtzu x10, h2
; CHECK-GI-FP16-NEXT:    fcvtzu x11, h3
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    fcvtzu x12, h4
; CHECK-GI-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-GI-FP16-NEXT:    cmp x9, x8
; CHECK-GI-FP16-NEXT:    fcvtzu x14, h1
; CHECK-GI-FP16-NEXT:    csel x4, x9, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x10, x8
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h2
; CHECK-GI-FP16-NEXT:    csel x5, x10, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x11, x8
; CHECK-GI-FP16-NEXT:    fcvtzu x10, h3
; CHECK-GI-FP16-NEXT:    csel x6, x11, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x12, x8
; CHECK-GI-FP16-NEXT:    csel x7, x12, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x13, x8
; CHECK-GI-FP16-NEXT:    csel x0, x13, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x14, x8
; CHECK-GI-FP16-NEXT:    csel x1, x14, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x9, x8
; CHECK-GI-FP16-NEXT:    csel x2, x9, x8, lo
; CHECK-GI-FP16-NEXT:    cmp x10, x8
; CHECK-GI-FP16-NEXT:    csel x3, x10, x8, lo
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i50> @llvm.fptoui.sat.v8f16.v8i50(<8 x half> %f)
    ret <8 x i50> %x
}

define <8 x i64> @test_unsigned_v8f16_v8i64(<8 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v8f16_v8i64:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-CVT-NEXT:    mov h4, v0.h[2]
; CHECK-SD-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-SD-CVT-NEXT:    mov h7, v0.h[3]
; CHECK-SD-CVT-NEXT:    fcvt s0, h0
; CHECK-SD-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-SD-CVT-NEXT:    mov h5, v1.h[1]
; CHECK-SD-CVT-NEXT:    mov h6, v1.h[3]
; CHECK-SD-CVT-NEXT:    fcvt s1, h1
; CHECK-SD-CVT-NEXT:    fcvt s4, h4
; CHECK-SD-CVT-NEXT:    fcvt s3, h3
; CHECK-SD-CVT-NEXT:    fcvt s7, h7
; CHECK-SD-CVT-NEXT:    fcvtzu x9, s0
; CHECK-SD-CVT-NEXT:    fcvt s2, h2
; CHECK-SD-CVT-NEXT:    fcvt s5, h5
; CHECK-SD-CVT-NEXT:    fcvt s6, h6
; CHECK-SD-CVT-NEXT:    fcvtzu x8, s1
; CHECK-SD-CVT-NEXT:    fcvtzu x12, s4
; CHECK-SD-CVT-NEXT:    fcvtzu x11, s3
; CHECK-SD-CVT-NEXT:    fcvtzu x15, s7
; CHECK-SD-CVT-NEXT:    fmov d0, x9
; CHECK-SD-CVT-NEXT:    fcvtzu x10, s2
; CHECK-SD-CVT-NEXT:    fcvtzu x13, s5
; CHECK-SD-CVT-NEXT:    fcvtzu x14, s6
; CHECK-SD-CVT-NEXT:    fmov d2, x8
; CHECK-SD-CVT-NEXT:    fmov d1, x12
; CHECK-SD-CVT-NEXT:    mov v0.d[1], x11
; CHECK-SD-CVT-NEXT:    fmov d3, x10
; CHECK-SD-CVT-NEXT:    mov v2.d[1], x13
; CHECK-SD-CVT-NEXT:    mov v1.d[1], x15
; CHECK-SD-CVT-NEXT:    mov v3.d[1], x14
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v8f16_v8i64:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-FP16-NEXT:    mov h4, v0.h[2]
; CHECK-SD-FP16-NEXT:    mov h3, v0.h[1]
; CHECK-SD-FP16-NEXT:    mov h7, v0.h[3]
; CHECK-SD-FP16-NEXT:    fcvtzu x9, h0
; CHECK-SD-FP16-NEXT:    mov h2, v1.h[2]
; CHECK-SD-FP16-NEXT:    mov h5, v1.h[1]
; CHECK-SD-FP16-NEXT:    mov h6, v1.h[3]
; CHECK-SD-FP16-NEXT:    fcvtzu x8, h1
; CHECK-SD-FP16-NEXT:    fcvtzu x12, h4
; CHECK-SD-FP16-NEXT:    fcvtzu x11, h3
; CHECK-SD-FP16-NEXT:    fcvtzu x15, h7
; CHECK-SD-FP16-NEXT:    fmov d0, x9
; CHECK-SD-FP16-NEXT:    fcvtzu x10, h2
; CHECK-SD-FP16-NEXT:    fcvtzu x13, h5
; CHECK-SD-FP16-NEXT:    fcvtzu x14, h6
; CHECK-SD-FP16-NEXT:    fmov d2, x8
; CHECK-SD-FP16-NEXT:    fmov d1, x12
; CHECK-SD-FP16-NEXT:    mov v0.d[1], x11
; CHECK-SD-FP16-NEXT:    fmov d3, x10
; CHECK-SD-FP16-NEXT:    mov v2.d[1], x13
; CHECK-SD-FP16-NEXT:    mov v1.d[1], x15
; CHECK-SD-FP16-NEXT:    mov v3.d[1], x14
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i64:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-CVT-NEXT:    fcvtl v2.2d, v1.2s
; CHECK-GI-CVT-NEXT:    fcvtl2 v1.2d, v1.4s
; CHECK-GI-CVT-NEXT:    fcvtl v3.2d, v0.2s
; CHECK-GI-CVT-NEXT:    fcvtl2 v4.2d, v0.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.2d, v2.2d
; CHECK-GI-CVT-NEXT:    fcvtzu v1.2d, v1.2d
; CHECK-GI-CVT-NEXT:    fcvtzu v2.2d, v3.2d
; CHECK-GI-CVT-NEXT:    fcvtzu v3.2d, v4.2d
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i64:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-GI-FP16-NEXT:    mov h4, v0.h[4]
; CHECK-GI-FP16-NEXT:    mov h5, v0.h[5]
; CHECK-GI-FP16-NEXT:    mov h6, v0.h[6]
; CHECK-GI-FP16-NEXT:    mov h7, v0.h[7]
; CHECK-GI-FP16-NEXT:    fcvt d0, h0
; CHECK-GI-FP16-NEXT:    fcvt d1, h1
; CHECK-GI-FP16-NEXT:    fcvt d2, h2
; CHECK-GI-FP16-NEXT:    fcvt d3, h3
; CHECK-GI-FP16-NEXT:    fcvt d4, h4
; CHECK-GI-FP16-NEXT:    fcvt d5, h5
; CHECK-GI-FP16-NEXT:    fcvt d6, h6
; CHECK-GI-FP16-NEXT:    fcvt d7, h7
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-FP16-NEXT:    mov v2.d[1], v3.d[0]
; CHECK-GI-FP16-NEXT:    mov v4.d[1], v5.d[0]
; CHECK-GI-FP16-NEXT:    mov v6.d[1], v7.d[0]
; CHECK-GI-FP16-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    fcvtzu v1.2d, v2.2d
; CHECK-GI-FP16-NEXT:    fcvtzu v2.2d, v4.2d
; CHECK-GI-FP16-NEXT:    fcvtzu v3.2d, v6.2d
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i64> @llvm.fptoui.sat.v8f16.v8i64(<8 x half> %f)
    ret <8 x i64> %x
}

define <8 x i100> @test_unsigned_v8f16_v8i100(<8 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f16_v8i100:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #176
; CHECK-SD-NEXT:    stp d9, d8, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x29, x30, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x28, x27, [sp, #96] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x26, x25, [sp, #112] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x24, x23, [sp, #128] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x22, x21, [sp, #144] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #160] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 176
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w22, -32
; CHECK-SD-NEXT:    .cfi_offset w23, -40
; CHECK-SD-NEXT:    .cfi_offset w24, -48
; CHECK-SD-NEXT:    .cfi_offset w25, -56
; CHECK-SD-NEXT:    .cfi_offset w26, -64
; CHECK-SD-NEXT:    .cfi_offset w27, -72
; CHECK-SD-NEXT:    .cfi_offset w28, -80
; CHECK-SD-NEXT:    .cfi_offset w30, -88
; CHECK-SD-NEXT:    .cfi_offset w29, -96
; CHECK-SD-NEXT:    .cfi_offset b8, -104
; CHECK-SD-NEXT:    .cfi_offset b9, -112
; CHECK-SD-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    mov x19, x8
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #1904214015 // =0x717fffff
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov x23, #68719476735 // =0xfffffffff
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x10, x23, x8, gt
; CHECK-SD-NEXT:    csinv x8, x9, xzr, le
; CHECK-SD-NEXT:    stp x8, x10, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x9, x23, x9, gt
; CHECK-SD-NEXT:    csinv x8, x8, xzr, le
; CHECK-SD-NEXT:    stp x8, x9, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x8, x8, xzr, le
; CHECK-SD-NEXT:    csel x25, x23, x9, gt
; CHECK-SD-NEXT:    str x8, [sp, #32] // 8-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x26, x23, x9, gt
; CHECK-SD-NEXT:    csinv x28, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x29, x23, x9, gt
; CHECK-SD-NEXT:    csinv x20, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x21, x23, x9, gt
; CHECK-SD-NEXT:    csinv x27, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csel x22, x23, x9, gt
; CHECK-SD-NEXT:    csinv x24, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    extr x8, x21, x27, #28
; CHECK-SD-NEXT:    extr x9, x29, x20, #28
; CHECK-SD-NEXT:    stur x28, [x19, #75]
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    bfi x22, x20, #36, #28
; CHECK-SD-NEXT:    lsr x11, x29, #28
; CHECK-SD-NEXT:    stur x8, [x19, #41]
; CHECK-SD-NEXT:    str x9, [x19, #16]
; CHECK-SD-NEXT:    ldr x10, [sp, #32] // 8-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    stp x24, x22, [x19]
; CHECK-SD-NEXT:    stur x10, [x19, #50]
; CHECK-SD-NEXT:    lsr x10, x21, #28
; CHECK-SD-NEXT:    strb w11, [x19, #24]
; CHECK-SD-NEXT:    strb w10, [x19, #49]
; CHECK-SD-NEXT:    csel x9, x23, x9, gt
; CHECK-SD-NEXT:    csinv x8, x8, xzr, le
; CHECK-SD-NEXT:    ldp x12, x11, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    bfi x9, x27, #36, #28
; CHECK-SD-NEXT:    stur x8, [x19, #25]
; CHECK-SD-NEXT:    stur x9, [x19, #33]
; CHECK-SD-NEXT:    extr x10, x11, x12, #28
; CHECK-SD-NEXT:    bfi x26, x12, #36, #28
; CHECK-SD-NEXT:    stur x10, [x19, #91]
; CHECK-SD-NEXT:    ldp x10, x9, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    stur x26, [x19, #83]
; CHECK-SD-NEXT:    extr x8, x9, x10, #28
; CHECK-SD-NEXT:    bfi x25, x10, #36, #28
; CHECK-SD-NEXT:    lsr x9, x9, #28
; CHECK-SD-NEXT:    stur x8, [x19, #66]
; CHECK-SD-NEXT:    lsr x8, x11, #28
; CHECK-SD-NEXT:    stur x25, [x19, #58]
; CHECK-SD-NEXT:    strb w8, [x19, #99]
; CHECK-SD-NEXT:    strb w9, [x19, #74]
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #160] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x22, x21, [sp, #144] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x24, x23, [sp, #128] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x26, x25, [sp, #112] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x28, x27, [sp, #96] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x29, x30, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add sp, sp, #176
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i100:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-GI-CVT-NEXT:    mov h2, v0.h[2]
; CHECK-GI-CVT-NEXT:    mov x11, x8
; CHECK-GI-CVT-NEXT:    fcvt s3, h0
; CHECK-GI-CVT-NEXT:    mov h4, v0.h[3]
; CHECK-GI-CVT-NEXT:    str wzr, [x8, #8]
; CHECK-GI-CVT-NEXT:    strb wzr, [x8, #12]
; CHECK-GI-CVT-NEXT:    fcvt s1, h1
; CHECK-GI-CVT-NEXT:    fcvt s2, h2
; CHECK-GI-CVT-NEXT:    fcvtzu x9, s3
; CHECK-GI-CVT-NEXT:    fcvt s3, h4
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s1
; CHECK-GI-CVT-NEXT:    mov h1, v0.h[4]
; CHECK-GI-CVT-NEXT:    fcvtzu x12, s2
; CHECK-GI-CVT-NEXT:    mov h2, v0.h[5]
; CHECK-GI-CVT-NEXT:    str x9, [x8]
; CHECK-GI-CVT-NEXT:    mov x9, x8
; CHECK-GI-CVT-NEXT:    fcvt s1, h1
; CHECK-GI-CVT-NEXT:    str x10, [x11, #12]!
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s3
; CHECK-GI-CVT-NEXT:    mov h3, v0.h[6]
; CHECK-GI-CVT-NEXT:    fcvt s2, h2
; CHECK-GI-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-GI-CVT-NEXT:    str wzr, [x11, #8]
; CHECK-GI-CVT-NEXT:    strb wzr, [x11, #12]
; CHECK-GI-CVT-NEXT:    mov x11, x8
; CHECK-GI-CVT-NEXT:    str x12, [x9, #25]!
; CHECK-GI-CVT-NEXT:    fcvtzu x12, s1
; CHECK-GI-CVT-NEXT:    str wzr, [x9, #8]
; CHECK-GI-CVT-NEXT:    fcvt s1, h3
; CHECK-GI-CVT-NEXT:    strb wzr, [x9, #12]
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    mov x9, x8
; CHECK-GI-CVT-NEXT:    str x10, [x11, #37]!
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s2
; CHECK-GI-CVT-NEXT:    str wzr, [x11, #8]
; CHECK-GI-CVT-NEXT:    strb wzr, [x11, #12]
; CHECK-GI-CVT-NEXT:    fcvtzu x11, s1
; CHECK-GI-CVT-NEXT:    str x12, [x9, #50]!
; CHECK-GI-CVT-NEXT:    str wzr, [x9, #8]
; CHECK-GI-CVT-NEXT:    strb wzr, [x9, #12]
; CHECK-GI-CVT-NEXT:    mov x9, x8
; CHECK-GI-CVT-NEXT:    str x10, [x9, #62]!
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s0
; CHECK-GI-CVT-NEXT:    str wzr, [x9, #8]
; CHECK-GI-CVT-NEXT:    strb wzr, [x9, #12]
; CHECK-GI-CVT-NEXT:    mov x9, x8
; CHECK-GI-CVT-NEXT:    str x11, [x9, #75]!
; CHECK-GI-CVT-NEXT:    str wzr, [x9, #8]
; CHECK-GI-CVT-NEXT:    strb wzr, [x9, #12]
; CHECK-GI-CVT-NEXT:    str x10, [x8, #87]!
; CHECK-GI-CVT-NEXT:    str wzr, [x8, #8]
; CHECK-GI-CVT-NEXT:    strb wzr, [x8, #12]
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i100:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    mov x11, x8
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h0
; CHECK-GI-FP16-NEXT:    str wzr, [x8, #8]
; CHECK-GI-FP16-NEXT:    strb wzr, [x8, #12]
; CHECK-GI-FP16-NEXT:    fcvtzu x10, h1
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[3]
; CHECK-GI-FP16-NEXT:    fcvtzu x12, h2
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-FP16-NEXT:    str x9, [x8]
; CHECK-GI-FP16-NEXT:    mov x9, x8
; CHECK-GI-FP16-NEXT:    str x10, [x11, #12]!
; CHECK-GI-FP16-NEXT:    fcvtzu x10, h1
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[5]
; CHECK-GI-FP16-NEXT:    str wzr, [x11, #8]
; CHECK-GI-FP16-NEXT:    strb wzr, [x11, #12]
; CHECK-GI-FP16-NEXT:    mov x11, x8
; CHECK-GI-FP16-NEXT:    str x12, [x9, #25]!
; CHECK-GI-FP16-NEXT:    fcvtzu x12, h2
; CHECK-GI-FP16-NEXT:    str wzr, [x9, #8]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[6]
; CHECK-GI-FP16-NEXT:    mov h0, v0.h[7]
; CHECK-GI-FP16-NEXT:    strb wzr, [x9, #12]
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h1
; CHECK-GI-FP16-NEXT:    str x10, [x11, #37]!
; CHECK-GI-FP16-NEXT:    mov x10, x8
; CHECK-GI-FP16-NEXT:    str wzr, [x11, #8]
; CHECK-GI-FP16-NEXT:    strb wzr, [x11, #12]
; CHECK-GI-FP16-NEXT:    fcvtzu x11, h2
; CHECK-GI-FP16-NEXT:    str x12, [x10, #50]!
; CHECK-GI-FP16-NEXT:    str wzr, [x10, #8]
; CHECK-GI-FP16-NEXT:    strb wzr, [x10, #12]
; CHECK-GI-FP16-NEXT:    mov x10, x8
; CHECK-GI-FP16-NEXT:    str x9, [x10, #62]!
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h0
; CHECK-GI-FP16-NEXT:    str wzr, [x10, #8]
; CHECK-GI-FP16-NEXT:    strb wzr, [x10, #12]
; CHECK-GI-FP16-NEXT:    mov x10, x8
; CHECK-GI-FP16-NEXT:    str x11, [x10, #75]!
; CHECK-GI-FP16-NEXT:    str wzr, [x10, #8]
; CHECK-GI-FP16-NEXT:    strb wzr, [x10, #12]
; CHECK-GI-FP16-NEXT:    str x9, [x8, #87]!
; CHECK-GI-FP16-NEXT:    str wzr, [x8, #8]
; CHECK-GI-FP16-NEXT:    strb wzr, [x8, #12]
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i100> @llvm.fptoui.sat.v8f16.v8i100(<8 x half> %f)
    ret <8 x i100> %x
}

define <8 x i128> @test_unsigned_v8f16_v8i128(<8 x half> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f16_v8i128:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #176
; CHECK-SD-NEXT:    stp d9, d8, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x29, x30, [sp, #80] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x28, x27, [sp, #96] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x26, x25, [sp, #112] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x24, x23, [sp, #128] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x22, x21, [sp, #144] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #160] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 176
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w22, -32
; CHECK-SD-NEXT:    .cfi_offset w23, -40
; CHECK-SD-NEXT:    .cfi_offset w24, -48
; CHECK-SD-NEXT:    .cfi_offset w25, -56
; CHECK-SD-NEXT:    .cfi_offset w26, -64
; CHECK-SD-NEXT:    .cfi_offset w27, -72
; CHECK-SD-NEXT:    .cfi_offset w28, -80
; CHECK-SD-NEXT:    .cfi_offset w30, -88
; CHECK-SD-NEXT:    .cfi_offset w29, -96
; CHECK-SD-NEXT:    .cfi_offset b8, -104
; CHECK-SD-NEXT:    .cfi_offset b9, -112
; CHECK-SD-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    mov x19, x8
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w8, #2139095039 // =0x7f7fffff
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    fmov s9, w8
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    csel x9, xzr, x1, lt
; CHECK-SD-NEXT:    csel x8, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x10, x8, xzr, le
; CHECK-SD-NEXT:    csinv x8, x9, xzr, le
; CHECK-SD-NEXT:    stp x8, x10, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    csinv x8, x8, xzr, le
; CHECK-SD-NEXT:    stp x8, x9, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x24, x9, xzr, le
; CHECK-SD-NEXT:    csinv x25, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x26, x9, xzr, le
; CHECK-SD-NEXT:    csinv x27, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[1]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x28, x9, xzr, le
; CHECK-SD-NEXT:    csinv x29, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x20, x9, xzr, le
; CHECK-SD-NEXT:    csinv x21, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    fcvt s8, h0
; CHECK-SD-NEXT:    csinv x22, x9, xzr, le
; CHECK-SD-NEXT:    csinv x23, x8, xzr, le
; CHECK-SD-NEXT:    fmov s0, s8
; CHECK-SD-NEXT:    bl __fixunssfti
; CHECK-SD-NEXT:    fcmp s8, #0.0
; CHECK-SD-NEXT:    stp x22, x23, [x19, #32]
; CHECK-SD-NEXT:    stp x20, x21, [x19, #16]
; CHECK-SD-NEXT:    stp x28, x29, [x19]
; CHECK-SD-NEXT:    csel x8, xzr, x1, lt
; CHECK-SD-NEXT:    csel x9, xzr, x0, lt
; CHECK-SD-NEXT:    fcmp s8, s9
; CHECK-SD-NEXT:    stp x26, x27, [x19, #112]
; CHECK-SD-NEXT:    stp x24, x25, [x19, #96]
; CHECK-SD-NEXT:    csinv x8, x8, xzr, le
; CHECK-SD-NEXT:    csinv x9, x9, xzr, le
; CHECK-SD-NEXT:    stp x9, x8, [x19, #48]
; CHECK-SD-NEXT:    ldr x8, [sp] // 8-byte Folded Reload
; CHECK-SD-NEXT:    str x8, [x19, #88]
; CHECK-SD-NEXT:    ldr x8, [sp, #8] // 8-byte Folded Reload
; CHECK-SD-NEXT:    str x8, [x19, #80]
; CHECK-SD-NEXT:    ldr x8, [sp, #16] // 8-byte Folded Reload
; CHECK-SD-NEXT:    str x8, [x19, #72]
; CHECK-SD-NEXT:    ldr x8, [sp, #24] // 8-byte Folded Reload
; CHECK-SD-NEXT:    str x8, [x19, #64]
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #160] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x22, x21, [sp, #144] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x24, x23, [sp, #128] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x26, x25, [sp, #112] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x28, x27, [sp, #96] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp x29, x30, [sp, #80] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldp d9, d8, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add sp, sp, #176
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v8f16_v8i128:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    mov h1, v0.h[1]
; CHECK-GI-CVT-NEXT:    mov h2, v0.h[2]
; CHECK-GI-CVT-NEXT:    mov h3, v0.h[3]
; CHECK-GI-CVT-NEXT:    mov h4, v0.h[4]
; CHECK-GI-CVT-NEXT:    fcvt s5, h0
; CHECK-GI-CVT-NEXT:    mov h6, v0.h[5]
; CHECK-GI-CVT-NEXT:    mov h7, v0.h[6]
; CHECK-GI-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-GI-CVT-NEXT:    fcvt s1, h1
; CHECK-GI-CVT-NEXT:    fcvt s2, h2
; CHECK-GI-CVT-NEXT:    fcvt s3, h3
; CHECK-GI-CVT-NEXT:    fcvtzu x9, s5
; CHECK-GI-CVT-NEXT:    fcvt s4, h4
; CHECK-GI-CVT-NEXT:    fcvt s5, h6
; CHECK-GI-CVT-NEXT:    fcvt s0, h0
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s1
; CHECK-GI-CVT-NEXT:    fcvt s1, h7
; CHECK-GI-CVT-NEXT:    fcvtzu x11, s2
; CHECK-GI-CVT-NEXT:    fcvtzu x12, s3
; CHECK-GI-CVT-NEXT:    mov v2.d[0], x9
; CHECK-GI-CVT-NEXT:    fcvtzu x9, s4
; CHECK-GI-CVT-NEXT:    mov v3.d[0], x10
; CHECK-GI-CVT-NEXT:    fcvtzu x10, s5
; CHECK-GI-CVT-NEXT:    mov v4.d[0], x11
; CHECK-GI-CVT-NEXT:    fcvtzu x11, s1
; CHECK-GI-CVT-NEXT:    mov v1.d[0], x12
; CHECK-GI-CVT-NEXT:    fcvtzu x12, s0
; CHECK-GI-CVT-NEXT:    mov v0.d[0], x9
; CHECK-GI-CVT-NEXT:    mov v2.d[1], xzr
; CHECK-GI-CVT-NEXT:    mov v5.d[0], x10
; CHECK-GI-CVT-NEXT:    mov v3.d[1], xzr
; CHECK-GI-CVT-NEXT:    mov v4.d[1], xzr
; CHECK-GI-CVT-NEXT:    mov v6.d[0], x11
; CHECK-GI-CVT-NEXT:    mov v7.d[0], x12
; CHECK-GI-CVT-NEXT:    mov v1.d[1], xzr
; CHECK-GI-CVT-NEXT:    mov v0.d[1], xzr
; CHECK-GI-CVT-NEXT:    mov v5.d[1], xzr
; CHECK-GI-CVT-NEXT:    stp q2, q3, [x8]
; CHECK-GI-CVT-NEXT:    mov v6.d[1], xzr
; CHECK-GI-CVT-NEXT:    mov v7.d[1], xzr
; CHECK-GI-CVT-NEXT:    stp q4, q1, [x8, #32]
; CHECK-GI-CVT-NEXT:    stp q0, q5, [x8, #64]
; CHECK-GI-CVT-NEXT:    stp q6, q7, [x8, #96]
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v8f16_v8i128:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov h2, v0.h[2]
; CHECK-GI-FP16-NEXT:    mov h3, v0.h[3]
; CHECK-GI-FP16-NEXT:    mov h4, v0.h[4]
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h0
; CHECK-GI-FP16-NEXT:    mov h5, v0.h[5]
; CHECK-GI-FP16-NEXT:    fcvtzu x10, h1
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[6]
; CHECK-GI-FP16-NEXT:    fcvtzu x11, h2
; CHECK-GI-FP16-NEXT:    mov h0, v0.h[7]
; CHECK-GI-FP16-NEXT:    fcvtzu x12, h3
; CHECK-GI-FP16-NEXT:    mov v2.d[0], x9
; CHECK-GI-FP16-NEXT:    fcvtzu x9, h4
; CHECK-GI-FP16-NEXT:    mov v3.d[0], x10
; CHECK-GI-FP16-NEXT:    fcvtzu x10, h5
; CHECK-GI-FP16-NEXT:    mov v4.d[0], x11
; CHECK-GI-FP16-NEXT:    fcvtzu x11, h1
; CHECK-GI-FP16-NEXT:    mov v1.d[0], x12
; CHECK-GI-FP16-NEXT:    fcvtzu x12, h0
; CHECK-GI-FP16-NEXT:    mov v0.d[0], x9
; CHECK-GI-FP16-NEXT:    mov v2.d[1], xzr
; CHECK-GI-FP16-NEXT:    mov v5.d[0], x10
; CHECK-GI-FP16-NEXT:    mov v3.d[1], xzr
; CHECK-GI-FP16-NEXT:    mov v4.d[1], xzr
; CHECK-GI-FP16-NEXT:    mov v6.d[0], x11
; CHECK-GI-FP16-NEXT:    mov v7.d[0], x12
; CHECK-GI-FP16-NEXT:    mov v1.d[1], xzr
; CHECK-GI-FP16-NEXT:    mov v0.d[1], xzr
; CHECK-GI-FP16-NEXT:    mov v5.d[1], xzr
; CHECK-GI-FP16-NEXT:    stp q2, q3, [x8]
; CHECK-GI-FP16-NEXT:    mov v6.d[1], xzr
; CHECK-GI-FP16-NEXT:    mov v7.d[1], xzr
; CHECK-GI-FP16-NEXT:    stp q4, q1, [x8, #32]
; CHECK-GI-FP16-NEXT:    stp q0, q5, [x8, #64]
; CHECK-GI-FP16-NEXT:    stp q6, q7, [x8, #96]
; CHECK-GI-FP16-NEXT:    ret
    %x = call <8 x i128> @llvm.fptoui.sat.v8f16.v8i128(<8 x half> %f)
    ret <8 x i128> %x
}


declare <8 x i8> @llvm.fptoui.sat.v8f32.v8i8(<8 x float> %f)
declare <8 x i16> @llvm.fptoui.sat.v8f32.v8i16(<8 x float> %f)
declare <16 x i8> @llvm.fptoui.sat.v16f32.v16i8(<16 x float> %f)
declare <16 x i16> @llvm.fptoui.sat.v16f32.v16i16(<16 x float> %f)

declare <16 x i8> @llvm.fptoui.sat.v16f16.v16i8(<16 x half> %f)
declare <16 x i16> @llvm.fptoui.sat.v16f16.v16i16(<16 x half> %f)

declare <8 x i8> @llvm.fptoui.sat.v8f64.v8i8(<8 x double> %f)
declare <8 x i16> @llvm.fptoui.sat.v8f64.v8i16(<8 x double> %f)
declare <16 x i8> @llvm.fptoui.sat.v16f64.v16i8(<16 x double> %f)
declare <16 x i16> @llvm.fptoui.sat.v16f64.v16i16(<16 x double> %f)

define <8 x i8> @test_unsigned_v8f32_v8i8(<8 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f32_v8i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v2.2d, #0x0000ff000000ff
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    umin v1.4s, v1.4s, v2.4s
; CHECK-SD-NEXT:    umin v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-SD-NEXT:    xtn v0.8b, v0.8h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v8f32_v8i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0x0000ff000000ff
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-NEXT:    umin v0.4s, v0.4s, v2.4s
; CHECK-GI-NEXT:    umin v1.4s, v1.4s, v2.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    xtn v0.8b, v0.8h
; CHECK-GI-NEXT:    ret
    %x = call <8 x i8> @llvm.fptoui.sat.v8f32.v8i8(<8 x float> %f)
    ret <8 x i8> %x
}

define <16 x i8> @test_unsigned_v16f32_v16i8(<16 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v16f32_v16i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v4.2d, #0x0000ff000000ff
; CHECK-SD-NEXT:    fcvtzu v3.4s, v3.4s
; CHECK-SD-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    umin v3.4s, v3.4s, v4.4s
; CHECK-SD-NEXT:    umin v2.4s, v2.4s, v4.4s
; CHECK-SD-NEXT:    umin v1.4s, v1.4s, v4.4s
; CHECK-SD-NEXT:    umin v0.4s, v0.4s, v4.4s
; CHECK-SD-NEXT:    uzp1 v2.8h, v2.8h, v3.8h
; CHECK-SD-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-SD-NEXT:    uzp1 v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v16f32_v16i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v4.2d, #0x0000ff000000ff
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-GI-NEXT:    fcvtzu v3.4s, v3.4s
; CHECK-GI-NEXT:    umin v0.4s, v0.4s, v4.4s
; CHECK-GI-NEXT:    umin v1.4s, v1.4s, v4.4s
; CHECK-GI-NEXT:    umin v2.4s, v2.4s, v4.4s
; CHECK-GI-NEXT:    umin v3.4s, v3.4s, v4.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
    %x = call <16 x i8> @llvm.fptoui.sat.v16f32.v16i8(<16 x float> %f)
    ret <16 x i8> %x
}

define <8 x i16> @test_unsigned_v8f32_v8i16(<8 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f32_v8i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-NEXT:    uqxtn v0.4h, v0.4s
; CHECK-SD-NEXT:    uqxtn2 v0.8h, v1.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v8f32_v8i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-NEXT:    umin v0.4s, v0.4s, v2.4s
; CHECK-GI-NEXT:    umin v1.4s, v1.4s, v2.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
    %x = call <8 x i16> @llvm.fptoui.sat.v8f32.v8i16(<8 x float> %f)
    ret <8 x i16> %x
}

define <16 x i16> @test_unsigned_v16f32_v16i16(<16 x float> %f) {
; CHECK-SD-LABEL: test_unsigned_v16f32_v16i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-SD-NEXT:    fcvtzu v4.4s, v1.4s
; CHECK-SD-NEXT:    uqxtn v0.4h, v0.4s
; CHECK-SD-NEXT:    uqxtn v1.4h, v2.4s
; CHECK-SD-NEXT:    fcvtzu v2.4s, v3.4s
; CHECK-SD-NEXT:    uqxtn2 v0.8h, v4.4s
; CHECK-SD-NEXT:    uqxtn2 v1.8h, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v16f32_v16i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v4.2d, #0x00ffff0000ffff
; CHECK-GI-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-GI-NEXT:    fcvtzu v3.4s, v3.4s
; CHECK-GI-NEXT:    umin v0.4s, v0.4s, v4.4s
; CHECK-GI-NEXT:    umin v1.4s, v1.4s, v4.4s
; CHECK-GI-NEXT:    umin v2.4s, v2.4s, v4.4s
; CHECK-GI-NEXT:    umin v3.4s, v3.4s, v4.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    ret
    %x = call <16 x i16> @llvm.fptoui.sat.v16f32.v16i16(<16 x float> %f)
    ret <16 x i16> %x
}



define <16 x i8> @test_unsigned_v16f16_v16i8(<16 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v16f16_v16i8:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl2 v3.4s, v1.8h
; CHECK-SD-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-SD-CVT-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-CVT-NEXT:    movi v2.2d, #0x0000ff000000ff
; CHECK-SD-CVT-NEXT:    fcvtzu v3.4s, v3.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v4.4s, v4.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-SD-CVT-NEXT:    umin v3.4s, v3.4s, v2.4s
; CHECK-SD-CVT-NEXT:    umin v1.4s, v1.4s, v2.4s
; CHECK-SD-CVT-NEXT:    umin v4.4s, v4.4s, v2.4s
; CHECK-SD-CVT-NEXT:    umin v0.4s, v0.4s, v2.4s
; CHECK-SD-CVT-NEXT:    uzp1 v1.8h, v1.8h, v3.8h
; CHECK-SD-CVT-NEXT:    uzp1 v0.8h, v0.8h, v4.8h
; CHECK-SD-CVT-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v16f16_v16i8:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    fcvtzu v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    uqxtn v0.8b, v0.8h
; CHECK-SD-FP16-NEXT:    uqxtn2 v0.16b, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v16f16_v16i8:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v3.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-CVT-NEXT:    fcvtl v4.4s, v1.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-CVT-NEXT:    movi v2.2d, #0x0000ff000000ff
; CHECK-GI-CVT-NEXT:    fcvtzu v3.4s, v3.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v4.4s, v4.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-CVT-NEXT:    umin v3.4s, v3.4s, v2.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v2.4s
; CHECK-GI-CVT-NEXT:    umin v4.4s, v4.4s, v2.4s
; CHECK-GI-CVT-NEXT:    umin v1.4s, v1.4s, v2.4s
; CHECK-GI-CVT-NEXT:    uzp1 v0.8h, v3.8h, v0.8h
; CHECK-GI-CVT-NEXT:    uzp1 v1.8h, v4.8h, v1.8h
; CHECK-GI-CVT-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v16f16_v16i8:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    movi v2.2d, #0xff00ff00ff00ff
; CHECK-GI-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    fcvtzu v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    umin v0.8h, v0.8h, v2.8h
; CHECK-GI-FP16-NEXT:    umin v1.8h, v1.8h, v2.8h
; CHECK-GI-FP16-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-GI-FP16-NEXT:    ret
    %x = call <16 x i8> @llvm.fptoui.sat.v16f16.v16i8(<16 x half> %f)
    ret <16 x i8> %x
}

define <16 x i16> @test_unsigned_v16f16_v16i16(<16 x half> %f) {
; CHECK-SD-CVT-LABEL: test_unsigned_v16f16_v16i16:
; CHECK-SD-CVT:       // %bb.0:
; CHECK-SD-CVT-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-CVT-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-CVT-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-CVT-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-CVT-NEXT:    fcvtzu v2.4s, v2.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v1.4s, v3.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v3.4s, v5.4s
; CHECK-SD-CVT-NEXT:    uqxtn v0.4h, v2.4s
; CHECK-SD-CVT-NEXT:    fcvtzu v2.4s, v4.4s
; CHECK-SD-CVT-NEXT:    uqxtn v1.4h, v1.4s
; CHECK-SD-CVT-NEXT:    uqxtn2 v0.8h, v2.4s
; CHECK-SD-CVT-NEXT:    uqxtn2 v1.8h, v3.4s
; CHECK-SD-CVT-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: test_unsigned_v16f16_v16i16:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    fcvtzu v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-CVT-LABEL: test_unsigned_v16f16_v16i16:
; CHECK-GI-CVT:       // %bb.0:
; CHECK-GI-CVT-NEXT:    fcvtl v3.4s, v0.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-CVT-NEXT:    fcvtl v4.4s, v1.4h
; CHECK-GI-CVT-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-CVT-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-GI-CVT-NEXT:    fcvtzu v3.4s, v3.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v4.4s, v4.4s
; CHECK-GI-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-GI-CVT-NEXT:    umin v3.4s, v3.4s, v2.4s
; CHECK-GI-CVT-NEXT:    umin v0.4s, v0.4s, v2.4s
; CHECK-GI-CVT-NEXT:    umin v4.4s, v4.4s, v2.4s
; CHECK-GI-CVT-NEXT:    umin v1.4s, v1.4s, v2.4s
; CHECK-GI-CVT-NEXT:    uzp1 v0.8h, v3.8h, v0.8h
; CHECK-GI-CVT-NEXT:    uzp1 v1.8h, v4.8h, v1.8h
; CHECK-GI-CVT-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: test_unsigned_v16f16_v16i16:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    fcvtzu v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
    %x = call <16 x i16> @llvm.fptoui.sat.v16f16.v16i16(<16 x half> %f)
    ret <16 x i16> %x
}

define <8 x i8> @test_unsigned_v8f64_v8i8(<8 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f64_v8i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d4, v3.d[1]
; CHECK-SD-NEXT:    mov d5, v2.d[1]
; CHECK-SD-NEXT:    mov w11, #255 // =0xff
; CHECK-SD-NEXT:    fcvtzu w9, d3
; CHECK-SD-NEXT:    mov d3, v1.d[1]
; CHECK-SD-NEXT:    fcvtzu w12, d2
; CHECK-SD-NEXT:    fcvtzu w14, d1
; CHECK-SD-NEXT:    fcvtzu w8, d4
; CHECK-SD-NEXT:    mov d4, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w10, d5
; CHECK-SD-NEXT:    fcvtzu w13, d3
; CHECK-SD-NEXT:    cmp w8, #255
; CHECK-SD-NEXT:    fcvtzu w15, d4
; CHECK-SD-NEXT:    csel w8, w8, w11, lo
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    csel w9, w9, w11, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    fmov s4, w9
; CHECK-SD-NEXT:    csel w9, w10, w11, lo
; CHECK-SD-NEXT:    cmp w12, #255
; CHECK-SD-NEXT:    fcvtzu w10, d0
; CHECK-SD-NEXT:    mov v4.s[1], w8
; CHECK-SD-NEXT:    csel w8, w12, w11, lo
; CHECK-SD-NEXT:    cmp w13, #255
; CHECK-SD-NEXT:    fmov s3, w8
; CHECK-SD-NEXT:    csel w8, w13, w11, lo
; CHECK-SD-NEXT:    cmp w14, #255
; CHECK-SD-NEXT:    mov v3.s[1], w9
; CHECK-SD-NEXT:    csel w9, w14, w11, lo
; CHECK-SD-NEXT:    cmp w15, #255
; CHECK-SD-NEXT:    fmov s2, w9
; CHECK-SD-NEXT:    csel w9, w15, w11, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    mov v2.s[1], w8
; CHECK-SD-NEXT:    csel w8, w10, w11, lo
; CHECK-SD-NEXT:    fmov s1, w8
; CHECK-SD-NEXT:    adrp x8, .LCPI82_0
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI82_0]
; CHECK-SD-NEXT:    mov v1.s[1], w9
; CHECK-SD-NEXT:    tbl v0.8b, { v1.16b, v2.16b, v3.16b, v4.16b }, v0.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v8f64_v8i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v4.2d, #0x000000000000ff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtzu v1.2d, v1.2d
; CHECK-GI-NEXT:    fcvtzu v2.2d, v2.2d
; CHECK-GI-NEXT:    fcvtzu v3.2d, v3.2d
; CHECK-GI-NEXT:    cmhi v5.2d, v4.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v6.2d, v4.2d, v1.2d
; CHECK-GI-NEXT:    cmhi v7.2d, v4.2d, v2.2d
; CHECK-GI-NEXT:    cmhi v16.2d, v4.2d, v3.2d
; CHECK-GI-NEXT:    bif v0.16b, v4.16b, v5.16b
; CHECK-GI-NEXT:    bif v1.16b, v4.16b, v6.16b
; CHECK-GI-NEXT:    bif v2.16b, v4.16b, v7.16b
; CHECK-GI-NEXT:    bif v3.16b, v4.16b, v16.16b
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    xtn v0.8b, v0.8h
; CHECK-GI-NEXT:    ret
    %x = call <8 x i8> @llvm.fptoui.sat.v8f64.v8i8(<8 x double> %f)
    ret <8 x i8> %x
}

define <16 x i8> @test_unsigned_v16f64_v16i8(<16 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v16f64_v16i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d16, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w10, d0
; CHECK-SD-NEXT:    mov w8, #255 // =0xff
; CHECK-SD-NEXT:    fcvtzu w9, d16
; CHECK-SD-NEXT:    mov d16, v1.d[1]
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    fmov s0, w10
; CHECK-SD-NEXT:    fcvtzu w10, d16
; CHECK-SD-NEXT:    mov d16, v2.d[1]
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    fcvtzu w9, d1
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    mov w11, v0.s[1]
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    fmov s1, w9
; CHECK-SD-NEXT:    fcvtzu w9, d16
; CHECK-SD-NEXT:    mov d16, v3.d[1]
; CHECK-SD-NEXT:    mov v0.b[1], w11
; CHECK-SD-NEXT:    mov v1.s[1], w10
; CHECK-SD-NEXT:    fcvtzu w10, d2
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    mov w11, v1.s[1]
; CHECK-SD-NEXT:    mov v0.b[2], v1.b[0]
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    fmov s2, w10
; CHECK-SD-NEXT:    fcvtzu w10, d16
; CHECK-SD-NEXT:    mov d16, v4.d[1]
; CHECK-SD-NEXT:    mov v0.b[3], w11
; CHECK-SD-NEXT:    mov v2.s[1], w9
; CHECK-SD-NEXT:    fcvtzu w9, d3
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    mov w11, v2.s[1]
; CHECK-SD-NEXT:    mov v0.b[4], v2.b[0]
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    fmov s3, w9
; CHECK-SD-NEXT:    fcvtzu w9, d16
; CHECK-SD-NEXT:    mov d16, v5.d[1]
; CHECK-SD-NEXT:    mov v0.b[5], w11
; CHECK-SD-NEXT:    mov v3.s[1], w10
; CHECK-SD-NEXT:    fcvtzu w10, d4
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    mov w11, v3.s[1]
; CHECK-SD-NEXT:    mov v0.b[6], v3.b[0]
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    fmov s4, w10
; CHECK-SD-NEXT:    fcvtzu w10, d16
; CHECK-SD-NEXT:    mov v0.b[7], w11
; CHECK-SD-NEXT:    mov v4.s[1], w9
; CHECK-SD-NEXT:    fcvtzu w9, d5
; CHECK-SD-NEXT:    mov d5, v6.d[1]
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    mov w11, v4.s[1]
; CHECK-SD-NEXT:    mov v0.b[8], v4.b[0]
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    fmov s16, w9
; CHECK-SD-NEXT:    fcvtzu w9, d5
; CHECK-SD-NEXT:    mov d5, v7.d[1]
; CHECK-SD-NEXT:    mov v0.b[9], w11
; CHECK-SD-NEXT:    mov v16.s[1], w10
; CHECK-SD-NEXT:    fcvtzu w10, d6
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    mov v0.b[10], v16.b[0]
; CHECK-SD-NEXT:    mov w11, v16.s[1]
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    fmov s6, w10
; CHECK-SD-NEXT:    fcvtzu w10, d7
; CHECK-SD-NEXT:    mov v0.b[11], w11
; CHECK-SD-NEXT:    mov v6.s[1], w9
; CHECK-SD-NEXT:    fcvtzu w9, d5
; CHECK-SD-NEXT:    cmp w9, #255
; CHECK-SD-NEXT:    mov v0.b[12], v6.b[0]
; CHECK-SD-NEXT:    mov w11, v6.s[1]
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    cmp w10, #255
; CHECK-SD-NEXT:    csel w8, w10, w8, lo
; CHECK-SD-NEXT:    fmov s5, w8
; CHECK-SD-NEXT:    mov v0.b[13], w11
; CHECK-SD-NEXT:    mov v5.s[1], w9
; CHECK-SD-NEXT:    mov v0.b[14], v5.b[0]
; CHECK-SD-NEXT:    mov w8, v5.s[1]
; CHECK-SD-NEXT:    mov v0.b[15], w8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v16f64_v16i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtzu v1.2d, v1.2d
; CHECK-GI-NEXT:    movi v16.2d, #0x000000000000ff
; CHECK-GI-NEXT:    fcvtzu v2.2d, v2.2d
; CHECK-GI-NEXT:    fcvtzu v3.2d, v3.2d
; CHECK-GI-NEXT:    fcvtzu v4.2d, v4.2d
; CHECK-GI-NEXT:    fcvtzu v5.2d, v5.2d
; CHECK-GI-NEXT:    fcvtzu v6.2d, v6.2d
; CHECK-GI-NEXT:    fcvtzu v7.2d, v7.2d
; CHECK-GI-NEXT:    cmhi v17.2d, v16.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v18.2d, v16.2d, v1.2d
; CHECK-GI-NEXT:    cmhi v19.2d, v16.2d, v2.2d
; CHECK-GI-NEXT:    cmhi v20.2d, v16.2d, v3.2d
; CHECK-GI-NEXT:    cmhi v21.2d, v16.2d, v4.2d
; CHECK-GI-NEXT:    cmhi v22.2d, v16.2d, v5.2d
; CHECK-GI-NEXT:    cmhi v23.2d, v16.2d, v6.2d
; CHECK-GI-NEXT:    cmhi v24.2d, v16.2d, v7.2d
; CHECK-GI-NEXT:    bif v0.16b, v16.16b, v17.16b
; CHECK-GI-NEXT:    bif v1.16b, v16.16b, v18.16b
; CHECK-GI-NEXT:    bif v2.16b, v16.16b, v19.16b
; CHECK-GI-NEXT:    bif v3.16b, v16.16b, v20.16b
; CHECK-GI-NEXT:    bif v4.16b, v16.16b, v21.16b
; CHECK-GI-NEXT:    bif v5.16b, v16.16b, v22.16b
; CHECK-GI-NEXT:    bif v6.16b, v16.16b, v23.16b
; CHECK-GI-NEXT:    bif v7.16b, v16.16b, v24.16b
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v2.4s, v4.4s, v5.4s
; CHECK-GI-NEXT:    uzp1 v3.4s, v6.4s, v7.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    uzp1 v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
    %x = call <16 x i8> @llvm.fptoui.sat.v16f64.v16i8(<16 x double> %f)
    ret <16 x i8> %x
}

define <8 x i16> @test_unsigned_v8f64_v8i16(<8 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v8f64_v8i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d4, v3.d[1]
; CHECK-SD-NEXT:    mov d5, v2.d[1]
; CHECK-SD-NEXT:    mov w10, #65535 // =0xffff
; CHECK-SD-NEXT:    fcvtzu w9, d3
; CHECK-SD-NEXT:    mov d3, v1.d[1]
; CHECK-SD-NEXT:    fcvtzu w12, d2
; CHECK-SD-NEXT:    fcvtzu w14, d1
; CHECK-SD-NEXT:    fcvtzu w8, d4
; CHECK-SD-NEXT:    mov d4, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w11, d5
; CHECK-SD-NEXT:    fcvtzu w13, d3
; CHECK-SD-NEXT:    cmp w8, w10
; CHECK-SD-NEXT:    fcvtzu w15, d4
; CHECK-SD-NEXT:    csel w8, w8, w10, lo
; CHECK-SD-NEXT:    cmp w9, w10
; CHECK-SD-NEXT:    csel w9, w9, w10, lo
; CHECK-SD-NEXT:    cmp w11, w10
; CHECK-SD-NEXT:    fmov s4, w9
; CHECK-SD-NEXT:    csel w9, w11, w10, lo
; CHECK-SD-NEXT:    cmp w12, w10
; CHECK-SD-NEXT:    fcvtzu w11, d0
; CHECK-SD-NEXT:    mov v4.s[1], w8
; CHECK-SD-NEXT:    csel w8, w12, w10, lo
; CHECK-SD-NEXT:    cmp w13, w10
; CHECK-SD-NEXT:    fmov s3, w8
; CHECK-SD-NEXT:    csel w8, w13, w10, lo
; CHECK-SD-NEXT:    cmp w14, w10
; CHECK-SD-NEXT:    mov v3.s[1], w9
; CHECK-SD-NEXT:    csel w9, w14, w10, lo
; CHECK-SD-NEXT:    cmp w15, w10
; CHECK-SD-NEXT:    fmov s2, w9
; CHECK-SD-NEXT:    csel w9, w15, w10, lo
; CHECK-SD-NEXT:    cmp w11, w10
; CHECK-SD-NEXT:    mov v2.s[1], w8
; CHECK-SD-NEXT:    csel w8, w11, w10, lo
; CHECK-SD-NEXT:    fmov s1, w8
; CHECK-SD-NEXT:    adrp x8, .LCPI84_0
; CHECK-SD-NEXT:    ldr q0, [x8, :lo12:.LCPI84_0]
; CHECK-SD-NEXT:    mov v1.s[1], w9
; CHECK-SD-NEXT:    tbl v0.16b, { v1.16b, v2.16b, v3.16b, v4.16b }, v0.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v8f64_v8i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v4.2d, #0x0000000000ffff
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtzu v1.2d, v1.2d
; CHECK-GI-NEXT:    fcvtzu v2.2d, v2.2d
; CHECK-GI-NEXT:    fcvtzu v3.2d, v3.2d
; CHECK-GI-NEXT:    cmhi v5.2d, v4.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v6.2d, v4.2d, v1.2d
; CHECK-GI-NEXT:    cmhi v7.2d, v4.2d, v2.2d
; CHECK-GI-NEXT:    cmhi v16.2d, v4.2d, v3.2d
; CHECK-GI-NEXT:    bif v0.16b, v4.16b, v5.16b
; CHECK-GI-NEXT:    bif v1.16b, v4.16b, v6.16b
; CHECK-GI-NEXT:    bif v2.16b, v4.16b, v7.16b
; CHECK-GI-NEXT:    bif v3.16b, v4.16b, v16.16b
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
    %x = call <8 x i16> @llvm.fptoui.sat.v8f64.v8i16(<8 x double> %f)
    ret <8 x i16> %x
}

define <16 x i16> @test_unsigned_v16f64_v16i16(<16 x double> %f) {
; CHECK-SD-LABEL: test_unsigned_v16f64_v16i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov d16, v3.d[1]
; CHECK-SD-NEXT:    mov d17, v2.d[1]
; CHECK-SD-NEXT:    mov w8, #65535 // =0xffff
; CHECK-SD-NEXT:    fcvtzu w9, d3
; CHECK-SD-NEXT:    mov d3, v1.d[1]
; CHECK-SD-NEXT:    fcvtzu w10, d1
; CHECK-SD-NEXT:    mov d1, v0.d[1]
; CHECK-SD-NEXT:    fcvtzu w11, d2
; CHECK-SD-NEXT:    fcvtzu w12, d0
; CHECK-SD-NEXT:    mov d0, v7.d[1]
; CHECK-SD-NEXT:    mov d2, v6.d[1]
; CHECK-SD-NEXT:    fcvtzu w14, d7
; CHECK-SD-NEXT:    fcvtzu w13, d16
; CHECK-SD-NEXT:    fcvtzu w16, d17
; CHECK-SD-NEXT:    fcvtzu w15, d6
; CHECK-SD-NEXT:    fcvtzu w17, d3
; CHECK-SD-NEXT:    mov d6, v5.d[1]
; CHECK-SD-NEXT:    mov d3, v4.d[1]
; CHECK-SD-NEXT:    fcvtzu w18, d1
; CHECK-SD-NEXT:    cmp w13, w8
; CHECK-SD-NEXT:    csel w13, w13, w8, lo
; CHECK-SD-NEXT:    cmp w9, w8
; CHECK-SD-NEXT:    csel w9, w9, w8, lo
; CHECK-SD-NEXT:    cmp w16, w8
; CHECK-SD-NEXT:    fmov s19, w9
; CHECK-SD-NEXT:    csel w9, w16, w8, lo
; CHECK-SD-NEXT:    cmp w11, w8
; CHECK-SD-NEXT:    fcvtzu w16, d0
; CHECK-SD-NEXT:    csel w11, w11, w8, lo
; CHECK-SD-NEXT:    cmp w17, w8
; CHECK-SD-NEXT:    mov v19.s[1], w13
; CHECK-SD-NEXT:    csel w13, w17, w8, lo
; CHECK-SD-NEXT:    cmp w10, w8
; CHECK-SD-NEXT:    csel w10, w10, w8, lo
; CHECK-SD-NEXT:    cmp w18, w8
; CHECK-SD-NEXT:    fmov s18, w11
; CHECK-SD-NEXT:    csel w11, w18, w8, lo
; CHECK-SD-NEXT:    cmp w12, w8
; CHECK-SD-NEXT:    fcvtzu w17, d2
; CHECK-SD-NEXT:    csel w12, w12, w8, lo
; CHECK-SD-NEXT:    cmp w16, w8
; CHECK-SD-NEXT:    fcvtzu w18, d6
; CHECK-SD-NEXT:    mov v18.s[1], w9
; CHECK-SD-NEXT:    csel w9, w16, w8, lo
; CHECK-SD-NEXT:    cmp w14, w8
; CHECK-SD-NEXT:    fmov s17, w10
; CHECK-SD-NEXT:    csel w10, w14, w8, lo
; CHECK-SD-NEXT:    fcvtzu w16, d5
; CHECK-SD-NEXT:    fmov s23, w10
; CHECK-SD-NEXT:    cmp w17, w8
; CHECK-SD-NEXT:    fcvtzu w14, d3
; CHECK-SD-NEXT:    csel w10, w17, w8, lo
; CHECK-SD-NEXT:    cmp w15, w8
; CHECK-SD-NEXT:    fcvtzu w17, d4
; CHECK-SD-NEXT:    mov v17.s[1], w13
; CHECK-SD-NEXT:    mov v23.s[1], w9
; CHECK-SD-NEXT:    csel w9, w15, w8, lo
; CHECK-SD-NEXT:    cmp w18, w8
; CHECK-SD-NEXT:    fmov s22, w9
; CHECK-SD-NEXT:    csel w9, w18, w8, lo
; CHECK-SD-NEXT:    cmp w16, w8
; CHECK-SD-NEXT:    fmov s16, w12
; CHECK-SD-NEXT:    mov v22.s[1], w10
; CHECK-SD-NEXT:    csel w10, w16, w8, lo
; CHECK-SD-NEXT:    cmp w14, w8
; CHECK-SD-NEXT:    fmov s21, w10
; CHECK-SD-NEXT:    csel w10, w14, w8, lo
; CHECK-SD-NEXT:    cmp w17, w8
; CHECK-SD-NEXT:    csel w8, w17, w8, lo
; CHECK-SD-NEXT:    mov v16.s[1], w11
; CHECK-SD-NEXT:    mov v21.s[1], w9
; CHECK-SD-NEXT:    fmov s20, w8
; CHECK-SD-NEXT:    adrp x8, .LCPI85_0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI85_0]
; CHECK-SD-NEXT:    mov v20.s[1], w10
; CHECK-SD-NEXT:    tbl v0.16b, { v16.16b, v17.16b, v18.16b, v19.16b }, v1.16b
; CHECK-SD-NEXT:    tbl v1.16b, { v20.16b, v21.16b, v22.16b, v23.16b }, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_unsigned_v16f64_v16i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtzu v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtzu v1.2d, v1.2d
; CHECK-GI-NEXT:    movi v16.2d, #0x0000000000ffff
; CHECK-GI-NEXT:    fcvtzu v2.2d, v2.2d
; CHECK-GI-NEXT:    fcvtzu v3.2d, v3.2d
; CHECK-GI-NEXT:    fcvtzu v4.2d, v4.2d
; CHECK-GI-NEXT:    fcvtzu v5.2d, v5.2d
; CHECK-GI-NEXT:    fcvtzu v6.2d, v6.2d
; CHECK-GI-NEXT:    fcvtzu v7.2d, v7.2d
; CHECK-GI-NEXT:    cmhi v17.2d, v16.2d, v0.2d
; CHECK-GI-NEXT:    cmhi v18.2d, v16.2d, v1.2d
; CHECK-GI-NEXT:    cmhi v19.2d, v16.2d, v2.2d
; CHECK-GI-NEXT:    cmhi v20.2d, v16.2d, v3.2d
; CHECK-GI-NEXT:    cmhi v21.2d, v16.2d, v4.2d
; CHECK-GI-NEXT:    cmhi v22.2d, v16.2d, v5.2d
; CHECK-GI-NEXT:    cmhi v23.2d, v16.2d, v6.2d
; CHECK-GI-NEXT:    cmhi v24.2d, v16.2d, v7.2d
; CHECK-GI-NEXT:    bif v0.16b, v16.16b, v17.16b
; CHECK-GI-NEXT:    bif v1.16b, v16.16b, v18.16b
; CHECK-GI-NEXT:    bif v2.16b, v16.16b, v19.16b
; CHECK-GI-NEXT:    bif v3.16b, v16.16b, v20.16b
; CHECK-GI-NEXT:    bif v4.16b, v16.16b, v21.16b
; CHECK-GI-NEXT:    bif v5.16b, v16.16b, v22.16b
; CHECK-GI-NEXT:    bif v6.16b, v16.16b, v23.16b
; CHECK-GI-NEXT:    bif v7.16b, v16.16b, v24.16b
; CHECK-GI-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    uzp1 v2.4s, v4.4s, v5.4s
; CHECK-GI-NEXT:    uzp1 v3.4s, v6.4s, v7.4s
; CHECK-GI-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    uzp1 v1.8h, v2.8h, v3.8h
; CHECK-GI-NEXT:    ret
    %x = call <16 x i16> @llvm.fptoui.sat.v16f64.v16i16(<16 x double> %f)
    ret <16 x i16> %x
}

define <2 x i64> @test_signed_v2f128_v2i64(<2 x fp128> %f) {
; CHECK-SD-LABEL: test_signed_v2f128_v2i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #80
; CHECK-SD-NEXT:    stp x30, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 80
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    mov v2.16b, v1.16b
; CHECK-SD-NEXT:    stp q1, q0, [sp, #32] // 32-byte Folded Spill
; CHECK-SD-NEXT:    adrp x8, .LCPI86_0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI86_0]
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfdi
; CHECK-SD-NEXT:    adrp x8, .LCPI86_1
; CHECK-SD-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI86_1]
; CHECK-SD-NEXT:    csel x19, xzr, x0, lt
; CHECK-SD-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x8, x19, xzr, le
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    str q0, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    bl __getf2
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    mov w19, w0
; CHECK-SD-NEXT:    bl __fixunstfdi
; CHECK-SD-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-SD-NEXT:    cmp w19, #0
; CHECK-SD-NEXT:    csel x19, xzr, x0, lt
; CHECK-SD-NEXT:    bl __gttf2
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    csinv x8, x19, xzr, le
; CHECK-SD-NEXT:    ldp x30, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-SD-NEXT:    fmov d0, x8
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    add sp, sp, #80
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_signed_v2f128_v2i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sub sp, sp, #96
; CHECK-GI-NEXT:    stp x30, x23, [sp, #48] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x22, x21, [sp, #64] // 16-byte Folded Spill
; CHECK-GI-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 96
; CHECK-GI-NEXT:    .cfi_offset w19, -8
; CHECK-GI-NEXT:    .cfi_offset w20, -16
; CHECK-GI-NEXT:    .cfi_offset w21, -24
; CHECK-GI-NEXT:    .cfi_offset w22, -32
; CHECK-GI-NEXT:    .cfi_offset w23, -40
; CHECK-GI-NEXT:    .cfi_offset w30, -48
; CHECK-GI-NEXT:    adrp x8, .LCPI86_1
; CHECK-GI-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI86_1]
; CHECK-GI-NEXT:    stp q2, q1, [sp, #16] // 32-byte Folded Spill
; CHECK-GI-NEXT:    mov v1.16b, v2.16b
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x19, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x19
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    adrp x8, .LCPI86_0
; CHECK-GI-NEXT:    mov v0.d[1], x20
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI86_0]
; CHECK-GI-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    mov x21, #-562949953421312 // =0xfffe000000000000
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    mov x22, #4629418941960159231 // =0x403effffffffffff
; CHECK-GI-NEXT:    csel x8, x19, x21, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x20, x22, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfdi
; CHECK-GI-NEXT:    ldp q1, q0, [sp, #16] // 32-byte Folded Reload
; CHECK-GI-NEXT:    mov x19, x0
; CHECK-GI-NEXT:    bl __gttf2
; CHECK-GI-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    csel x20, x8, xzr, gt
; CHECK-GI-NEXT:    mov x8, v0.d[1]
; CHECK-GI-NEXT:    mov v0.d[0], x20
; CHECK-GI-NEXT:    csel x23, x8, xzr, gt
; CHECK-GI-NEXT:    mov v0.d[1], x23
; CHECK-GI-NEXT:    bl __lttf2
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x8, x20, x21, lt
; CHECK-GI-NEXT:    mov v0.d[0], x8
; CHECK-GI-NEXT:    csel x8, x23, x22, lt
; CHECK-GI-NEXT:    mov v0.d[1], x8
; CHECK-GI-NEXT:    bl __fixunstfdi
; CHECK-GI-NEXT:    mov v0.d[0], x19
; CHECK-GI-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x22, x21, [sp, #64] // 16-byte Folded Reload
; CHECK-GI-NEXT:    ldp x30, x23, [sp, #48] // 16-byte Folded Reload
; CHECK-GI-NEXT:    mov v0.d[1], x0
; CHECK-GI-NEXT:    add sp, sp, #96
; CHECK-GI-NEXT:    ret
    %x = call <2 x i64> @llvm.fptoui.sat.v2f128.v2i64(<2 x fp128> %f)
    ret <2 x i64> %x
}
