; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instsimplify -march=nvptx64 -S | FileCheck %s

; f2ll/f2ull and d2ll/d2ull - double/float to i64 tests

;###############################################################
;#               Tests with Positive 1.5                       #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_1_5_f2ll_rm() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rm() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ll.rm(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ll_rn() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rn() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ll.rn(float 1.5)
  ret i64 %res
}


define i64 @test_pos_1_5_f2ll_rp() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rp() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ll.rp(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ll_rz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ll.rz(float 1.5)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ll_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_pos_1_5_f2ll_rm_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rm_ftz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ll.rm.ftz(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ll_rn_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rn_ftz() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ll.rn.ftz(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ll_rp_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rp_ftz() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ll.rp.ftz(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ll_rz_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ll_rz_ftz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ll.rz.ftz(float 1.5)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_1_5_d2ll_rm() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ll_rm() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.d2ll.rm(double 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_d2ll_rn() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ll_rn() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.d2ll.rn(double 1.5)
  ret i64 %res
}


define i64 @test_pos_1_5_d2ll_rp() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ll_rp() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.d2ll.rp(double 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_d2ll_rz() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ll_rz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.d2ll.rz(double 1.5)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                        f2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_1_5_f2ull_rm() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rm() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ull.rm(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ull_rn() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rn() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ull.rn(float 1.5)
  ret i64 %res
}


define i64 @test_pos_1_5_f2ull_rp() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rp() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ull.rp(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ull_rz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ull.rz(float 1.5)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ull_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_pos_1_5_f2ull_rm_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rm_ftz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ull.rm.ftz(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ull_rn_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rn_ftz() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ull.rn.ftz(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ull_rp_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rp_ftz() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.f2ull.rp.ftz(float 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_f2ull_rz_ftz() {
; CHECK-LABEL: define i64 @test_pos_1_5_f2ull_rz_ftz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ull.rz.ftz(float 1.5)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_1_5_d2ull_rm() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ull_rm() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.d2ull.rm(double 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_d2ull_rn() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ull_rn() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.d2ull.rn(double 1.5)
  ret i64 %res
}


define i64 @test_pos_1_5_d2ull_rp() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ull_rp() {
; CHECK-NEXT:    ret i64 2
;
  %res = call i64 @llvm.nvvm.d2ull.rp(double 1.5)
  ret i64 %res
}

define i64 @test_pos_1_5_d2ull_rz() {
; CHECK-LABEL: define i64 @test_pos_1_5_d2ull_rz() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.d2ull.rz(double 1.5)
  ret i64 %res
}

;###############################################################
;#               Tests with Negative 1.5                       #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_1_5_f2ll_rm() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rm() {
; CHECK-NEXT:    ret i64 -2
;
  %res = call i64 @llvm.nvvm.f2ll.rm(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ll_rn() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rn() {
; CHECK-NEXT:    ret i64 -2
;
  %res = call i64 @llvm.nvvm.f2ll.rn(float -1.5)
  ret i64 %res
}


define i64 @test_neg_1_5_f2ll_rp() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rp() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.f2ll.rp(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ll_rz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rz() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.f2ll.rz(float -1.5)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ll_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_neg_1_5_f2ll_rm_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rm_ftz() {
; CHECK-NEXT:    ret i64 -2
;
  %res = call i64 @llvm.nvvm.f2ll.rm.ftz(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ll_rn_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rn_ftz() {
; CHECK-NEXT:    ret i64 -2
;
  %res = call i64 @llvm.nvvm.f2ll.rn.ftz(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ll_rp_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rp_ftz() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.f2ll.rp.ftz(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ll_rz_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ll_rz_ftz() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.f2ll.rz.ftz(float -1.5)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_1_5_d2ll_rm() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ll_rm() {
; CHECK-NEXT:    ret i64 -2
;
  %res = call i64 @llvm.nvvm.d2ll.rm(double -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_d2ll_rn() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ll_rn() {
; CHECK-NEXT:    ret i64 -2
;
  %res = call i64 @llvm.nvvm.d2ll.rn(double -1.5)
  ret i64 %res
}


define i64 @test_neg_1_5_d2ll_rp() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ll_rp() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.d2ll.rp(double -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_d2ll_rz() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ll_rz() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.d2ll.rz(double -1.5)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                        f2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_1_5_f2ull_rm() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rm(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rm(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ull_rn() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rn() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rn(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rn(float -1.5)
  ret i64 %res
}


define i64 @test_neg_1_5_f2ull_rp() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rp() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rp(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rp(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ull_rz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rz() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rz(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rz(float -1.5)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ull_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_neg_1_5_f2ull_rm_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rm_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rm.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rm.ftz(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ull_rn_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rn_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rn.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rn.ftz(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ull_rp_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rp_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rp.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rp.ftz(float -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_f2ull_rz_ftz() {
; CHECK-LABEL: define i64 @test_neg_1_5_f2ull_rz_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rz.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rz.ftz(float -1.5)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_1_5_d2ull_rm() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ull_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.d2ull.rm(double -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.d2ull.rm(double -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_d2ull_rn() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ull_rn() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.d2ull.rn(double -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.d2ull.rn(double -1.5)
  ret i64 %res
}


define i64 @test_neg_1_5_d2ull_rp() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ull_rp() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.d2ull.rp(double -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.d2ull.rp(double -1.5)
  ret i64 %res
}

define i64 @test_neg_1_5_d2ull_rz() {
; CHECK-LABEL: define i64 @test_neg_1_5_d2ull_rz() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.d2ull.rz(double -1.500000e+00)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.d2ull.rz(double -1.5)
  ret i64 %res
}

;###############################################################
;#                    Tests with NaN                           #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_nan_f2ll_rm() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rm(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ll_rn() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rn(float 0x7FFFFF0000000000)
  ret i64 %res
}


define i64 @test_nan_f2ll_rp() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rp(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ll_rz() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rz(float 0x7FFFFF0000000000)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ll_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_nan_f2ll_rm_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rm_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rm.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ll_rn_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rn_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rn.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ll_rp_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rp_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rp.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ll_rz_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ll_rz_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rz.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_nan_d2ll_rm() {
; CHECK-LABEL: define i64 @test_nan_d2ll_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rm(double 0xFFF8000000000000)
  ret i64 %res
}

define i64 @test_nan_d2ll_rn() {
; CHECK-LABEL: define i64 @test_nan_d2ll_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rn(double 0xFFF8000000000000)
  ret i64 %res
}


define i64 @test_nan_d2ll_rp() {
; CHECK-LABEL: define i64 @test_nan_d2ll_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rp(double 0xFFF8000000000000)
  ret i64 %res
}

define i64 @test_nan_d2ll_rz() {
; CHECK-LABEL: define i64 @test_nan_d2ll_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rz(double 0xFFF8000000000000)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                        f2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_nan_f2ull_rm() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rm(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ull_rn() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rn(float 0x7FFFFF0000000000)
  ret i64 %res
}


define i64 @test_nan_f2ull_rp() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rp(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ull_rz() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rz(float 0x7FFFFF0000000000)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ull_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_nan_f2ull_rm_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rm_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rm.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ull_rn_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rn_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rn.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ull_rp_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rp_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rp.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}

define i64 @test_nan_f2ull_rz_ftz() {
; CHECK-LABEL: define i64 @test_nan_f2ull_rz_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rz.ftz(float 0x7FFFFF0000000000)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_nan_d2ull_rm() {
; CHECK-LABEL: define i64 @test_nan_d2ull_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rm(double 0xFFF8000000000000)
  ret i64 %res
}

define i64 @test_nan_d2ull_rn() {
; CHECK-LABEL: define i64 @test_nan_d2ull_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rn(double 0xFFF8000000000000)
  ret i64 %res
}


define i64 @test_nan_d2ull_rp() {
; CHECK-LABEL: define i64 @test_nan_d2ull_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rp(double 0xFFF8000000000000)
  ret i64 %res
}

define i64 @test_nan_d2ull_rz() {
; CHECK-LABEL: define i64 @test_nan_d2ull_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rz(double 0xFFF8000000000000)
  ret i64 %res
}

;###############################################################
;#            Tests with Positive Subnormal                    #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_subnormal_f2ll_rm() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rm(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ll_rn() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rn(float 0x380FFFFFC0000000)
  ret i64 %res
}


define i64 @test_pos_subnormal_f2ll_rp() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rp() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ll.rp(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ll_rz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rz(float 0x380FFFFFC0000000)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ll_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_pos_subnormal_f2ll_rm_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rm_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rm.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ll_rn_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rn_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rn.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ll_rp_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rp_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rp.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ll_rz_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ll_rz_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rz.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_subnormal_d2ll_rm() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ll_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rm(double 0x000fffffffffffff)
  ret i64 %res
}

define i64 @test_pos_subnormal_d2ll_rn() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ll_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rn(double 0x000fffffffffffff)
  ret i64 %res
}


define i64 @test_pos_subnormal_d2ll_rp() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ll_rp() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.d2ll.rp(double 0x000fffffffffffff)
  ret i64 %res
}

define i64 @test_pos_subnormal_d2ll_rz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ll_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rz(double 0x000fffffffffffff)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                        f2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_subnormal_f2ull_rm() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rm(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ull_rn() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rn(float 0x380FFFFFC0000000)
  ret i64 %res
}


define i64 @test_pos_subnormal_f2ull_rp() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rp() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.f2ull.rp(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ull_rz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rz(float 0x380FFFFFC0000000)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ull_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_pos_subnormal_f2ull_rm_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rm_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rm.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ull_rn_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rn_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rn.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ull_rp_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rp_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rp.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}

define i64 @test_pos_subnormal_f2ull_rz_ftz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_f2ull_rz_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rz.ftz(float 0x380FFFFFC0000000)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_pos_subnormal_d2ull_rm() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ull_rm() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rm(double 0x000fffffffffffff)
  ret i64 %res
}

define i64 @test_pos_subnormal_d2ull_rn() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ull_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rn(double 0x000fffffffffffff)
  ret i64 %res
}


define i64 @test_pos_subnormal_d2ull_rp() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ull_rp() {
; CHECK-NEXT:    ret i64 1
;
  %res = call i64 @llvm.nvvm.d2ull.rp(double 0x000fffffffffffff)
  ret i64 %res
}

define i64 @test_pos_subnormal_d2ull_rz() {
; CHECK-LABEL: define i64 @test_pos_subnormal_d2ull_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rz(double 0x000fffffffffffff)
  ret i64 %res
}

;###############################################################
;#            Tests with Negative Subnormal                    #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_subnormal_f2ll_rm() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rm() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.f2ll.rm(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ll_rn() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rn(float 0xB80FFFFFC0000000)
  ret i64 %res
}


define i64 @test_neg_subnormal_f2ll_rp() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rp(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ll_rz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ll_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_neg_subnormal_f2ll_rm_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rm_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rm.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ll_rn_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rn_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rn.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ll_rp_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rp_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rp.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ll_rz_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ll_rz_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ll.rz.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ll                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_subnormal_d2ll_rm() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ll_rm() {
; CHECK-NEXT:    ret i64 -1
;
  %res = call i64 @llvm.nvvm.d2ll.rm(double 0x800fffffffffffff)
  ret i64 %res
}

define i64 @test_neg_subnormal_d2ll_rn() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ll_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rn(double 0x800fffffffffffff)
  ret i64 %res
}


define i64 @test_neg_subnormal_d2ll_rp() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ll_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rp(double 0x800fffffffffffff)
  ret i64 %res
}

define i64 @test_neg_subnormal_d2ll_rz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ll_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ll.rz(double 0x800fffffffffffff)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                        f2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_subnormal_f2ull_rm() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.f2ull.rm(float 0xB80FFFFFC0000000)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.f2ull.rm(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ull_rn() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rn(float 0xB80FFFFFC0000000)
  ret i64 %res
}


define i64 @test_neg_subnormal_f2ull_rp() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rp(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ull_rz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

;+-------------------------------------------------------------+
;|                      f2ull_ftz                                |
;+-------------------------------------------------------------+
define i64 @test_neg_subnormal_f2ull_rm_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rm_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rm.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ull_rn_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rn_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rn.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ull_rp_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rp_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rp.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}

define i64 @test_neg_subnormal_f2ull_rz_ftz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_f2ull_rz_ftz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.f2ull.rz.ftz(float 0xB80FFFFFC0000000)
  ret i64 %res
}
;+-------------------------------------------------------------+
;|                        d2ull                                  |
;+-------------------------------------------------------------+
define i64 @test_neg_subnormal_d2ull_rm() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ull_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.nvvm.d2ull.rm(double 0x800FFFFFFFFFFFFF)
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.nvvm.d2ull.rm(double 0x800fffffffffffff)
  ret i64 %res
}

define i64 @test_neg_subnormal_d2ull_rn() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ull_rn() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rn(double 0x800fffffffffffff)
  ret i64 %res
}


define i64 @test_neg_subnormal_d2ull_rp() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ull_rp() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rp(double 0x800fffffffffffff)
  ret i64 %res
}

define i64 @test_neg_subnormal_d2ull_rz() {
; CHECK-LABEL: define i64 @test_neg_subnormal_d2ull_rz() {
; CHECK-NEXT:    ret i64 0
;
  %res = call i64 @llvm.nvvm.d2ull.rz(double 0x800fffffffffffff)
  ret i64 %res
}

declare i64 @llvm.nvvm.f2ll.rm(float)
declare i64 @llvm.nvvm.f2ll.rn(float)
declare i64 @llvm.nvvm.f2ll.rp(float)
declare i64 @llvm.nvvm.f2ll.rz(float)

declare i64 @llvm.nvvm.f2ll.rm.ftz(float)
declare i64 @llvm.nvvm.f2ll.rn.ftz(float)
declare i64 @llvm.nvvm.f2ll.rp.ftz(float)
declare i64 @llvm.nvvm.f2ll.rz.ftz(float)

declare i64 @llvm.nvvm.d2ll.rm(double)
declare i64 @llvm.nvvm.d2ll.rn(double)
declare i64 @llvm.nvvm.d2ll.rp(double)
declare i64 @llvm.nvvm.d2ll.rz(double)


declare i64 @llvm.nvvm.f2ull.rm(float)
declare i64 @llvm.nvvm.f2ull.rn(float)
declare i64 @llvm.nvvm.f2ull.rp(float)
declare i64 @llvm.nvvm.f2ull.rz(float)

declare i64 @llvm.nvvm.f2ull.rm.ftz(float)
declare i64 @llvm.nvvm.f2ull.rn.ftz(float)
declare i64 @llvm.nvvm.f2ull.rp.ftz(float)
declare i64 @llvm.nvvm.f2ull.rz.ftz(float)

declare i64 @llvm.nvvm.d2ull.rm(double)
declare i64 @llvm.nvvm.d2ull.rn(double)
declare i64 @llvm.nvvm.d2ull.rp(double)
declare i64 @llvm.nvvm.d2ull.rz(double)
