; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test high-part vector multiplication.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Test a v16i8 unsigned high-part multiplication.
define <16 x i8> @f1(<16 x i8> %val1, <16 x i8> %val2) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlhb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %zext1 = zext <16 x i8> %val1 to <16 x i16>
  %zext2 = zext <16 x i8> %val2 to <16 x i16>
  %mulx = mul <16 x i16> %zext1, %zext2
  %highx = lshr <16 x i16> %mulx, splat(i16 8)
  %high = trunc <16 x i16> %highx to <16 x i8>
  ret <16 x i8> %high
}

; Test a v16i8 signed high-part multiplication.
define <16 x i8> @f2(<16 x i8> %val1, <16 x i8> %val2) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmhb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sext1 = sext <16 x i8> %val1 to <16 x i16>
  %sext2 = sext <16 x i8> %val2 to <16 x i16>
  %mulx = mul <16 x i16> %sext1, %sext2
  %highx = lshr <16 x i16> %mulx, splat(i16 8)
  %high = trunc <16 x i16> %highx to <16 x i8>
  ret <16 x i8> %high
}

; Test a v8i16 unsigned high-part multiplication.
define <8 x i16> @f3(<8 x i16> %val1, <8 x i16> %val2) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlhh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %zext1 = zext <8 x i16> %val1 to <8 x i32>
  %zext2 = zext <8 x i16> %val2 to <8 x i32>
  %mulx = mul <8 x i32> %zext1, %zext2
  %highx = lshr <8 x i32> %mulx, splat(i32 16)
  %high = trunc <8 x i32> %highx to <8 x i16>
  ret <8 x i16> %high
}

; Test a v8i16 signed high-part multiplication.
define <8 x i16> @f4(<8 x i16> %val1, <8 x i16> %val2) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmhh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sext1 = sext <8 x i16> %val1 to <8 x i32>
  %sext2 = sext <8 x i16> %val2 to <8 x i32>
  %mulx = mul <8 x i32> %sext1, %sext2
  %highx = lshr <8 x i32> %mulx, splat(i32 16)
  %high = trunc <8 x i32> %highx to <8 x i16>
  ret <8 x i16> %high
}

; Test a v4i32 unsigned high-part multiplication.
define <4 x i32> @f5(<4 x i32> %val1, <4 x i32> %val2) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlhf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %zext1 = zext <4 x i32> %val1 to <4 x i64>
  %zext2 = zext <4 x i32> %val2 to <4 x i64>
  %mulx = mul <4 x i64> %zext1, %zext2
  %highx = lshr <4 x i64> %mulx, splat(i64 32)
  %high = trunc <4 x i64> %highx to <4 x i32>
  ret <4 x i32> %high
}

; Test a v4i32 signed high-part multiplication.
define <4 x i32> @f6(<4 x i32> %val1, <4 x i32> %val2) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmhf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sext1 = sext <4 x i32> %val1 to <4 x i64>
  %sext2 = sext <4 x i32> %val2 to <4 x i64>
  %mulx = mul <4 x i64> %sext1, %sext2
  %highx = lshr <4 x i64> %mulx, splat(i64 32)
  %high = trunc <4 x i64> %highx to <4 x i32>
  ret <4 x i32> %high
}
