; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64-linux-gnu -mattr=+neon < %s | FileCheck %s

; Verify the cost of integer division by constant.

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define <16 x i8> @sdiv8xi16(<16 x i8> %x) {
; CHECK-LABEL: 'sdiv8xi16'
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %div = sdiv <16 x i8> %x, splat (i8 9)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %div
;
  %div = sdiv <16 x i8> %x, <i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9>
  ret <16 x i8> %div
}

define <8 x i16> @sdiv16xi8(<8 x i16> %x) {
; CHECK-LABEL: 'sdiv16xi8'
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %div = sdiv <8 x i16> %x, splat (i16 9)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %div
;
  %div = sdiv <8 x i16> %x, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %div
}

define <4 x i32> @sdiv32xi4(<4 x i32> %x) {
; CHECK-LABEL: 'sdiv32xi4'
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %div = sdiv <4 x i32> %x, splat (i32 9)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %div
;
  %div = sdiv <4 x i32> %x, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %div
}

define <16 x i8> @udiv8xi16(<16 x i8> %x) {
; CHECK-LABEL: 'udiv8xi16'
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %div = udiv <16 x i8> %x, splat (i8 9)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %div
;
  %div = udiv <16 x i8> %x, <i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9>
  ret <16 x i8> %div
}

define <8 x i16> @udiv16xi8(<8 x i16> %x) {
; CHECK-LABEL: 'udiv16xi8'
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %div = udiv <8 x i16> %x, splat (i16 9)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %div
;
  %div = udiv <8 x i16> %x, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %div
}

define <4 x i32> @udiv32xi4(<4 x i32> %x) {
; CHECK-LABEL: 'udiv32xi4'
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:4 SizeLat:4 for: %div = udiv <4 x i32> %x, splat (i32 9)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %div
;
  %div = udiv <4 x i32> %x, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %div
}
