; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux -mcpu=penryn |  FileCheck %s

define void @t0(ptr %dst, <2 x i64> %src1, <2 x i64> %src2) nounwind readonly {
; CHECK-LABEL: t0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    pcmpeqq %xmm2, %xmm0
; CHECK-NEXT:    pcmpeqq %xmm2, %xmm1
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    movdqa %xmm0, (%rdi)
; CHECK-NEXT:    retq
  %cmp1 = icmp ne <2 x i64> %src1, zeroinitializer
  %cmp2 = icmp ne <2 x i64> %src2, zeroinitializer
  %t1 = and <2 x i1> %cmp1, %cmp2
  %t2 = sext <2 x i1> %t1 to <2 x i64>
  store <2 x i64> %t2, ptr %dst
  ret void
}

define void @t2(ptr %dst, <3 x i64> %src1, <3 x i64> %src2) nounwind readonly {
; CHECK-LABEL: t2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %r9, %xmm0
; CHECK-NEXT:    movq %r8, %xmm1
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; CHECK-NEXT:    movq %rdx, %xmm0
; CHECK-NEXT:    movq %rsi, %xmm2
; CHECK-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; CHECK-NEXT:    movq %rcx, %xmm0
; CHECK-NEXT:    movq {{.*#+}} xmm3 = mem[0],zero
; CHECK-NEXT:    pxor %xmm4, %xmm4
; CHECK-NEXT:    pcmpeqq %xmm4, %xmm2
; CHECK-NEXT:    pcmpeqq %xmm4, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm5, %xmm5
; CHECK-NEXT:    pcmpeqq %xmm4, %xmm1
; CHECK-NEXT:    por %xmm2, %xmm1
; CHECK-NEXT:    pcmpeqq %xmm4, %xmm3
; CHECK-NEXT:    por %xmm0, %xmm3
; CHECK-NEXT:    packssdw %xmm3, %xmm1
; CHECK-NEXT:    pxor %xmm5, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,2,2,2]
; CHECK-NEXT:    pslld $31, %xmm0
; CHECK-NEXT:    psrad $31, %xmm0
; CHECK-NEXT:    pmovsxdq %xmm1, %xmm1
; CHECK-NEXT:    movdqa %xmm1, (%rdi)
; CHECK-NEXT:    movq %xmm0, 16(%rdi)
; CHECK-NEXT:    retq
  %cmp1 = icmp ne <3 x i64> %src1, zeroinitializer
  %cmp2 = icmp ne <3 x i64> %src2, zeroinitializer
  %t1 = and <3 x i1> %cmp1, %cmp2
  %t2 = sext <3 x i1> %t1 to <3 x i64>
  store <3 x i64> %t2, ptr %dst
  ret void
}
