; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X64

define float @fneg_strict_fadd_to_strict_fsub(float %x, float %y) nounwind strictfp {
; X86-LABEL: fneg_strict_fadd_to_strict_fsub:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    subss {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    wait
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
;
; X64-LABEL: fneg_strict_fadd_to_strict_fsub:
; X64:       # %bb.0:
; X64-NEXT:    subss %xmm1, %xmm0
; X64-NEXT:    retq
  %neg = fneg float %y
  %add = call float @llvm.experimental.constrained.fadd.f32(float %x, float %neg, metadata!"round.dynamic", metadata!"fpexcept.strict")
  ret float %add
}

define float @fneg_strict_fadd_to_strict_fsub_2(float %x, float %y) nounwind strictfp {
; X86-LABEL: fneg_strict_fadd_to_strict_fsub_2:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    subss {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    wait
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
;
; X64-LABEL: fneg_strict_fadd_to_strict_fsub_2:
; X64:       # %bb.0:
; X64-NEXT:    subss %xmm1, %xmm0
; X64-NEXT:    retq
  %neg = fneg float %y
  %add = call float @llvm.experimental.constrained.fadd.f32(float %neg, float %x, metadata!"round.dynamic", metadata!"fpexcept.strict")
  ret float %add
}

define double @fneg_strict_fadd_to_strict_fsub_d(double %x, double %y) nounwind strictfp {
; X86-LABEL: fneg_strict_fadd_to_strict_fsub_d:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    subsd 16(%ebp), %xmm0
; X86-NEXT:    movsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    wait
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: fneg_strict_fadd_to_strict_fsub_d:
; X64:       # %bb.0:
; X64-NEXT:    subsd %xmm1, %xmm0
; X64-NEXT:    retq
  %neg = fneg double %y
  %add = call double @llvm.experimental.constrained.fadd.f64(double %x, double %neg, metadata!"round.dynamic", metadata!"fpexcept.strict")
  ret double %add
}

define double @fneg_strict_fadd_to_strict_fsub_2d(double %x, double %y) nounwind strictfp {
; X86-LABEL: fneg_strict_fadd_to_strict_fsub_2d:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    subsd 16(%ebp), %xmm0
; X86-NEXT:    movsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    wait
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: fneg_strict_fadd_to_strict_fsub_2d:
; X64:       # %bb.0:
; X64-NEXT:    subsd %xmm1, %xmm0
; X64-NEXT:    retq
  %neg = fneg double %y
  %add = call double @llvm.experimental.constrained.fadd.f64(double %neg, double %x, metadata!"round.dynamic", metadata!"fpexcept.strict")
  ret double %add
}


declare float @llvm.experimental.constrained.fadd.f32(float, float, metadata, metadata)
declare double @llvm.experimental.constrained.fadd.f64(double, double, metadata, metadata)
