; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=ve | FileCheck %s

declare void @foo() noreturn

;;; Check a case where a separate branch is needed and where the original
;;; order should be reversed.  Copied from SystemZ/branch-08.ll

define i32 @f1(i32 %a, ptr %bptr) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    st %s9, (, %s11)
; CHECK-NEXT:    st %s10, 8(, %s11)
; CHECK-NEXT:    or %s9, 0, %s11
; CHECK-NEXT:    lea %s11, -240(, %s11)
; CHECK-NEXT:    brge.l %s11, %s8, .LBB0_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    ld %s61, 24(, %s14)
; CHECK-NEXT:    or %s62, 0, %s0
; CHECK-NEXT:    lea %s63, 315
; CHECK-NEXT:    shm.l %s63, (%s61)
; CHECK-NEXT:    shm.l %s8, 8(%s61)
; CHECK-NEXT:    shm.l %s11, 16(%s61)
; CHECK-NEXT:    monc
; CHECK-NEXT:    or %s0, 0, %s62
; CHECK-NEXT:  .LBB0_4: # %entry
; CHECK-NEXT:    ldl.sx %s1, (, %s1)
; CHECK-NEXT:    cmpu.w %s0, %s1, %s0
; CHECK-NEXT:    brlt.w 0, %s0, .LBB0_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    or %s0, 1, (0)1
; CHECK-NEXT:    or %s11, 0, %s9
; CHECK-NEXT:    ld %s10, 8(, %s11)
; CHECK-NEXT:    ld %s9, (, %s11)
; CHECK-NEXT:    b.l.t (, %s10)
; CHECK-NEXT:  .LBB0_2: # %callit
; CHECK-NEXT:    lea %s0, foo@lo
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea.sl %s12, foo@hi(, %s0)
; CHECK-NEXT:    bsic %s10, (, %s12)
entry:
  %b = load i32, ptr %bptr
  %cmp = icmp ult i32 %a, %b
  br i1 %cmp, label %callit, label %return

callit:
  call void @foo()
  unreachable

return:
  ret i32 1
}

;;; Same again with a fused compare and branch.

define i32 @f2(i32 %a) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    st %s9, (, %s11)
; CHECK-NEXT:    st %s10, 8(, %s11)
; CHECK-NEXT:    or %s9, 0, %s11
; CHECK-NEXT:    lea %s11, -240(, %s11)
; CHECK-NEXT:    brge.l %s11, %s8, .LBB1_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    ld %s61, 24(, %s14)
; CHECK-NEXT:    or %s62, 0, %s0
; CHECK-NEXT:    lea %s63, 315
; CHECK-NEXT:    shm.l %s63, (%s61)
; CHECK-NEXT:    shm.l %s8, 8(%s61)
; CHECK-NEXT:    shm.l %s11, 16(%s61)
; CHECK-NEXT:    monc
; CHECK-NEXT:    or %s0, 0, %s62
; CHECK-NEXT:  .LBB1_4: # %entry
; CHECK-NEXT:    breq.w 0, %s0, .LBB1_2
; CHECK-NEXT:  # %bb.1: # %return
; CHECK-NEXT:    or %s0, 1, (0)1
; CHECK-NEXT:    or %s11, 0, %s9
; CHECK-NEXT:    ld %s10, 8(, %s11)
; CHECK-NEXT:    ld %s9, (, %s11)
; CHECK-NEXT:    b.l.t (, %s10)
; CHECK-NEXT:  .LBB1_2: # %callit
; CHECK-NEXT:    lea %s0, foo@lo
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea.sl %s12, foo@hi(, %s0)
; CHECK-NEXT:    bsic %s10, (, %s12)
entry:
  %cmp = icmp eq i32 %a, 0
  br i1 %cmp, label %callit, label %return

callit:
  call void @foo()
  unreachable

return:
  ret i32 1
}
