; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test half atomic stores.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -verify-machineinstrs | FileCheck %s -check-prefix=CHECK
; RUN: llc < %s -mtriple=s390x-linux-gnu -verify-machineinstrs -mcpu=z16 | FileCheck %s -check-prefix=VECTOR

define void @f1(ptr %src, half %val) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $f0h killed $f0h def $f0d
; CHECK-NEXT:    lgdr %r0, %f0
; CHECK-NEXT:    srlg %r0, %r0, 48
; CHECK-NEXT:    sth %r0, 0(%r2)
; CHECK-NEXT:    bcr 15, %r0
; CHECK-NEXT:    br %r14
;
; VECTOR-LABEL: f1:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    vsteh %v0, 0(%r2), 0
; VECTOR-NEXT:    bcr 14, %r0
; VECTOR-NEXT:    br %r14
  store atomic half %val, ptr %src seq_cst, align 2
  ret void
}
