; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=hexagon -hexagon-bit=0 < %s | FileCheck %s
; Optimized bitwise operations.

define i32 @my_clrbit(i32 %x) nounwind {
; CHECK-LABEL: my_clrbit:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = clrbit(r0,#31)
; CHECK-NEXT:     r1 = r0
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     memw(r29+#4) = r1
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i32, align 4
  store i32 %x, ptr %x.addr, align 4
  %0 = load i32, ptr %x.addr, align 4
  %and = and i32 %0, 2147483647
  ret i32 %and
}

define i64 @my_clrbit2(i64 %x) nounwind {
; CHECK-LABEL: my_clrbit2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = clrbit(r0,#31)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %and = and i64 %0, -2147483649
  ret i64 %and
}

define i64 @my_clrbit3(i64 %x) nounwind {
; CHECK-LABEL: my_clrbit3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = clrbit(r1,#31)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %and = and i64 %0, 9223372036854775807
  ret i64 %and
}

define i32 @my_clrbit4(i32 %x) nounwind {
; CHECK-LABEL: my_clrbit4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = clrbit(r0,#13)
; CHECK-NEXT:     r1 = r0
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     memw(r29+#4) = r1
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i32, align 4
  store i32 %x, ptr %x.addr, align 4
  %0 = load i32, ptr %x.addr, align 4
  %and = and i32 %0, -8193
  ret i32 %and
}

define i64 @my_clrbit5(i64 %x) nounwind {
; CHECK-LABEL: my_clrbit5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = clrbit(r0,#13)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %and = and i64 %0, -8193
  ret i64 %and
}

define i64 @my_clrbit6(i64 %x) nounwind {
; CHECK-LABEL: my_clrbit6:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = clrbit(r1,#27)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %and = and i64 %0, -576460752303423489
  ret i64 %and
}

define zeroext i16 @my_setbit(i16 zeroext %crc) nounwind {
; CHECK-LABEL: my_setbit:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = setbit(r0,#15)
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     memh(r29+#6) = r0
; CHECK-NEXT:    }
entry:
  %crc.addr = alloca i16, align 2
  store i16 %crc, ptr %crc.addr, align 2
  %0 = load i16, ptr %crc.addr, align 2
  %conv = zext i16 %0 to i32
  %or = or i32 %conv, 32768
  %conv1 = trunc i32 %or to i16
  store i16 %conv1, ptr %crc.addr, align 2
  %1 = load i16, ptr %crc.addr, align 2
  ret i16 %1
}

define i32 @my_setbit2(i32 %x) nounwind {
; CHECK-LABEL: my_setbit2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = setbit(r0,#15)
; CHECK-NEXT:     r1 = r0
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     memw(r29+#4) = r1
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i32, align 4
  store i32 %x, ptr %x.addr, align 4
  %0 = load i32, ptr %x.addr, align 4
  %or = or i32 %0, 32768
  ret i32 %or
}

define i64 @my_setbit3(i64 %x) nounwind {
; CHECK-LABEL: my_setbit3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = setbit(r0,#15)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %or = or i64 %0, 32768
  ret i64 %or
}

define i32 @my_setbit4(i32 %x) nounwind {
; CHECK-LABEL: my_setbit4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = setbit(r0,#31)
; CHECK-NEXT:     r1 = r0
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     memw(r29+#4) = r1
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i32, align 4
  store i32 %x, ptr %x.addr, align 4
  %0 = load i32, ptr %x.addr, align 4
  %or = or i32 %0, -2147483648
  ret i32 %or
}

define i64 @my_setbit5(i64 %x) nounwind {
; CHECK-LABEL: my_setbit5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = setbit(r1,#13)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %or = or i64 %0, 35184372088832
  ret i64 %or
}

define zeroext i16 @my_togglebit(i16 zeroext %crc) nounwind {
; CHECK-LABEL: my_togglebit:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = togglebit(r0,#15)
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     memh(r29+#6) = r0
; CHECK-NEXT:    }
entry:
  %crc.addr = alloca i16, align 2
  store i16 %crc, ptr %crc.addr, align 2
  %0 = load i16, ptr %crc.addr, align 2
  %conv = zext i16 %0 to i32
  %xor = xor i32 %conv, 32768
  %conv1 = trunc i32 %xor to i16
  store i16 %conv1, ptr %crc.addr, align 2
  %1 = load i16, ptr %crc.addr, align 2
  ret i16 %1
}

define i32 @my_togglebit2(i32 %x) nounwind {
; CHECK-LABEL: my_togglebit2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = togglebit(r0,#15)
; CHECK-NEXT:     r1 = r0
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     memw(r29+#4) = r1
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i32, align 4
  store i32 %x, ptr %x.addr, align 4
  %0 = load i32, ptr %x.addr, align 4
  %xor = xor i32 %0, 32768
  ret i32 %xor
}

define i64 @my_togglebit3(i64 %x) nounwind {
; CHECK-LABEL: my_togglebit3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = togglebit(r0,#15)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %xor = xor i64 %0, 32768
  ret i64 %xor
}

define i64 @my_togglebit4(i64 %x) nounwind {
; CHECK-LABEL: my_togglebit4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    {
; CHECK-NEXT:     r29 = add(r29,#-8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = togglebit(r1,#20)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r29 = add(r29,#8)
; CHECK-NEXT:     memd(r29+#0) = r1:0
; CHECK-NEXT:    }
entry:
  %x.addr = alloca i64, align 8
  store i64 %x, ptr %x.addr, align 8
  %0 = load i64, ptr %x.addr, align 8
  %xor = xor i64 %0, 4503599627370496
  ret i64 %xor
}
