; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX10,GFX10-GISEL %s

; RUN: llc -global-isel=0 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -mattr=+real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -mattr=-real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -mattr=+real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11,GFX1-GISEL,GFX1-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -mattr=-real-true16 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11,GFX1-GISEL,GFX1-GISEL-FAKE16 %s


; FIXME: promotion not handled without f16 insts

define half @v_constained_fmul_f16_fpexcept_strict(half %x, half %y) #0 {
; GCN-LABEL: v_constained_fmul_f16_fpexcept_strict:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f16_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_constained_fmul_f16_fpexcept_strict:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_constained_fmul_f16_fpexcept_strict:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_constained_fmul_f16_fpexcept_strict:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-TRUE16-LABEL: v_constained_fmul_f16_fpexcept_strict:
; GFX1-GISEL-TRUE16:       ; %bb.0:
; GFX1-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX1-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-FAKE16-LABEL: v_constained_fmul_f16_fpexcept_strict:
; GFX1-GISEL-FAKE16:       ; %bb.0:
; GFX1-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX1-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %val = call half @llvm.experimental.constrained.fmul.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict")
  ret half %val
}

define half @v_constained_fmul_f16_fpexcept_ignore(half %x, half %y) #0 {
; GCN-LABEL: v_constained_fmul_f16_fpexcept_ignore:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f16_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_constained_fmul_f16_fpexcept_ignore:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_constained_fmul_f16_fpexcept_ignore:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_constained_fmul_f16_fpexcept_ignore:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-TRUE16-LABEL: v_constained_fmul_f16_fpexcept_ignore:
; GFX1-GISEL-TRUE16:       ; %bb.0:
; GFX1-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX1-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-FAKE16-LABEL: v_constained_fmul_f16_fpexcept_ignore:
; GFX1-GISEL-FAKE16:       ; %bb.0:
; GFX1-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX1-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %val = call half @llvm.experimental.constrained.fmul.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret half %val
}

define half @v_constained_fmul_f16_fpexcept_maytrap(half %x, half %y) #0 {
; GCN-LABEL: v_constained_fmul_f16_fpexcept_maytrap:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f16_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_constained_fmul_f16_fpexcept_maytrap:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_constained_fmul_f16_fpexcept_maytrap:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_constained_fmul_f16_fpexcept_maytrap:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-TRUE16-LABEL: v_constained_fmul_f16_fpexcept_maytrap:
; GFX1-GISEL-TRUE16:       ; %bb.0:
; GFX1-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX1-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-FAKE16-LABEL: v_constained_fmul_f16_fpexcept_maytrap:
; GFX1-GISEL-FAKE16:       ; %bb.0:
; GFX1-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX1-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %val = call half @llvm.experimental.constrained.fmul.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.maytrap")
  ret half %val
}

define <2 x half> @v_constained_fmul_v2f16_fpexcept_strict(<2 x half> %x, <2 x half> %y) #0 {
; GFX9-LABEL: v_constained_fmul_v2f16_fpexcept_strict:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: v_constained_fmul_v2f16_fpexcept_strict:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mul_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: v_constained_fmul_v2f16_fpexcept_strict:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_constained_fmul_v2f16_fpexcept_strict:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %val = call <2 x half> @llvm.experimental.constrained.fmul.v2f16(<2 x half> %x, <2 x half> %y, metadata !"round.tonearest", metadata !"fpexcept.strict")
  ret <2 x half> %val
}

define <2 x half> @v_constained_fmul_v2f16_fpexcept_ignore(<2 x half> %x, <2 x half> %y) #0 {
; GFX9-LABEL: v_constained_fmul_v2f16_fpexcept_ignore:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: v_constained_fmul_v2f16_fpexcept_ignore:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mul_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: v_constained_fmul_v2f16_fpexcept_ignore:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_constained_fmul_v2f16_fpexcept_ignore:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %val = call <2 x half> @llvm.experimental.constrained.fmul.v2f16(<2 x half> %x, <2 x half> %y, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x half> %val
}

define <2 x half> @v_constained_fmul_v2f16_fpexcept_maytrap(<2 x half> %x, <2 x half> %y) #0 {
; GFX9-LABEL: v_constained_fmul_v2f16_fpexcept_maytrap:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: v_constained_fmul_v2f16_fpexcept_maytrap:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mul_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: v_constained_fmul_v2f16_fpexcept_maytrap:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_constained_fmul_v2f16_fpexcept_maytrap:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %val = call <2 x half> @llvm.experimental.constrained.fmul.v2f16(<2 x half> %x, <2 x half> %y, metadata !"round.tonearest", metadata !"fpexcept.maytrap")
  ret <2 x half> %val
}

define <3 x half> @v_constained_fmul_v3f16_fpexcept_strict(<3 x half> %x, <3 x half> %y) #0 {
; GFX9-SDAG-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mul_f16_sdwa v4, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v4, v0, v2
; GFX8-GISEL-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v1.l, v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-LABEL: v_constained_fmul_v3f16_fpexcept_strict:
; GFX1-GISEL:       ; %bb.0:
; GFX1-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX1-GISEL-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX1-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %val = call <3 x half> @llvm.experimental.constrained.fmul.v3f16(<3 x half> %x, <3 x half> %y, metadata !"round.tonearest", metadata !"fpexcept.strict")
  ret <3 x half> %val
}

; FIXME: Scalarized
define <4 x half> @v_constained_fmul_v4f16_fpexcept_strict(<4 x half> %x, <4 x half> %y) #0 {
; GFX9-SDAG-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_mul_f16_sdwa v4, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-SDAG-NEXT:    v_mul_f16_sdwa v5, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-SDAG-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-SDAG-NEXT:    v_perm_b32 v0, v5, v0, s4
; GFX9-SDAG-NEXT:    v_perm_b32 v1, v4, v1, s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mul_f16_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_mul_f16_sdwa v5, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-SDAG-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v4, v0, v2
; GFX8-GISEL-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v2, v1, v3
; GFX8-GISEL-NEXT:    v_mul_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-GISEL-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mul_f16_sdwa v4, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-SDAG-NEXT:    v_mul_f16_sdwa v5, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-SDAG-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX10-SDAG-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v1.h, v1.h, v3.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.h, v0.h, v2.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v1.l, v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v2, v6, v5
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v3, v7, v4
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v1, v3, v1, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1-GISEL-LABEL: v_constained_fmul_v4f16_fpexcept_strict:
; GFX1-GISEL:       ; %bb.0:
; GFX1-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1-GISEL-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX1-GISEL-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX1-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %val = call <4 x half> @llvm.experimental.constrained.fmul.v4f16(<4 x half> %x, <4 x half> %y, metadata !"round.tonearest", metadata !"fpexcept.strict")
  ret <4 x half> %val
}

define amdgpu_ps half @s_constained_fmul_f16_fpexcept_strict(half inreg %x, half inreg %y) #0 {
; GCN-LABEL: s_constained_fmul_f16_fpexcept_strict:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v0, s3
; GCN-NEXT:    v_mul_f16_e32 v0, s2, v0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_constained_fmul_f16_fpexcept_strict:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mul_f16_e64 v0, s2, s3
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-SDAG-TRUE16-LABEL: s_constained_fmul_f16_fpexcept_strict:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e64 v0.l, s2, s3
; GFX11-SDAG-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-SDAG-FAKE16-LABEL: s_constained_fmul_f16_fpexcept_strict:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e64 v0, s2, s3
; GFX11-SDAG-FAKE16-NEXT:    ; return to shader part epilog
;
; GFX1-GISEL-TRUE16-LABEL: s_constained_fmul_f16_fpexcept_strict:
; GFX1-GISEL-TRUE16:       ; %bb.0:
; GFX1-GISEL-TRUE16-NEXT:    v_mul_f16_e64 v0.l, s2, s3
; GFX1-GISEL-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX1-GISEL-FAKE16-LABEL: s_constained_fmul_f16_fpexcept_strict:
; GFX1-GISEL-FAKE16:       ; %bb.0:
; GFX1-GISEL-FAKE16-NEXT:    v_mul_f16_e64 v0, s2, s3
; GFX1-GISEL-FAKE16-NEXT:    ; return to shader part epilog
  %val = call half @llvm.experimental.constrained.fmul.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict")
  ret half %val
}

define amdgpu_ps <2 x half> @s_constained_fmul_v2f16_fpexcept_strict(<2 x half> inreg %x, <2 x half> inreg %y) #0 {
; GFX9-LABEL: s_constained_fmul_v2f16_fpexcept_strict:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_pk_mul_f16 v0, s2, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX8-SDAG-LABEL: s_constained_fmul_v2f16_fpexcept_strict:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_lshr_b32 s0, s3, 16
; GFX8-SDAG-NEXT:    s_lshr_b32 s1, s2, 16
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-SDAG-NEXT:    v_mul_f16_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-SDAG-NEXT:    v_mul_f16_e32 v1, s2, v1
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-SDAG-NEXT:    ; return to shader part epilog
;
; GFX8-GISEL-LABEL: s_constained_fmul_v2f16_fpexcept_strict:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_lshr_b32 s0, s2, 16
; GFX8-GISEL-NEXT:    s_lshr_b32 s1, s3, 16
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-GISEL-NEXT:    v_mul_f16_e32 v0, s2, v0
; GFX8-GISEL-NEXT:    v_mul_f16_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_constained_fmul_v2f16_fpexcept_strict:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_pk_mul_f16 v0, s2, s3
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %val = call <2 x half> @llvm.experimental.constrained.fmul.v2f16(<2 x half> %x, <2 x half> %y, metadata !"round.tonearest", metadata !"fpexcept.strict")
  ret <2 x half> %val
}

declare half @llvm.experimental.constrained.fmul.f16(half, half, metadata, metadata) #1
declare <2 x half> @llvm.experimental.constrained.fmul.v2f16(<2 x half>, <2 x half>, metadata, metadata) #1
declare <3 x half> @llvm.experimental.constrained.fmul.v3f16(<3 x half>, <3 x half>, metadata, metadata) #1
declare <4 x half> @llvm.experimental.constrained.fmul.v4f16(<4 x half>, <4 x half>, metadata, metadata) #1

attributes #0 = { strictfp }
attributes #1 = { inaccessiblememonly nounwind willreturn }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11: {{.*}}
; GFX11-SDAG: {{.*}}
; GFX8: {{.*}}
