/* language-model-utils.c generated by valac 0.38.8, the Vala compiler
 * generated from language-model-utils.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <string.h>




gdouble kkc_language_model_utils_decode_cost (guint16 cost, gdouble min_cost);
glong kkc_language_model_utils_bsearch_ngram (void* memory, glong start_offset, glong end_offset, glong record_size, guint8* needle, int needle_length1);


gdouble kkc_language_model_utils_decode_cost (guint16 cost, gdouble min_cost) {
	gdouble result = 0.0;
	guint16 _tmp0_;
	gdouble _tmp1_;
	_tmp0_ = cost;
	_tmp1_ = min_cost;
	result = (_tmp0_ * _tmp1_) / 65535;
	return result;
}


glong kkc_language_model_utils_bsearch_ngram (void* memory, glong start_offset, glong end_offset, glong record_size, guint8* needle, int needle_length1) {
	glong result = 0L;
	glong offset = 0L;
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	_tmp0_ = start_offset;
	_tmp1_ = end_offset;
	_tmp2_ = start_offset;
	offset = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
	while (TRUE) {
		glong _tmp3_;
		glong _tmp4_;
		guint8* p = NULL;
		void* _tmp5_;
		glong _tmp6_;
		glong _tmp7_;
		gint r = 0;
		guint8* _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		guint8* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		glong _tmp16_;
		glong _tmp17_;
		glong _tmp18_;
		_tmp3_ = start_offset;
		_tmp4_ = end_offset;
		if (!(_tmp3_ <= _tmp4_)) {
			break;
		}
		_tmp5_ = memory;
		_tmp6_ = offset;
		_tmp7_ = record_size;
		p = ((guint8*) _tmp5_) + (_tmp6_ * _tmp7_);
		_tmp8_ = p;
		_tmp9_ = needle;
		_tmp9__length1 = needle_length1;
		_tmp10_ = needle;
		_tmp10__length1 = needle_length1;
		_tmp11_ = memcmp (_tmp8_, _tmp9_, (gsize) _tmp10__length1);
		r = _tmp11_;
		_tmp12_ = r;
		if (_tmp12_ == 0) {
			result = offset;
			return result;
		}
		_tmp13_ = r;
		if (_tmp13_ > 0) {
			glong _tmp14_;
			_tmp14_ = offset;
			end_offset = _tmp14_ - 1;
		} else {
			glong _tmp15_;
			_tmp15_ = offset;
			start_offset = _tmp15_ + 1;
		}
		_tmp16_ = start_offset;
		_tmp17_ = end_offset;
		_tmp18_ = start_offset;
		offset = _tmp16_ + ((_tmp17_ - _tmp18_) / 2);
	}
	result = (glong) -1;
	return result;
}



