// This file is generated by kconfig_compiler_kf5 from ktouch.kcfg.
// All changes you do to this file will be lost.
#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class Preferences : public KConfigSkeleton
{
  public:

    static Preferences *self();
    ~Preferences();

    /**
      Set The keyboard layout to use on non-X11 platforms
    */
    static
    void setKeyboardLayoutName( const QString & v )
    {
      if (!self()->isImmutable( QStringLiteral( "KeyboardLayoutName" ) ))
        self()->mKeyboardLayoutName = v;
    }

    /**
      Get The keyboard layout to use on non-X11 platforms
    */
    static
    QString keyboardLayoutName()
    {
      return self()->mKeyboardLayoutName;
    }

    /**
      Set Controls whether typing errors have to be corrected or not.
    */
    static
    void setEnforceTypingErrorCorrection( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "EnforceTypingErrorCorrection" ) ))
        self()->mEnforceTypingErrorCorrection = v;
    }

    /**
      Get Controls whether typing errors have to be corrected or not.
    */
    static
    bool enforceTypingErrorCorrection()
    {
      return self()->mEnforceTypingErrorCorrection;
    }

    /**
      Set Controls the visibility of the keyboard during training.
    */
    static
    void setShowKeyboard( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "ShowKeyboard" ) ))
        self()->mShowKeyboard = v;
    }

    /**
      Get Controls the visibility of the keyboard during training.
    */
    static
    bool showKeyboard()
    {
      return self()->mShowKeyboard;
    }

    /**
      Set Controls the visibility of realtime statistics during training.
    */
    static
    void setShowStatistics( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "ShowStatistics" ) ))
        self()->mShowStatistics = v;
    }

    /**
      Get Controls the visibility of realtime statistics during training.
    */
    static
    bool showStatistics()
    {
      return self()->mShowStatistics;
    }

    /**
      Set Return key at the end of a line will switch to next line.
    */
    static
    void setNextLineWithReturn( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "NextLineWithReturn" ) ))
        self()->mNextLineWithReturn = v;
    }

    /**
      Get Return key at the end of a line will switch to next line.
    */
    static
    bool nextLineWithReturn()
    {
      return self()->mNextLineWithReturn;
    }

    /**
      Set Space key at the end of a line will switch to next line.
    */
    static
    void setNextLineWithSpace( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "NextLineWithSpace" ) ))
        self()->mNextLineWithSpace = v;
    }

    /**
      Get Space key at the end of a line will switch to next line.
    */
    static
    bool nextLineWithSpace()
    {
      return self()->mNextLineWithSpace;
    }

    /**
      Set The minimum required amount of strokes per minute to unlock the next lesson.
    */
    static
    void setRequiredStrokesPerMinute( int v )
    {
      if (v < 0)
      {
        qDebug() << "setRequiredStrokesPerMinute: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 360)
      {
        qDebug() << "setRequiredStrokesPerMinute: value " << v << " is greater than the maximum value of 360";
        v = 360;
      }

      if (!self()->isImmutable( QStringLiteral( "RequiredStrokesPerMinute" ) ))
        self()->mRequiredStrokesPerMinute = v;
    }

    /**
      Get The minimum required amount of strokes per minute to unlock the next lesson.
    */
    static
    int requiredStrokesPerMinute()
    {
      return self()->mRequiredStrokesPerMinute;
    }

    /**
      Set The minimum required typing accuracy in percent to unlock the next lesson.
    */
    static
    void setRequiredAccuracy( double v )
    {
      if (v < 90)
      {
        qDebug() << "setRequiredAccuracy: value " << v << " is less than the minimum value of 90";
        v = 90;
      }

      if (v > 100)
      {
        qDebug() << "setRequiredAccuracy: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (!self()->isImmutable( QStringLiteral( "RequiredAccuracy" ) ))
        self()->mRequiredAccuracy = v;
    }

    /**
      Get The minimum required typing accuracy in percent to unlock the next lesson.
    */
    static
    double requiredAccuracy()
    {
      return self()->mRequiredAccuracy;
    }

    /**
      Set The keyboard tinting color to highlight keys for each finger.
    */
    static
    void setFingerColor( int i, const QColor & v )
    {
      if (!self()->isImmutable( QStringLiteral( "FingerColor%1" ).arg( i ) ))
        self()->mFingerColor[i] = v;
    }

    /**
      Get The keyboard tinting color to highlight keys for each finger.
    */
    static
    QColor fingerColor( int i )
    {
      return self()->mFingerColor[i];
    }

    /**
      Set The ID of the last used profile.
    */
    static
    void setLastUsedProfileId( int v )
    {
      if (!self()->isImmutable( QStringLiteral( "LastUsedProfileId" ) ))
        self()->mLastUsedProfileId = v;
    }

    /**
      Get The ID of the last used profile.
    */
    static
    int lastUsedProfileId()
    {
      return self()->mLastUsedProfileId;
    }

  protected:
    Preferences();
    friend class PreferencesHelper;


    // General
    QString mKeyboardLayoutName;

    // Training
    bool mEnforceTypingErrorCorrection;
    bool mShowKeyboard;
    bool mShowStatistics;
    bool mNextLineWithReturn;
    bool mNextLineWithSpace;
    int mRequiredStrokesPerMinute;
    double mRequiredAccuracy;

    // Colors
    QColor mFingerColor[8];

    // Session
    int mLastUsedProfileId;

  private:
};

#endif

