; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='loop(loop-idiom)' < %s -S | FileCheck %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i64 @valid_wcslen32(ptr %src) {
; CHECK-LABEL: define i64 @valid_wcslen32(
; CHECK-SAME: ptr [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    br i1 [[CMP]], label %[[RETURN:.*]], label %[[LOR_LHS_FALSE:.*]]
; CHECK:       [[LOR_LHS_FALSE]]:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[SRC]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP1]], label %[[RETURN]], label %[[WHILE_COND_PREHEADER:.*]]
; CHECK:       [[WHILE_COND_PREHEADER]]:
; CHECK-NEXT:    [[NEWGEP:%.*]] = getelementptr i8, ptr [[SRC]], i64 4
; CHECK-NEXT:    [[WCSLEN:%.*]] = call i64 @wcslen(ptr [[NEWGEP]])
; CHECK-NEXT:    [[TMP1:%.*]] = shl i64 [[WCSLEN]], 2
; CHECK-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 4
; CHECK-NEXT:    [[END:%.*]] = getelementptr i8, ptr [[SRC]], i64 [[TMP2]]
; CHECK-NEXT:    br label %[[WHILE_COND:.*]]
; CHECK:       [[WHILE_COND]]:
; CHECK-NEXT:    [[SRC_PN:%.*]] = phi ptr [ [[CURR_0:%.*]], %[[WHILE_COND]] ], [ [[SRC]], %[[WHILE_COND_PREHEADER]] ]
; CHECK-NEXT:    [[CURR_0]] = getelementptr inbounds i8, ptr [[SRC_PN]], i64 4
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[CURR_0]], align 4
; CHECK-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[TMP3]], 0
; CHECK-NEXT:    br i1 true, label %[[WHILE_END:.*]], label %[[WHILE_COND]]
; CHECK:       [[WHILE_END]]:
; CHECK-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[END]] to i64
; CHECK-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[SRC]] to i64
; CHECK-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
; CHECK-NEXT:    [[SUB_PTR_DIV:%.*]] = ashr exact i64 [[SUB_PTR_SUB]], 2
; CHECK-NEXT:    br label %[[RETURN]]
; CHECK:       [[RETURN]]:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi i64 [ [[SUB_PTR_DIV]], %[[WHILE_END]] ], [ 0, %[[LOR_LHS_FALSE]] ], [ 0, %[[ENTRY]] ]
; CHECK-NEXT:    ret i64 [[RETVAL_0]]
;
entry:
  %cmp = icmp eq ptr %src, null
  br i1 %cmp, label %return, label %lor.lhs.false

lor.lhs.false:                                    ; preds = %entry
  %0 = load i32, ptr %src, align 4
  %cmp1 = icmp eq i32 %0, 0
  br i1 %cmp1, label %return, label %while.cond.preheader

while.cond.preheader:                             ; preds = %lor.lhs.false
  br label %while.cond

while.cond:                                       ; preds = %while.cond.preheader, %while.cond
  %src.pn = phi ptr [ %curr.0, %while.cond ], [ %src, %while.cond.preheader ]
  %curr.0 = getelementptr inbounds i8, ptr %src.pn, i64 4
  %1 = load i32, ptr %curr.0, align 4
  %tobool.not = icmp eq i32 %1, 0
  br i1 %tobool.not, label %while.end, label %while.cond

while.end:                                        ; preds = %while.cond
  %curr.0.lcssa = phi ptr [ %curr.0, %while.cond ]
  %sub.ptr.lhs.cast = ptrtoint ptr %curr.0.lcssa to i64
  %sub.ptr.rhs.cast = ptrtoint ptr %src to i64
  %sub.ptr.sub = sub i64 %sub.ptr.lhs.cast, %sub.ptr.rhs.cast
  %sub.ptr.div = ashr exact i64 %sub.ptr.sub, 2
  br label %return

return:                                           ; preds = %entry, %lor.lhs.false, %while.end
  %retval.0 = phi i64 [ %sub.ptr.div, %while.end ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i64 %retval.0
}

define i64 @invalid_char_size(ptr %src) {
; CHECK-LABEL: define i64 @invalid_char_size(
; CHECK-SAME: ptr [[SRC:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[SRC]], null
; CHECK-NEXT:    br i1 [[CMP]], label %[[RETURN:.*]], label %[[LOR_LHS_FALSE:.*]]
; CHECK:       [[LOR_LHS_FALSE]]:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[SRC]], align 2
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i16 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP1]], label %[[RETURN]], label %[[WHILE_COND_PREHEADER:.*]]
; CHECK:       [[WHILE_COND_PREHEADER]]:
; CHECK-NEXT:    br label %[[WHILE_COND:.*]]
; CHECK:       [[WHILE_COND]]:
; CHECK-NEXT:    [[SRC_PN:%.*]] = phi ptr [ [[CURR_0:%.*]], %[[WHILE_COND]] ], [ [[SRC]], %[[WHILE_COND_PREHEADER]] ]
; CHECK-NEXT:    [[CURR_0]] = getelementptr inbounds i8, ptr [[SRC_PN]], i64 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr [[CURR_0]], align 2
; CHECK-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i16 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_NOT]], label %[[WHILE_END:.*]], label %[[WHILE_COND]]
; CHECK:       [[WHILE_END]]:
; CHECK-NEXT:    [[CURR_0_LCSSA:%.*]] = phi ptr [ [[CURR_0]], %[[WHILE_COND]] ]
; CHECK-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[CURR_0_LCSSA]] to i64
; CHECK-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[SRC]] to i64
; CHECK-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
; CHECK-NEXT:    [[SUB_PTR_DIV:%.*]] = ashr exact i64 [[SUB_PTR_SUB]], 1
; CHECK-NEXT:    br label %[[RETURN]]
; CHECK:       [[RETURN]]:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi i64 [ [[SUB_PTR_DIV]], %[[WHILE_END]] ], [ 0, %[[LOR_LHS_FALSE]] ], [ 0, %[[ENTRY]] ]
; CHECK-NEXT:    ret i64 [[RETVAL_0]]
;
entry:
  %cmp = icmp eq ptr %src, null
  br i1 %cmp, label %return, label %lor.lhs.false

lor.lhs.false:                                    ; preds = %entry
  %0 = load i16, ptr %src, align 2
  %cmp1 = icmp eq i16 %0, 0
  br i1 %cmp1, label %return, label %while.cond.preheader

while.cond.preheader:                             ; preds = %lor.lhs.false
  br label %while.cond

while.cond:                                       ; preds = %while.cond.preheader, %while.cond
  %src.pn = phi ptr [ %curr.0, %while.cond ], [ %src, %while.cond.preheader ]
  %curr.0 = getelementptr inbounds i8, ptr %src.pn, i64 2
  %1 = load i16, ptr %curr.0, align 2
  %tobool.not = icmp eq i16 %1, 0
  br i1 %tobool.not, label %while.end, label %while.cond

while.end:                                        ; preds = %while.cond
  %curr.0.lcssa = phi ptr [ %curr.0, %while.cond ]
  %sub.ptr.lhs.cast = ptrtoint ptr %curr.0.lcssa to i64
  %sub.ptr.rhs.cast = ptrtoint ptr %src to i64
  %sub.ptr.sub = sub i64 %sub.ptr.lhs.cast, %sub.ptr.rhs.cast
  %sub.ptr.div = ashr exact i64 %sub.ptr.sub, 1
  br label %return

return:                                           ; preds = %entry, %lor.lhs.false, %while.end
  %retval.0 = phi i64 [ %sub.ptr.div, %while.end ], [ 0, %lor.lhs.false ], [ 0, %entry ]
  ret i64 %retval.0
}
!llvm.module.flags = !{!0}
!0 = !{i32 1, !"wchar_size", i32 4}

