; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64-gnu-linux < %s | FileCheck -check-prefixes=CHECK %s

define { half, half } @test_modf_f16(half %a) {
; CHECK-LABEL: test_modf_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr s1, [sp, #12]
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    fcvt h1, s1
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %result = call { half, half } @llvm.modf.f16(half %a)
  ret { half, half } %result
}

define half @test_modf_f16_only_use_fractional_part(half %a) {
; CHECK-LABEL: test_modf_f16_only_use_fractional_part:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %result = call { half, half } @llvm.modf.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_modf_f16_only_use_integral_part(half %a) {
; CHECK-LABEL: test_modf_f16_only_use_integral_part:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr s0, [sp, #12]
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %result = call { half, half } @llvm.modf.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_modf_v2f16(<2 x half> %a) {
; CHECK-LABEL: test_modf_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    fmov s0, s1
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h2, s0
; CHECK-NEXT:    add x0, sp, #56
; CHECK-NEXT:    mov h1, v1.h[2]
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-NEXT:    str q2, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h2, s0
; CHECK-NEXT:    add x0, sp, #60
; CHECK-NEXT:    mov h1, v1.h[3]
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldp s2, s1, [sp, #40]
; CHECK-NEXT:    fcvt h4, s0
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-NEXT:    fcvt h3, s1
; CHECK-NEXT:    fcvt h1, s2
; CHECK-NEXT:    ldr s2, [sp, #56]
; CHECK-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-NEXT:    fcvt h2, s2
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    mov v1.h[1], v3.h[0]
; CHECK-NEXT:    ldr s3, [sp, #60]
; CHECK-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-NEXT:    fcvt h2, s3
; CHECK-NEXT:    mov v1.h[3], v2.h[0]
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
  %result = call { <2 x half>, <2 x half> } @llvm.modf.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_modf_f32(float %a) {
; CHECK-LABEL: test_modf_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr s1, [sp, #12]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %result = call { float, float } @llvm.modf.f32(float %a)
  ret { float, float } %result
}

define { <3 x float>, <3 x float> } @test_modf_v3f32(<3 x float> %a) {
; CHECK-LABEL: test_modf_v3f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #80
; CHECK-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 80
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    add x0, sp, #56
; CHECK-NEXT:    add x19, sp, #56
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    add x0, sp, #60
; CHECK-NEXT:    add x20, sp, #60
; CHECK-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr s1, [sp, #44]
; CHECK-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-NEXT:    ld1 { v1.s }[1], [x19]
; CHECK-NEXT:    mov v2.s[2], v0.s[0]
; CHECK-NEXT:    ld1 { v1.s }[2], [x20]
; CHECK-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    add sp, sp, #80
; CHECK-NEXT:    ret
  %result = call { <3 x float>, <3 x float> } @llvm.modf.v3f32(<3 x float> %a)
  ret { <3 x float>, <3 x float> } %result
}

define { <2 x float>, <2 x float> } @test_modf_v2f32(<2 x float> %a) {
; CHECK-LABEL: test_modf_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    add x19, sp, #40
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl modff
; CHECK-NEXT:    ldr s1, [sp, #44]
; CHECK-NEXT:    ldr q2, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    ld1 { v1.s }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
  %result = call { <2 x float>, <2 x float> } @llvm.modf.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

define { double, double } @test_modf_f64(double %a) {
; CHECK-LABEL: test_modf_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    add x0, sp, #8
; CHECK-NEXT:    bl modf
; CHECK-NEXT:    ldr d1, [sp, #8]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %result = call { double, double } @llvm.modf.f64(double %a)
  ret { double, double } %result
}

define { <2 x double>, <2 x double> } @test_modf_v2f64(<2 x double> %a) {
; CHECK-LABEL: test_modf_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    add x0, sp, #32
; CHECK-NEXT:    add x19, sp, #32
; CHECK-NEXT:    bl modf
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl modf
; CHECK-NEXT:    ldr d1, [sp, #40]
; CHECK-NEXT:    ldr q2, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    ld1 { v1.d }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v2.d[0]
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
  %result = call { <2 x double>, <2 x double> } @llvm.modf.v2f64(<2 x double> %a)
  ret { <2 x double>, <2 x double> } %result
}
