; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt < %s -passes=gvn -S | FileCheck %s

define i1 @test_i1(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define i1 @test_i1(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i1, ptr [[A]], align 1
; CHECK-NEXT:    store i1 [[TMP0]], ptr [[B]], align 1
; CHECK-NEXT:    ret i1 [[TMP0]]
;
entry:
  %0 = load i1, ptr %a, align 1
  store i1 %0, ptr %b, align 1
  %1 = load i1, ptr %a, align 1
  ret i1 %1
}

define i8 @test_i8(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define i8 @test_i8(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A]], align 1
; CHECK-NEXT:    store i8 [[TMP0]], ptr [[B]], align 1
; CHECK-NEXT:    ret i8 [[TMP0]]
;
entry:
  %0 = load i8, ptr %a, align 1
  store i8 %0, ptr %b, align 1
  %1 = load i8, ptr %a, align 1
  ret i8 %1
}

define i32 @test_i32(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define i32 @test_i32(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[B]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load i32, ptr %a, align 4
  store i32 %0, ptr %b, align 4
  %1 = load i32, ptr %a, align 4
  ret i32 %1
}

define float @test_float(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define float @test_float(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[A]], align 4
; CHECK-NEXT:    store float [[TMP0]], ptr [[B]], align 4
; CHECK-NEXT:    ret float [[TMP0]]
;
entry:
  %0 = load float, ptr %a, align 4
  store float %0, ptr %b, align 4
  %1 = load float, ptr %a, align 4
  ret float %1
}

define i32 @test_unaligned_store(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define i32 @test_unaligned_store(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[B]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    ret i32 [[TMP1]]
;
entry:
  %0 = load i32, ptr %a, align 4
  store i32 %0, ptr %b, align 2
  %1 = load i32, ptr %a, align 4
  ret i32 %1
}

define i32 @test_unaligned_loads(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define i32 @test_unaligned_loads(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[B]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    ret i32 [[TMP1]]
;
entry:
  %0 = load i32, ptr %a, align 2
  store i32 %0, ptr %b, align 4
  %1 = load i32, ptr %a, align 2
  ret i32 %1
}

define i8 @test_modify_between(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define i8 @test_modify_between(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A]], align 1
; CHECK-NEXT:    store i8 42, ptr [[C]], align 1
; CHECK-NEXT:    store i8 [[TMP0]], ptr [[B]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[A]], align 1
; CHECK-NEXT:    ret i8 [[TMP1]]
;
entry:
  %0 = load i8, ptr %a, align 1
  store i8 42, ptr %c, align 1
  store i8 %0, ptr %b, align 1
  %1 = load i8, ptr %a, align 1
  ret i8 %1
}

define i32 @test_unordered(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: define i32 @test_unordered(
; CHECK-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[B]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = load atomic i32, ptr [[A]] unordered, align 4
; CHECK-NEXT:    ret i32 [[TMP1]]
;
entry:
  %0 = load i32, ptr %a, align 4
  store i32 %0, ptr %b, align 4
  %1 = load atomic i32, ptr %a unordered, align 4
  ret i32 %1
}
