// This file is generated by kconfig_compiler_kf5 from qalculatebackend.kcfg.
// All changes you do to this file will be lost.
#ifndef QALCULATESETTINGS_H
#define QALCULATESETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class QalculateSettings : public KConfigSkeleton
{
  public:
    enum AngleUnit { ANGLE_UNIT_NONE, ANGLE_UNIT_RADIANS, ANGLE_UNIT_DEGREES, ANGLE_UNIT_GRADIANS };
    enum StructuringMode { STRUCTURING_NONE, STRUCTURING_SIMPLIFY, STRUCTURING_FACTORIZE };
    enum NumberFractionFormat { FRACTION_DECIMAL, FRACTION_DECIMAL_EXACT, FRACTION_FRACTIONAL, FRACTION_COMBINED };
    enum ExpMode { EXP_NONE, EXP_PURE, EXP_SCIENTIFIC, EXP_PRECISION };
    enum SmoothingMode { SMOOTHING_NONE, SMOOTHING_UNIQUE, SMOOTHING_CSPLINES, SMOOTHING_BEZIER, SMOOTHING_SBEZIER };
    enum PlotStyle { STYLE_LINES, STYLE_POINTS, STYLE_LINES_POINTS, STYLE_BOXES, STYLE_HISTOGRAM, STYLE_STEPS, STYLE_CANDLESTICKS, STYLE_DOTS };
    enum LegendPosition { LEGEND_NONE, LEGEND_TOP_LEFT, LEGEND_TOP_RIGHT, LEGEND_BOTTOM_LEFT, LEGEND_BOTTOM_RIGHT, LEGEND_BELOW, LEGEND_OUTSIDE };

    static QalculateSettings *self();
    ~QalculateSettings();


    /**
      Get If and how units will be automatically converted. If true, convert to the best suited SI units (the least amount of units).
    */
    static
    bool postConversion()
    {
      return self()->mPostConversion;
    }


    /**
      Get Default angle unit for trigonometric functions.
    */
    static
    int angleUnit()
    {
      return self()->mAngleUnit;
    }


    /**
      Get Base of parsed and evaluated numbers.
    */
    static
    int base()
    {
      return self()->mBase;
    }


    /**
      Get If the evaluation result will be simplified or factorized.
    */
    static
    int structuring()
    {
      return self()->mStructuring;
    }


    /**
      Get If rational numbers will be displayed with decimals, as a fraction, or something in between.
    */
    static
    int fractionFormat()
    {
      return self()->mFractionFormat;
    }


    /**
      Get Show that the digit series of a number continues forever with three dots, instead of rounding (ex. 2/3 displays as 0.666666... instead of 0.666667).
    */
    static
    bool indicateInfiniteSeries()
    {
      return self()->mIndicateInfiniteSeries;
    }


    /**
      Get Use all decimal SI prefixes. If false, prefixes which is not a multiple of thousand (centi, deci, deca, hecto) will not be used automatically.
    */
    static
    bool useAllPrefixes()
    {
      return self()->mUseAllPrefixes;
    }


    /**
      Get If true, negative exponents will be used instead of division (ex. 5/x^2 becomes 5*x^-2).
    */
    static
    bool negativeExponents()
    {
      return self()->mNegativeExponents;
    }


    /**
      Get Numerical display.
    */
    static
    int minExp()
    {
      return self()->mMinExp;
    }


    /**
      Get If true, plots will be displayed inside the worksheet. If not they appear in a separate window.
    */
    static
    bool inlinePlot()
    {
      return self()->mInlinePlot;
    }


    /**
      Get Whether colors should be used in plots.
    */
    static
    bool coloredPlot()
    {
      return self()->mColoredPlot;
    }


    /**
      Get Whether a grid should be plotted.
    */
    static
    bool plotGrid()
    {
      return self()->mPlotGrid;
    }


    /**
      Get Whether full borders should be drawn around the plot.
    */
    static
    bool plotBorder()
    {
      return self()->mPlotBorder;
    }


    /**
      Get Width of lines, in pixels.
    */
    static
    int plotLineWidth()
    {
      return self()->mPlotLineWidth;
    }


    /**
      Get Number of interpolation steps to be used in plotting.
    */
    static
    int plotSteps()
    {
      return self()->mPlotSteps;
    }


    /**
      Get Smoothing mode in plots.
    */
    static
    int plotSmoothing()
    {
      return self()->mPlotSmoothing;
    }


    /**
      Get Style of plots.
    */
    static
    int plotStyle()
    {
      return self()->mPlotStyle;
    }


    /**
      Get Legend position in plots.
    */
    static
    int plotLegend()
    {
      return self()->mPlotLegend;
    }


    /**
      Get List of scripts to autorun at the beginning of session
    */
    static
    QStringList autorunScripts()
    {
      return self()->mAutorunScripts;
    }

  protected:
    QalculateSettings();
    friend class QalculateSettingsHelper;


    // QalculateBackend
    bool mPostConversion;
    int mAngleUnit;
    int mBase;
    int mStructuring;
    int mFractionFormat;
    bool mIndicateInfiniteSeries;
    bool mUseAllPrefixes;
    bool mNegativeExponents;
    int mMinExp;
    bool mInlinePlot;
    bool mColoredPlot;
    bool mPlotGrid;
    bool mPlotBorder;
    int mPlotLineWidth;
    int mPlotSteps;
    int mPlotSmoothing;
    int mPlotStyle;
    int mPlotLegend;
    QStringList mAutorunScripts;

  private:
};

#endif

