#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "nonwin.h"

extern char *_itoa (int value, char *string, int radix);
char *itoa (int value, char *string, int radix)
{
    *_itoa (value,string,radix) ;
}

int l[19][19], ma[19][19], ml[19][19];
extern int p[19][19];
extern int mymove, umove;
extern int rd, lib;     /* ,pass */
extern int mik, mjk, uik, ujk, mk, uk;  /* piece captured */
extern int opn[9];  /* opening pattern flag */

#define MAXTRY 500
#define EMPTY 0


void genmove(int *i, int *j)
/* generate computer move */
  {
   int ti, tj, tval;
   int a;
   int ii, val;
   int try = 0;   /* number of try */

/* initialize move and value */
   *i = -1;  *j = -1;  val = -1;

/* re-evaluate liberty of opponent pieces */
   eval(umove);

/* find opponent piece to capture or attack */
   if (findwinner(&ti, &tj, &tval))
       if (tval > val)
        {
        val = tval;
        *i = ti;
        *j = tj;
        }

/* save any piece if threaten */
   if (findsaver(&ti, &tj, &tval))
      if (tval > val)
        {
        val = tval;
        *i = ti;
        *j = tj;
        }

/* try match local play pattern for new move */
   if (findpatn(&ti, &tj, &tval))
       if (tval > val)
        {
        val = tval;
        *i = ti;
        *j = tj;
        }

/* no urgent move then do random move */
   if (val < 0)
       do {
            random(&rd);
            *i = rd % 19;
            /* avoid low line  and center region */
            if ((*i < 2) || (*i > 16) || ((*i > 5) && (*i < 13)))
                {
                random(&rd);
                *i = rd % 19;
                if ((*i < 2) || (*i > 16))
                    {
                    random(&rd);
                    *i = rd % 19;
                    }
                }
            random(&rd);
            *j = rd % 19;
            /* avoid low line and center region */
            if ((*j < 2) || (*j > 16) || ((*j > 5) && (*j < 13)))
                {
                random(&rd);
                *j = rd % 19;
                if ((*j < 2) || (*j > 16))
                    {
                    random(&rd);
                    *j = rd % 19;
                    }
                }
            lib = 0;
            countlib(*i, *j, mymove);
            }
        /* avoid illegal move, liberty one or suicide, fill in own eye */
        while ((++try < MAXTRY)
            && ((p[*i][*j] != EMPTY) || (lib < 2) || fioe(*i, *j)));

        if (try >= MAXTRY)  /* computer pass */
            {
            /* pass++; */
            *i = -1;
            }
    /* **** else
            {
            pass = 0;
            printf("my move: ");
            if (*j < 8)
                a = *j + 65;
            else
                a = *j + 66;
            printf("%c", a);
            ii = 19 - *i;
            if (ii < 10)
                printf("%1d\n", ii);
            else
                printf("%2d\n", ii);
            } **** */

}  /* end genmove */



void count(int i,int j,int color)
/* count liberty of color piece at i, j */
/* int i, j, color; */
{
/* set current piece as marked */
 ml[i][j] = EMPTY;

/* check North neighbor */
 if (i != EMPTY)
   {
    if ((p[i - 1][j] == EMPTY) && ml[i - 1][j])
      {
       ++lib;
       ml[i - 1][j] = EMPTY;
     }
    else
       if ((p[i - 1][j] == color) && ml[i - 1][j])
      count(i - 1, j, color);
  }
/* check South neighbor */
 if (i != 18)
   {
    if ((p[i + 1][j] == EMPTY) && ml[i + 1][j])
      {
       ++lib;
       ml[i + 1][j] = EMPTY;
     }
    else
       if ((p[i + 1][j] == color) && ml[i + 1][j])
      count(i + 1, j, color);
  }
/* check West neighbor */
 if (j != EMPTY)
   {
    if ((p[i][j - 1] == EMPTY) && ml[i][j - 1])
      {
       ++lib;
       ml[i][j - 1] = EMPTY;
     }
    else
       if ((p[i][j - 1] == color) && ml[i][j - 1])
      count(i, j - 1, color);
  }
/* check East neighbor */
 if (j != 18)
   {
    if ((p[i][j + 1] == EMPTY) && ml[i][j + 1])
      {
       ++lib;
       ml[i][j + 1] = EMPTY;
     }
    else
       if ((p[i][j + 1] == color) && ml[i][j + 1])
      count(i, j + 1, color);
  }
}  /* end count */



void countlib(int m,int n,int color)
/* count liberty of color piece at m, n */
/* int m, n, color; */
{
 int i, j;

/* set all piece as unmarked */
 for (i = 0; i < 19; i++)
   for (j = 0; j < 19; j++)
     ml[i][j] = 1;

/* count liberty of current piece */
 count(m, n, color);
}  /* end countlib */



void eval(int color)
/* evaluate liberty of color pieces */
 {
  int i, j;

/* find liberty of each piece */
  for (i = 0; i < 19; i++)
    for (j = 0; j < 19; j++)
      if (p[i][j] == color)
    {
     lib = 0;
     countlib(i, j, color);
     l[i][j] = lib;
      }
}  /* end eval */


void examboard(int color)
/* examine pieces */
/* int color; */
  {
   int i, j, n;

/* find liberty of each piece */
   eval(color);

/* initialize piece captured */
   if (color == mymove)
     {
      mik = -1;
      mjk = -1;
    }
   else
     {
      uik = -1;
      ujk = -1;
    }
   n = 0; /* The number of captures this move for Ko purposes */

/* remove all piece of zero liberty */
   for (i = 0; i < 19; i++)
     for (j = 0; j < 19; j++)
       if ((p[i][j] == color) && (l[i][j] == 0))
     {
      p[i][j] = EMPTY;
/* record piece captured */
      if (color == mymove)
        {
         mik = i;
         mjk = j;
         ++mk;
       }
      else
        {
         uik = i;
         ujk = j;
         ++uk;
       }
      ++n;  /* increment number of captures on this move */
    }
/* reset to -1 if more than one stone captured since  no Ko possible */
   if (color == mymove && n > 1)
     {
       mik = -1;   
       mjk = -1;
     }
   else if ( n > 1 )
     {
       uik = -1;
       ujk = -1;
     }
}  /* end examboard */



findcolor(int i,int j)
/* find color for empty piece */
{
 int k, color1, color2;

/* check North neighbor */
 color1 = 0;
 k = i;
 do --k;
 while ((p[k][j] == EMPTY) && (k > 0));
 color1 = p[k][j];

/* check South neighbor */
 color2 = 0;
 k = i;
 do k++;
 while ((p[k][j] == EMPTY) && (k < 18));
 color2 = p[k][j];

 if (color1)
   {
    if ((color1 == color2) || (color2 == 0))
       return color1;
    else
       return 0;  /* cannot determine */
  }
 else
    if (color2)
       return color2;
    else  /* both zero */
       {
/* check West neighbor */
    color1 = 0;
    k = j;
    do --k;
    while ((p[i][k] == EMPTY) && (k > 0));
    color1 = p[i][k];

/* check East neighbor */
    color2 = 0;
    k = j;
    do k++;
    while ((p[i][k] == EMPTY) && (k < 18));
    color2 = p[i][k];

    if (color1)
      {
       if ((color1 == color2) || (color2 == 0))
          return color1;
       else
          return 0;  /* cannot determine */
     }
    else
       if (color2)
          return color2;
       else
          return 0;
      }
}  /* end findcolor */



findnextmove(int m,int n,int *i,int *j,int *val,int minlib)
/* find new move i, j from group containing m, n */
 {
  int ti, tj, tval;
  int found = 0;

  *i = -1;   *j = -1;   *val = -1;
/* mark current position */
  ma[m][n] = 1;

/* check North neighbor */
  if (m != 0)
     if (p[m - 1][n] == EMPTY)
      {
       ti = m - 1;
       tj = n;
       lib = 0;
       countlib(ti, tj, mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((p[m - 1][n] == mymove) && !ma[m - 1][n])
     if (findnextmove(m - 1, n, &ti, &tj, &tval, minlib))
        found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val)
       {
    *val = tval;
    *i = ti;
    *j = tj;
      }
     if (minlib == 1) return 1;
   }

/* check South neighbor */
  if (m != 18)
     if (p[m + 1][n] == EMPTY)
      {
       ti = m + 1;
       tj = n;
       lib = 0;
       countlib(ti, tj, mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((p[m + 1][n] == mymove) && !ma[m + 1][n])
      if (findnextmove(m + 1, n, &ti, &tj, &tval, minlib))
         found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val)
       {
    *val = tval;
    *i = ti;
    *j = tj;
      }
     if (minlib == 1) return 1;
   }

/* check West neighbor */
  if (n != 0)
     if (p[m][n - 1] == EMPTY)
      {
       ti = m;
       tj = n - 1;
       lib = 0;
       countlib(ti, tj, mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((p[m][n - 1] == mymove) && !ma[m][n - 1])
      if (findnextmove(m, n - 1, &ti, &tj, &tval, minlib))
          found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val)
       {
    *val = tval;
    *i = ti;
    *j = tj;
      }
     if (minlib == 1) return 1;
   }

/* check East neighbor */
  if (n != 18)
     if (p[m][n + 1] == EMPTY)
      {
       ti = m;
       tj = n + 1;
       lib = 0;
       countlib(ti, tj, mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((p[m][n + 1] == mymove) && !ma[m][n + 1])
      if (findnextmove(m, n + 1, &ti, &tj, &tval, minlib))
          found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val)
       {
    *val = tval;
    *i = ti;
    *j = tj;
      }
     if (minlib == 1) return 1;
   }

 if (*val > 0)  /* found next move */
    return 1;
 else   /* next move failed */
    return 0;
}  /* end findnextmove */



fval(int newlib,int minlib)
/* evaluate new move */
{
 int k, val;

 if (newlib <= minlib)
    val = -1;
 else
   {
    k = newlib - minlib;
    val = 40 + (k - 1) * 50 / (minlib * minlib * minlib);
  }
 return val;
}  /* end fval */



findopen(int m,int n,int i[],int j[],int color,int minlib,int *ct)
/* find all open spaces i, j from m, n */
{
/* mark this one */
 ma[m][n] = 1;

/* check North neighbor */
 if (m != 0)
   {
    if ((p[m - 1][n] == EMPTY) && (((m - 1) != mik) || (n != mjk)))
      {
       i[*ct] = m - 1;
       j[*ct] = n;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((p[m - 1][n] == color) && !ma[m - 1][n])
     if (findopen(m - 1, n, i, j, color, minlib, ct) && (*ct == minlib))
        return 1;
  }

/* check South neighbor */
 if (m != 18)
   {
    if ((p[m + 1][n] == EMPTY) && (((m + 1) != mik) || (n != mjk)))
      {
       i[*ct] = m + 1;
       j[*ct] = n;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((p[m + 1][n] == color) && !ma[m + 1][n])
     if (findopen(m + 1, n, i, j, color, minlib, ct) && (*ct == minlib))
        return 1;
  }

/* check West neighbor */
 if (n != 0)
   {
    if ((p[m][n - 1] == EMPTY) && ((m != mik) || ((n - 1) != mjk)))
      {
       i[*ct] = m;
       j[*ct] = n - 1;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((p[m][n - 1] == color) && !ma[m][n - 1])
     if (findopen(m, n - 1, i, j, color, minlib, ct) && (*ct == minlib))
        return 1;
  }

/* check East neighbor */
 if (n != 18)
   {
    if ((p[m][n + 1] == EMPTY) && ((m != mik) || ((n + 1) != mjk)))
      {
       i[*ct] = m;
       j[*ct] = n + 1;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((p[m][n + 1] == color) && !ma[m][n + 1])
     if (findopen(m, n + 1, i, j, color, minlib, ct) && (*ct == minlib))
        return 1;
  }

/* fail to find open space */
 return 0;
}  /* end findopen */



findpatn(int *i,int *j,int *val)
/* find pattern to match for next move */
{
 int m, n;
 int ti, tj, tval;
 static int cnd, mtype;  /* game tree node number, move type */
/* mtype = 0, basic; 1, inverted; 2, reflected; 3, inverted & reflected */

/* open game then occupy corners */
 if (opn[4])   /* continue last move */
   {
    opn[4] = 0;  /* clear flag */
    if (opening(i, j, &cnd, mtype)) opn[4] = 1; /* more move then reset flag */
    if (p[*i][*j] == EMPTY)  /* valid move */
      {
       *val = 80;
       return 1;
     }
    else
      opn[4] = 0;
  }

 if (opn[0])   /* Northwest corner */
   {
    opn[0] = 0;  /* clear flag */
    if (openregion(0, 0, 5, 5))
      {
       cnd = 0;
       mtype = 0;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) opn[4] = 1;
       *val = 80;
       return 1;
     }
 }

 if (opn[1])   /* Southwest corner */
   {
    opn[1] = 0;
    if (openregion(13, 0, 18, 5))
      {
       cnd = 0;
       mtype = 1;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) opn[4] = 1;
       *val = 80;
       return 1;
     }
  }

 if (opn[2])   /* Northeast corner */
   {
    opn[2] = 0;
    if (openregion(0, 13, 5, 18))
      {
       cnd = 0;
       mtype = 2;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) opn[4] = 1;
       *val = 80;
       return 1;
     }
  }

 if (opn[3])   /* Northeast corner */
   {
    opn[3] = 0;
    if (openregion(13, 13, 18, 18))
      {
       cnd = 0;
       mtype = 3;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) opn[4] = 1;
       *val = 80;
       return 1;
     }
  }

/* occupy edges */
 if (opn[5])   /* North edge */
   {
    opn[5] = 0;
    if (openregion(0, 6, 4, 11))
      {
       *i = 3;
       *j = 9;
       *val = 80;
       return 1;
     }
  }

 if (opn[6])   /* South edge */
   {
    opn[6] = 0;
    if (openregion(18, 6, 14, 11))
      {
       *i = 15;
       *j = 9;
       *val = 80;
       return 1;
     }
  }

 if (opn[7])   /* West edge */
   {
    opn[7] = 0;
    if (openregion(6, 0, 11, 4))
      {
       *i = 9;
       *j = 3;
       *val = 80;
       return 1;
     }
  }

 if (opn[8])   /* East edge */
   {
    opn[8] = 0;
    if (openregion(6, 18, 11, 14))
      {
       *i = 9;
       *j = 15;
       *val = 80;
       return 1;
     }
  }

 *i = -1;
 *j = -1;
 *val = -1;

/* find local pattern */
 for (m = 0; m < 19; m++)
   for (n = 0; n < 19; n++)
     if ((p[m][n] == mymove) &&
         (matchpat(m, n, &ti, &tj, &tval) && (tval > *val)))
       {
        *val = tval;
        *i = ti;
        *j = tj;
      }
 if (*val > 0)  /* pattern found */
    return 1;
 else  /* no match found */
    return 0;
}  /* end findpatn */




findsaver(int *i,int *j,int *val)
/* find move if any pieces is threaten */
  {
   int m, n, minlib;
   int ti, tj, tval;

   *i = -1;   *j = -1;   *val = -1;
   for (minlib = 1; minlib < 4; minlib++)
      {
/* count piece with minimum liberty */
       for (m = 0; m < 19; m++)
     for (n = 0; n < 19; n++)
       if ((p[m][n] == mymove) && (l[m][n] == minlib))
/* find move to save pieces */
         {
          initmark();
          if (findnextmove(m, n, &ti, &tj, &tval, minlib) && (tval > *val))
        {
         *val = tval;
         *i = ti;
         *j = tj;
           }
         }
     }
    if (*val > 0)   /* find move */
       return 1;
    else        /* move not found */
       return 0;
 }  /* findsaver */


findwinner(int *i, int *j, int *val)
/* find opponent piece to capture or attack */
{
 int m, n, ti[3], tj[3], tval, ct, u, v, lib1;

 *i = -1;   *j = -1;   *val = -1;

/* find opponent with liberty less than four */
 for (m = 0; m < 19; m++)
   for (n = 0; n < 19; n++)
     if ((p[m][n] == umove) && (l[m][n] < 4))
       {
    ct = 0;
    initmark();
    if (findopen(m, n, ti, tj, umove, l[m][n], &ct))
      {
       if (l[m][n] == 1)
         {
          if (*val < 120)
        {
         *val = 120;
         *i = ti[0];
         *j = tj[0];
           }
        }
       else
         for (u = 0; u < l[m][n]; u++)
           for (v = 0; v < l[m][n]; v++)
          if (u != v)
            {
             lib = 0;
             countlib(ti[u], tj[u], mymove);
             if (lib > 0) /* valid move */
               {
                        lib1 = lib;
            p[ti[u]][tj[u]] = mymove;
            /* look ahead opponent move */
            lib = 0;
            countlib(ti[v], tj[v], umove);
            if ((lib1 == 1) && (lib > 0))
                          tval = 0;
                        else
                          tval = 120 - 20 * lib;
            if (*val < tval)
              {
               *val = tval;
               *i = ti[u];
               *j = tj[u];
             }
            p[ti[u]][tj[u]] = EMPTY;
              }
           }
     }
      }
 if (*val > 0)  /* find move */
    return 1;
 else  /* fail to find winner */
    return 0;
}  /* end findwinner */



fioe(int i,int j)
{
/* check top edge */
 if (i == 0)
   {
    if ((j == 0) && ((p[1][0] == mymove) && (p[0][1] == mymove))) return 1;
    if ((j == 18) && ((p[1][18] == mymove) && (p[0][17] == mymove))) return 1;
    if ((p[1][j] == mymove) &&
    ((p[0][j - 1] == mymove) && (p[0][j + 1] == mymove))) return 1;
    else
       return 0;
  }
/* check bottom edge */
 if (i == 18)
   {
    if ((j == 0) && ((p[17][0] == mymove) && (p[18][1] == mymove))) return 1;
    if ((j == 18) && ((p[17][18] == mymove) && (p[18][17] == mymove))) return 1;
    if ((p[17][j] == mymove) &&
    ((p[18][j - 1] == mymove) && (p[18][j + 1] == mymove)))
       return 1;
    else
       return 0;
  }
/* check left edge */
 if (j == 0)
    if ((p[i][1] == mymove) &&
    ((p[i - 1] [0] == mymove) && (p[i + 1][0] == mymove)))
       return 1;
    else
       return 0;
/* check right edge */
 if (j == 18)
    if ((p[i][17] == mymove) &&
    ((p[i - 1] [18] == mymove) && (p[i + 1][18] == mymove)))
       return 1;
    else
       return 0;
/* check center pieces */
 if (((p[i][j - 1] == mymove) && (p[i][j + 1] == mymove)) &&
     ((p[i - 1][j] == mymove) && (p[i + 1][j] == mymove)))
    return 1;
 else
    return 0;
}  /* fioe */


void initmark()
/* initialize all marking with zero */
{
int i, j;

  for (i = 0; i < 19; i++)
    for (j = 0; j < 19; j++)
      ma[i][j] = 0;
}  /* end initmark */


#define MAXPC 16
#define abs(x) ((x) < 0 ? -(x) : (x))
#define line(x) (abs(x - 9))

matchpat(int m, int n, int *i, int *j, int *val)
/* match pattern and get next move */
{
 struct patval {int x, y, att;}; /* pattern x, y coor and attribute */
/* att = 0 - empty, 1 - your piece, 2 - my piece, 3 - my next move */
/* 4 - empty on edge, 5 - your piece on edge, 6 - my piece on edge */
 struct pattern {
         struct patval patn[MAXPC];   /* pattern */
/* number of pieces in pattern, no. of transformation, pattern value */
         int patlen, trfno, patwt;
           };



#define PATNO 24

/* pattern x, y coor and attribute */
/* for each pattern coordinate 0,0 must have my piece */
/* att = 0 - empty, 1 - your piece, 2 - my piece, 3 - my next move */
/* 4 - empty on edge, 5 - your piece on edge, 6 - my piece on edge */
/*
 struct patval {int x, y, att;};
*/

/* patn - patern */
/* patlen - no. of pieces in pattern */
/* trfno - no. of transformation to match pattern */
/*     8 for normal pattern, 4 for symmetrical pattern */
/* patwt - pattern value */
/*
 struct pattern {
         struct patval patn[MAXPC];
         int patlen, trfno, patwt;
           };
*/
 static struct pattern pat[PATNO] = {
/*
   pattern 0: 232   connect if invaded
          010
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, 3},
     {1, 1, 1},
     {2, 0, 2},
     {2, 1, EMPTY}}, 6, 4, 82},
/*
   pattern 1: 230   connect if invaded
          012
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, 3},
     {1, 1, 1},
     {2, 0, EMPTY},
     {2, 1, 2}}, 6, 8, 82},
/*
   pattern 2: 212   try to attack
          030
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, 1},
     {1, 1, 3},
     {2, 0, 2},
     {2, 1, EMPTY}}, 6, 4, 82},
/*
   pattern 3: 2302   connect if invaded
          0100
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, 3},
     {1, 1, 1},
     {2, 0, EMPTY},
     {2, 1, EMPTY},
     {3, 0, 2},
     {3, 1, EMPTY}},8, 8, 83},
/*
   pattern 4: 20302   connect if invaded
          00100
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, EMPTY},
     {1, 1, EMPTY},
     {2, 0, 3},
     {2, 1, 1},
     {3, 0, EMPTY},
     {3, 1, EMPTY},
     {4, 0, 2},
     {4, 1, EMPTY}}, 10, 4, 84},
/*
   pattern 5: 203   form eye to protect
          021
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, EMPTY},
     {1, 1, 2},
     {2, 0, 3},
     {2, 1, 1}}, 6, 8, 82},
/*
   pattern 6: 202    form eye to protect
          031
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, EMPTY},
     {1, 1, 3},
     {2, 0, 2},
     {2, 1, 1}}, 6, 8, 82},
/*
   pattern 7: 230   connect if invaded
          102
*/
   {{{0, 0, 2},
     {0, 1, 1},
     {1, 0, 3},
     {1, 1, EMPTY},
     {2, 0, EMPTY},
     {2, 1, 2}}, 6, 8, 82},
/*
   pattern 8: 200000
           00030  extend
           00000
*/
   {{{0, 0, 2},
     {1, 0, EMPTY},
     {2, 0, EMPTY},
     {3, 0, EMPTY},
     {4, 0, EMPTY},
     {5, 0, EMPTY},
     {1, 1, EMPTY},
     {2, 1, EMPTY},
     {3, 1, EMPTY},
     {4, 1, 3},
     {5, 1, EMPTY},
     {1, 2, EMPTY},
     {2, 2, EMPTY},
     {3, 2, EMPTY},
     {4, 2, EMPTY},
     {5, 2, EMPTY}}, 16, 8, 80},
/*
   pattern 9:  2
          000
          000  extend
          000
          030
          000
*/
   {{{ 0, 0, 2},
     {-1, 1, EMPTY},
     { 0, 1, EMPTY},
     { 1, 1, EMPTY},
     {-1, 2, EMPTY},
     { 0, 2, EMPTY},
     { 1, 2, EMPTY},
     {-1, 3, EMPTY},
     { 0, 3, EMPTY},
     { 1, 3, EMPTY},
     {-1, 4, EMPTY},
     { 0, 4, 3},
     { 1, 4, EMPTY},
     {-1, 5, EMPTY},
     { 0, 5, EMPTY},
     { 1, 5, EMPTY}}, 16, 4, 80},
/*
   pattern 10: 20000
        0030  extend
        0000
*/
   {{{0, 0, 2},
     {1, 0, EMPTY},
     {2, 0, EMPTY},
     {3, 0, EMPTY},
     {4, 0, EMPTY},
     {1, 1, EMPTY},
     {2, 1, EMPTY},
     {3, 1, 3},
     {4, 1, EMPTY},
     {1, 2, EMPTY},
     {2, 2, EMPTY},
     {3, 2, EMPTY},
     {4, 2, EMPTY}}, 13, 8, 79},
/*
   pattern 11:  2
           000
           000  extend
           030
           000
*/
   {{{ 0, 0, 2},
     {-1, 1, EMPTY},
     { 0, 1, EMPTY},
     { 1, 1, EMPTY},
     {-1, 2, EMPTY},
     { 0, 2, EMPTY},
     { 1, 2, EMPTY},
     {-1, 3, EMPTY},
     { 0, 3, 3},
     { 1, 3, EMPTY},
     {-1, 4, EMPTY},
     { 0, 4, EMPTY},
     { 1, 4, EMPTY}}, 13, 4, 79},
/*
   pattern 12: 2000
        030  extend
        000
*/
   {{{0, 0, 2},
     {1, 0, EMPTY},
     {2, 0, EMPTY},
     {3, 0, EMPTY},
     {1, 1, EMPTY},
     {2, 1, 3},
     {3, 1, EMPTY},
     {1, 2, EMPTY},
     {2, 2, EMPTY},
     {3, 2, EMPTY}}, 10, 8, 76},
/*
   pattern 13:  2
           000  extend
           030
           000
*/
   {{{ 0, 0, 2},
     {-1, 1, EMPTY},
     { 0, 1, EMPTY},
     { 1, 1, EMPTY},
     {-1, 2, EMPTY},
     { 0, 2, 3},
     { 1, 2, EMPTY},
     {-1, 3, EMPTY},
     { 0, 3, EMPTY},
     { 1, 3, EMPTY}}, 10, 4, 76},
/*
   pattern 14: 643   form eye on the edge
        20
*/
   {{{0, 0, 6},
     {1, 0, 4},
     {1, 1, 2},
     {2, 0, 3},
     {2, 1, EMPTY}}, 5, 8, 80},
/*
   pattern 15: 646    solidify eye on the edge
           231
*/
   {{{0, 0, 6},
     {1, 0, 4},
     {1, 1, 2},
     {2, 0, 6},
     {2, 1, 3},
     {3, 1, 1}}, 6, 8, 75},
/*
   pattern 16: 646    solidify eye on the edge
        230
         1
*/
   {{{0, 0, 6},
     {1, 0, 4},
     {1, 1, 2},
     {2, 0, 6},
     {2, 1, 3},
     {2, 2, 1},
     {3, 1, EMPTY}}, 7, 8, 75},
/*
   pattern 17: 646    solidify eye on the edge
        230
         0
*/
   {{{0, 0, 6},
     {1, 0, 4},
     {1, 1, 2},
     {2, 0, 6},
     {2, 1, 3},
     {2, 2, EMPTY},
     {3, 1, EMPTY}}, 7, 8, 75},
/*
   pattern 18:  2      form eye on center
           202
        3
*/
   {{{0, 0, 2},
    {-1, 1, 2},
     {0, 1, EMPTY},
     {1, 1, 2},
     {0, 2, 3}}, 5, 4, 80},
/*
   pattern 19:  2      solidify eye on center
           202
        231
*/
   {{{0, 0, 2},
    {-1, 1, 2},
     {0, 1, EMPTY},
     {1, 1, 2},
     {0, 2, 2},
     {1, 2, 3},
     {2, 2, 1}}, 7, 8, 75},
/*
   pattern 20:  2      solidify eye on center
           202
        230
         0
*/
   {{{0, 0, 2},
    {-1, 1, 2},
     {0, 1, EMPTY},
     {1, 1, 2},
     {0, 2, 2},
     {1, 2, 3},
     {2, 2, EMPTY},
     {1, 3, EMPTY}}, 8, 8, 75},
/*
   pattern 21:  2     solidify eye on center
           202
        230
         1
*/
   {{{0, 0, 2},
    {-1, 1, 2},
     {0, 1, EMPTY},
     {1, 1, 2},
     {0, 2, 2},
     {1, 2, 3},
     {2, 2, EMPTY},
     {1, 3, 1}}, 8, 8, 75},
/*
   pattern 23: 20100     connect if invaded
           00302
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, EMPTY},
     {1, 1, EMPTY},
     {2, 0, 1},
     {2, 1, 3},
     {3, 0, EMPTY},
     {3, 1, EMPTY},
     {4, 0, EMPTY},
     {4, 1, 2}}, 10, 8, 84},
/*
   pattern 24: 2100 connect if invaded
           0302
*/
   {{{0, 0, 2},
     {0, 1, EMPTY},
     {1, 0, 1},
     {1, 1, 3},
     {2, 0, EMPTY},
     {2, 1, EMPTY},
     {3, 0, EMPTY},
     {3, 1, 2}}, 10, 8, 83}
  };
/* end patterns */

/* transformation matrice */
 static int trf [8][2][2] = {
   {{1, 0}, {0, 1}}, /* linear transfomation matrix */
   {{1, 0}, {0, -1}},  /* invert */
   {{0, 1}, {-1, 0}},  /* rotate 90 */
   {{0, -1}, {-1, 0}},  /* rotate 90 and invert */
   {{-1, 0}, {0, 1}},  /* flip left */
   {{-1, 0}, {0, -1}},  /* flip left and invert */
   {{0, 1}, {1, 0}},  /* rotate 90 and flip left */
   {{0, -1}, {1, 0}}  /* rotate 90, flip left and invert */
 };
 int k, my, nx, l, r, cont;
 int ti, tj, tval;

 *i = -1;   *j = -1;   *val = -1;
 for (r = 0; r < PATNO; r++)
/* try each pattern */
    for (l = 0; l < pat[r].trfno; l++)
/* try each orientation transformation */
      {
       k = 0;  cont = 1;
       while ((k != pat[r].patlen) && cont)
/* match each point */
     {
/* transform pattern real coordinate */
      nx = n + trf[l][0][0] * pat[r].patn[k].x
         + trf[l][0][1] * pat[r].patn[k].y;
      my = m + trf[l][1][0] * pat[r].patn[k].x
         + trf[l][1][1] * pat[r].patn[k].y;

/* outside the board */
      if ((my < 0) || ( my > 18) || (nx < 0) || (nx > 18))
        {
         cont = 0;
         break;
       }
      switch (pat[r].patn[k].att) {
      case 0 : if (p[my][nx] == EMPTY)  /* open */
              break;
           else
             {
              cont = 0;
              break;
            }
      case 1 : if (p[my][nx] == umove)  /* your piece */
              break;
           else
             {
              cont = 0;
              break;
            }
      case 2 : if (p[my][nx] == mymove)  /* my piece */
              break;
           else
             {
              cont = 0;
              break;
            }
      case 3 : if (p[my][nx] == EMPTY)  /* open for new move */
            {
             lib = 0;
             countlib(my, nx, mymove);  /* check liberty */
             if (lib > 1)  /* move o.k. */
               {
            ti = my;
            tj = nx;
            break;
               }
             else
               {
            cont = 0;
            break;
              }
             }
           else
             {
              cont = 0;
              break;
            }
      case 4 : if ((p[my][nx] == EMPTY)  /* open on edge */
               && ((my == 0) || (my == 18) || (nx == 0) || (nx == 18)))
              break;
           else
             {
              cont = 0;
              break;
            }
      case 5 : if ((p[my][nx] == umove)  /* your piece on edge */
               && ((my == 0) || (my == 18) || (nx == 0) || (nx == 18)))
              break;
           else
             {
              cont = 0;
              break;
            }
      case 6 : if ((p[my][nx] == mymove)  /* my piece on edge */
               && ((my == 0) || (my == 18) || (nx == 0) || (nx == 18)))
              break;
           else
             {
              cont = 0;
              break;
            }
         }
      ++k;
     }
     if (cont)   /* match pattern */
       {
        tval = pat[r].patwt;
        if ((r >= 8) && (r <= 13))  /* patterns for expand region */
          {
           if (line(ti) > 7)  /* penalty on line 1, 2 */
          tval--;
           else
          if ((line(ti) == 6) || (line(ti) == 7))
             tval++;    /* reward on line 3, 4 */

           if (line(tj) > 7)  /* penalty on line 1, 2 */
          tval--;
           else
          if ((line(tj) == 6) || (line(tj) == 7))
             tval++;    /* reward on line 3, 4 */
         }
        if (tval > *val)
          {
           *val = tval;
           *i = ti;
           *j = tj;
         }
      }
      }
 if (*val > 0)  /* pattern matched */
    return 1;
 else  /* match failed */
    return 0;
}  /* end matchpat */



opening(int *i, int *j, int *cnd,int type)
/* get move for opening from game tree */
/* int *i, *j, *cnd, type; */
{
 struct tnode {
   int i, j, ndct, next[8];
  };

 static struct tnode tree[] = {
  {-1, -1, 8, { 1, 2, 3, 4, 5, 6, 7, 20}},  /* 0 */
  {2, 3, 2, { 8, 9}},
  {2, 4, 1, {10}},
  {3, 2, 2, {11, 12}},
  {3, 3, 6, {14, 15, 16, 17, 18, 19}},
  {3, 4, 1, {10}},  /* 5 */
  {4, 2, 1, {13}},
  {4, 3, 1, {13}},
  {4, 2, 0},
  {4, 3, 0},
  {3, 2, 0},  /* 10 */
  {2, 4, 0},
  {3, 4, 0},
  {2, 3, 0},
  {2, 5, 1, {10}},
  {2, 6, 1, {10}},  /* 15 */
  {3, 5, 1, {10}},
  {5, 2, 1, {13}},
  {5, 3, 1, {13}},
  {6, 2, 1, {13}},
  {2, 2, 0}  /* 20 */
};
int m;

/* get i, j */
 if ((type == 1) || (type == 3))
    *i = 18 - tree[*cnd].i;   /* inverted */
 else
    *i = tree[*cnd].i;
 if ((type == 2) || (type == 3))
    *j = 18 - tree[*cnd].j;   /* reflected */
 else
    *j = tree[*cnd].j;
 if (tree[*cnd].ndct)  /* more move */
   {
    random(&rd);
    m = rd % tree[*cnd].ndct;  /* select move */
    *cnd = tree[*cnd].next[m];  /* new  current node */
    return 1;
  }
 else
    return 0;
}  /* end opening */



openregion(int i1, int j1, int i2, int j2)
/* check if region from i1, j1 to i2, j2 is open */
/* int i1, j1, i2, j2; */

{
 int minx, maxx, miny, maxy, x, y;

/* exchange upper and lower limits */

 if (i1 < i2)
   {
    miny = i1;
    maxy = i2;
  }
 else
   {
    miny = i2;
    maxy = i1;
  }

 if (j1 < j2)
   {
    minx = j1;
    maxx = j2;
  }
 else
   {
    minx = j2;
    maxx = j1;
  }

/* check for empty region */
 for (y = miny; y <= maxy; y++)
   for (x = minx; x <= maxx; x++)
     if (p[y][x] != EMPTY) return 0;
 return 1;
}  /* end openregion */


void random(int *i)
/* random number generator */
  {
   if (*i == 0)
     seed(i);
   else
     {
      *i = *i * 137 % 3833;
      if (*i < 0) *i = -*i;
   }
}  /* end random */

void seed(int *i)
{
    *i = clock();
} 

#define BLACK 2

void sethand(int i)
/* set up handicap pieces */
{
 if (i > 0)
   {
    p[3][3] = BLACK;
    if (i > 1)
      {
       p[15][15] = BLACK;
       if (i > 2)
     {
      p[3][15] = BLACK;
      if (i > 3)
        {
         p[15][3] = BLACK;
         if (i == 5)
        p[9][9] = BLACK;
         else
        if (i > 5)
          {
           p[9][15] = BLACK;
           p[9][3] = BLACK;
           if (i == 7)
              p[9][9] = BLACK;
           else
              if (i > 7)
            {
             p[15][9] = BLACK;
             p[3][9] = BLACK;
             if (i > 8)
             p[9][9] = BLACK;
             if (i > 9)
               {p[2][2] = 2;
                if (i > 10)
                  {p[16][16] = 2;
                   if (i > 11)
                 {p[2][16] = 2;
                  if (i > 12)
                    {p[16][2] = 2;
                     if (i > 13)
                       {p[6][6] = 2;
                    if (i > 14)
                      {p[12][12] = 2;
                       if (i > 15)
                         {p[6][12] = 2;
                          if (i > 16)
                        p[12][6] = 2;
                        }
                     }
                      }
                   }
                }
                 }
              }
               }
         }
       }
    }
     }
  }
}  /* end sethand */



suicide(int i, int j)
/* check for suicide move of opponent at p[i][j] */
{
 int m, n, k;

/* check liberty of new move */
 lib = 0;
 countlib(i, j, umove);
 if (lib == 0)
/* new move is suicide then check if kill my pieces and Ko possibility */
   {
/* assume alive */
    p[i][j] = umove;

/* check my pieces */
    eval(mymove);
    k = 0;

    for (m = 0; m < 19; m++)
      for (n = 0; n < 19; n++)
/* count pieces will be killed */
    if ((p[m][n] == mymove) && !l[m][n]) ++k;

    if ((k == 0) || (k == 1 && ((i == uik) && (j == ujk))))
/* either no effect on my pieces or an illegal Ko take back */
      {
       p[i][j] = EMPTY;   /* restore to open */
       return 1;
      }
    else
/* good move */
      return 0;
   }
 else
/* valid move */
   return 0;
}  /* end suicide */

