		DOSSEG

		.MODEL	large

		PUBLIC	_ega_putline, _ega_normal

		.CODE

		ASSUME	DS:DGROUP

; void setp(int plane);
; void ega_putline(long offset, int count, char huge * buffer);

egapar		struc
ega_bp    	dw	?
ega_ret		dd	?
ega_offset	dd	?
ega_count	dw	?
ega_buffer	dd	?
egapar		ends

frame		equ	[ bp - bp0 ]

_ega_putline    PROC	far

		push	bp
		mov	bp, sp
		push	es
		push	ds
		push  di
		push  si
;		mov	dx,03c4h
;		mov	ax,0f02h
;		out	dx,ax
		mov	ax,0a000h
		mov	es,ax
		mov	di,WORD PTR frame.ega_offset
		mov	ax,WORD PTR frame.ega_offset[2]			; if ega_offset > 64 kB
		and	al,7
		mov	dx,3cdh
		out	dx,al						; set segment select register
		lds	si,frame.ega_buffer
		mov	cx,frame.ega_count
		shr	cx,1

		cld
		rep	movsw

		pop	si
		pop	di
		pop	ds
		pop	es
		pop	bp
		ret

_ega_putline    ENDP



_ega_normal	PROC    far

;		mov	dx,03c4h
;		mov	ax,0f02h
;		out	dx,ax
		ret

_ega_normal	ENDP





		PUBLIC  _xms_init
		PUBLIC  _xms_alloc
		PUBLIC  _xms_free
		PUBLIC  _xms_copy

_xms_init	PROC FAR

		push	bp
		mov     bp,sp
		push    ds
		push    es

		mov     ax,4300h
		int     2fh
		cmp     al,80h
		jne     $1

		mov     ax,4310h
		int     2fh
		mov     [xms_call_o],bx
		mov     [xms_call_s],es

		mov     ah,08h
		call    dword ptr [xms_call_o]
		jmp     $2

$1:		mov     ax,0
$2:		pop     es
		pop     ds
		pop     bp
		ret

_xms_init	ENDP

_xms_alloc	PROC FAR

		push    bp
		mov     bp,sp
		push    ds

		mov     dx,6[bp]        ; Anzahl 1K-Blcke
		mov     ah,9            ; XMS-Funktionsnummer Alloc
		call    dword ptr [xms_call_o]
		cmp     ax,1
		jne     %1
		mov     ax,dx
		jmp     %2
%1:		mov     ax,0

%2:		pop     ds
		pop     bp
		ret

_xms_alloc	ENDP

_xms_free	PROC FAR

		push    bp
		mov     bp,sp
		push    ds

		mov     dx,6[bp]
		mov     ah,0ah
		call    dword ptr [xms_call_o]

		pop     ds
		pop     bp
		ret

_xms_free	ENDP

_xms_copy	PROC FAR

		push    bp
		mov     bp,sp
		push    ds
		push    es
		push    si

		mov     ax,ds
		mov     es,ax
		lea     si,6[bp]
		mov     ax,ss
		mov     ds,ax
		mov     ah,0bh
		call    es:dword ptr [xms_call_o]

		pop     si
		pop     es
		pop     ds
		pop     bp
		ret


_xms_copy	ENDP


		.286
		public	_draw_char

pk_nibble	MACRO
		LOCAL   l1

		mov	ax, pk_flags
		xor	ah, 1
		je 	l1
		lods byte ptr es:[si] ; Verndert keine Flags
l1:		ror     al, 4
		mov	pk_flags, ax
		and     ax, 0fh

		ENDM


		.DATA
		extrn _frame_width:word
		extrn _frame_height:word
		extrn _frame_or:dword

		.CODE

pk_pnum		PROC    near

		; Holt die nchste Zahl aus den PK-Daten
		; es:si muss den Zeiger innerhalb der PK-Daten enthalten
		; pk_flags muss vor dem ersten Aufruf gelscht werden
		; Verndert: ax, bx, cx, si

		pk_nibble
		jnz     non_zero
		xor     cx,cx           ; Nullen in CX zhlen
zero_loop1:	inc     cx              ; Eine wurde bereits am Anfang gefunden
		pk_nibble               ; Nchstes Nibble holen
		jz short zero_loop1     ; Wenn Null, dann weiterzhlen
zero_loop2:	shl     ax,4            ; Es ist mindestens eine 8-Bit Zahl
		mov     bx,ax           ; bisherige Zahl in BX zwischenspeichern
		pk_nibble               ; die nchsten vier Bits nach AX
		or      ax,bx           ; mit den gemerkten zusammenfassen
		loop    zero_loop2      ; das Ganze so oft, wie in CX gezhlt
		sub     ax,15
		add     ax,pk_dynf
		mov     bx,13
		sub     bx,pk_dynf
		shl     bx,4
		add     ax,bx

pk_pready:	ret

non_zero:	cmp     ax,pk_dynf
		jbe     pk_pready       ; AX enthlt schon die fertige Zahl
		cmp     ax,14
		jae     pk_1415         ; keine Zahl sondern Repeat-Count
		mov     bx,ax
		sub     bx,pk_dynf
		dec     bx
		shl     bx,4
		pk_nibble
		add     ax,bx
		add     ax,pk_dynf
		inc     ax
		jmp     pk_pready

pk_1415:	mov     ax,1
		jne     pk_rep1
		call    pk_pnum
pk_rep1:        mov	cx, pk_repeat
		or	cx, cx
		jnz	pk_ignore
		inc	ax
		mov     pk_repeat, ax
pk_ignore:	jmp     pk_pnum


pk_pnum		ENDP

pk_poke		PROC	NEAR

		push	cx
		push	ax
		mov	al, pk_byte
		or	al, al
		jz	pk_out
		mov	cx, pk_y
		or	cx, cx
		js	pk_out
		mov	cx, pk_xx
		or	cx, cx
		js	pk_out
		cmp	cx, _frame_width
		jge	pk_out
		push	si
		push	bx
		push	es
		push	ax
		push	dx
		push	di
		call	[_frame_or]
		xor	al, al
		mov	pk_byte, al
		pop	di
		pop	dx
		pop	ax
		pop	es
		pop	bx
		pop	si
pk_out:         pop	ax
		pop	cx
		ret

pk_poke		ENDP


_draw_char	PROC    FAR

pkchar		struc
pc_next		dd      ?
pc_dynf		dw      ?
pc_state	dw      ?
pc_pl		dw      2 dup (?)
pc_cc		dw      2 dup (?)
pc_tfm		dw      2 dup (?)
pc_dx		dw      2 dup (?)
pc_dy		dw      2 dup (?)
pc_w		dw      2 dup (?)
pc_h		dw      2 dup (?)
pc_hoff		dw      2 dup (?)
pc_voff		dw      2 dup (?)
pc_data		db      ?
pkchar		ends

pdframe		struc
bp1		dw      ?
ret1		dd      ?
addr		dd      ?
xpos		dw      ?
ypos		dw      ?
pdframe		ends


;
; void draw_char(pk_char far *ptr, int x, int y);
;

frame		equ     [bp-bp0]

		push    bp
		mov     bp,sp
		push    es
		push    si
		push	di

		les     bx, frame.addr	; Zeiger auf pk_char nach es:bx
		mov	ax, bx
		mov	cx, es
		shr	ax, 4
		add	ax, cx
		mov	es, cx
		and	bx, 0fh

		mov     ax, es:[bx].pc_dynf ; dyn_f des pk_char holen
		mov     pk_dynf, ax		; und speichern

		mov     ax, frame.ypos      ; y um ptr->voff verschieben
		sub     ax, es:[bx].pc_voff
		mov     pk_y, ax            ; y * frame_width als
		imul    _frame_width	    ; vorzeichenbehafteten Wert
		mov	pk_addr_lo, ax      ; berechnen und speichern
		mov     pk_addr_hi, dx
		mov     ax, frame.xpos      ; x um ptr->hoff verschieben
		sub     ax, es:[bx].pc_hoff
		mov     cl, al              ; die unteren drei Bits von x
		and     cl, 7               ; sind die Bitposition der Maske
		sar     ax, 3               ; x/8 ist die Byteposition
		mov     pk_x, ax            ; Byteposition speichern
		cwd                         ; in ein long verwandeln
		add	ax, pk_addr_lo      ; und zu y * frame_width addieren
		adc	dx, pk_addr_hi
		mov	pk_addr_lo, ax
		mov	pk_addr_hi, dx
		mov	al, 128             ; Maske zunchst ganz links
		shr	al, cl		    ; um x%8 verschieben
		mov	pk_mask, al	    ; und speichern

		mov     ax, es:[bx].pc_w
		mov	pk_w, ax
		mov	ax, es:[bx].pc_h
		mov	pk_h, ax
		mov	ax, es:[bx].pc_state
		mov	pk_state, al

		mov	ax, _frame_height
		sub	ax, pk_y
		cmp     ax, pk_h
		jge     pk_l1
		mov     pk_h, ax
pk_l1:
		mov     si, bx		; es:si auf die pk_char Daten
		add     si, pc_data	; zeigen lassen, fuer pk_pnum
		xor	ax, ax		; pk_flags muss ebenfalls
		mov	pk_flags, ax	; fuer pk_pnum initialisiert werden.
		mov	pk_byte, al

		mov	cx, pk_h
		cmp	cx, 0
		jg	pk_doit
		jmp	pk_hbreak

pk_doit:	cmp	pk_dynf, 14
		jne	pk_packed
		jmp	pk_unpacked

pk_packed:	xor	bx, bx		; Bitzhler fr run-counts
		mov	ah, pk_state

pk_hloop:       mov	cx, pk_x
		mov	pk_xx, cx
		mov	cx, pk_w	; Bitzhler fr das Zeichen
		mov	di, pk_addr_lo	; Addresszhler fr frame_buffer
		mov	dx, pk_addr_hi	; in dx:di
		mov	al, pk_mask
		push	si
		push	bx
		push	ax
		push	pk_flags
pk_wloop:	or	bx, bx		; run-count abgelaufen
		jnz     pk_setrc
		push    cx
		push	ax
		call    pk_pnum		; nchsten run-count holen
		mov	bx, ax
		pop	ax
		pop	cx
		xor	ah, 1
pk_setrc:	dec	bx
		test    ah, 1
		jne	pk_shift
		or	pk_byte, al

pk_shift:	shr     al, 1
		jne	pk_nxtbit
		call	pk_poke
		mov	al, 128
		inc	pk_xx
		inc     di
		jnz	pk_nxtbit
		inc	dx

pk_nxtbit:	loop    pk_wloop
		mov	al, pk_byte
		or	al, al
		jz	pk_nxtbit1
		call	pk_poke
pk_nxtbit1:	mov	cx, pk_repeat
		cmp	cx, 1
		jbe	pk_norepeat

		dec	pk_repeat
		pop	pk_flags
		pop	ax
		pop     bx
		pop	si
		jmp	pk_nxtline

pk_norepeat:    add	sp, 8
		mov	pk_repeat, 0

pk_nxtline:     mov	di, pk_addr_lo
		add	di, _frame_width
		mov	pk_addr_lo, di
		jnc	pk_noadd
		inc	pk_addr_hi
pk_noadd:	inc	pk_y
		mov	di, pk_y
		cmp	di, _frame_height
		jge	pk_hbreak
		dec	pk_h
		jz	pk_hbreak
		jmp	pk_hloop

pk_hbreak:      pop	di
		pop	si
		pop     es
		pop     bp
		ret

pk_unpacked:    mov	ah, 128
		lods	byte ptr es:[si]
pk_uhloop:	mov	cx, pk_x
		mov	pk_xx, cx
		mov	cx, pk_w	; Bitzhler fr das Zeichen
		mov	di, pk_addr_lo	; Addresszhler fr frame_buffer
		mov	dx, pk_addr_hi	; in dx:di
		mov	bl, pk_mask
		mov	pk_byte, 0
pk_uwloop:	test	al, ah
		jz	pk_ushift
		or	pk_byte, bl

pk_ushift:	shr	ah, 1
		jnz	pk_ushift1
		lods	byte ptr es:[si]
		mov	ah, 128
pk_ushift1:	shr	bl, 1
		jnz	pk_ushift2
		call	pk_poke
		mov	bl, 128
		inc	pk_xx
		inc	di
		jnz	pk_ushift2
		inc	dx
pk_ushift2:	loop	pk_uwloop

		call	pk_poke
		mov	bx, pk_addr_lo
		add	bx, _frame_width
		mov	pk_addr_lo, bx
		mov	bx, pk_addr_hi
		adc	bx, 0
		mov	pk_addr_hi, bx
		inc	pk_y
		mov	bx, pk_y
		cmp	bx, _frame_height
		jge	pk_uhbreak
		dec	pk_h
		jz	pk_uhbreak
		jmp	pk_uhloop
pk_uhbreak:	jmp	pk_hbreak


_draw_char	ENDP

_pk_ipnum	PROC    FAR

pframe		struc
bp0		dw	?
ret0		dd	?
addr		dd	?
dynf		dw	?
pframe		ends

		push    bp
		mov     bp,sp

		xor     ax,ax
		mov     pk_flags,ax
		mov     ax,word ptr [bp].addr
		mov     word ptr pk_ptr,ax
		mov     ax,word ptr [bp].addr+2
		mov     word ptr pk_ptr+2,ax
		mov     ax,[bp].dynf
		mov     pk_dynf,ax

		pop     bp
		ret

_pk_ipnum	ENDP

		ENDS

		.DATA

xms_call_o	DW	?
xms_call_s	DW	?

pk_ptr		DD	?
pk_addr_lo	DW	?
pk_addr_hi	DW	?
pk_flags	DW      ?
pk_dynf		DW      ?
pk_x		DW      ?
pk_y		DW      ?
pk_w		DW	?
pk_h		DW      ?
pk_repeat	DW	?
pk_xx		DW	?
pk_state	DB 	?
pk_mask		DB	?
pk_byte		DB	?

pk_flags1	DW      ?
pk_ptr1		DD      ?

		END
