/*
** Datei: DVIMKPK.C
** Autor: Markus Zahn
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef AMIGA
#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <dos/dostags.h>
#endif

#include "dvi.h"
#include "dvimkpk.h"

extern const int dvilw;

/* Verwendete Funktionen aus "dvirdpk.c" */
extern void fnt_pkname( char *name, char *schab, char *fn, int isize, int rsize	);
extern FILE *fnt_pklocate(fnt_t *f);

FILE *fnt_mkpk( fnt_t *f )
{
  /*
   * Die Optionsvariable CALLMF kann mit einem ARexx-Script
   * belegt werden, das die Fonterzeugung oder die Erstellung
   * eines dazu geeigneten Batchfiles uebernimmt.
   * ( analog zur PasTeX-Implementation :-)
   */
  FILE *pk = NULL;
  double size = (double)f->s*dvi_info.mag / 1e3 / (double)f->d;
  int dbl_magstep; /* magstep * 2 um auch halbe magsteps zu erfassen */
  int isize = iround( size * 1000.0 );
  int rsize = iround( size * (double)op.hres );
  char pkname[MAX_PATH_LEN], pkpath[MAX_PATH_LEN];
  char command[256]; /* fuer das aufzurufende Script */
  long error;
  int i;
#ifdef AMIGA
  ULONG oldIDCMP;
  struct Window *iowin = ( (struct Process *)FindTask( NULL ) )->pr_WindowPtr;
#endif

  if( *op.pk_callmf != '\0' )
  {
#ifdef AMIGA
    strcpy( command, "SYS:Rexxc/rx " );
    if( !dvilw )
    {
      oldIDCMP = iowin->IDCMPFlags;
      ModifyIDCMP( iowin, oldIDCMP & ~( IDCMP_VANILLAKEY | IDCMP_RAWKEY |
        IDCMP_CLOSEWINDOW ) );
    }
#endif

    /* Nur die erste Fontformat Schablone verwenden! */
    for( i = 0; op.pk_path[i] != '\0' && op.pk_path[i] != PATH_SEP; i++ )
      pkpath[i] = op.pk_path[i];
    pkpath[i] = '\0';

    dbl_magstep = iround( 2.0 * log( size ) / log( 1.2 ) );
    if( fabs( exp( (double)dbl_magstep / 2.0 * log( 1.2 ) ) - size ) > 5e-4	)
      dbl_magstep = -1;
    else
    {
      size = exp( (double)dbl_magstep / 2.0 * log( 1.2 ) );
      isize = iround( size * 1000.0 );
      rsize = iround( size * (double)op.hres );
    }
    fnt_pkname( pkname, pkpath, f->n, isize, rsize );

#ifdef AMIGA
    strcat( command, op.pk_callmf );
#endif
#ifdef  UNIX
    strcpy( command, op.pk_callmf );
#endif

    /* 
     * Jetzt noch:
     * Fontname, magstep / magnification, dpi und pkfullname
     */
#ifdef AMIGA
    if( dbl_magstep != -1 )
    {
      sprintf( command + strlen( command ),
      " font=%s magstep=%.1lf dpi=%d hres=%d vres=%d pkfull=%s",
      f->n, (double)dbl_magstep / 2.0, rsize, op.hres, op.vres, pkname );
    }
    else
    {
      sprintf( command + strlen( command ),
      " font=%s mag=%.10lf dpi=%d hres=%d vres=%d pkfull=%s",
      f->n, size, rsize, op.hres, op.vres, pkname );
    }
#endif
#ifdef  UNIX
      sprintf( command + strlen( command ),
        " %s %d %d %.10lf", f->n, rsize, op.hres, size );
#endif
    print( "Creating new font %s...", pkname );

#ifdef AMIGA
    if( DOSBase && ( DOSBase->dl_lib.lib_Version > 36 ) )
      error = SystemTags( command, SYS_UserShell, (ULONG)TRUE,
        SYS_Output, (ULONG)NULL, TAG_DONE );
      /* SYS_Output = NULL clont den Input() handle! */
    else
      error = system( command );

    if( !dvilw )
      ModifyIDCMP( iowin, oldIDCMP );
#endif
#ifdef UNIX
    error = system( command );
#endif

    if( error == 0 )
      pk = fnt_pklocate( f );

  }
  return( pk );
}
