/*
 * Datei: DVIAMIGA.H
 * Autor: Markus Zahn
 */

/*
 * Anzahl der Bitplanes
 */
#define DEPTH 4

/*
 * Scrollschrittweite
 */
#define PIX_UPDOWN 16
#define PIX_LEFTRIGHT 16

/*
 * RawKey Codes f"ur Cursor Keys
 */
#define CRSR_UP    76
#define CRSR_DOWN  77
#define CRSR_RIGHT 78
#define CRSR_LEFT  79

/*
 * Zus"atzlich Qualifier f"ur die RawKey Codes
 */
#define SHIFT_QUALIFIER ( IEQUALIFIER_LSHIFT | IEQUALIFIER_RSHIFT )
#define ALT_QUALIFIER   ( IEQUALIFIER_LALT | IEQUALIFIER_RALT )

/*
 * Implentierte Druckertreiber
 */
enum devices
{
  NO_PRINTER = -1,
  P6LOW, P6HIGH, P6MID,
  FX80,
  HPLJ, HPLJLOW,
  BJ300
};

struct prt_def
{
  long hres;
  long vres;
  int (*shipout)( void );
  char name[8];
};

typedef struct
{
  long prt_mag;                   /* Magnification f"ur Ausdruck */
  int redirect;                   /* Ausgabeumlenkung ja/nein */
  char redir_name[MAX_PATH_LEN];  /* Name der Redirection Datei */
  long pixmem;                    /* Maximalspeicher f"ur die Bitmap beim Druck */
  char screenmode[MAX_PATH_LEN];  /* Modename des DVI Screens */
  unsigned long displayid;        /* DisplayModeID des DVI Screens */
  int depth;                      /* Tiefe des DVI Screens */
} ami_options;

extern ami_options aop;
