#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include "dvi.h"

struct name_table
{
    struct name_table *next;
    char *file_name, *font_name;
} *short_names = NULL;

char *adobe_name(char *name, char **tfm_name)
{
    register struct name_table *p;

    for (p = short_names; p!=NULL; p=p->next)
	if (!strcmp(name,p->file_name) || !strcmp(name,p->font_name)) 
	{
	    *tfm_name = p->file_name;
	    return p->font_name;
	}
    return NULL;
}

static void define_name(char * tfm_name, char * ps_name)
{
    struct name_table *n;

    n = (struct name_table*)mem_alloc(sizeof(struct name_table),"Name-Table entry");
    n->file_name = mem_strdup(tfm_name);
    n->font_name = mem_strdup(ps_name);
    n->next = short_names;
    short_names = n;
}

void init_name_table(FILE * fp)
{
    char line[512], *tfm_name, *ps_name;

    while(NULL!=fgets(line,511,fp))
    {
	tfm_name = strtok(line," \t\n=");
	if (tfm_name==NULL) continue;
	if (*tfm_name==';') continue;
	ps_name = strtok(NULL," =\t\n");
	if (ps_name==NULL)
	    fprintf(stderr,"No Postscript name for font %s\n",tfm_name);
	else define_name(tfm_name,ps_name);
    }

}

void exit_name_table(void)
{
    struct name_table *p, *q;

    for (p=short_names; p!=NULL; p=q)
    {
	q = p->next;
	mem_strfree(p->file_name);
	mem_strfree(p->font_name);
	mem_free(p,sizeof(struct name_table));
    }
    short_names = NULL;
}
