###############################################################################
package CrawlerCommons::ParseState;

# MODULE IMPORTS
########################################
# Pragmas
#------------------#

# CPAN/Core
#------------------#
use Const::Fast;
use Try::Tiny;

# Moose Setup
#------------------#
use Moose;
use namespace::autoclean;

# Moose Pragmas
#------------------#

# Custom Modules
#------------------#
use CrawlerCommons::RobotRules;


# VARIABLES/CONSTANTS
########################################
# Constants
#------------------#

# Variables
#------------------#
our $VERSION = '0.01';


# MOOSE ATTRIBUTES
########################################
# Class
#-----------------------------------------------------------------------------#
#-----------------------------------------------------------------------------#

# Instance
#-----------------------------------------------------------------------------#
has 'current_rules'             => (
    default                     => sub {
        CrawlerCommons::RobotRules->new(
          _mode => $CrawlerCommons::RobotRules::ALLOW_SOME);
    },
    is                          => 'ro',
    isa                         => 'CrawlerCommons::RobotRules',
);
#-----------------------------------------------------------------------------#
has 'is_adding_rules'           => (
    default                     => 0,
    is                          => 'rw',
    isa                         => 'Bool',
);
#-----------------------------------------------------------------------------#
has 'is_finished_agent_fields'  => (
    default                     => 0,
    is                          => 'rw',
    isa                         => 'Bool',
);
#-----------------------------------------------------------------------------#
has 'is_matched_real_name'      => (
    default                     => 0,
    is                          => 'rw',
    isa                         => 'Bool',
);
#-----------------------------------------------------------------------------#
has 'is_matched_wildcard'       => (
    default                     => 0,
    is                          => 'rw',
    isa                         => 'Bool',
);
#-----------------------------------------------------------------------------#
has 'is_skip_agents'            => (
    default                     => 0,
    is                          => 'rw',
    isa                         => 'Bool',
);
#-----------------------------------------------------------------------------#
has 'target_name'               => (
    is                          => 'ro',
    isa                         => 'Str',
    required                    => 1,
);
#-----------------------------------------------------------------------------#
has 'url'                       => (
    is                          => 'ro',
    isa                         => 'Str',
    required                    => 1,
);
#-----------------------------------------------------------------------------#

# METHODS
########################################
# Construction
#------------------#
#-----------------------------------------------------------------------------#
#-----------------------------------------------------------------------------#

# Class Methods
#------------------#
#-----------------------------------------------------------------------------#
#-----------------------------------------------------------------------------#

# Instance Methods
#------------------#
#-----------------------------------------------------------------------------#
sub add_rule {
    my ($self, $path, $allow) = @_;
    $self->current_rules->add_rule( $path, $allow );
}
#-----------------------------------------------------------------------------#
sub add_sitemap {
    my ($self, $sitemap) = @_;
    $self->current_rules->add_sitemap( $sitemap );
}
#-----------------------------------------------------------------------------#
sub clear_rules {$_[0]->current_rules->clear_rules;}
#-----------------------------------------------------------------------------#
sub set_crawl_delay {
    my ($self, $delay_ms) = @_;
    $self->current_rules->set_crawl_delay( $delay_ms );
}
#-----------------------------------------------------------------------------#

# Private Methods
#------------------#
#-----------------------------------------------------------------------------#
#-----------------------------------------------------------------------------#

###############################################################################

__PACKAGE__->meta->make_immutable;

###############################################################################

1;

__END__