/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXPathObject;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class Input
extends ControlSequence {
    private boolean tryKpsewhich = true;
    private byte notFoundAction = 0;
    public static final byte NOT_FOUND_ACTION_ERROR = 0;
    public static final byte NOT_FOUND_ACTION_WARN = 1;
    public static final byte NOT_FOUND_ACTION_IGNORE = 2;

    public Input() {
        this("input");
    }

    public Input(String string) {
        this(string, 0);
    }

    public Input(String string, byte by) {
        this(string, by, true);
    }

    public Input(String string, byte by, boolean bl) {
        super(string);
        this.notFoundAction = by;
        this.tryKpsewhich = bl;
    }

    @Override
    public Object clone() {
        return new Input(this.getName(), this.notFoundAction, this.tryKpsewhich);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        if (!(teXObject instanceof TeXPathObject) && teXObject.canExpand() && teXObject instanceof Expandable) {
            teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
        }
        if (!this.doInput(teXParser, teXObject, teXObjectList)) {
            switch (this.notFoundAction) {
                case 1: {
                    teXParser.warningMessage("tex.error.file.not.found", teXObject.toString(teXParser));
                    break;
                }
                case 0: {
                    throw new TeXSyntaxException(teXParser, "tex.error.file.not.found", teXObject.toString(teXParser));
                }
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    protected String getDefaultExtension() {
        return "tex";
    }

    protected String toBasename(TeXParser teXParser, TeXObject teXObject) throws IOException {
        return teXObject.toString(teXParser);
    }

    protected boolean doInput(TeXParser teXParser, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        TeXPath teXPath;
        TeXParserListener teXParserListener = teXParser.getListener();
        if (teXObject instanceof TeXPathObject) {
            teXPath = ((TeXPathObject)teXObject).getTeXPath();
        } else {
            String string = this.toBasename(teXParser, teXObject);
            teXPath = new TeXPath(teXParser, string, this.tryKpsewhich && !string.contains("/"), this.getDefaultExtension());
        }
        teXParserListener.addFileReference(teXPath);
        return teXParserListener.input(teXPath, teXObjectList);
    }
}

