/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.solver;

import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core3.Histogram;
import net.sourceforge.plantuml.project.core3.HistogramSimple;
import net.sourceforge.plantuml.project.core3.TaskLoad;
import net.sourceforge.plantuml.project.core3.TaskLoadImpl;
import net.sourceforge.plantuml.project.solver.AbstractSolver;
import net.sourceforge.plantuml.project.time.Instant;

public class Solver3
extends AbstractSolver {
    private final Histogram workLoad;

    public Solver3(Histogram workLoad) {
        this.workLoad = workLoad;
    }

    public TaskLoad solveForward(long totalLoad, long start) {
        HistogramSimple resultLoad = new HistogramSimple();
        TaskLoadImpl result = new TaskLoadImpl(resultLoad);
        start = this.workLoad.getNext(start - 1L);
        result.setStart(start);
        long currentTime = start;
        while (totalLoad > 0L) {
            long tmpWorkLoad = this.workLoad.getValueAt(currentTime);
            long nextChange = this.workLoad.getNext(currentTime);
            long duration = nextChange - currentTime;
            if (duration <= 0L) {
                throw new IllegalArgumentException();
            }
            long partialLoad = duration * tmpWorkLoad;
            resultLoad.put(currentTime, tmpWorkLoad);
            if (partialLoad >= totalLoad) {
                long end = currentTime + totalLoad / tmpWorkLoad;
                result.setEnd(end);
                resultLoad.put(end, 0L);
                return result;
            }
            totalLoad -= partialLoad;
            currentTime = nextChange;
        }
        throw new UnsupportedOperationException();
    }

    public TaskLoad solveBackward(long totalLoad, long end) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Instant computeEnd() {
        Instant start = (Instant)this.values.get((Object)TaskAttribute.START);
        int fullLoad = ((Load)this.values.get((Object)TaskAttribute.LOAD)).getFullLoad();
        TaskLoad taskLoad = this.solveBackward(fullLoad, start.getMillis());
        return Instant.create(taskLoad.getEnd());
    }

    @Override
    protected Instant computeStart() {
        throw new UnsupportedOperationException();
    }
}

