/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.common.util.concurrent;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import shaded.com.google.common.annotations.GwtIncompatible;
import shaded.com.google.common.annotations.J2ktIncompatible;
import shaded.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import shaded.com.google.common.util.concurrent.ListenableFuture;
import shaded.com.google.common.util.concurrent.ListeningExecutorService;
import shaded.com.google.common.util.concurrent.ParametricNullness;
import shaded.com.google.common.util.concurrent.TrustedListenableFutureTask;

@CheckReturnValue
@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractListeningExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    @Override
    @CanIgnoreReturnValue
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable2, @ParametricNullness T value) {
        return TrustedListenableFutureTask.create(runnable2, value);
    }

    @Override
    @CanIgnoreReturnValue
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return TrustedListenableFutureTask.create(callable);
    }

    @Override
    @CanIgnoreReturnValue
    public ListenableFuture<?> submit(Runnable task) {
        return (ListenableFuture)super.submit(task);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> ListenableFuture<T> submit(Runnable task, @ParametricNullness T result2) {
        return (ListenableFuture)super.submit(task, result2);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return (ListenableFuture)super.submit(task);
    }
}

