/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import com.google.gson.Gson;
import java.security.AccessController;
import lombok.Generated;
import org.opensearch.sql.utils.SerializeUtils;

public final class ErrorFormatter {
    private static final Gson PRETTY_PRINT_GSON = AccessController.doPrivileged(() -> SerializeUtils.getGsonBuilder().setPrettyPrinting().disableHtmlEscaping().create());
    private static final Gson GSON = AccessController.doPrivileged(() -> SerializeUtils.getGsonBuilder().disableHtmlEscaping().create());

    public static String compactFormat(Throwable t2) {
        JsonError error = new JsonError(t2.getClass().getSimpleName(), t2.getMessage());
        return ErrorFormatter.compactJsonify(error);
    }

    public static String prettyFormat(Throwable t2) {
        JsonError error = new JsonError(t2.getClass().getSimpleName(), t2.getMessage());
        return ErrorFormatter.prettyJsonify(error);
    }

    public static String compactJsonify(Object jsonObject) {
        return AccessController.doPrivileged(() -> GSON.toJson(jsonObject));
    }

    public static String prettyJsonify(Object jsonObject) {
        return AccessController.doPrivileged(() -> PRETTY_PRINT_GSON.toJson(jsonObject));
    }

    @Generated
    private ErrorFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class JsonError {
        private final String type;
        private final String reason;

        @Generated
        public JsonError(String type2, String reason) {
            this.type = type2;
            this.reason = reason;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }
    }
}

