/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.setProperty("SecureRandom.DEFAULT ThreadSafe", "true");
        provider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] byArray) {
                        SecureRandom secureRandom = provider.getDefaultSecureRandom();
                        secureRandom.setSeed(byArray);
                    }

                    @Override
                    protected void engineNextBytes(byte[] byArray) {
                        SecureRandom secureRandom = provider.getDefaultSecureRandom();
                        secureRandom.nextBytes(byArray);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int n) {
                        SecureRandom secureRandom = provider.getDefaultSecureRandom();
                        return secureRandom.generateSeed(n);
                    }
                };
            }
        });
        provider.setProperty("SecureRandom.NONCEANDIV ThreadSafe", "true");
        provider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(this, provider){

            @Override
            public Object createInstance(Object object) {
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] byArray) {
                        SecureRandom secureRandom = provider.get();
                        secureRandom.setSeed(byArray);
                    }

                    @Override
                    protected void engineNextBytes(byte[] byArray) {
                        SecureRandom secureRandom = provider.get();
                        secureRandom.nextBytes(byArray);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int n) {
                        SecureRandom secureRandom = provider.get();
                        return secureRandom.generateSeed(n);
                    }
                };
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    private class PooledNonceSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.POOL_SIZE];
        private final BouncyCastleFipsProvider provider;

        PooledNonceSecureRandomProvider(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.provider = bouncyCastleFipsProvider;
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int n = (Thread.currentThread().hashCode() & BouncyCastleFipsProvider.POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
                EntropySourceProvider entropySourceProvider = this.provider.getEntropySourceProvider();
                EntropySource entropySource = entropySourceProvider.get(this.provider.getProviderDefaultSecurityStrength() / 2 + 1);
                this.providerDefaultRandom[n].compareAndSet(null, this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(entropySource.getEntropy(), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV")));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[n].get();
            }
        }
    }
}

