/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.EdECPrivateKey;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.Prov15EdDSAPublicKey;

class Prov15EdDSAPrivateKey
implements Destroyable,
EdDSAPrivateKey,
EdECPrivateKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricEdDSAPrivateKey baseKey;
    private transient AsymmetricEdDSAPublicKey basePublicKey;

    Prov15EdDSAPrivateKey(AsymmetricEdDSAPrivateKey privKey, AsymmetricEdDSAPublicKey pubKey) {
        this.baseKey = privKey;
        this.basePublicKey = pubKey;
    }

    Prov15EdDSAPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.baseKey = new AsymmetricEdDSAPrivateKey(keyInfo);
        this.basePublicKey = new AsymmetricEdDSAPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
    }

    @Override
    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed((Destroyable)this);
        return "PKCS#8";
    }

    @Override
    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    AsymmetricEdDSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed((Destroyable)this);
        return this.baseKey;
    }

    @Override
    public EdDSAPublicKey getPublicKey() {
        return new Prov15EdDSAPublicKey(this.basePublicKey);
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("EdDSA");
        }
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), this.basePublicKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Prov15EdDSAPrivateKey) {
            return this.baseKey.equals(((Prov15EdDSAPrivateKey)o).baseKey);
        }
        return false;
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricEdDSAPrivateKey(enc);
        this.basePublicKey = new AsymmetricEdDSAPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }

    @Override
    public Optional<byte[]> getBytes() {
        return Optional.of(this.baseKey.getSecret());
    }

    @Override
    public NamedParameterSpec getParams() {
        Object z = null;
        if (this.baseKey.getAlgorithm().getName().startsWith("Ed448")) {
            return NamedParameterSpec.ED448;
        }
        return NamedParameterSpec.ED25519;
    }
}

