/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSignerWithMessageRecovery;
import org.bouncycastle.crypto.OutputValidatorWithMessageRecovery;
import org.bouncycastle.crypto.OutputVerifierWithMessageRecovery;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureWithMessageRecoveryOperatorFactory;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

abstract class GuardedSignatureWithMessageRecoveryOperatorFactory<T extends Parameters>
implements SignatureWithMessageRecoveryOperatorFactory<T> {
    GuardedSignatureWithMessageRecoveryOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public final OutputSignerWithMessageRecovery<T> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        return this.doCreateSigner(asymmetricPrivateKey, t2);
    }

    @Override
    public final OutputVerifierWithMessageRecovery<T> createVerifier(AsymmetricPublicKey asymmetricPublicKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        return this.doCreateVerifier(asymmetricPublicKey, t2);
    }

    @Override
    public final OutputValidatorWithMessageRecovery<T> createValidator(AsymmetricPublicKey asymmetricPublicKey, T t2, byte[] byArray) throws InvalidSignatureException {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        return this.doCreateValidator(asymmetricPublicKey, t2, byArray);
    }

    protected abstract OutputSignerWithMessageRecovery<T> doCreateSigner(AsymmetricPrivateKey var1, T var2);

    protected abstract OutputVerifierWithMessageRecovery<T> doCreateVerifier(AsymmetricPublicKey var1, T var2);

    protected abstract OutputValidatorWithMessageRecovery<T> doCreateValidator(AsymmetricPublicKey var1, T var2, byte[] var3) throws InvalidSignatureException;
}

