/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Method;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.calcite.linq4j.function.Strict;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableMultimap;

public class ScalarFunctionImpl
extends ReflectiveFunctionBase
implements ScalarFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private ScalarFunctionImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    @Deprecated
    public static ImmutableMultimap<String, ScalarFunction> createAll(Class<?> clazz) {
        ImmutableMultimap.Builder<String, ScalarFunction> builder = ImmutableMultimap.builder();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !ReflectUtil.isStatic(method) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz)) continue;
            ScalarFunction function = ScalarFunctionImpl.create(method);
            builder.put(method.getName(), function);
        }
        return builder.build();
    }

    public static ImmutableMultimap<String, Function> functions(Class<?> clazz) {
        ImmutableMultimap.Builder<String, Function> builder = ImmutableMultimap.builder();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !ReflectUtil.isStatic(method) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz)) continue;
            TableFunction tableFunction = TableFunctionImpl.create(method);
            if (tableFunction != null) {
                builder.put(method.getName(), tableFunction);
                continue;
            }
            ScalarFunction function = ScalarFunctionImpl.create(method);
            builder.put(method.getName(), function);
        }
        return builder.build();
    }

    public static @Nullable ScalarFunction create(Class<?> clazz, String methodName) {
        Method method = ScalarFunctionImpl.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        return ScalarFunctionImpl.create(method);
    }

    public static ScalarFunction create(Method method) {
        Class<?> clazz;
        if (!(ReflectUtil.isStatic(method) || ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass()) || ScalarFunctionImpl.classHasPublicFunctionContextConstructor(clazz))) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        CallImplementor implementor = ScalarFunctionImpl.createImplementor(method);
        return new ScalarFunctionImpl(method, implementor);
    }

    public static ScalarFunction createUnsafe(Method method) {
        CallImplementor implementor = ScalarFunctionImpl.createImplementor(method);
        return new ScalarFunctionImpl(method, implementor);
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.method.getReturnType());
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        NullPolicy nullPolicy = ScalarFunctionImpl.getNullPolicy(method);
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method), nullPolicy, false);
    }

    private static NullPolicy getNullPolicy(Method m4) {
        if (m4.getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m4.getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        if (m4.getDeclaringClass().getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m4.getDeclaringClass().getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        return NullPolicy.NONE;
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory, SqlOperatorBinding opBinding) {
        RelDataType returnType = this.getReturnType(typeFactory);
        switch (ScalarFunctionImpl.getNullPolicy(this.method)) {
            case STRICT: {
                for (RelDataType type2 : opBinding.collectOperandTypes()) {
                    if (!type2.isNullable()) continue;
                    return typeFactory.createTypeWithNullability(returnType, true);
                }
                break;
            }
            case SEMI_STRICT: {
                return typeFactory.createTypeWithNullability(returnType, true);
            }
        }
        return returnType;
    }
}

