/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;

public class SimpleStringMetadataIndexKey
implements MetadataIndexKey {
    @Nonnull
    private String value;

    public SimpleStringMetadataIndexKey(@Nonnull String newValue) {
        this.value = Constraint.isNotNull(StringSupport.trimOrNull(newValue), "String index value was null");
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.value).toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleStringMetadataIndexKey) {
            SimpleStringMetadataIndexKey other = (SimpleStringMetadataIndexKey)obj;
            return this.value.equals(other.value);
        }
        return false;
    }
}

