/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.embeddable.internal.NonAggregatedIdentifierMappingInitializer;

public class EmbeddableForeignKeyResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T>,
InitializerProducer<EmbeddableForeignKeyResultImpl<T>> {
    private final String resultVariable;
    private final FetchParent fetchParent;
    private final EmbeddableMappingType fetchContainer;

    public EmbeddableForeignKeyResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart embeddableValuedModelPart, String resultVariable, FetchParent fetchParent, DomainResultCreationState creationState) {
        super(navigablePath);
        this.fetchContainer = embeddableValuedModelPart.getEmbeddableTypeDescriptor();
        this.resultVariable = resultVariable;
        this.fetchParent = fetchParent;
        this.resetFetches(creationState.visitFetches(this));
    }

    protected EmbeddableForeignKeyResultImpl(EmbeddableForeignKeyResultImpl<T> original) {
        super(original);
        this.resultVariable = original.resultVariable;
        this.fetchParent = original.fetchParent;
        this.fetchContainer = original.fetchContainer;
    }

    @Override
    public FetchParent getRoot() {
        return this.fetchParent.getRoot();
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return true;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public Fetch generateFetchableFetch(Fetchable fetchable, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        boolean shouldSelect;
        if (fetchable instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOne = (ToOneAttributeMapping)fetchable;
            shouldSelect = selected && !creationState.isAssociationKeyVisited(toOne.getForeignKeyDescriptor().getAssociationKey()) && !"{fk}".equals(this.getNavigablePath().getLocalName()) && !"{fk-target}".equals(this.getNavigablePath().getLocalName());
        } else {
            shouldSelect = selected;
        }
        return fetchable.generateFetch(this, fetchablePath, fetchTiming, shouldSelect, resultVariable, creationState);
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableAssembler(creationState.resolveInitializer(this, parent, this).asEmbeddableInitializer());
    }

    @Override
    public Initializer<?> createInitializer(EmbeddableForeignKeyResultImpl<T> resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer((InitializerParent)parent, creationState);
    }

    public EmbeddableInitializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return this.getReferencedModePart() instanceof NonAggregatedIdentifierMapping ? new NonAggregatedIdentifierMappingInitializer(this, null, creationState, true) : new EmbeddableInitializerImpl(this, null, null, null, creationState, true);
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.fetchContainer.getPartMappingType();
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }
}

