/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share.generated;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKey;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;

public enum CoordinatorRecordType {
    SHARE_SNAPSHOT("ShareSnapshot", 0, 0, 0),
    SHARE_UPDATE("ShareUpdate", 1, 0, 0);

    private final String name;
    private final short id;
    private final short lowestSupportedVersion;
    private final short highestSupportedVersion;

    private CoordinatorRecordType(String name, short id, short lowestSupportedVersion, short highestSupportedVersion) {
        this.name = name;
        this.id = id;
        this.lowestSupportedVersion = lowestSupportedVersion;
        this.highestSupportedVersion = highestSupportedVersion;
    }

    public static CoordinatorRecordType fromId(short id) {
        switch (id) {
            case 0: {
                return SHARE_SNAPSHOT;
            }
            case 1: {
                return SHARE_UPDATE;
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + id);
    }

    public ApiMessage newRecordKey() {
        switch (this.id) {
            case 0: {
                return new ShareSnapshotKey();
            }
            case 1: {
                return new ShareUpdateKey();
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + this.id);
    }

    public ApiMessage newRecordValue() {
        switch (this.id) {
            case 0: {
                return new ShareSnapshotValue();
            }
            case 1: {
                return new ShareUpdateValue();
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + this.id);
    }

    public short id() {
        return this.id;
    }

    public short lowestSupportedVersion() {
        return this.lowestSupportedVersion;
    }

    public short highestSupportedVersion() {
        return this.highestSupportedVersion;
    }

    public String toString() {
        return this.name();
    }
}

