/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jsampler.CC;
import org.jsampler.JSUtils;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.classic.MainFrame;
import org.jsampler.view.std.JSAdvancedGeneralPropsDlg;
import org.jsampler.view.std.JSGeneralProps;

class GeneralPane
extends JPanel {
    private final JCheckBox checkWindowSizeAndLocation = new JCheckBox(ClassicI18n.i18n.getLabel("GeneralPane.checkWindowSizeAndLocation"));
    private final JCheckBox checkLeftPaneState = new JCheckBox(ClassicI18n.i18n.getLabel("GeneralPane.checkLeftPaneState"));
    private final JCheckBox checkShowLSConsoleWhenRunScript = new JCheckBox(ClassicI18n.i18n.getLabel("GeneralPane.checkShowLSConsoleWhenRunScript"));
    private final JCheckBox checkShowVolumesInDecibels = new JCheckBox(ClassicI18n.i18n.getLabel("GeneralPane.checkShowVolumesInDecibels"));
    private final JSGeneralProps.MaxVolumePane maxVolPane = new JSGeneralProps.MaxVolumePane();
    private final JSGeneralProps.JSamplerHomePane jSamplerHomePane = new JSGeneralProps.JSamplerHomePane();
    private final RecentScriptsPane recentScriptsPane = new RecentScriptsPane();
    private final JButton btnAdvanced = new JButton(ClassicI18n.i18n.getButtonLabel("GeneralPane.btnAdvanced"));
    private final Dialog owner;

    public GeneralPane(Dialog dialog) {
        this.owner = dialog;
        this.setLayout(new BoxLayout(this, 1));
        this.checkWindowSizeAndLocation.setAlignmentX(0.0f);
        this.checkWindowSizeAndLocation.setSelected(ClassicPrefs.getSaveWindowProperties());
        this.checkWindowSizeAndLocation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
            }
        });
        this.add(this.checkWindowSizeAndLocation);
        this.checkLeftPaneState.setAlignmentX(0.0f);
        this.checkLeftPaneState.setSelected(ClassicPrefs.getSaveLeftPaneState());
        this.add(this.checkLeftPaneState);
        this.checkShowLSConsoleWhenRunScript.setAlignmentX(0.0f);
        boolean bl = ClassicPrefs.preferences().getBoolProperty("showLSConsoleWhenRunScript");
        this.checkShowLSConsoleWhenRunScript.setSelected(bl);
        this.add(this.checkShowLSConsoleWhenRunScript);
        bl = ClassicPrefs.preferences().getBoolProperty("volMeasurementUnitDecibel");
        this.checkShowVolumesInDecibels.setSelected(bl);
        this.add(this.checkShowVolumesInDecibels);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.maxVolPane);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.jSamplerHomePane);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.recentScriptsPane);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel.add(jPanel2);
        jPanel.add(this.btnAdvanced);
        jPanel.setAlignmentX(0.0f);
        this.add(jPanel);
        this.add(Box.createGlue());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.btnAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralPane.this.showAdvancedProperties();
            }
        });
    }

    private void showAdvancedProperties() {
        new JSAdvancedGeneralPropsDlg(this.owner).setVisible(true);
    }

    protected void apply() {
        this.maxVolPane.apply();
        ClassicPrefs.setSaveWindowProperties(this.checkWindowSizeAndLocation.isSelected());
        ClassicPrefs.setSaveLeftPaneState(this.checkLeftPaneState.isSelected());
        boolean bl = this.checkShowLSConsoleWhenRunScript.isSelected();
        ClassicPrefs.preferences().setBoolProperty("showLSConsoleWhenRunScript", bl);
        bl = this.checkShowVolumesInDecibels.isSelected();
        ClassicPrefs.preferences().setBoolProperty("volMeasurementUnitDecibel", bl);
        int n = this.recentScriptsPane.getRecentScriptsSize();
        ClassicPrefs.preferences().setIntProperty("recentLscpScripts.maxNumber", n);
        ((MainFrame)CC.getMainFrame()).updateRecentScriptsMenu();
        String string = this.jSamplerHomePane.getJSamplerHome();
        if (string.length() > 0 && !string.equals(CC.getJSamplerHome())) {
            JSUtils.changeJSamplerHome(string);
        }
    }

    private class RecentScriptsPane
    extends JSGeneralProps.RecentScriptsPane {
        private RecentScriptsPane() {
        }

        @Override
        protected void clearRecentScripts() {
            ((MainFrame)CC.getMainFrame()).clearRecentScripts();
        }
    }
}

