/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.instance;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.instance.GeneratedViewState;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.ManagedProxyClassGenerator;
import org.gradle.model.internal.type.ModelType;

@ServiceScope(value={Scope.Global.class})
public class ManagedProxyFactory {
    private final ManagedProxyClassGenerator proxyClassGenerator = new ManagedProxyClassGenerator();
    private final LoadingCache<CacheKey, Class<?>> generatedImplementationTypes = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<CacheKey, Class<?>>(){

        public Class<?> load(CacheKey key) throws Exception {
            return ManagedProxyFactory.this.proxyClassGenerator.generate(key.backingStateType, key.schema, key.structBindings);
        }
    });

    public <T> T createProxy(GeneratedViewState state, StructSchema<T> viewSchema, StructBindings<?> bindings) {
        try {
            Class generatedClass = (Class)Cast.uncheckedCast((Object)this.generatedImplementationTypes.get((Object)new CacheKey(GeneratedViewState.class, viewSchema, bindings)));
            Constructor constructor = generatedClass.getConstructor(GeneratedViewState.class, TypeConverter.class);
            return constructor.newInstance(state, null);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public <T> T createProxy(ModelElementState state, StructSchema<T> viewSchema, StructBindings<?> bindings, TypeConverter typeConverter) {
        try {
            Class generatedClass = (Class)Cast.uncheckedCast((Object)this.generatedImplementationTypes.get((Object)new CacheKey(ModelElementState.class, viewSchema, bindings)));
            StructSchema<?> delegateSchema = bindings.getDelegateSchema();
            if (delegateSchema == null) {
                Constructor constructor = generatedClass.getConstructor(ModelElementState.class, TypeConverter.class);
                return constructor.newInstance(state, typeConverter);
            }
            ModelType delegateType = delegateSchema.getType();
            Object delegate = state.getBackingNode().getPrivateData(delegateType);
            Constructor constructor = generatedClass.getConstructor(ModelElementState.class, TypeConverter.class, delegateType.getConcreteClass());
            return constructor.newInstance(state, typeConverter, delegate);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static class CacheKey {
        private final Class<? extends GeneratedViewState> backingStateType;
        private final StructSchema<?> schema;
        private final StructBindings<?> structBindings;

        private CacheKey(Class<? extends GeneratedViewState> backingStateType, StructSchema<?> schema, StructBindings<?> structBindings) {
            this.backingStateType = backingStateType;
            this.schema = schema;
            this.structBindings = structBindings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equal(this.backingStateType, cacheKey.backingStateType) && Objects.equal(this.schema, cacheKey.schema) && Objects.equal(this.structBindings.getDelegateSchema(), cacheKey.structBindings.getDelegateSchema());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.backingStateType, this.schema, this.structBindings.getDelegateSchema()});
        }
    }
}

