/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.scripts.ScriptFileUtil;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class BuildLayoutValidator {
    private final BuildLayoutFactory buildLayoutFactory;
    private final DocumentationRegistry documentationRegistry;
    private final BuildClientMetaData clientMetaData;
    private final List<BuiltInCommand> builtInCommands;

    public BuildLayoutValidator(BuildLayoutFactory buildLayoutFactory, DocumentationRegistry documentationRegistry, BuildClientMetaData clientMetaData, List<BuiltInCommand> builtInCommands) {
        this.buildLayoutFactory = buildLayoutFactory;
        this.documentationRegistry = documentationRegistry;
        this.clientMetaData = clientMetaData;
        this.builtInCommands = builtInCommands;
    }

    public void validate(StartParameterInternal startParameter) {
        BuildLayout buildLayout = this.buildLayoutFactory.getLayoutFor(startParameter.toBuildLayoutConfiguration());
        if (!buildLayout.isBuildDefinitionMissing()) {
            return;
        }
        for (BuiltInCommand command : this.builtInCommands) {
            if (!command.commandLineMatches(startParameter.getTaskNames())) continue;
            return;
        }
        StringBuilder message = new StringBuilder("Directory '");
        message.append(startParameter.getCurrentDir()).append("' does not contain a Gradle build.\n\n").append("A Gradle build's root directory should contain one of the possible settings files: ").append(String.join((CharSequence)", ", ScriptFileUtil.getValidSettingsFileNames())).append(".").append("It may also contain one of the possible build files: ").append(String.join((CharSequence)", ", ScriptFileUtil.getValidBuildFileNames())).append(".\n\n").append("To create a new Gradle build in this directory run '");
        this.clientMetaData.describeCommand(message, "init");
        message.append("'\n\n").append(this.documentationRegistry.getDocumentationRecommendationFor("information about the 'init' task", "build_init_plugin")).append("\n\n").append(this.documentationRegistry.getDocumentationRecommendationFor("details on creating a Gradle build", "tutorial_using_tasks"));
        throw new BuildLayoutException(message.toString());
    }

    private static class BuildLayoutException
    extends GradleException
    implements FailureResolutionAware {
        public BuildLayoutException(String message) {
            super(message);
        }

        @Override
        public void appendResolutions(FailureResolutionAware.Context context) {
            context.doNotSuggestResolutionsThatRequireBuildDefinition();
            context.appendResolution(output -> {
                output.text((Object)"Run ");
                context.getClientMetaData().describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), "init");
                output.text((Object)" to create a new Gradle build in this directory.");
            });
        }
    }
}

