/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.CSSKeyframesRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.KeyframeRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class KeyframesRule
extends BaseCSSRule
implements CSSKeyframesRule {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private final CSSRuleArrayList cssRules;

    protected KeyframesRule(AbstractCSSStyleSheet parentSheet, int origin) {
        super(parentSheet, (short)7, origin);
        this.cssRules = new CSSRuleArrayList();
    }

    KeyframesRule(AbstractCSSStyleSheet parentSheet, KeyframesRule copyfrom) {
        super(parentSheet, (short)7, copyfrom.getOrigin());
        this.name = copyfrom.name;
        this.cssRules = copyfrom.cssRules;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String keyframesName) {
        this.name = keyframesName;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public void appendRule(String rule) throws DOMException {
        KeyframeRule krule = new KeyframeRule(this);
        krule.setCssText(rule);
        this.cssRules.add(krule);
    }

    @Override
    public void deleteRule(String select) {
        try {
            select = this.keyframeSelector(select);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule rule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!rule.getKeyText().equals(select)) continue;
            this.cssRules.remove(i);
            break;
        }
    }

    @Override
    public CSSKeyframeRule findRule(String select) throws DOMException {
        try {
            select = this.keyframeSelector(select);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule rule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!rule.getKeyText().equals(select)) continue;
            return rule;
        }
        return null;
    }

    String keyframeSelector(String rawselector) throws DOMException {
        LexicalUnit selunit;
        StringReader re = new StringReader(rawselector);
        Parser parser = this.createSACParser();
        try {
            selunit = parser.parsePropertyValue(re);
        }
        catch (CSSException e) {
            throw new DOMSyntaxException(e);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return KeyframesRule.keyframeSelector(selunit);
    }

    static String keyframeSelector(LexicalUnit selunit) throws DOMException {
        StringBuilder buffer = new StringBuilder();
        KeyframesRule.appendSelector(buffer, selunit);
        LexicalUnit lu = selunit.getNextLexicalUnit();
        while (lu != null) {
            LexicalUnit nextlu = lu.getNextLexicalUnit();
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                throw new DOMSyntaxException("Wrong keyframe selector syntax: " + selunit.toString());
            }
            if (nextlu == null) break;
            buffer.append(',');
            KeyframesRule.appendSelector(buffer, nextlu);
            lu = nextlu.getNextLexicalUnit();
        }
        return buffer.toString();
    }

    private static void appendSelector(StringBuilder buffer, LexicalUnit selunit) throws DOMException {
        LexicalUnit.LexicalType type = selunit.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.STRING) {
            buffer.append(selunit.getStringValue());
        } else if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float floatValue = selunit.getFloatValue();
            if (floatValue % 1.0f != 0.0f) {
                buffer.append(String.format(Locale.ROOT, "%s", Float.valueOf(floatValue)));
            } else {
                buffer.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(floatValue)));
            }
            buffer.append('%');
        } else if (type == LexicalUnit.LexicalType.INTEGER && selunit.getIntegerValue() == 0) {
            buffer.append('0');
        } else {
            throw new DOMSyntaxException("Wrong keyframe selector: " + selunit.toString());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(30 + this.getCssRules().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
            sb.append("@keyframes");
            if (this.name != null) {
                String sname = this.getName();
                if (sname.indexOf(32) == -1) {
                    sb.append(' ').append(sname);
                } else {
                    sb.append(' ').append('\'').append(sname).append('\'');
                }
            }
            sb.append('{');
            Iterator it = this.getCssRules().iterator();
            while (it.hasNext()) {
                sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
            }
            sb.append('}');
            return sb.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)"@keyframes ");
            if (this.name != null) {
                String sname = this.getName();
                if (sname.indexOf(32) == -1) {
                    wri.write((CharSequence)sname);
                } else {
                    wri.write('\'');
                    wri.write((CharSequence)sname);
                    wri.write('\'');
                }
            }
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            this.getCssRules().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endRuleList(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    @Override
    boolean hasErrorsOrWarnings() {
        for (AbstractCSSRule rule : this.cssRules) {
            if (!rule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cssRules.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyframesRule other = (KeyframesRule)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.cssRules == null ? other.cssRules != null : !this.cssRules.equals(other.cssRules));
    }

    @Override
    public KeyframesRule clone(AbstractCSSStyleSheet parentSheet) {
        return new KeyframesRule(parentSheet, this);
    }
}

